/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.compare.algorithm;

import oracle.javatools.compare.CompareContributor;
import oracle.javatools.compare.CompareDifference;
import oracle.javatools.compare.CompareModel;
import oracle.javatools.compare.CompareType;
import oracle.javatools.compare.ContributorKind;
import oracle.javatools.compare.algorithm.BaseCompareDifference;

public class BaseCompareModel
implements CompareModel {
    private CompareType _type;
    private final CompareContributor _firstContributor;
    private final CompareContributor _secondContributor;
    private final CompareContributor _ancestorContributor;
    private CompareDifference[] _differences;

    private void $init$() {
        this._type = CompareType.TEXT;
    }

    public BaseCompareModel(BaseCompareModel scm, CompareDifference[] differences) {
        this(scm._firstContributor, scm._secondContributor, scm._ancestorContributor, differences);
        this._type = scm._type;
    }

    public BaseCompareModel(CompareContributor first, CompareContributor second, CompareDifference[] differences) {
        this(first, second, null, differences);
    }

    public BaseCompareModel(CompareContributor first, CompareContributor second, CompareContributor ancestor, CompareDifference[] differences) {
        this.$init$();
        this._firstContributor = first;
        this._secondContributor = second;
        this._ancestorContributor = ancestor;
        this._differences = differences;
    }

    public BaseCompareModel createInstance(CompareDifference[] differences) {
        return new BaseCompareModel(this, differences);
    }

    public void setType(CompareType type) {
        this._type = type;
    }

    public CompareType getType() {
        return this._type;
    }

    public CompareContributor getContributor(ContributorKind contrib) {
        if (contrib == ContributorKind.FIRST) {
            return this._firstContributor;
        }
        if (contrib == ContributorKind.SECOND) {
            return this._secondContributor;
        }
        if (contrib == ContributorKind.ANCESTOR) {
            return this._ancestorContributor;
        }
        throw new IllegalArgumentException("Unknown contributor kind: " + contrib);
    }

    public CompareDifference[] getDifferences() {
        return this._differences;
    }

    public int getDifferenceCount() {
        return this._differences.length;
    }

    public int getConflictCount() {
        int n = 0;
        CompareDifference[] compareDifferenceArray = this.getDifferences();
        int n2 = 0;
        while (n2 < compareDifferenceArray.length) {
            CompareDifference difference = compareDifferenceArray[n2];
            if (difference.isConflict()) {
                ++n;
            }
            ++n2;
        }
        return n;
    }

    public int getResolvedCount() {
        int n = 0;
        CompareDifference[] compareDifferenceArray = this.getDifferences();
        int n2 = 0;
        while (n2 < compareDifferenceArray.length) {
            CompareDifference difference = compareDifferenceArray[n2];
            if (difference.isResolved()) {
                ++n;
            }
            ++n2;
        }
        return n;
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        int i = 0;
        while (i < this._differences.length) {
            str.append("CB");
            str.append(String.valueOf(i));
            str.append(": ");
            str.append(this._differences[i].toString());
            str.append("\n");
            ++i;
        }
        return str.toString();
    }

    public int[] getDifferenceTypeCounts() {
        int[] count = new int[3];
        int i = 0;
        while (i < this.getDifferences().length) {
            BaseCompareDifference db = (BaseCompareDifference)this.getDifferences()[i];
            if (db.isAddition(ContributorKind.FIRST, ContributorKind.SECOND)) {
                count[0] = count[0] + 1;
            }
            if (db.isRemoval(ContributorKind.FIRST, ContributorKind.SECOND)) {
                count[1] = count[1] + 1;
            }
            if (db.isChange(ContributorKind.FIRST, ContributorKind.SECOND)) {
                count[2] = count[2] + 1;
            }
            ++i;
        }
        return count;
    }
}

