/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.compare.algorithm.directory;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import oracle.javatools.compare.CompareAlgorithm;
import oracle.javatools.compare.CompareContributor;
import oracle.javatools.compare.CompareFailedException;
import oracle.javatools.compare.CompareModel;
import oracle.javatools.compare.ContributorKind;
import oracle.javatools.compare.algorithm.directory.DirectoryCompareContributor;
import oracle.javatools.compare.algorithm.directory.DirectoryFile;
import oracle.javatools.compare.algorithm.directory.DirectoryList;
import oracle.javatools.compare.algorithm.sequence.SequenceCompareDifference;
import oracle.javatools.compare.algorithm.sequence.SequenceCompareModel;

public class DirectoryCompareAlgorithm
implements CompareAlgorithm {
    public boolean canCompare(CompareContributor first, CompareContributor second) {
        return true;
    }

    public CompareModel compare(CompareContributor first, CompareContributor second) throws CompareFailedException {
        DirectoryCompareContributor dccF = (DirectoryCompareContributor)first;
        DirectoryCompareContributor dccS = (DirectoryCompareContributor)second;
        DirectoryList listF = dccF.getDirectoryList();
        DirectoryList listS = dccS.getDirectoryList();
        ArrayList<DirectoryFile> lhsFiles = new ArrayList<DirectoryFile>(Arrays.asList(listF.getFiles()));
        ArrayList<DirectoryFile> rhsFiles = new ArrayList<DirectoryFile>(Arrays.asList(listS.getFiles()));
        ArrayList<DirectoryFile> lhsOnlyFiles = new ArrayList<DirectoryFile>(lhsFiles);
        lhsOnlyFiles.removeAll(rhsFiles);
        ArrayList<DirectoryFile> rhsOnlyFiles = new ArrayList<DirectoryFile>(rhsFiles);
        rhsOnlyFiles.removeAll(lhsFiles);
        lhsFiles.removeAll(lhsOnlyFiles);
        rhsFiles.removeAll(rhsOnlyFiles);
        ArrayList<DirectoryFile> changeFiles = new ArrayList<DirectoryFile>();
        for (DirectoryFile lhsFile : lhsFiles) {
            DirectoryFile rhsFile;
            if (lhsFile.compareTo(rhsFile = rhsFiles.get(rhsFiles.indexOf(lhsFile))) == 0) continue;
            changeFiles.add(lhsFile);
        }
        ArrayList<SequenceCompareDifference> differences = new ArrayList<SequenceCompareDifference>();
        for (DirectoryFile file : lhsOnlyFiles) {
            SequenceCompareDifference difference = new SequenceCompareDifference(2);
            difference.setFirstStart(listF.indexOf(file));
            difference.setFirstLength(1);
            difference.setSecondStart(Math.abs(listS.binarySearch(file) + 1));
            difference.setSecondLength(0);
            differences.add(difference);
        }
        for (DirectoryFile file : rhsOnlyFiles) {
            SequenceCompareDifference difference = new SequenceCompareDifference(2);
            difference.setFirstStart(Math.abs(listF.binarySearch(file) + 1));
            difference.setFirstLength(0);
            difference.setSecondStart(listS.indexOf(file));
            difference.setSecondLength(1);
            differences.add(difference);
        }
        for (DirectoryFile file : changeFiles) {
            SequenceCompareDifference difference = new SequenceCompareDifference(2);
            difference.setFirstStart(listF.indexOf(file));
            difference.setFirstLength(1);
            difference.setSecondStart(listS.indexOf(file));
            difference.setSecondLength(1);
            differences.add(difference);
        }
        Collections.sort(differences, new 1());
        return new SequenceCompareModel((DirectoryCompareContributor)first, (DirectoryCompareContributor)second, differences.toArray(new SequenceCompareDifference[0]));
    }

    final class 1
    implements Comparator {
        public int compare(Object o1, Object o2) {
            int i = ((SequenceCompareDifference)o1).getStart(ContributorKind.FIRST) - ((SequenceCompareDifference)o2).getStart(ContributorKind.FIRST);
            if (i != 0) {
                return i;
            }
            i = ((SequenceCompareDifference)o1).getStart(ContributorKind.SECOND) - ((SequenceCompareDifference)o2).getStart(ContributorKind.SECOND);
            if (i != 0) {
                return i;
            }
            i = ((SequenceCompareDifference)o1).getStart(ContributorKind.ANCESTOR) - ((SequenceCompareDifference)o2).getStart(ContributorKind.ANCESTOR);
            return i;
        }
    }
}

