/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.compare.algorithm.directory;

import java.text.ParseException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.javatools.compare.CompareContributor;
import oracle.javatools.compare.algorithm.sequence.SequenceCompareElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectoryFile
extends SequenceCompareElement
implements Comparable {
    private final String _name;
    private final String _id;
    private final boolean _directory;
    private boolean _canRead;
    private boolean _canWrite;
    private CompareContributor _compareContributor;

    private void $init$() {
        this._canRead = true;
        this._canWrite = true;
    }

    public DirectoryFile(DirectoryFile directoryFile) {
        this(directoryFile.isDirectory(), directoryFile.getName(), directoryFile.getID());
    }

    public DirectoryFile(boolean directory, String name, String id) {
        this.$init$();
        this._directory = directory;
        this._name = name;
        this._id = id;
    }

    public static final DirectoryFile parseFile(String spec) throws ParseException {
        Pattern pattern = Pattern.compile("^(.+?)( ([^ ]+))?$");
        Matcher matcher = pattern.matcher(spec);
        if (!matcher.matches()) {
            throw new ParseException("", 0);
        }
        String name = matcher.group(1);
        DirectoryFile file = new DirectoryFile(name.endsWith("/"), name.replace('/', ' ').trim(), matcher.group(3));
        return file;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this._name);
        if (this._directory) {
            stringBuffer.append('/');
        }
        if (this._id != null) {
            stringBuffer.append(' ');
            stringBuffer.append(this._id);
        }
        return stringBuffer.toString();
    }

    public String getName() {
        return this._name;
    }

    public String getID() {
        return this._id;
    }

    public boolean isDirectory() {
        return this._directory;
    }

    public boolean equals(Object o) {
        if (!(o instanceof DirectoryFile)) {
            return false;
        }
        DirectoryFile otherFile = (DirectoryFile)o;
        return this._name.equals(otherFile.getName());
    }

    public int compareTo(Object o) {
        return this.toString().compareTo(((DirectoryFile)o).toString());
    }

    @Override
    public Object getData() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this._name);
        if (this._directory) {
            stringBuffer.append('/');
        }
        stringBuffer.append('\n');
        return stringBuffer.toString().toCharArray();
    }

    public boolean canRead() {
        return this._canRead;
    }

    public void setCanRead(boolean canRead) {
        this._canRead = canRead;
    }

    public boolean canWrite() {
        return this._canWrite;
    }

    public void setCanWrite(boolean canWrite) {
        this._canWrite = canWrite;
    }

    public CompareContributor getCompareContributor() throws Exception {
        if (this._compareContributor == null) {
            this._compareContributor = this.createCompareContributor();
        }
        return this._compareContributor;
    }

    protected CompareContributor createCompareContributor() throws Exception {
        throw new UnsupportedOperationException();
    }
}

