/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.compare.algorithm.text;

import java.awt.EventQueue;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.undo.UndoableEdit;
import oracle.ide.util.Assert;
import oracle.javatools.buffer.ExpiredTextBufferException;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.buffer.TextBufferListener;
import oracle.javatools.compare.CompareHints;
import oracle.javatools.compare.ContributorKind;
import oracle.javatools.compare.algorithm.sequence.SequenceCompareContributor;
import oracle.javatools.compare.algorithm.sequence.SequenceCompareDifference;
import oracle.javatools.compare.algorithm.sequence.SequenceCompareElement;

public abstract class TextCompareContributor
extends SequenceCompareContributor {
    private List _changeListeners;
    private TextBufferListener _bufferListener;
    private Object _documentModel;
    private Boolean _ignoreWhitespace;

    public Object getDocumentModel() {
        return this._documentModel;
    }

    public void setDocumentModel(Object documentModel) {
        this._documentModel = documentModel;
    }

    protected void addTextBufferListeners() {
        this._bufferListener = new 1();
        this.getTextBuffer().addTextBufferListener(this._bufferListener);
    }

    public void addChangeListener(ChangeListener cl) {
        if (this._changeListeners == null) {
            this._changeListeners = new ArrayList();
        }
        if (!this._changeListeners.contains(cl)) {
            this._changeListeners.add(cl);
        }
    }

    public void removeChangeListener(ChangeListener cl) {
        if (this._changeListeners != null) {
            this._changeListeners.remove(cl);
        }
    }

    protected void fireChangeEvent() {
        if (this._changeListeners != null) {
            ChangeEvent ce = null;
            Iterator i = this._changeListeners.iterator();
            while (i.hasNext()) {
                if (ce == null) {
                    ce = new ChangeEvent(this);
                }
                ((ChangeListener)i.next()).stateChanged(ce);
            }
        }
    }

    public final void setIgnoreWhitespace(boolean ignoreWhitespace) {
        this._ignoreWhitespace = ignoreWhitespace;
    }

    public final boolean getIgnoreWhitespace() {
        if (this._ignoreWhitespace != null) {
            return this._ignoreWhitespace;
        }
        return CompareHints.isIgnoreWhiteSpace();
    }

    public abstract TextBuffer getTextBuffer();

    public int getLength() {
        this.getTextBuffer().readLock();
        try {
            if (this.getTextBuffer().getLength() == 0) {
                int n = 0;
                return n;
            }
            int n = this.getTextBuffer().getLineMap().getLineCount();
            return n;
        }
        catch (ExpiredTextBufferException etbe) {
            Assert.printStackTrace(etbe);
            int n = 0;
            this.getTextBuffer().readUnlock();
            return n;
        }
        {
            finally {
                this.getTextBuffer().readUnlock();
            }
        }
    }

    public boolean equal(int thisIndex, SequenceCompareContributor other, int otherIndex) {
        TextCompareContributor otherText = (TextCompareContributor)other;
        int thisLineOffset = this.getTextBuffer().getLineMap().getLineStartOffset(thisIndex);
        int thatLineOffset = otherText.getTextBuffer().getLineMap().getLineStartOffset(otherIndex);
        int thisLineEndOffset = this.getTextBuffer().getLineMap().getLineEndOffset(thisIndex);
        int thatLineEndOffset = otherText.getTextBuffer().getLineMap().getLineEndOffset(otherIndex);
        thisLineEndOffset = Math.min(thisLineEndOffset, this.getTextBuffer().getLength());
        thatLineEndOffset = Math.min(thatLineEndOffset, otherText.getTextBuffer().getLength());
        if (!this.getIgnoreWhitespace() && thatLineEndOffset - thatLineOffset != thisLineEndOffset - thisLineOffset) {
            boolean bl = false;
            return bl;
        }
        int i = thisLineOffset;
        int j = thatLineOffset;
        while (i < thisLineEndOffset || j < thatLineEndOffset) {
            char thatChar;
            char thisChar = i < thisLineEndOffset ? this.getTextBuffer().getChar(i) : (char)'\u0000';
            char c = thatChar = j < thatLineEndOffset ? otherText.getTextBuffer().getChar(j) : (char)'\u0000';
            if (this.getIgnoreWhitespace()) {
                if (TextCompareContributor.isWhitespace(thisChar)) {
                    ++i;
                    continue;
                }
                if (TextCompareContributor.isWhitespace(thatChar)) {
                    ++j;
                    continue;
                }
            }
            if (thisChar != thatChar) {
                boolean bl = false;
                return bl;
            }
            ++i;
            ++j;
        }
        boolean bl = true;
        return bl;
    }

    private static final boolean isWhitespace(char c) {
        return c == ' ' || c == '\t';
    }

    public SequenceCompareElement getElement(SequenceCompareDifference difference, ContributorKind contributor) {
        int start = this.getTextBuffer().getLineMap().getLineStartOffset(difference.getStart(contributor));
        int end = this.getTextBuffer().getLineMap().getLineEndOffset(difference.getStart(contributor) + difference.getLength(contributor) - 1);
        char[] chars = this.getTextBuffer().getChars(start, end - start);
        return new 2(this, chars);
    }

    public UndoableEdit deleteElement(int start, int end) {
        int startCaretPos = this.getTextBuffer().getLineMap().getLineStartOffset(start);
        int endCaretPos = this.getTextBuffer().getLineMap().getLineEndOffset(end);
        endCaretPos = Math.min(endCaretPos, this.getTextBuffer().getLength());
        this.getTextBuffer().remove(startCaretPos, endCaretPos - startCaretPos);
        return null;
    }

    public UndoableEdit insertElement(int index, boolean after, SequenceCompareElement element) {
        int indexCaretPos = !after ? this.getTextBuffer().getLineMap().getLineStartOffset(index) : this.getTextBuffer().getLineMap().getLineEndOffset(index);
        indexCaretPos = Math.min(indexCaretPos, this.getTextBuffer().getLength());
        this.getTextBuffer().insert(indexCaretPos, (char[])element.getData());
        return null;
    }

    public UndoableEdit replaceElement(int start, int end, SequenceCompareElement element) {
        int startCaretPos = this.getTextBuffer().getLineMap().getLineStartOffset(start);
        int endCaretPos = this.getTextBuffer().getLineMap().getLineEndOffset(end);
        endCaretPos = Math.min(endCaretPos, this.getTextBuffer().getLength());
        this.getTextBuffer().remove(startCaretPos, endCaretPos - startCaretPos);
        this.getTextBuffer().insert(startCaretPos, (char[])element.getData());
        return null;
    }

    static PropertyChangeSupport mav$getPropertyChangeSupport(TextCompareContributor textCompareContributor) {
        return textCompareContributor.getPropertyChangeSupport();
    }

    final class oracle.javatools.compare.algorithm.text.TextCompareContributor$1
    implements TextBufferListener {
        public void attributeUpdate(TextBuffer buffer, int attribute) {
            if (attribute != 5) {
                return;
            }
            if (TextCompareContributor.mav$getPropertyChangeSupport(TextCompareContributor.this) == null) {
                return;
            }
            boolean modified = TextCompareContributor.this.getTextBuffer().isModified();
            this.firePropertyChange("modified", modified ^ true, modified);
        }

        private void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
            if (!EventQueue.isDispatchThread()) {
                EventQueue.invokeLater(new 1(this, propertyName, oldValue, newValue));
                return;
            }
            TextCompareContributor.mav$getPropertyChangeSupport(TextCompareContributor.this).firePropertyChange(propertyName, oldValue, newValue);
        }

        public void removeUpdate(TextBuffer buffer, int a, int b, char[] c) {
            TextCompareContributor.this.fireChangeEvent();
        }

        public void insertUpdate(TextBuffer buffer, int a, int b, char[] c) {
            TextCompareContributor.this.fireChangeEvent();
        }

        static void mav$firePropertyChange(oracle.javatools.compare.algorithm.text.TextCompareContributor$1 var0, String string, Object object, Object object2) {
            var0.firePropertyChange(string, object, object2);
        }

        final class 1
        implements Runnable {
            private final /* synthetic */ String v$propertyName;
            private final /* synthetic */ Object v$oldValue;
            private final /* synthetic */ Object v$newValue;
            final /* synthetic */ oracle.javatools.compare.algorithm.text.TextCompareContributor$1 this$0;

            public void run() {
                oracle.javatools.compare.algorithm.text.TextCompareContributor$1.mav$firePropertyChange(this.this$0, this.v$propertyName, this.v$oldValue, this.v$newValue);
            }

            public 1(oracle.javatools.compare.algorithm.text.TextCompareContributor$1 var1_1, String string, Object object, Object object2) {
                this.v$newValue = object2;
                this.v$oldValue = object;
                this.v$propertyName = string;
                this.this$0 = var1_1;
            }
        }
    }

    final class 2
    extends SequenceCompareElement {
        private final /* synthetic */ char[] v$chars;
        final /* synthetic */ TextCompareContributor this$0;

        public Object getData() {
            return this.v$chars;
        }

        public 2(TextCompareContributor textCompareContributor, char[] cArray) {
            this.v$chars = cArray;
            this.this$0 = textCompareContributor;
        }
    }
}

