/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.data;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.javatools.data.ChangeInfo;
import oracle.javatools.data.Dirtyable;
import oracle.javatools.data.ListStructure;
import oracle.javatools.data.NullCapableConcurrentHashMap;
import oracle.javatools.data.Structure;
import oracle.javatools.data.StructureChangeListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class HashStructure
extends Structure {
    public static final int NONEXISTENT = 0;
    public static final int PERSISTENT = 1;
    public static final int PLACEHOLDER = 2;

    private HashStructure() {
    }

    public static final HashStructure newInstance() {
        return new Impl(null);
    }

    public static final HashStructure newChainForStatusQuo(HashStructure[] hashes) {
        return new ChainForStatusQuo(hashes, null, null);
    }

    public static final HashStructure newChainForOverriding(HashStructure[] hashes) {
        return new ChainForOverriding(hashes, null, null);
    }

    public final String getString(String name) {
        Object obj = this.getObject(name);
        return obj != null ? obj.toString() : null;
    }

    public final String getString(String name, String defaultValue) {
        if (this.containsKey(name)) {
            Object obj = this.getObject(name);
            return obj != null ? obj.toString() : null;
        }
        this.putPlaceholder(name, defaultValue);
        return defaultValue;
    }

    public final void putString(String name, String value) {
        this.putObject(name, value);
    }

    public final void putString(String name, String value, boolean removeIfNullValue) {
        this.putObject(name, value, removeIfNullValue);
    }

    public final boolean getBoolean(String name) {
        Object obj = this.getObject(name);
        return obj != null ? Boolean.valueOf(obj.toString()) : false;
    }

    public final boolean getBoolean(String name, boolean defaultValue) {
        Object obj = this.getObject(name);
        if (obj != null) {
            return Boolean.valueOf(obj.toString());
        }
        this.putPlaceholder(name, Boolean.toString(defaultValue));
        return defaultValue;
    }

    public final void putBoolean(String name, boolean value) {
        Boolean b = value ? Boolean.TRUE : Boolean.FALSE;
        this.putString(name, b.toString());
    }

    public final int getInt(String name) {
        Object obj = this.getObject(name);
        return obj != null ? Integer.parseInt(obj.toString()) : 0;
    }

    public final int getInt(String name, int defaultValue) {
        Object obj = this.getObject(name);
        if (obj != null) {
            return Integer.parseInt(obj.toString());
        }
        this.putPlaceholder(name, Integer.toString(defaultValue));
        return defaultValue;
    }

    public final void putInt(String name, int value) {
        this.putString(name, Integer.toString(value));
    }

    public final long getLong(String name) {
        Object obj = this.getObject(name);
        return obj != null ? Long.parseLong(obj.toString()) : 0L;
    }

    public final long getLong(String name, long defaultValue) {
        Object obj = this.getObject(name);
        if (obj != null) {
            return Long.parseLong(obj.toString());
        }
        this.putPlaceholder(name, Long.toString(defaultValue));
        return defaultValue;
    }

    public final void putLong(String name, long value) {
        this.putString(name, Long.toString(value));
    }

    public final float getFloat(String name) {
        Object obj = this.getObject(name);
        return obj != null ? Float.parseFloat(obj.toString()) : 0.0f;
    }

    public final float getFloat(String name, float defaultValue) {
        Object obj = this.getObject(name);
        if (obj != null) {
            return Float.parseFloat(obj.toString());
        }
        this.putPlaceholder(name, Float.toString(defaultValue));
        return defaultValue;
    }

    public final void putFloat(String name, float value) {
        this.putString(name, Float.toString(value));
    }

    public final double getDouble(String name) {
        Object obj = this.getObject(name);
        return obj != null ? Double.parseDouble(obj.toString()) : 0.0;
    }

    public final double getDouble(String name, double defaultValue) {
        Object obj = this.getObject(name);
        if (obj != null) {
            return Double.parseDouble(obj.toString());
        }
        this.putPlaceholder(name, Double.toString(defaultValue));
        return defaultValue;
    }

    public final void putDouble(String name, double value) {
        this.putString(name, Double.toString(value));
    }

    public final URL getURL(String name) {
        return (URL)this.getObject(name);
    }

    public final URL getURL(String name, URL defaultValue) {
        if (this.containsKey(name)) {
            return (URL)this.getObject(name);
        }
        this.putPlaceholder(name, defaultValue);
        return defaultValue;
    }

    public final void putPlaceholderURL(String name, URL placeholderValue) {
        this.putPlaceholder(name, placeholderValue);
    }

    public final void putURL(String name, URL value) {
        this.putObject(name, value);
    }

    public final void putURL(String name, URL value, boolean removeIfNullValue) {
        this.putObject(name, value, removeIfNullValue);
    }

    public abstract Object getObject(String var1);

    public abstract Set<String> keySet();

    public final void applyChange(ChangeInfo change) {
        if (change != null) {
            String name = change.getPropertyName();
            Structure keyStruct = this;
            StringTokenizer st = new StringTokenizer(name, "/", true);
            boolean tokenSeen = false;
            String curToken = null;
            while (st.hasMoreTokens()) {
                if (keyStruct == null) break;
                curToken = st.nextToken();
                if (!st.hasMoreTokens()) continue;
                if ("/".equals(curToken)) {
                    if (tokenSeen) {
                        tokenSeen = false;
                        continue;
                    }
                    keyStruct = this.descendStruct(keyStruct, "");
                    continue;
                }
                keyStruct = this.descendStruct(keyStruct, curToken);
                tokenSeen = true;
            }
            if (keyStruct instanceof HashStructure) {
                HashStructure hash = keyStruct;
                switch (change.getChangeType()) {
                    case 0: 
                    case 1: {
                        hash.putObject(curToken, change.getNewValue());
                        break;
                    }
                    case 2: {
                        Object newValue = change.getNewValue();
                        if (newValue instanceof Structure) {
                            hash.putStructure(curToken, (Structure)newValue, "structure", true);
                            break;
                        }
                        hash.putPlaceholder(curToken, newValue);
                        break;
                    }
                    case 3: {
                        hash.remove(curToken);
                        break;
                    }
                }
            } else if (keyStruct instanceof ListStructure) {
                ListStructure list = (ListStructure)keyStruct;
                try {
                    int index = Integer.parseInt(curToken);
                    switch (change.getChangeType()) {
                        case 0: {
                            list.set(index, change.getNewValue());
                            break;
                        }
                        case 1: {
                            list.add(index, change.getNewValue());
                            break;
                        }
                        case 2: {
                            list.addPlaceholder(change.getNewValue());
                            break;
                        }
                        case 3: {
                            list.remove(index);
                            break;
                        }
                    }
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
        }
    }

    public final void applyChanges(ChangeInfo[] changes) {
        if (changes != null) {
            int n = changes.length;
            Pattern pattern = Pattern.compile("/\\d+(/|$)");
            HashSet<String> seen = new HashSet<String>();
            int i = n - 1;
            while (i >= 0) {
                ChangeInfo change = changes[i];
                String name = change.getPropertyName();
                Matcher matcher = pattern.matcher(name);
                if (!matcher.find()) {
                    if (seen.contains(name)) {
                        changes[i] = null;
                    } else {
                        seen.add(name);
                    }
                }
                --i;
            }
            int i2 = 0;
            while (i2 < changes.length) {
                this.applyChange(changes[i2]);
                ++i2;
            }
        }
    }

    private Structure descendStruct(Structure struct, String name) {
        if (struct instanceof HashStructure) {
            HashStructure hash = (HashStructure)struct;
            Object nextObj = hash.getObject(name);
            if (nextObj != null) {
                return nextObj instanceof Structure ? (Structure)nextObj : null;
            }
        } else if (struct instanceof ListStructure) {
            ListStructure list = (ListStructure)struct;
            try {
                int index = Integer.parseInt(name);
                Object nextObj = list.get(index);
                if (nextObj != null) {
                    Structure structure = nextObj instanceof Structure ? (Structure)nextObj : null;
                    return structure;
                }
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return null;
    }

    public abstract Set<String> persistentKeySet();

    public abstract int keyStatus(String var1);

    public abstract void setKeyStatus(String var1, int var2);

    abstract HashStructure unchain();

    public final HashStructure getHashStructure(String name) {
        return (HashStructure)this.getObject(name);
    }

    public final HashStructure getOrCreateHashStructure(String name) {
        HashStructure hash = this.getHashStructure(name);
        if (hash == null) {
            hash = HashStructure.newInstance();
            this.putStructure(name, hash, "hash", true);
        }
        return hash;
    }

    public final void putHashStructure(String name, HashStructure hash) {
        this.putStructure(name, hash, "hash", false);
    }

    public final void putPlaceholderHashStructure(String name, HashStructure hash) {
        this.putStructure(name, hash, "hash", true);
    }

    public final List getAsList(String name) {
        if (this.containsKey(name)) {
            Object obj = this.getObject(name);
            if (obj instanceof ListStructure) {
                return Collections.unmodifiableList((ListStructure)obj);
            }
            return Collections.singletonList(obj);
        }
        return null;
    }

    public final ListStructure getListStructure(String name) {
        return (ListStructure)this.getObject(name);
    }

    public final ListStructure getOrCreateListStructure(String name) {
        ListStructure list = this.getListStructure(name);
        if (list == null) {
            list = ListStructure.newInstance();
            this.putStructure(name, list, "list", true);
        }
        return list;
    }

    public final void putListStructure(String name, ListStructure list) {
        this.putStructure(name, list, "list", false);
    }

    public final void putPlaceholderListStructure(String name, ListStructure list) {
        this.putStructure(name, list, "list", true);
    }

    @Override
    public void clear() {
    }

    public abstract boolean containsKey(String var1);

    public abstract void remove(String var1);

    public abstract int size();

    public abstract void setParentDirtyable(Dirtyable var1);

    public boolean isAnyValueOverridden(String[] names) {
        return false;
    }

    public abstract void hideValues(String[] var1);

    public abstract void recoverValues(String[] var1);

    public boolean isReadOnly() {
        return false;
    }

    public HashStructure asReadOnly() {
        return new ReadOnly(this, null);
    }

    public HashStructure copyTo(HashStructure target, String[] names) {
        HashStructure copy = HashStructure.notNullOrCreate(target);
        int n = names.length;
        int i = 0;
        while (i < n) {
            String name = names[i];
            if (this.containsKey(name)) {
                HashStructure.copyItem(this, copy, name, true);
            } else {
                copy.remove(name);
            }
            ++i;
        }
        return copy;
    }

    public HashStructure copyTo(HashStructure target) {
        return this.copyImpl(target, true);
    }

    HashStructure copyImpl(HashStructure target, boolean deleteDestKeysMissingFromSrcHash) {
        HashStructure orig = this;
        HashStructure copy = HashStructure.notNullOrCreate(target);
        HashStructure.deepCopy(orig, copy, deleteDestKeysMissingFromSrcHash);
        return copy;
    }

    private static void deepCopy(HashStructure srcHash, HashStructure destHash, boolean deleteDestKeysMissingFromSrcHash) {
        if (deleteDestKeysMissingFromSrcHash) {
            ArrayList<String> keysToRemove = new ArrayList<String>();
            Iterator<String> destKeyIter = destHash.keySet().iterator();
            while (destKeyIter.hasNext()) {
                String key = destKeyIter.next().toString();
                if (srcHash.containsKey(key)) continue;
                keysToRemove.add(key);
            }
            Iterator keysToRemoveIter = keysToRemove.iterator();
            while (keysToRemoveIter.hasNext()) {
                destHash.remove(keysToRemoveIter.next().toString());
            }
        }
        for (String keyObj : srcHash.keySet()) {
            String key = keyObj.toString();
            HashStructure.copyItem(srcHash, destHash, key, deleteDestKeysMissingFromSrcHash);
        }
    }

    private static void copyItem(HashStructure srcHash, HashStructure destHash, String key, boolean deleteDestKeysMissingFromSrcHash) {
        Object srcValue = srcHash.getObject(key);
        if (srcValue instanceof HashStructure) {
            HashStructure targetHash;
            Object destValue = destHash.getObject(key);
            if (destValue instanceof HashStructure) {
                targetHash = (HashStructure)destValue;
            } else {
                targetHash = HashStructure.newInstance();
                destHash.putHashStructure(key, targetHash);
            }
            HashStructure origHash = (HashStructure)srcValue;
            origHash.copyImpl(targetHash, deleteDestKeysMissingFromSrcHash);
        } else if (srcValue instanceof ListStructure) {
            Object destValue = destHash.getObject(key);
            ListStructure origList = (ListStructure)srcValue;
            if (destValue instanceof ListStructure) {
                ListStructure targetList = (ListStructure)destValue;
                ListStructure.deepCopy(origList, targetList);
            } else {
                ListStructure targetList = ListStructure.newInstance();
                ListStructure.deepCopy(origList, targetList);
                targetList.markDirty(false);
                destHash.putListStructure(key, targetList);
            }
        } else {
            destHash.putObject(key, srcValue);
        }
    }

    abstract void putObject(String var1, Object var2);

    private void putObject(String name, Object value, boolean removeIfNullValue) {
        if (removeIfNullValue && value == null) {
            this.remove(name);
        } else {
            this.putObject(name, value);
        }
    }

    private static HashStructure notNullOrCreate(HashStructure hash) {
        return hash != null ? hash : HashStructure.newInstance();
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        return this.equalsImpl((HashStructure)obj);
    }

    abstract boolean equalsImpl(HashStructure var1);

    abstract void putPlaceholder(String var1, Object var2);

    abstract void putStructure(String var1, Structure var2, String var3, boolean var4);

    static HashStructure maS$notNullOrCreate(HashStructure hashStructure) {
        return HashStructure.notNullOrCreate(hashStructure);
    }

    HashStructure(1 var1_1) {
        this();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class Impl
    extends HashStructure {
        final HashSet _placeholderKeys;
        private final Map<String, Object> _data;
        private Dirtyable _parentDirtyable;
        private static final int NO_CREATE = 0;
        private static final int CREATE_PLACEHOLDER = 1;
        private static final int CREATE_PERSISTENT = 2;

        private void $init$() {
            this._placeholderKeys = new HashSet();
            this._data = new NullCapableConcurrentHashMap();
        }

        private Impl() {
            super(null);
            this.$init$();
        }

        @Override
        public HashStructure copyTo(HashStructure target, String[] names) {
            HashStructure copy = HashStructure.maS$notNullOrCreate(target);
            if (names != null && copy.getClass() == Impl.class) {
                Impl targetImpl = (Impl)copy;
                int n = names.length;
                int i = 0;
                while (i < n) {
                    Impl targetKeyStruct;
                    String name = names[i];
                    Impl keyStruct = this.getKeyStruct(name, 0);
                    if (keyStruct != null && (targetKeyStruct = targetImpl.getKeyStruct(name, 0)) != null) {
                        String leafName = this.getLeafName(name);
                        if (keyStruct._placeholderKeys.contains(leafName)) {
                            targetKeyStruct._placeholderKeys.add(leafName);
                        } else {
                            targetKeyStruct._placeholderKeys.remove(leafName);
                        }
                    }
                    ++i;
                }
            }
            return super.copyTo(copy, names);
        }

        @Override
        public HashStructure copyTo(HashStructure target) {
            HashStructure copy = this.transferPlaceholders(target);
            return super.copyTo(copy);
        }

        @Override
        HashStructure copyImpl(HashStructure target, boolean deleteDestKeysMissingFromSrcHash) {
            HashStructure copy = this.transferPlaceholders(target);
            return super.copyImpl(copy, deleteDestKeysMissingFromSrcHash);
        }

        private HashStructure transferPlaceholders(HashStructure target) {
            HashStructure copy = HashStructure.maS$notNullOrCreate(target);
            if (copy.getClass() == Impl.class) {
                Impl impl = (Impl)copy;
                impl._placeholderKeys.clear();
                impl._placeholderKeys.addAll(this._placeholderKeys);
            }
            return copy;
        }

        @Override
        public Object getObject(String name) {
            Impl keyStruct = this.getKeyStruct(name, 0);
            return keyStruct != null ? keyStruct._data.get(this.getLeafName(name)) : null;
        }

        @Override
        public Set<String> keySet() {
            return Collections.unmodifiableSet(this._data.keySet());
        }

        public Set persistentKeySet() {
            HashSet<String> keySet = new HashSet<String>(this._data.keySet());
            keySet.removeAll(this._placeholderKeys);
            return Collections.unmodifiableSet(keySet);
        }

        @Override
        public int keyStatus(String key) {
            Impl keyStruct = this.getKeyStruct(key, 0);
            if (keyStruct != null) {
                String leafName = this.getLeafName(key);
                if (keyStruct._data.keySet().contains(leafName)) {
                    if (keyStruct._placeholderKeys.contains(leafName)) {
                        return 2;
                    }
                    return 1;
                }
                return 0;
            }
            return 0;
        }

        @Override
        public void setKeyStatus(String key, int status) {
            Impl keyStruct = this.getKeyStruct(key, 0);
            if (keyStruct != null) {
                String leafName = this.getLeafName(key);
                if (keyStruct._data.keySet().contains(leafName)) {
                    if (status == 2) {
                        keyStruct._placeholderKeys.add(leafName);
                    } else if (status == 1) {
                        keyStruct._placeholderKeys.remove(leafName);
                    }
                }
            }
        }

        @Override
        HashStructure unchain() {
            return this;
        }

        @Override
        public void clear() {
            ArrayList<String> keys = new ArrayList<String>();
            keys.addAll(this._data.keySet());
            Iterator iter = keys.iterator();
            while (iter.hasNext()) {
                Impl.removeValueFromKeyStruct(this, (String)iter.next());
            }
        }

        @Override
        public boolean containsKey(String name) {
            Impl keyStruct = this.getKeyStruct(name, 0);
            return keyStruct != null ? keyStruct._data.containsKey(this.getLeafName(name)) : false;
        }

        @Override
        public void remove(String name) {
            Impl keyStruct = this.getKeyStruct(name, 0);
            Impl.removeValueFromKeyStruct(keyStruct, this.getLeafName(name));
        }

        private static void removeValueFromKeyStruct(Impl keyStruct, String leafName) {
            if (keyStruct != null && keyStruct._data.containsKey(leafName)) {
                Object oldValue = keyStruct._data.remove(leafName);
                if (oldValue instanceof Structure) {
                    ((Structure)oldValue).setParent(null);
                }
                if (keyStruct._placeholderKeys.contains(leafName)) {
                    keyStruct._placeholderKeys.remove(leafName);
                } else {
                    keyStruct.markDirty(true);
                }
                keyStruct.fireValueRemoved(leafName, keyStruct, oldValue);
            }
        }

        @Override
        public int size() {
            return this._data.size();
        }

        @Override
        Dirtyable getParentDirtyable() {
            return this._parentDirtyable != null ? this._parentDirtyable : super.getParentDirtyable();
        }

        @Override
        public void setParentDirtyable(Dirtyable parentDirtyable) {
            this._parentDirtyable = parentDirtyable;
        }

        @Override
        public void hideValues(String[] names) {
            if (names != null) {
                int n = names.length;
                int i = 0;
                while (i < n) {
                    String name = names[i];
                    Impl keyStruct = this.getKeyStruct(name, 0);
                    if (keyStruct != null) {
                        String leafName = this.getLeafName(name);
                        String hiddenLeafName = "hidden:" + leafName;
                        if (keyStruct.containsKey(leafName)) {
                            Object value = keyStruct.getObject(leafName);
                            keyStruct.remove(leafName);
                            keyStruct.putObject(hiddenLeafName, value);
                        }
                    }
                    ++i;
                }
            }
        }

        @Override
        public void recoverValues(String[] names) {
            if (names != null) {
                int n = names.length;
                int i = 0;
                while (i < n) {
                    String name = names[i];
                    Impl keyStruct = this.getKeyStruct(name, 0);
                    if (keyStruct != null) {
                        String leafName = this.getLeafName(name);
                        String hiddenLeafName = "hidden:" + leafName;
                        if (keyStruct.containsKey(hiddenLeafName)) {
                            Object value = keyStruct.getObject(hiddenLeafName);
                            keyStruct.remove(hiddenLeafName);
                            keyStruct.putObject(leafName, value);
                        }
                    }
                    ++i;
                }
            }
        }

        @Override
        void removeChild(Structure child) {
            for (String key : this._data.keySet()) {
                Object value = this._data.get(key);
                if (value != child) continue;
                Impl.removeValueFromKeyStruct(this, key);
                break;
            }
        }

        @Override
        protected boolean equalsImpl(HashStructure o) {
            Set otherPersistentKeys;
            if (!(o instanceof Impl)) {
                return false;
            }
            Impl other = (Impl)o;
            Set persistentKeys = this.persistentKeySet();
            if (!persistentKeys.equals(otherPersistentKeys = other.persistentKeySet())) {
                return false;
            }
            for (Object key : persistentKeys) {
                Object otherValue;
                Object value = this._data.get(key);
                if (!Impl.areDifferent(value, otherValue = other._data.get(key))) continue;
                return false;
            }
            HashSet placeholderKeys = new HashSet();
            placeholderKeys.addAll(this._placeholderKeys);
            placeholderKeys.addAll(other._placeholderKeys);
            for (Object key : placeholderKeys) {
                Object otherValue;
                Object value;
                if (!this._data.containsKey(key) || !other._data.containsKey(key) || !Impl.areDifferent(value = this._data.get(key), otherValue = other._data.get(key))) continue;
                return false;
            }
            return true;
        }

        @Override
        void putObject(String name, Object value) {
            Impl.checkNotNull(name, "name");
            this.putObject0(name, value, false);
        }

        @Override
        void putPlaceholder(String name, Object value) {
            Impl.checkNotNull(name, "name");
            this.putObject0(name, value, true);
        }

        @Override
        void putStructure(String name, Structure struct, String valueParamName, boolean isPlaceholder) {
            Impl.checkNotNull(name, "name");
            Impl.checkNotNull(struct, valueParamName);
            this.putObject0(name, struct, isPlaceholder);
        }

        private final Impl getKeyStruct(String name, boolean isPlaceholder) {
            return this.getKeyStruct(name, isPlaceholder ? 1 : 2);
        }

        private final Impl getKeyStruct(String name, int createMode) {
            Impl.checkNotNull(name, "name");
            HashStructure keyStruct = this;
            StringTokenizer st = new StringTokenizer(name, "/", true);
            boolean tokenSeen = false;
            String curToken = null;
            while (st.hasMoreTokens()) {
                if (keyStruct == null) break;
                curToken = st.nextToken();
                if (!st.hasMoreTokens()) continue;
                if ("/".equals(curToken)) {
                    if (tokenSeen) {
                        tokenSeen = false;
                        continue;
                    }
                    keyStruct = Impl.descend(keyStruct, "", createMode);
                    continue;
                }
                keyStruct = Impl.descend(keyStruct, curToken, createMode);
                tokenSeen = true;
            }
            return keyStruct;
        }

        private static HashStructure descend(HashStructure hash, String name, int createMode) {
            HashStructure result;
            switch (createMode) {
                case 0: {
                    result = hash.getHashStructure(name);
                    break;
                }
                case 1: {
                    result = hash.getOrCreateHashStructure(name);
                    break;
                }
                case 2: {
                    HashStructure persistentHash = hash.getHashStructure(name);
                    if (persistentHash == null) {
                        persistentHash = HashStructure.newInstance();
                        hash.putHashStructure(name, persistentHash);
                    }
                    result = persistentHash;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unexpected mode in descend(..).");
                }
            }
            return result;
        }

        private String getLeafName(String name) {
            return name.substring(name.lastIndexOf(47) + 1);
        }

        private void putObject0(String name, Object value, boolean isPlaceholder) {
            Impl keyStruct = this.getKeyStruct(name, isPlaceholder);
            String leafName = this.getLeafName(name);
            if (value instanceof Structure) {
                keyStruct.checkAndSetParent((Structure)value, leafName);
            }
            Impl.putValueInKeyStruct(keyStruct, leafName, value, isPlaceholder);
        }

        private static void putValueInKeyStruct(Impl keyStruct, String leafName, Object value, boolean isPlaceholder) {
            Object oldValue = keyStruct._data.get(leafName);
            boolean alreadyContainsKey = keyStruct._data.containsKey(leafName);
            if (Impl.areEqual(oldValue, value) && (value != null || alreadyContainsKey)) {
                return;
            }
            keyStruct._data.put(leafName, value);
            if (isPlaceholder) {
                keyStruct._placeholderKeys.add(leafName);
                keyStruct.firePlaceholderValueAdded(leafName, keyStruct, value);
            } else if (alreadyContainsKey) {
                keyStruct.clearPlaceholderFlag(leafName);
                keyStruct.markDirty(true);
                keyStruct.fireValueModified(leafName, keyStruct, oldValue, value);
            } else if (keyStruct._placeholderKeys.contains(leafName)) {
                keyStruct.firePlaceholderValueAdded(leafName, keyStruct, value);
            } else {
                keyStruct.clearPlaceholderFlag(leafName);
                keyStruct.markDirty(true);
                keyStruct.fireValueAdded(leafName, keyStruct, value);
            }
        }

        @Override
        final void clearPlaceholderFlag(String structName) {
            this._placeholderKeys.remove(structName);
        }

        private static void checkNotNull(Object obj, String paramName) {
            if (obj == null) {
                throw new IllegalArgumentException("The '" + paramName + "' parameter must not be null.");
            }
        }

        Impl(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class BaseChain
    extends HashStructure {
        final HashStructure[] _hashes;
        private final String _prefix;

        private BaseChain(HashStructure[] hashes, String prefix) {
            super(null);
            if (hashes == null) {
                throw new IllegalArgumentException("hashes cannot be null");
            }
            int n = hashes.length;
            ArrayList<HashStructure> hashList = new ArrayList<HashStructure>();
            int i = 0;
            while (i < n) {
                HashStructure hash = hashes[i];
                if (hash != null) {
                    hashList.add(hash);
                }
                ++i;
            }
            int trimmedSize = hashList.size();
            if (trimmedSize < 1) {
                throw new IllegalArgumentException("hashes must contain at least one non-null element");
            }
            this._hashes = hashList.toArray(new HashStructure[trimmedSize]);
            this._prefix = prefix == null ? "" : (prefix.endsWith("/") ? prefix : prefix + "/");
        }

        @Override
        public String getStructName() {
            if ("".equals(this._prefix)) {
                return null;
            }
            int n = this._prefix.length() - 1;
            int start = this._prefix.lastIndexOf("/", n - 1);
            return this._prefix.substring(start + 1, n);
        }

        @Override
        public String getFullName() {
            if ("".equals(this._prefix)) {
                return null;
            }
            int n = this._prefix.length() - 1;
            return this._prefix.substring(0, n);
        }

        @Override
        public void applyBatchChanges(Runnable runnable) {
            this.applyBatchChangesImpl(0, runnable);
        }

        private void applyBatchChangesImpl(int index, Runnable runnable) {
            while (index < this._hashes.length) {
                HashStructure hash;
                if ((hash = this._hashes[index++]) == null) continue;
                int nextIndex = index;
                hash.applyBatchChanges(new 1(this, nextIndex, runnable));
                return;
            }
            super.applyBatchChanges(runnable);
        }

        @Override
        void removeChild(Structure child) {
            int n = this._hashes.length;
            int i = 0;
            while (i < n) {
                this._hashes[i].removeChild(child);
                ++i;
            }
        }

        abstract HashStructure getChainedHashStructure(String var1);

        abstract ListStructure getChainedListStructure(ListStructure var1, String var2);

        @Override
        public final Object getObject(String name) {
            String fullName = this.getFullName(name);
            int n = this._hashes.length;
            int i = 0;
            while (i < n) {
                HashStructure hash = this._hashes[i];
                if (hash.containsKey(fullName)) {
                    Object value = hash.getObject(fullName);
                    if (value instanceof HashStructure) {
                        return this.getChainedHashStructure(fullName);
                    }
                    if (value instanceof ListStructure) {
                        return this.getChainedListStructure((ListStructure)value, fullName);
                    }
                    return value;
                }
                ++i;
            }
            return null;
        }

        @Override
        public Set<String> keySet() {
            HashSet<String> keySet = new HashSet<String>();
            int n = this._hashes.length;
            int i = 0;
            while (i < n) {
                HashStructure hash = this.getSubHashStructureAtPrefix(this._hashes[i]);
                if (hash != null) {
                    keySet.addAll(hash.keySet());
                }
                ++i;
            }
            return Collections.unmodifiableSet(keySet);
        }

        public Set persistentKeySet() {
            HashSet<String> keySet = new HashSet<String>();
            int n = this._hashes.length;
            int i = 0;
            while (i < n) {
                HashStructure hash = this.getSubHashStructureAtPrefix(this._hashes[i]);
                if (hash != null) {
                    keySet.addAll(hash.persistentKeySet());
                }
                ++i;
            }
            return keySet;
        }

        @Override
        public int keyStatus(String key) {
            int n = this._hashes.length;
            int i = 0;
            while (i < n) {
                int keyStatus;
                HashStructure hash = this.getSubHashStructureAtPrefix(this._hashes[i]);
                if (hash != null && (keyStatus = hash.keyStatus(key)) != 0) {
                    return keyStatus;
                }
                ++i;
            }
            return 0;
        }

        @Override
        public void setKeyStatus(String key, int status) {
            int n = this._hashes.length;
            int i = 0;
            while (i < n) {
                HashStructure hash = this.getSubHashStructureAtPrefix(this._hashes[i]);
                if (hash != null && hash.containsKey(key)) {
                    hash.setKeyStatus(key, status);
                    return;
                }
                ++i;
            }
        }

        @Override
        HashStructure unchain() {
            String fullName = this.getFullName();
            if (fullName != null) {
                int n = this._hashes.length;
                int i = 0;
                while (i < n) {
                    HashStructure hash = this._hashes[i];
                    if (hash.containsKey(fullName)) {
                        HashStructure result = hash.getHashStructure(fullName);
                        if (result != null) {
                            result = result.unchain();
                        }
                        return result;
                    }
                    ++i;
                }
            } else {
                return this._hashes[0].unchain();
            }
            throw new IllegalStateException("Unable to unchain HashStructure.");
        }

        HashStructure getSubHashStructureAtPrefix(HashStructure hash) {
            if ("".equals(this._prefix)) {
                return hash;
            }
            String prefix = this._prefix.endsWith("/") ? this._prefix.substring(0, this._prefix.length() - 1) : this._prefix;
            try {
                HashStructure hashStructure = hash.getHashStructure(prefix);
                return hashStructure;
            }
            catch (Exception e) {
                e.printStackTrace();
                HashStructure hashStructure = null;
                return hashStructure;
            }
        }

        @Override
        public boolean containsKey(String name) {
            String fullName = this.getFullName(name);
            int n = this._hashes.length;
            int i = 0;
            while (i < n) {
                HashStructure hash = this._hashes[i];
                if (hash.containsKey(fullName)) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        @Override
        public int size() {
            return this.keySet().size();
        }

        @Override
        public void setParentDirtyable(Dirtyable parentDirtyable) {
            throw new IllegalStateException("A chained HashStructure cannot be put into another HashStructure");
        }

        @Override
        public final boolean isAnyValueOverridden(String[] names) {
            int numNames = names.length;
            int i = 0;
            while (i < numNames) {
                String fullName = this.getFullName(names[i]);
                int n = this._hashes.length - 1;
                int j = 0;
                while (j < n) {
                    HashStructure hash = this._hashes[j];
                    if (hash.containsKey(fullName)) {
                        return true;
                    }
                    ++j;
                }
                ++i;
            }
            return false;
        }

        @Override
        public void hideValues(String[] names) {
            if (names != null) {
                HashStructure firstHash = this._hashes[0];
                String[] fullNames = this.toFullNames(names);
                firstHash.hideValues(fullNames);
            }
        }

        @Override
        public void recoverValues(String[] names) {
            if (names != null) {
                HashStructure firstHash = this._hashes[0];
                String[] fullNames = this.toFullNames(names);
                firstHash.recoverValues(fullNames);
            }
        }

        private String[] toFullNames(String[] names) {
            ArrayList<String> fullNames = new ArrayList<String>();
            int n = names.length;
            int i = 0;
            while (i < n) {
                String name = names[i];
                if (name != null) {
                    fullNames.add(this.getFullName(name));
                }
                ++i;
            }
            return fullNames.toArray(new String[fullNames.size()]);
        }

        @Override
        void setParent(Structure parent) {
            throw new IllegalStateException("A chained HashStructure cannot have a parent.");
        }

        String getFullName(String name) {
            return this._prefix + name;
        }

        protected boolean samePrefixAndLength(BaseChain other) {
            return other._hashes.length == this._hashes.length && BaseChain.areEqual(other._prefix, this._prefix);
        }

        @Override
        boolean equalsImpl(HashStructure o) {
            if (!(o instanceof BaseChain)) {
                return false;
            }
            BaseChain other = (BaseChain)o;
            if (!this.samePrefixAndLength(other)) {
                return false;
            }
            int i = 0;
            while (i < this._hashes.length) {
                if (!this._hashes[i].equals(other._hashes[i])) {
                    return false;
                }
                ++i;
            }
            return true;
        }

        BaseChain(HashStructure[] hashStructureArray, String string, 1 var3_3) {
            this(hashStructureArray, string);
        }

        static void mav$applyBatchChangesImpl(BaseChain baseChain, int n, Runnable runnable) {
            baseChain.applyBatchChangesImpl(n, runnable);
        }

        final class 1
        implements Runnable {
            private final /* synthetic */ int v$nextIndex;
            private final /* synthetic */ Runnable v$runnable;
            final /* synthetic */ BaseChain this$0;

            public void run() {
                BaseChain.mav$applyBatchChangesImpl(this.this$0, this.v$nextIndex, this.v$runnable);
            }

            public 1(BaseChain baseChain, int n, Runnable runnable) {
                this.v$runnable = runnable;
                this.v$nextIndex = n;
                this.this$0 = baseChain;
            }
        }
    }

    private static final class ChainForStatusQuo
    extends BaseChain {
        private ChainForStatusQuo(HashStructure[] hashes, String prefix) {
            super(hashes, prefix, null);
        }

        final HashStructure getChainedHashStructure(String fullName) {
            return new ChainForStatusQuo(this._hashes, fullName);
        }

        final ListStructure getChainedListStructure(ListStructure found, String fullName) {
            return found;
        }

        public void clear() {
            int n = this._hashes.length;
            int i = 0;
            while (i < n) {
                HashStructure hash = this._hashes[i];
                HashStructure subHash = this.getSubHashStructureAtPrefix(hash);
                if (subHash != null) {
                    subHash.clear();
                    break;
                }
                ++i;
            }
        }

        public void remove(String name) {
            String fullName = this.getFullName(name);
            int n = this._hashes.length;
            int i = 0;
            while (i < n) {
                HashStructure hash = this._hashes[i];
                if (hash.containsKey(fullName)) {
                    hash.remove(fullName);
                    break;
                }
                ++i;
            }
        }

        void putObject(String name, Object value) {
            String fullName = this.getFullName(name);
            HashStructure hash = this.findHashStructureWithKey(fullName);
            if (hash != null) {
                hash.putObject(fullName, value);
            }
        }

        void putPlaceholder(String name, Object value) {
            String fullName = this.getFullName(name);
            HashStructure hash = this.findHashStructureWithKey(fullName);
            if (hash != null) {
                hash.putPlaceholder(fullName, value);
            }
        }

        void putStructure(String name, Structure struct, String valueParamName, boolean isPlaceholder) {
            String fullName = this.getFullName(name);
            HashStructure hash = this.findHashStructureWithKey(fullName);
            if (hash != null) {
                hash.putStructure(fullName, struct, valueParamName, isPlaceholder);
            }
        }

        private HashStructure findHashStructureWithKey(String fullName) {
            HashStructure hash = null;
            int n = this._hashes.length;
            int i = 0;
            while (i < n) {
                hash = this._hashes[i];
                if (hash.containsKey(fullName)) {
                    return hash;
                }
                ++i;
            }
            return hash;
        }

        protected boolean equalsImpl(HashStructure o) {
            if (!(o instanceof ChainForStatusQuo)) {
                return false;
            }
            ChainForStatusQuo other = (ChainForStatusQuo)o;
            if (!this.samePrefixAndLength(other)) {
                return false;
            }
            int i = this._hashes.length;
            while (i > 0) {
                if (!this._hashes[i - 1].equals(other._hashes[i - 1])) {
                    return false;
                }
                --i;
            }
            return true;
        }

        ChainForStatusQuo(HashStructure[] hashStructureArray, String string, 1 var3_3) {
            this(hashStructureArray, string);
        }

        public final class 1 {
        }
    }

    private static final class ChainForOverriding
    extends BaseChain {
        private final HashStructure _firstHash;

        private ChainForOverriding(HashStructure[] hashes, String prefix) {
            super(hashes, prefix, null);
            this._firstHash = this._hashes[0];
        }

        final HashStructure getChainedHashStructure(String fullName) {
            return new ChainForOverriding(this._hashes, fullName);
        }

        final ListStructure getChainedListStructure(ListStructure found, String fullName) {
            HashStructure subHash = this.getSubHashStructureAtPrefix(this._firstHash);
            return ListStructure.newChainForOverriding(found, this._firstHash, fullName);
        }

        public void clear() {
            HashStructure subHash = this.getSubHashStructureAtPrefix(this._firstHash);
            if (subHash != null) {
                subHash.clear();
            }
        }

        public void remove(String name) {
            String fullName = this.getFullName(name);
            this._firstHash.remove(fullName);
        }

        void putObject(String name, Object value) {
            String fullName = this.getFullName(name);
            this._firstHash.putObject(fullName, value);
        }

        void putPlaceholder(String name, Object value) {
            String fullName = this.getFullName(name);
            this._firstHash.putPlaceholder(fullName, value);
        }

        void putStructure(String name, Structure struct, String valueParamName, boolean isPlaceholder) {
            String fullName = this.getFullName(name);
            this._firstHash.putStructure(fullName, struct, valueParamName, isPlaceholder);
        }

        ChainForOverriding(HashStructure[] hashStructureArray, String string, 1 var3_3) {
            this(hashStructureArray, string);
        }

        public final class 1 {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ReadOnly
    extends HashStructure {
        private final HashStructure _hash;

        private ReadOnly(HashStructure hash) {
            super(null);
            this._hash = hash;
        }

        @Override
        void removeChild(Structure child) {
            this.throwReadOnly();
        }

        @Override
        public void addStructureChangeListener(StructureChangeListener listener) {
            this.throwReadOnly();
        }

        @Override
        public void removeStructureChangeListener(StructureChangeListener listener) {
            this.throwReadOnly();
        }

        @Override
        public Object getObject(String name) {
            return this._hash.getObject(name);
        }

        @Override
        public Set<String> keySet() {
            return this._hash.keySet();
        }

        public Set persistentKeySet() {
            return this._hash.persistentKeySet();
        }

        @Override
        public int keyStatus(String key) {
            return this._hash.keyStatus(key);
        }

        @Override
        public void setKeyStatus(String key, int status) {
            this.throwReadOnly();
        }

        @Override
        HashStructure unchain() {
            return this._hash.unchain();
        }

        @Override
        public void clear() {
            this.throwReadOnly();
        }

        @Override
        public boolean containsKey(String name) {
            return this._hash.containsKey(name);
        }

        @Override
        public void remove(String name) {
            this.throwReadOnly();
        }

        @Override
        public int size() {
            return this._hash.size();
        }

        @Override
        public void setParentDirtyable(Dirtyable parentDirtyable) {
            this.throwReadOnly();
        }

        @Override
        public boolean isAnyValueOverridden(String[] names) {
            return this._hash.isAnyValueOverridden(names);
        }

        @Override
        public void hideValues(String[] names) {
            this.throwReadOnly();
        }

        @Override
        public void recoverValues(String[] names) {
            this.throwReadOnly();
        }

        @Override
        public boolean isReadOnly() {
            return true;
        }

        @Override
        public HashStructure asReadOnly() {
            return this;
        }

        @Override
        void putObject(String name, Object value) {
            this.throwReadOnly();
        }

        @Override
        void putPlaceholder(String name, Object value) {
            this.throwReadOnly();
        }

        @Override
        void putStructure(String name, Structure struct, String valueParamName, boolean isPlaceholder) {
            this.throwReadOnly();
        }

        private void throwReadOnly() {
            throw new UnsupportedOperationException("This HashStructure is read-only");
        }

        @Override
        protected boolean equalsImpl(HashStructure other) {
            if (!(other instanceof ReadOnly)) {
                return false;
            }
            return this._hash.equals(((ReadOnly)other)._hash);
        }

        ReadOnly(HashStructure hashStructure, 1 var2_2) {
            this(hashStructure);
        }

        public final class 1 {
        }
    }

    public final class 1 {
    }
}

