/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.data;

import java.net.URL;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import oracle.javatools.data.AuditedWriteList;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.Structure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListStructure
extends Structure
implements List {
    private final List<Object> _list;

    private void $init$() {
        this._list = Collections.synchronizedList(new AuditedWriteList(new ArrayList()));
    }

    private ListStructure() {
        this.$init$();
    }

    public static final ListStructure newInstance() {
        return new ListStructure();
    }

    static final ListStructure newChainForOverriding(ListStructure found, HashStructure firstHash, String fullName) {
        return new ChainForOverriding(found, firstHash, fullName);
    }

    public void add(int index, Object obj) {
        this.checkObjectForAdd(obj);
        this._list.add(index, obj);
        this.markDirty(true);
        this.fireValueAdded(Integer.toString(index), this, obj);
    }

    @Override
    public boolean add(Object obj) {
        this.checkObjectForAdd(obj);
        this._list.add(obj);
        this.markDirty(true);
        this.fireValueAdded(Integer.toString(this._list.size() - 1), this, obj);
        return true;
    }

    public boolean addPlaceholder(Object obj) {
        this.checkObjectForAdd(obj);
        this._list.add(obj);
        this.firePlaceholderValueAdded(Integer.toString(this._list.size() - 1), this, obj);
        return true;
    }

    public boolean addAll(int index, Collection coll) {
        boolean[] modified = new boolean[]{false};
        if (coll != null) {
            if (coll instanceof ListStructure) {
                ArrayList newColl = new ArrayList();
                newColl.addAll(coll);
                coll = newColl;
            }
            Iterator checkIter = coll.iterator();
            Iterator addIter = coll.iterator();
            while (checkIter.hasNext()) {
                this.checkObjectForAdd(checkIter.next(), false);
            }
            this.applyBatchChanges(new 1(this, index, addIter, modified));
        }
        return modified[0];
    }

    @Override
    public boolean addAll(Collection coll) {
        return this.addAll(this.size(), coll);
    }

    @Override
    public void clear() {
        int n = this.size();
        if (n > 0) {
            this.applyBatchChanges(new 2(this, n));
        }
    }

    @Override
    public boolean contains(Object obj) {
        return this._list.contains(obj);
    }

    @Override
    public boolean containsAll(Collection coll) {
        return this._list.containsAll(coll);
    }

    public Object get(int index) {
        return this._list.get(index);
    }

    @Override
    public int indexOf(Object obj) {
        if (obj instanceof Structure) {
            int n = this.size();
            int i = 0;
            while (i < n) {
                Object item = this.get(i);
                if (item == obj) {
                    return i;
                }
                ++i;
            }
            return -1;
        }
        return this._list.indexOf(obj);
    }

    @Override
    public boolean isEmpty() {
        return this._list.isEmpty();
    }

    public Object iteratorLock() {
        return this._list;
    }

    @Override
    public Iterator iterator() {
        return new 3();
    }

    @Override
    public int lastIndexOf(Object obj) {
        if (obj instanceof Structure) {
            int n = this.size();
            int i = n - 1;
            while (i >= 0) {
                Object item = this.get(i);
                if (item == obj) {
                    return i;
                }
                --i;
            }
            return -1;
        }
        return this._list.lastIndexOf(obj);
    }

    public ListIterator listIterator() {
        throw new UnsupportedOperationException();
    }

    public ListIterator listIterator(int i) {
        throw new UnsupportedOperationException();
    }

    public Object remove(int index) {
        Object obj = this._list.remove(index);
        this.dirtyAndMaybeDetach(obj);
        this.fireValueRemoved(Integer.toString(index), this, obj);
        return obj;
    }

    @Override
    public boolean remove(Object obj) {
        int i = this.indexOf(obj);
        if (i >= 0) {
            this.remove(i);
            return true;
        }
        return false;
    }

    @Override
    public boolean removeAll(Collection coll) {
        boolean[] modified = new boolean[]{false};
        if (coll != null) {
            Iterator iter = coll.iterator();
            this.applyBatchChanges(new 4(this, iter, modified));
        }
        return modified[0];
    }

    @Override
    public boolean retainAll(Collection coll) {
        boolean[] modified = new boolean[]{false};
        if (coll != null) {
            Iterator iter = this.iterator();
            this.applyBatchChanges(new 5(this, iter, coll, modified));
        }
        return modified[0];
    }

    public Object set(int index, Object newValue) {
        this.checkObjectForAdd(newValue);
        Object oldValue = this._list.set(index, newValue);
        this.dirtyAndMaybeDetach(oldValue);
        this.fireValueModified(Integer.toString(index), this, oldValue, newValue);
        return oldValue;
    }

    public List subList(int i, int j) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        return this._list.size();
    }

    @Override
    public Object[] toArray() {
        return this._list.toArray();
    }

    @Override
    public Object[] toArray(Object[] array) {
        return this._list.toArray(array);
    }

    public boolean mirror(List list) {
        if (this != list) {
            boolean equal;
            int size = this.size();
            boolean bl = equal = list == null && size == 0 || list != null && size == list.size();
            if (equal) {
                Iterator iter = this.iterator();
                Iterator otherIter = list.iterator();
                while (iter.hasNext()) {
                    if (!ListStructure.areDifferent(iter.next(), otherIter.next())) continue;
                    equal = false;
                    break;
                }
            }
            if (!equal) {
                this.applyBatchChanges(new 6(this, list));
                return true;
            }
        }
        return false;
    }

    public void internalPreprsist() {
        if (this._list.size() > 0) {
            HashSet keys = new HashSet();
            Collator collator = Collator.getInstance();
            try {
                7 c = new 7(this, keys, collator);
                Collections.sort(this._list, c);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    String getNameOfChild(Structure struct) {
        int n = this.size();
        int i = 0;
        while (i < n) {
            if (struct == this.get(i)) {
                return Integer.toString(i);
            }
            ++i;
        }
        return null;
    }

    @Override
    void removeChild(Structure child) {
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            if (iter.next() != child) continue;
            iter.remove();
            break;
        }
    }

    public ListStructure copyTo(ListStructure dest) {
        ListStructure finalDest = dest != null ? dest : ListStructure.newInstance();
        finalDest.applyBatchChanges(new 8(this, finalDest));
        return finalDest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void deepCopy(ListStructure srcList, ListStructure destList) {
        if (!srcList.equalsImpl(destList)) {
            destList.clear();
            Object object = srcList.iteratorLock();
            synchronized (object) {
                for (Object obj : srcList) {
                    if (obj instanceof HashStructure) {
                        HashStructure hash = (HashStructure)obj;
                        destList.add(hash.copyTo(null));
                        continue;
                    }
                    if (obj instanceof ListStructure) {
                        ListStructure list = (ListStructure)obj;
                        destList.add(list.copyTo(null));
                        continue;
                    }
                    destList.add(obj);
                }
            }
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        return this.equalsImpl((ListStructure)obj);
    }

    protected boolean equalsImpl(ListStructure other) {
        return this._list.equals(other._list);
    }

    @Override
    public int hashCode() {
        return this._list.hashCode();
    }

    private void dirtyAndMaybeDetach(Object obj) {
        this.markDirty(true);
        this.maybeDetach(obj);
    }

    private void maybeDetach(Object obj) {
        if (obj instanceof Structure) {
            ((Structure)obj).setParent(null);
        }
    }

    private void checkObjectForAdd(Object obj) {
        this.checkObjectForAdd(obj, true);
    }

    private void checkObjectForAdd(Object obj, boolean reparentNow) {
        if (obj != null) {
            Class<?> type = obj.getClass();
            if (type == HashStructure.Impl.class || type == ListStructure.class) {
                if (reparentNow) {
                    this.checkAndSetParent((Structure)obj, null);
                } else {
                    this.checkForCycleWith((Structure)obj);
                }
            } else if (type != String.class && type != Boolean.class && type != Integer.class && type != Long.class && type != Float.class && type != Double.class && type != URL.class) {
                throw new IllegalArgumentException("Type not supported by ListStructure: " + type.getName());
            }
        }
    }

    ListStructure(8 var1_1) {
        this();
    }

    static void mav$dirtyAndMaybeDetach(ListStructure listStructure, Object object) {
        listStructure.dirtyAndMaybeDetach(object);
    }

    static List ra$_list(ListStructure listStructure) {
        return listStructure._list;
    }

    final class 1
    implements Runnable {
        private final /* synthetic */ int v$index;
        private final /* synthetic */ Iterator v$addIter;
        private final /* synthetic */ boolean[] v$modified;
        final /* synthetic */ ListStructure this$0;

        public void run() {
            int i = this.v$index;
            while (this.v$addIter.hasNext()) {
                this.this$0.add(i++, this.v$addIter.next());
                this.v$modified[0] = true;
            }
        }

        public 1(ListStructure listStructure, int n, Iterator iterator, boolean[] blArray) {
            this.v$modified = blArray;
            this.v$addIter = iterator;
            this.v$index = n;
            this.this$0 = listStructure;
        }
    }

    final class 2
    implements Runnable {
        private final /* synthetic */ int v$n;
        final /* synthetic */ ListStructure this$0;

        public void run() {
            int i = this.v$n - 1;
            while (i >= 0) {
                this.this$0.remove(i);
                --i;
            }
        }

        public 2(ListStructure listStructure, int n) {
            this.v$n = n;
            this.this$0 = listStructure;
        }
    }

    final class 3
    implements Iterator {
        private int _curIndex;
        private int _removeCount;
        private final Iterator _iter;
        private Object _cur;

        private void $init$() {
            this._curIndex = -1;
            this._removeCount = 0;
            this._iter = ListStructure.ra$_list(ListStructure.this).iterator();
        }

        public boolean hasNext() {
            return this._iter.hasNext();
        }

        public Object next() {
            ++this._curIndex;
            this._cur = this._iter.next();
            return this._cur;
        }

        public void remove() {
            this._iter.remove();
            ListStructure.mav$dirtyAndMaybeDetach(ListStructure.this, this._cur);
            ListStructure.this.fireValueRemoved(Integer.toString(this._curIndex - this._removeCount++), ListStructure.this, this._cur);
        }

        public 3() {
            this.$init$();
        }
    }

    final class 4
    implements Runnable {
        private final /* synthetic */ Iterator v$iter;
        private final /* synthetic */ boolean[] v$modified;
        final /* synthetic */ ListStructure this$0;

        public void run() {
            while (this.v$iter.hasNext()) {
                this.v$modified[0] = this.v$modified[0] | this.this$0.remove(this.v$iter.next());
            }
        }

        public 4(ListStructure listStructure, Iterator iterator, boolean[] blArray) {
            this.v$modified = blArray;
            this.v$iter = iterator;
            this.this$0 = listStructure;
        }
    }

    final class 5
    implements Runnable {
        private final /* synthetic */ Iterator v$iter;
        private final /* synthetic */ Collection v$coll;
        private final /* synthetic */ boolean[] v$modified;
        final /* synthetic */ ListStructure this$0;

        public void run() {
            while (this.v$iter.hasNext()) {
                Object obj = this.v$iter.next();
                if (this.v$coll.contains(obj)) continue;
                this.v$iter.remove();
                this.v$modified[0] = true;
            }
        }

        public 5(ListStructure listStructure, Iterator iterator, Collection collection, boolean[] blArray) {
            this.v$modified = blArray;
            this.v$coll = collection;
            this.v$iter = iterator;
            this.this$0 = listStructure;
        }
    }

    final class 6
    implements Runnable {
        private final /* synthetic */ List v$list;
        final /* synthetic */ ListStructure this$0;

        public void run() {
            this.this$0.clear();
            this.this$0.addAll((Collection)this.v$list);
        }

        public 6(ListStructure listStructure, List list) {
            this.v$list = list;
            this.this$0 = listStructure;
        }
    }

    final class 7
    implements Comparator {
        private final /* synthetic */ HashSet v$keys;
        private final /* synthetic */ Collator v$collator;
        final /* synthetic */ ListStructure this$0;

        public int compare(Object o1, Object o2) {
            HashStructure hash1 = (HashStructure)o1;
            HashStructure hash2 = (HashStructure)o2;
            this.v$keys.clear();
            this.v$keys.addAll(hash1.persistentKeySet());
            this.v$keys.addAll(hash2.persistentKeySet());
            Object[] keyArray = this.v$keys.toArray(new String[this.v$keys.size()]);
            Arrays.sort(keyArray);
            int n = keyArray.length;
            int i = 0;
            while (i < n) {
                Object v2;
                Object key = keyArray[i];
                Object v1 = hash1.getObject((String)key);
                if (v1 != (v2 = hash2.getObject((String)key))) {
                    String s2;
                    if (v1 == null) {
                        return -1;
                    }
                    if (v2 == null) {
                        return 1;
                    }
                    String s1 = this.toString(v1);
                    int comp = this.v$collator.compare(s1, s2 = this.toString(v2));
                    if (comp != 0) {
                        return comp;
                    }
                }
                ++i;
            }
            return 0;
        }

        private String toString(Object obj) {
            if (obj instanceof URL) {
                return ((URL)obj).getPath();
            }
            return obj.toString();
        }

        public 7(ListStructure listStructure, HashSet hashSet, Collator collator) {
            this.v$collator = collator;
            this.v$keys = hashSet;
            this.this$0 = listStructure;
        }
    }

    final class 8
    implements Runnable {
        private final /* synthetic */ ListStructure v$finalDest;
        final /* synthetic */ ListStructure this$0;

        public void run() {
            ListStructure.deepCopy(this.this$0, this.v$finalDest);
        }

        public 8(ListStructure listStructure, ListStructure listStructure2) {
            this.v$finalDest = listStructure2;
            this.this$0 = listStructure;
        }
    }

    private static final class ChainForOverriding
    extends ListStructure {
        private final ListStructure _found;
        private ListStructure _firstList;
        private final HashStructure _firstHash;
        private final String _fullName;

        ChainForOverriding(ListStructure found, HashStructure firstHash, String fullName) {
            super(null);
            this._found = found;
            this._firstHash = firstHash;
            this._fullName = fullName;
        }

        public void add(int index, Object obj) {
            this.getWriteList().add(index, obj);
        }

        public boolean add(Object obj) {
            return this.getWriteList().add(obj);
        }

        public boolean addAll(int index, Collection coll) {
            return this.getWriteList().addAll(index, coll);
        }

        public boolean addAll(Collection coll) {
            return this.getWriteList().addAll(coll);
        }

        public void clear() {
            this.getWriteList().clear();
        }

        public boolean contains(Object obj) {
            return this.getReadList().contains(obj);
        }

        public boolean containsAll(Collection coll) {
            return this.getReadList().containsAll(coll);
        }

        public Object get(int index) {
            if (this._firstList != null) {
                return this._firstList.get(index);
            }
            Object obj = this._found.get(index);
            Iterator concurrentModDetector = this._found.iterator();
            if (obj instanceof HashStructure) {
                HashStructure hash = (HashStructure)obj;
                HashStructure hashCopy = hash.copyTo(null);
                1DL dl = new 1DL(this, hashCopy, concurrentModDetector, index);
                hashCopy.setParent(dl);
                return hashCopy;
            }
            if (obj instanceof ListStructure) {
                ListStructure list = (ListStructure)obj;
                ListStructure listCopy = list.copyTo(null);
                1DL dl = new 1DL(this, listCopy, concurrentModDetector, index);
                listCopy.setParent(dl);
                return listCopy;
            }
            return obj;
        }

        public int indexOf(Object obj) {
            return this.getReadList().indexOf(obj);
        }

        public boolean isEmpty() {
            return this.getReadList().isEmpty();
        }

        public Iterator iterator() {
            if (this._firstList != null) {
                return this._firstList.iterator();
            }
            ListStructure copy = this.getListCopy();
            2DL dl = new 2DL(this, copy);
            copy.setParent(dl);
            return copy.iterator();
        }

        public int lastIndexOf(Object obj) {
            return this.getReadList().lastIndexOf(obj);
        }

        public ListIterator listIterator() {
            if (this._firstList != null) {
                return this._firstList.listIterator();
            }
            throw new UnsupportedOperationException();
        }

        public ListIterator listIterator(int i) {
            if (this._firstList != null) {
                return this._firstList.listIterator(i);
            }
            throw new UnsupportedOperationException();
        }

        public Object remove(int index) {
            return this.getWriteList().remove(index);
        }

        public boolean remove(Object obj) {
            return this.getWriteList().remove(obj);
        }

        public boolean removeAll(Collection coll) {
            return this.getWriteList().removeAll(coll);
        }

        public boolean retainAll(Collection coll) {
            return this.getWriteList().retainAll(coll);
        }

        public Object set(int index, Object obj) {
            return this.getWriteList().set(index, obj);
        }

        public List subList(int i, int j) {
            throw new UnsupportedOperationException();
        }

        public int size() {
            return this.getReadList().size();
        }

        public Object[] toArray() {
            return this.getListCopy().toArray();
        }

        public Object[] toArray(Object[] array) {
            return this.getListCopy().toArray(array);
        }

        protected boolean equalsImpl(ListStructure other) {
            if (this._firstList == null) {
                return other == null;
            }
            return this._firstList.equalsImpl(other);
        }

        private ListStructure getWriteList() {
            if (this._firstList == null) {
                ListStructure existingList = this._firstHash.getListStructure(this._fullName);
                if (existingList != null) {
                    this._firstList = existingList;
                } else {
                    this._firstList = this.getListCopy();
                    this._firstHash.putListStructure(this._fullName, this._firstList);
                }
            }
            return this._firstList;
        }

        private ListStructure getReadList() {
            return this._firstList != null ? this._firstList : this._found;
        }

        private ListStructure getListCopy() {
            return this.getReadList().copyTo(null);
        }

        static HashStructure ra$_firstHash(ChainForOverriding chainForOverriding) {
            return chainForOverriding._firstHash;
        }

        static String ra$_fullName(ChainForOverriding chainForOverriding) {
            return chainForOverriding._fullName;
        }

        class 1DL
        extends Structure {
            private final Object _obj;
            private boolean _copyHappened;
            private final /* synthetic */ Iterator v$concurrentModDetector;
            private final /* synthetic */ int v$index;
            final /* synthetic */ ChainForOverriding this$0;

            1DL(ChainForOverriding chainForOverriding, Object obj, Iterator iterator, int n) {
                this.v$index = n;
                this.v$concurrentModDetector = iterator;
                this.this$0 = chainForOverriding;
                this._obj = obj;
            }

            public void markDirty(boolean dirty) {
                if (!this._copyHappened && dirty) {
                    if (!this.v$concurrentModDetector.hasNext()) {
                        throw new ConcurrentModificationException();
                    }
                    this.v$concurrentModDetector.next();
                    this.this$0.set(this.v$index, this._obj);
                    this._copyHappened = true;
                }
            }

            void removeChild(Structure child) {
            }
        }

        class 2DL
        extends Structure {
            private boolean _copyHappened;
            private final /* synthetic */ ListStructure v$copy;
            final /* synthetic */ ChainForOverriding this$0;

            public void markDirty(boolean dirty) {
                if (!this._copyHappened && dirty) {
                    ChainForOverriding.ra$_firstHash(this.this$0).putListStructure(ChainForOverriding.ra$_fullName(this.this$0), this.v$copy);
                    this._copyHappened = true;
                }
            }

            void removeChild(Structure child) {
            }

            2DL(ChainForOverriding chainForOverriding, ListStructure listStructure) {
                this.v$copy = listStructure;
                this.this$0 = chainForOverriding;
            }
        }
    }
}

