/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.data;

import oracle.javatools.data.ChangeBuffer;
import oracle.javatools.data.ChangeInfo;
import oracle.javatools.data.Dirtyable;
import oracle.javatools.data.StructureChangeEvent;
import oracle.javatools.data.StructureChangeListener;
import oracle.javatools.util.CopyOnWriteList;

public abstract class Structure
implements Dirtyable {
    private transient Structure _parent;
    private transient String _structName;
    private transient boolean _dirty;
    private final CopyOnWriteList _listeners;
    private final Object _changeBufferLock;
    private int _changeBufferDepth;
    private transient ChangeBuffer _changeBuffer;

    private void $init$() {
        this._listeners = new CopyOnWriteList();
        this._changeBufferLock = new Object();
        this._changeBufferDepth = 0;
    }

    Structure() {
        this.$init$();
    }

    public final boolean isDirty() {
        Dirtyable parent = this.getParentDirtyable();
        return parent != null ? parent.isDirty() : this._dirty;
    }

    public void markDirty(boolean dirty) {
        Dirtyable parent = this.getParentDirtyable();
        if (parent != null) {
            parent.markDirty(dirty);
        } else {
            this._dirty = dirty;
        }
        if (dirty) {
            this.clearParentPlaceholderFlags();
        }
    }

    public void clear() {
    }

    public String getStructName() {
        Structure parent;
        if (this._structName == null && this.getParent() != null && (parent = this.getParent()) != null) {
            return parent.getNameOfChild(this);
        }
        return this._structName;
    }

    public String getFullName() {
        Structure parent = this.getParent();
        if (parent != null) {
            String parentName = parent.getFullName();
            String structName = this.getStructName();
            if (parentName == null) {
                return structName;
            }
            return parentName + "/" + structName;
        }
        return null;
    }

    public void addStructureChangeListener(StructureChangeListener listener) {
        if (listener != null) {
            this._listeners.addIfAbsent(listener);
        }
    }

    public void removeStructureChangeListener(StructureChangeListener listener) {
        if (listener != null) {
            this._listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyBatchChanges(Runnable runnable) {
        Object object = this._changeBufferLock;
        synchronized (object) {
            if (this._changeBuffer == null) {
                this._changeBuffer = new ChangeBuffer();
            }
            ++this._changeBufferDepth;
        }
        ChangeBuffer changeBuffer = null;
        try {
            try {
                runnable.run();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        catch (Throwable throwable) {
            Object object2 = this._changeBufferLock;
            synchronized (object2) {
                if (--this._changeBufferDepth == 0) {
                    changeBuffer = this._changeBuffer;
                    this._changeBuffer = null;
                }
            }
            throw throwable;
        }
        Object object3 = this._changeBufferLock;
        synchronized (object3) {
            if (--this._changeBufferDepth == 0) {
                changeBuffer = this._changeBuffer;
                this._changeBuffer = null;
            }
        }
        if (changeBuffer != null && changeBuffer.getChanges().length > 0) {
            this.fireBatchEvent("", changeBuffer);
        }
    }

    private void clearParentPlaceholderFlags() {
        Structure parent = this.getParent();
        if (parent != null) {
            parent.clearPlaceholderFlag(this.getStructName());
        }
    }

    void clearPlaceholderFlag(String structName) {
    }

    Dirtyable getParentDirtyable() {
        return this.getParent();
    }

    String getNameOfChild(Structure struct) {
        return null;
    }

    abstract void removeChild(Structure var1);

    final Structure getParent() {
        return this._parent;
    }

    private void setStructName(String structName) {
        this._structName = structName;
    }

    void setParent(Structure parent) {
        this._parent = parent;
    }

    final void checkAndSetParent(Structure struct, String structName) {
        this.checkForCycleWith(struct);
        this.removeFromParent(struct);
        struct.setParent(this);
        struct.setStructName(structName);
    }

    static boolean areDifferent(Object o1, Object o2) {
        return Structure.areEqual(o1, o2) ^ true;
    }

    static boolean areEqual(Object o1, Object o2) {
        if (o1 == o2) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        return o1.equals(o2);
    }

    void checkForCycleWith(Structure other) {
        Structure curParent = this;
        while (curParent != null) {
            if (curParent == other) {
                throw new IllegalStateException("Cyclical references are not allowed.");
            }
            curParent = curParent.getParent();
        }
    }

    private void removeFromParent(Structure child) {
        Structure oldParent = child.getParent();
        if (oldParent != null) {
            oldParent.removeChild(child);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void fireValueModified(String name, Structure valueParent, Object oldValue, Object newValue) {
        Structure parent;
        Object object = this._changeBufferLock;
        synchronized (object) {
            if (this._changeBuffer != null) {
                this._changeBuffer.addChangeInfo(ChangeInfo.valueModified(name, valueParent, oldValue, newValue));
                return;
            }
        }
        if (this._listeners.size() > 0) {
            ChangeInfo[] details = new ChangeInfo[]{ChangeInfo.valueModified(name, valueParent, oldValue, newValue)};
            this.fireStructureChangeEvent(details);
        }
        if ((parent = this.getParent()) != null) {
            String nameInParent = this.getNameInParent(name);
            parent.fireValueModified(nameInParent, valueParent, oldValue, newValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void fireValueAdded(String name, Structure valueParent, Object newValue) {
        Structure parent;
        Object object = this._changeBufferLock;
        synchronized (object) {
            if (this._changeBuffer != null) {
                this._changeBuffer.addChangeInfo(ChangeInfo.valueAdded(name, valueParent, newValue));
                return;
            }
        }
        if (this._listeners.size() > 0) {
            ChangeInfo[] details = new ChangeInfo[]{ChangeInfo.valueAdded(name, valueParent, newValue)};
            this.fireStructureChangeEvent(details);
        }
        if ((parent = this.getParent()) != null) {
            String nameInParent = this.getNameInParent(name);
            parent.fireValueAdded(nameInParent, valueParent, newValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void firePlaceholderValueAdded(String name, Structure valueParent, Object newValue) {
        Structure parent;
        Object object = this._changeBufferLock;
        synchronized (object) {
            if (this._changeBuffer != null) {
                this._changeBuffer.addChangeInfo(ChangeInfo.placeholderValueAdded(name, valueParent, newValue));
                return;
            }
        }
        if (this._listeners.size() > 0) {
            ChangeInfo[] details = new ChangeInfo[]{ChangeInfo.placeholderValueAdded(name, valueParent, newValue)};
            this.fireStructureChangeEvent(details);
        }
        if ((parent = this.getParent()) != null) {
            String nameInParent = this.getNameInParent(name);
            parent.firePlaceholderValueAdded(nameInParent, valueParent, newValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void fireValueRemoved(String name, Structure valueParent, Object oldValue) {
        Structure parent;
        Object object = this._changeBufferLock;
        synchronized (object) {
            if (this._changeBuffer != null) {
                this._changeBuffer.addChangeInfo(ChangeInfo.valueRemoved(name, valueParent, oldValue));
                return;
            }
        }
        if (this._listeners.size() > 0) {
            ChangeInfo[] details = new ChangeInfo[]{ChangeInfo.valueRemoved(name, valueParent, oldValue)};
            this.fireStructureChangeEvent(details);
        }
        if ((parent = this.getParent()) != null) {
            String nameInParent = this.getNameInParent(name);
            parent.fireValueRemoved(nameInParent, valueParent, oldValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireBatchEvent(String namePrefix, ChangeBuffer buffer) {
        Structure parent;
        Object object = this._changeBufferLock;
        synchronized (object) {
            if (this._changeBuffer != null) {
                this._changeBuffer.addChangeInfos(buffer.getChangesWithPrefixApplied(namePrefix));
                return;
            }
        }
        if (this._listeners.size() > 0) {
            ChangeInfo[] details = buffer.getChangesWithPrefixApplied(namePrefix);
            this.fireStructureChangeEvent(details);
        }
        if ((parent = this.getParent()) != null) {
            String prefixInParent = this.getNameInParent(namePrefix);
            parent.fireBatchEvent(prefixInParent, buffer);
        }
    }

    private String getNameInParent(String name) {
        return this.getStructName() + "/" + name;
    }

    private void fireStructureChangeEvent(ChangeInfo[] details) {
        StructureChangeEvent event = new StructureChangeEvent((Object)this, details);
        Object[] listeners = this._listeners.getItems();
        int n = listeners.length;
        int i = 0;
        while (i < n) {
            StructureChangeListener listener = (StructureChangeListener)listeners[i];
            listener.structureValuesChanged(event);
            ++i;
        }
    }
}

