/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.jndi;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.ContextNotEmptyException;
import javax.naming.InvalidNameException;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameClassPair;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.NotContextException;
import javax.naming.OperationNotSupportedException;
import oracle.javatools.jndi.DefaultNameParser;
import oracle.javatools.jndi.FlatContext;

final class HashContext
extends FlatContext {
    private final HashMap _bindings;
    private final HashMap _envMap;
    private final String _namePrefix;
    private static final Object SUBCONTEXT = new Object();

    HashContext(Hashtable env) {
        this._bindings = new HashMap();
        this._envMap = new HashMap();
        this._namePrefix = "";
        if (env != null) {
            this._envMap.put(this._namePrefix, new HashMap(env));
        }
    }

    private HashContext(HashContext context, String namePrefix) {
        this._bindings = context._bindings;
        this._envMap = context._envMap;
        this._namePrefix = namePrefix != null ? namePrefix : "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object lookup(String name) throws NamingException {
        this.checkNameIsNotNull(name);
        if (name.length() == 0) {
            return new HashContext(this, this._namePrefix);
        }
        String absName = this.getAbsoluteName(name);
        HashMap hashMap = this._bindings;
        synchronized (hashMap) {
            if (this._bindings.containsKey(absName)) {
                Object value = this._bindings.get(absName);
                Object object = value != SUBCONTEXT ? value : new HashContext(this, absName);
                return object;
            }
        }
        throw new NameNotFoundException("The name '" + name + "' is not bound in this context");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bind(String name, Object obj) throws NamingException {
        this.checkNameIsNotEmpty(name);
        HashMap hashMap = this._bindings;
        synchronized (hashMap) {
            String absName = this.getAbsoluteName(name);
            this.checkSubcontexts(absName);
            if (this._bindings.containsKey(absName)) {
                throw new NameAlreadyBoundException("JNDI spec requires the use of rebind() to overwrite an existing binding.");
            }
            this._bindings.put(absName, obj);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rebind(String name, Object obj) throws NamingException {
        this.checkNameIsNotEmpty(name);
        HashMap hashMap = this._bindings;
        synchronized (hashMap) {
            String absName = this.getAbsoluteName(name);
            this.checkSubcontexts(absName);
            Object curValue = this._bindings.get(absName);
            if (curValue == SUBCONTEXT) {
                throw new OperationNotSupportedException("The object bound to the name '" + name + "' is a subcontext, and rebinding of a subcontext is not supported by this Context implementation.");
            }
            this._bindings.put(absName, obj);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unbind(String name) throws NamingException {
        this.checkNameIsNotEmpty(name);
        HashMap hashMap = this._bindings;
        synchronized (hashMap) {
            String absName = this.getAbsoluteName(name);
            Object obj = this._bindings.get(absName);
            if (obj == SUBCONTEXT) {
                this.checkSubcontextIsEmpty(absName);
            }
            this._bindings.remove(absName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rename(String oldName, String newName) throws NamingException {
        this.checkNameIsNotEmpty(oldName);
        this.checkNameIsNotEmpty(newName);
        HashMap hashMap = this._bindings;
        synchronized (hashMap) {
            String oldAbsName = this.getAbsoluteName(oldName);
            String newAbsName = this.getAbsoluteName(newName);
            this.checkSubcontexts(newAbsName);
            if (!this._bindings.containsKey(oldAbsName)) {
                throw new NameNotFoundException("The name '" + oldName + "' is not bound in this context, so it cannot be renamed.");
            }
            if (this._bindings.containsKey(newAbsName)) {
                throw new NameAlreadyBoundException("The name '" + newName + "' is already bound in this context, so '" + oldName + "' cannot be renamed to '" + newName + "'.");
            }
            this._bindings.put(newAbsName, this._bindings.remove(oldAbsName));
        }
    }

    public NamingEnumeration list(String name) throws NamingException {
        return new NameEnum(name, false);
    }

    public NamingEnumeration listBindings(String name) throws NamingException {
        return new NameEnum(name, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroySubcontext(String name) throws NamingException {
        this.checkNameIsNotEmpty(name);
        HashMap hashMap = this._bindings;
        synchronized (hashMap) {
            String absName = this.getAbsoluteName(name);
            if (!this._bindings.containsKey(absName)) {
                throw new NameNotFoundException("The name '" + name + "' is not bound in this context, so there is no subcontext to destroy.");
            }
            if (this._bindings.get(absName) != SUBCONTEXT) {
                throw new NotContextException("The name '" + name + "' is bound to an object, not a subcontext.");
            }
            this.checkSubcontextIsEmpty(absName);
            this._bindings.remove(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Context createSubcontext(String name) throws NamingException {
        this.checkNameIsNotEmpty(name);
        HashMap hashMap = this._bindings;
        synchronized (hashMap) {
            String absName = this.getAbsoluteName(name);
            this.checkSubcontexts(absName);
            if (this._bindings.containsKey(absName)) {
                throw new NameAlreadyBoundException("The name '" + name + "' is already bound in this context, so a subcontext with that name cannot be created.");
            }
            this._bindings.put(absName, SUBCONTEXT);
            HashMap hashMap2 = this._envMap;
            synchronized (hashMap2) {
                String parentName;
                int lastSlash = absName.lastIndexOf("/");
                String string = parentName = lastSlash >= 0 ? absName.substring(0, lastSlash) : "";
                if (this._envMap.containsKey(parentName)) {
                    HashMap parentEnv = (HashMap)this._envMap.get(parentName);
                    this._envMap.put(absName, new HashMap(parentEnv));
                }
            }
            HashContext hashContext = new HashContext(this, absName);
            return hashContext;
        }
    }

    public Object lookupLink(String name) throws NamingException {
        return this.lookup(name);
    }

    public NameParser getNameParser(String name) throws NamingException {
        return new DefaultNameParser();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object addToEnvironment(String key, Object value) throws NamingException {
        HashMap contextEnv;
        if (key == null) {
            throw new NullPointerException("JNDI spec does not allow the context environment to have a property with a null name.");
        }
        HashMap hashMap = contextEnv = this.findOrCreateContextEnv();
        synchronized (hashMap) {
            Object object = contextEnv.put(key, value);
            return object;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object removeFromEnvironment(String key) throws NamingException {
        HashMap contextEnv = this.findContextEnv();
        if (contextEnv == null) {
            return null;
        }
        HashMap hashMap = contextEnv;
        synchronized (hashMap) {
            Object v = contextEnv.remove(key);
            return v;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable getEnvironment() throws NamingException {
        HashMap contextEnv = this.findContextEnv();
        if (contextEnv == null) {
            return new Hashtable(0);
        }
        HashMap hashMap = contextEnv;
        synchronized (hashMap) {
            Hashtable hashtable = new Hashtable(contextEnv);
            return hashtable;
        }
    }

    public void close() throws NamingException {
    }

    public String getNameInNamespace() throws NamingException {
        return this._namePrefix;
    }

    private void checkNameIsNotNull(String name) throws InvalidNameException {
        if (name == null) {
            throw new InvalidNameException("A null name is not allowed for JNDI operations.");
        }
    }

    private void checkNameIsNotEmpty(String name) throws InvalidNameException {
        this.checkNameIsNotNull(name);
        if (name.length() == 0) {
            throw new InvalidNameException("An empty name is not allowed for this JNDI operation.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkSubcontextIsEmpty(String absName) throws ContextNotEmptyException {
        if (absName == null || absName.length() == 0) {
            throw new IllegalStateException("****  INTERNAL ERROR: empty subcontext name in checkSubcontextIsEmpty");
        }
        HashMap hashMap = this._bindings;
        synchronized (hashMap) {
            Iterator iter = this._bindings.keySet().iterator();
            while (iter.hasNext()) {
                String boundName = iter.next().toString();
                if (!boundName.startsWith(absName) || boundName.equals(absName)) continue;
                throw new ContextNotEmptyException("This JNDI operation requires the subcontext to be empty before proceeding.");
            }
        }
    }

    private void checkSubcontexts(String absName) throws NamingException {
        int curSlash = absName.indexOf(47);
        while (curSlash >= 0) {
            String curName = absName.substring(0, curSlash);
            if (!this._bindings.containsKey(curName)) {
                throw new NameNotFoundException("There is no subcontext named '" + curName + "'.  The JNDI spec requires that subcontexts be created first with the createSubcontext() method before binding objects.");
            }
            Object curValue = this._bindings.get(curName);
            if (curValue != SUBCONTEXT) {
                throw new NotContextException("Expecting a subcontext but found an object bound to the name '" + curName + "'.");
            }
            curSlash = absName.indexOf(47, curSlash + 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HashMap findContextEnv() {
        HashMap hashMap = this._envMap;
        synchronized (hashMap) {
            HashMap hashMap2 = (HashMap)this._envMap.get(this._namePrefix);
            return hashMap2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HashMap findOrCreateContextEnv() {
        HashMap hashMap = this._envMap;
        synchronized (hashMap) {
            HashMap contextEnv = this.findContextEnv();
            if (contextEnv == null) {
                contextEnv = new HashMap();
                this._envMap.put(this._namePrefix, contextEnv);
            }
            HashMap hashMap2 = contextEnv;
            return hashMap2;
        }
    }

    private String getAbsoluteName(String relativeName) {
        if (relativeName == null) {
            throw new IllegalStateException("****  INTERNAL ERROR: getAbsoluteName() received a null name.");
        }
        if (relativeName.length() == 0) {
            return this._namePrefix;
        }
        return this._namePrefix.length() > 0 ? this._namePrefix + "/" + relativeName : relativeName;
    }

    private static HashContext newHashContext(HashContext context, String namePrefix) {
        return new HashContext(context, namePrefix);
    }

    static HashMap ra$_bindings(HashContext hashContext) {
        return hashContext._bindings;
    }

    static Object ra$SUBCONTEXT() {
        return SUBCONTEXT;
    }

    static HashContext maS$newHashContext(HashContext hashContext, String string) {
        return HashContext.newHashContext(hashContext, string);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class NameEnum
    implements NamingEnumeration {
        private final int _absNamePrefixOffset;
        private final Iterator _names;
        private final boolean _wantBindings;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        NameEnum(String absName, boolean wantBindings) {
            int absNameLen = absName.length();
            this._absNamePrefixOffset = absNameLen > 0 ? absNameLen + 1 : 0;
            ArrayList<String> nameList = new ArrayList<String>();
            HashMap hashMap = HashContext.ra$_bindings(HashContext.this);
            synchronized (hashMap) {
                Iterator iter = HashContext.ra$_bindings(HashContext.this).keySet().iterator();
                while (iter.hasNext()) {
                    String name = iter.next().toString();
                    if ((absNameLen != 0 || name.indexOf(47) >= 0) && (!name.startsWith(absName) || name.equals(absName) || name.charAt(absNameLen) != '/' || name.indexOf(47, this._absNamePrefixOffset) >= 0)) continue;
                    nameList.add(name);
                }
            }
            this._names = nameList.iterator();
            this._wantBindings = wantBindings;
        }

        @Override
        public boolean hasMoreElements() {
            return this._names.hasNext();
        }

        @Override
        public boolean hasMore() throws NamingException {
            return this.hasMoreElements();
        }

        @Override
        public Object nextElement() {
            String absName = this._names.next().toString();
            String name = absName.substring(this._absNamePrefixOffset);
            Object obj = HashContext.ra$_bindings(HashContext.this).get(absName);
            if (this._wantBindings) {
                return new Binding(name, obj != HashContext.ra$SUBCONTEXT() ? obj : HashContext.maS$newHashContext(HashContext.this, name));
            }
            String className = obj == HashContext.ra$SUBCONTEXT() ? HashContext.class.getName() : (obj != null ? obj.getClass().getName() : "null");
            return new NameClassPair(name, className);
        }

        public Object next() throws NamingException {
            return this.nextElement();
        }

        @Override
        public void close() {
        }
    }
}

