/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.jndi;

import java.util.Hashtable;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import oracle.javatools.jndi.NullContext;

public class LocalContext
implements Context {
    private final Context _context;

    public LocalContext() {
        this(LocalContext.getInitialContext());
    }

    private LocalContext(Context context) {
        if (context == null) {
            throw new NullPointerException();
        }
        this._context = context;
    }

    private static Context getInitialContext() {
        try {
            InitialContext initialContext = new InitialContext();
            return initialContext;
        }
        catch (NamingException e) {
            NullContext nullContext = new NullContext();
            return nullContext;
        }
    }

    public Object lookup(Name name) {
        try {
            Object object = this._context.lookup(name);
            return object;
        }
        catch (NamingException e) {
            Object var4_4 = null;
            return var4_4;
        }
    }

    public Object lookup(String name) {
        try {
            Object object = this._context.lookup(name);
            return object;
        }
        catch (NamingException e) {
            Object var4_4 = null;
            return var4_4;
        }
    }

    public void bind(Name name, Object obj) {
        try {
            this._context.bind(name, obj);
        }
        catch (NamingException namingException) {
            // empty catch block
        }
    }

    public void bind(String name, Object obj) {
        try {
            this._context.bind(name, obj);
        }
        catch (NamingException namingException) {
            // empty catch block
        }
    }

    public void rebind(Name name, Object obj) {
        try {
            this._context.rebind(name, obj);
        }
        catch (NamingException namingException) {
            // empty catch block
        }
    }

    public void rebind(String name, Object obj) {
        try {
            this._context.rebind(name, obj);
        }
        catch (NamingException namingException) {
            // empty catch block
        }
    }

    public void unbind(Name name) {
        try {
            this._context.unbind(name);
        }
        catch (NamingException namingException) {
            // empty catch block
        }
    }

    public void unbind(String name) {
        try {
            this._context.unbind(name);
        }
        catch (NamingException namingException) {
            // empty catch block
        }
    }

    public void rename(Name oldName, Name newName) {
        try {
            this._context.rename(oldName, newName);
        }
        catch (NamingException namingException) {
            // empty catch block
        }
    }

    public void rename(String oldName, String newName) {
        try {
            this._context.rename(oldName, newName);
        }
        catch (NamingException namingException) {
            // empty catch block
        }
    }

    public NamingEnumeration list(Name name) {
        try {
            NamingEnumeration<NameClassPair> namingEnumeration = this._context.list(name);
            return namingEnumeration;
        }
        catch (NamingException e) {
            NamingEnumeration namingEnumeration = null;
            return namingEnumeration;
        }
    }

    public NamingEnumeration list(String name) {
        try {
            NamingEnumeration<NameClassPair> namingEnumeration = this._context.list(name);
            return namingEnumeration;
        }
        catch (NamingException e) {
            NamingEnumeration namingEnumeration = null;
            return namingEnumeration;
        }
    }

    public NamingEnumeration listBindings(Name name) {
        try {
            NamingEnumeration<Binding> namingEnumeration = this._context.listBindings(name);
            return namingEnumeration;
        }
        catch (NamingException e) {
            NamingEnumeration namingEnumeration = null;
            return namingEnumeration;
        }
    }

    public NamingEnumeration listBindings(String name) {
        try {
            NamingEnumeration<Binding> namingEnumeration = this._context.listBindings(name);
            return namingEnumeration;
        }
        catch (NamingException e) {
            NamingEnumeration namingEnumeration = null;
            return namingEnumeration;
        }
    }

    public void destroySubcontext(Name name) {
        try {
            this._context.destroySubcontext(name);
        }
        catch (NamingException namingException) {
            // empty catch block
        }
    }

    public void destroySubcontext(String name) {
        try {
            this._context.destroySubcontext(name);
        }
        catch (NamingException namingException) {
            // empty catch block
        }
    }

    public Context createSubcontext(Name name) {
        try {
            Context context = this._context.createSubcontext(name);
            return context;
        }
        catch (NamingException e) {
            Context context = null;
            return context;
        }
    }

    public Context createSubcontext(String name) {
        try {
            Context context = this._context.createSubcontext(name);
            return context;
        }
        catch (NamingException e) {
            Context context = null;
            return context;
        }
    }

    public Object lookupLink(Name name) {
        try {
            Object object = this._context.lookupLink(name);
            return object;
        }
        catch (NamingException e) {
            Object var4_4 = null;
            return var4_4;
        }
    }

    public Object lookupLink(String name) {
        try {
            Object object = this._context.lookupLink(name);
            return object;
        }
        catch (NamingException e) {
            Object var4_4 = null;
            return var4_4;
        }
    }

    public NameParser getNameParser(Name name) {
        try {
            NameParser nameParser = this._context.getNameParser(name);
            return nameParser;
        }
        catch (NamingException e) {
            NameParser nameParser = null;
            return nameParser;
        }
    }

    public NameParser getNameParser(String name) {
        try {
            NameParser nameParser = this._context.getNameParser(name);
            return nameParser;
        }
        catch (NamingException e) {
            NameParser nameParser = null;
            return nameParser;
        }
    }

    public Name composeName(Name name, Name prefix) {
        try {
            Name name2 = this._context.composeName(name, prefix);
            return name2;
        }
        catch (NamingException e) {
            Name name3 = null;
            return name3;
        }
    }

    public String composeName(String name, String prefix) {
        try {
            String string = this._context.composeName(name, prefix);
            return string;
        }
        catch (NamingException e) {
            String string = null;
            return string;
        }
    }

    public Object addToEnvironment(String name, Object value) {
        try {
            Object object = this._context.addToEnvironment(name, value);
            return object;
        }
        catch (NamingException e) {
            Object var5_5 = null;
            return var5_5;
        }
    }

    public Object removeFromEnvironment(String name) {
        try {
            Object object = this._context.removeFromEnvironment(name);
            return object;
        }
        catch (NamingException e) {
            Object var4_4 = null;
            return var4_4;
        }
    }

    public Hashtable getEnvironment() {
        try {
            Hashtable<?, ?> hashtable = this._context.getEnvironment();
            return hashtable;
        }
        catch (NamingException e) {
            Hashtable hashtable = null;
            return hashtable;
        }
    }

    public void close() {
        try {
            this._context.close();
        }
        catch (NamingException namingException) {
            // empty catch block
        }
    }

    public String getNameInNamespace() {
        try {
            String string = this._context.getNameInNamespace();
            return string;
        }
        catch (NamingException e) {
            String string = null;
            return string;
        }
    }
}

