/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.net;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.BitSet;

public class EncoderUtils {
    private static final int _MAX_BYTES_PER_CHAR = 10;
    private static final BitSet _DONT_ENCODE_SET = new BitSet(256);
    private static final BitSet _DONT_ENCODE_SET_SMALL = new BitSet(256);

    public static String encodeURL(String text, String queryEncoding, boolean useISOForBody) throws UnsupportedEncodingException {
        StringWriter sw = new StringWriter(text.length());
        try {
            EncoderUtils.writeURL(sw, text, queryEncoding, useISOForBody);
        }
        catch (UnsupportedEncodingException uee) {
            throw uee;
        }
        catch (IOException ioe) {
            // empty catch block
        }
        return sw.toString();
    }

    public static void writeURL(Writer out, String text, String queryEncoding, boolean useISOForBody) throws IOException, UnsupportedEncodingException {
        EncoderUtils._writeURL(out, text, queryEncoding, useISOForBody, 0, false);
    }

    public static void writeQueryParameters(Writer out, String text, String encoding, int start) throws IOException, UnsupportedEncodingException {
        EncoderUtils._encodeString(out, text, encoding, start, _DONT_ENCODE_SET, true);
    }

    public static String encodeUIXQueryParameter(String text) {
        int length = text.length();
        int i = 0;
        while (i < length) {
            char ch = text.charAt(i);
            if (EncoderUtils._isSpecialQueryParameterChar(ch)) {
                StringBuffer buffer = new StringBuffer(text);
                buffer.setLength(i);
                EncoderUtils._appendUIXQueryParameter(buffer, text, i);
                return new String(buffer);
            }
            ++i;
        }
        return text;
    }

    public static void appendUIXQueryParameter(StringBuffer buffer, String text) {
        buffer.append(text);
        int length = text.length();
        int i = 0;
        while (i < length) {
            char ch = text.charAt(i);
            if (EncoderUtils._isSpecialQueryParameterChar(ch)) {
                buffer.setLength(buffer.length() - (length - i));
                EncoderUtils._appendUIXQueryParameter(buffer, text, i);
                break;
            }
            ++i;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void _writeURL(Writer out, String text, String queryEncoding, boolean useISOForBody, int start, boolean inAnchor) throws IOException, UnsupportedEncodingException {
        int length = text.length();
        int i = start;
        while (i < length) {
            block10: {
                char ch;
                block11: {
                    block13: {
                        block12: {
                            ch = text.charAt(i);
                            if (ch >= '!' && ch <= '~') break block11;
                            if (!useISOForBody) break block12;
                            EncoderUtils._writeDoubleHex(out, ch);
                            break block10;
                        }
                        if (ch > '\u007f') break block13;
                        EncoderUtils._writeDoubleHex(out, ch);
                        break block10;
                    }
                    if (ch <= '\u07ff') {
                        int high = ch >> 6 | 0xC0;
                        int low = ch & 0x3F | 0x80;
                        EncoderUtils._writeDoubleHex(out, high);
                        EncoderUtils._writeDoubleHex(out, low);
                        break block10;
                    } else if ((ch & 0xFC00) == 55296) {
                        int highSurrogate = ch & 0x3FF;
                        int wwww = (highSurrogate & 0x3C0) >> 6;
                        int uuuuu = wwww + 1;
                        int zzzz = (highSurrogate & 0x3C) >> 2;
                        int yyyyyy = (highSurrogate & 3) << 4 & 0x30;
                        ch = ++i < length ? text.charAt(i) : (char)'\u0000';
                        int lowSurrogate = ch & 0x3FF;
                        int xxxxxx = lowSurrogate & 0x3F;
                        int byte1 = 0xF0 | uuuuu >> 2;
                        int byte2 = 0x80 | (uuuuu & 3) << 4 & 0x30 | zzzz;
                        int byte3 = 0x80 | (yyyyyy |= (lowSurrogate & 0x3C0) >> 6);
                        int byte4 = 0x80 | xxxxxx;
                        EncoderUtils._writeDoubleHex(out, byte1);
                        EncoderUtils._writeDoubleHex(out, byte2);
                        EncoderUtils._writeDoubleHex(out, byte3);
                        EncoderUtils._writeDoubleHex(out, byte4);
                        break block10;
                    } else {
                        int high = ch >> 12 | 0xE0;
                        int middle = (ch & 0xFC0) >> 6 | 0x80;
                        int low = ch & 0x3F | 0x80;
                        EncoderUtils._writeDoubleHex(out, high);
                        EncoderUtils._writeDoubleHex(out, middle);
                        EncoderUtils._writeDoubleHex(out, low);
                    }
                    break block10;
                }
                if (ch == '\"') {
                    out.write("%22");
                } else if (ch == '?') {
                    if (!inAnchor) {
                        out.write(63);
                        EncoderUtils.writeQueryParameters(out, text, queryEncoding, i + 1);
                        return;
                    }
                    out.write("%3F");
                } else {
                    out.write(ch);
                }
            }
            ++i;
        }
    }

    private static boolean _isSpecialQueryParameterChar(char ch) {
        return ch == '%' || ch == '+' || ch == '&' || ch == '#';
    }

    private static void _appendUIXQueryParameter(StringBuffer buffer, String text, int from) {
        int length = text.length();
        int j = from;
        while (j < length) {
            char c = text.charAt(j);
            switch (c) {
                case '#': {
                    buffer.append("%23");
                    break;
                }
                case '&': {
                    buffer.append("%26");
                    break;
                }
                case '%': {
                    buffer.append("%25");
                    break;
                }
                case '+': {
                    buffer.append("%2b");
                    break;
                }
                default: {
                    buffer.append(c);
                    break;
                }
            }
            ++j;
        }
    }

    public static String encodeString(String text, String encoding) throws UnsupportedEncodingException {
        StringWriter sw = new StringWriter(text.length());
        try {
            EncoderUtils._encodeString(sw, text, encoding, 0, _DONT_ENCODE_SET_SMALL, false);
        }
        catch (UnsupportedEncodingException uee) {
            throw uee;
        }
        catch (IOException ioe) {
            // empty catch block
        }
        return sw.toString();
    }

    public static String decodeString(String text, String encoding) throws UnsupportedEncodingException {
        int firstPercent = text.indexOf(37);
        if (firstPercent < 0) {
            return text;
        }
        int length = text.length();
        StringBuffer buffer = new StringBuffer(length);
        buffer.append(text);
        buffer.setLength(firstPercent);
        byte[] bytes = null;
        int byteIndex = 0;
        int i = firstPercent;
        while (i < length) {
            char ch = text.charAt(i);
            if (ch != '%') {
                if (byteIndex > 0) {
                    buffer.append(new String(bytes, 0, byteIndex, encoding));
                    byteIndex = 0;
                }
                buffer.append(ch);
            } else {
                if (i + 2 < length) {
                    byte b = (byte)(EncoderUtils._fromHex(text.charAt(i + 1)) << 4 | EncoderUtils._fromHex(text.charAt(i + 2)));
                    if (encoding == null) {
                        buffer.append((char)b);
                    } else {
                        if (bytes == null) {
                            bytes = new byte[10];
                        } else if (bytes.length == byteIndex) {
                            byte[] newBytes = new byte[byteIndex * 2];
                            System.arraycopy(bytes, 0, newBytes, 0, byteIndex);
                            bytes = newBytes;
                        }
                        bytes[byteIndex] = b;
                        ++byteIndex;
                    }
                }
                i += 2;
            }
            ++i;
        }
        if (byteIndex > 0) {
            buffer.append(new String(bytes, 0, byteIndex, encoding));
        }
        return new String(buffer);
    }

    private static void _encodeString(Writer out, String text, String encoding, int start, BitSet dontEncodeSet, boolean lookForAnchor) throws IOException, UnsupportedEncodingException {
        ByteArrayOutputStream buf = null;
        OutputStreamWriter writer = null;
        char[] charArray = null;
        int length = text.length();
        int i = start;
        while (i < length) {
            block8: {
                char ch = text.charAt(i);
                if (lookForAnchor && '#' == ch) {
                    out.write(ch);
                    EncoderUtils._writeURL(out, text, encoding, false, i + 1, true);
                    return;
                }
                if (dontEncodeSet.get(ch)) {
                    out.write(ch);
                } else {
                    if (buf == null) {
                        buf = new ByteArrayOutputStream(10);
                        writer = encoding != null ? new OutputStreamWriter((OutputStream)buf, encoding) : new OutputStreamWriter(buf);
                        charArray = new char[1];
                    }
                    try {
                        charArray[0] = ch;
                        writer.write(charArray, 0, 1);
                        writer.flush();
                    }
                    catch (IOException e) {
                        buf.reset();
                        break block8;
                    }
                    byte[] ba = buf.toByteArray();
                    int j = 0;
                    while (j < ba.length) {
                        EncoderUtils._writeDoubleHex(out, ba[j] + 256);
                        ++j;
                    }
                    buf.reset();
                }
            }
            ++i;
        }
    }

    private static void _writeDoubleHex(Writer out, int i) throws IOException {
        out.write(37);
        out.write(EncoderUtils._getHex((i >> 4) % 16));
        out.write(EncoderUtils._getHex(i % 16));
    }

    private static char _getHex(int i) {
        if (i < 10) {
            return (char)(48 + i);
        }
        return (char)(65 + (i - 10));
    }

    private static byte _fromHex(char ch) {
        if (ch >= '0' && ch <= '9') {
            return (byte)(ch - 48);
        }
        if (ch >= 'a' && ch <= 'f') {
            return (byte)(10 + (ch - 97));
        }
        return (byte)(10 + (ch - 65));
    }

    static {
        int i = 97;
        while (i <= 122) {
            _DONT_ENCODE_SET.set(i);
            _DONT_ENCODE_SET_SMALL.set(i);
            ++i;
        }
        int i2 = 65;
        while (i2 <= 90) {
            _DONT_ENCODE_SET.set(i2);
            _DONT_ENCODE_SET_SMALL.set(i2);
            ++i2;
        }
        int i3 = 48;
        while (i3 <= 57) {
            _DONT_ENCODE_SET.set(i3);
            _DONT_ENCODE_SET_SMALL.set(i3);
            ++i3;
        }
        _DONT_ENCODE_SET.set(37);
        _DONT_ENCODE_SET.set(43);
        _DONT_ENCODE_SET.set(35);
        _DONT_ENCODE_SET.set(38);
        _DONT_ENCODE_SET.set(61);
        _DONT_ENCODE_SET.set(45);
        _DONT_ENCODE_SET_SMALL.set(45);
        _DONT_ENCODE_SET.set(95);
        _DONT_ENCODE_SET_SMALL.set(95);
        _DONT_ENCODE_SET.set(46);
        _DONT_ENCODE_SET_SMALL.set(46);
        _DONT_ENCODE_SET.set(42);
        _DONT_ENCODE_SET.set(126);
        _DONT_ENCODE_SET.set(47);
        _DONT_ENCODE_SET_SMALL.set(47);
        _DONT_ENCODE_SET.set(39);
        _DONT_ENCODE_SET.set(33);
        _DONT_ENCODE_SET.set(40);
        _DONT_ENCODE_SET.set(41);
    }
}

