/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.diff;

import oracle.javatools.parser.AbstractLexer;
import oracle.javatools.parser.LexerToken;
import oracle.javatools.parser.diff.DiffTokens;

public class DiffLexer
extends AbstractLexer
implements DiffTokens {
    private int lastToken = -1;
    private int startOffset = -1;
    private int endOffset = -1;
    private boolean useLastToken = false;

    public DiffLexer() {
        this.setTextBuffer(null);
        this.setPosition(0);
    }

    public int lex(LexerToken lexedToken) {
        block10: {
            if (this.useLastToken) {
                this.useLastToken = false;
                return this.fillLexerToken(lexedToken);
            }
            this.lastToken = 0;
            try {
                while (true) {
                    char c = this.textBuffer.getChar(this.currentPos++);
                    this.startOffset = this.currentPos - 1;
                    if (c == '\n') continue;
                    if (c == '@') {
                        if (!this.peekChars(2).equals("@ ")) {
                            this.skipLine();
                            continue;
                        }
                        this.lastToken = 11;
                        this.skipLine();
                        break;
                    }
                    if (c == '+') {
                        if (this.peekChars(3).equals("++ ")) {
                            this.skipLine();
                            continue;
                        }
                        this.lastToken = 12;
                        this.skipLine();
                        break;
                    }
                    if (c == '-') {
                        if (this.peekChars(3).equals("-- ")) {
                            this.skipLine();
                            continue;
                        }
                        this.lastToken = 13;
                        this.skipLine();
                        break;
                    }
                    this.skipLine();
                }
            }
            catch (IndexOutOfBoundsException e) {
                this.currentPos = this.textBuffer.getLength();
                if (this.lastToken != 0) break block10;
                this.startOffset = this.currentPos;
            }
        }
        this.endOffset = this.currentPos;
        this.useLastToken = false;
        return this.fillLexerToken(lexedToken);
    }

    public void backup() {
        this.useLastToken = true;
    }

    public void setPosition(int offset) {
        super.setPosition(offset);
        this.useLastToken = false;
    }

    private String peekChars(int count) {
        StringBuffer charBuffer = new StringBuffer();
        int i = this.currentPos;
        int n = Math.min(this.currentPos + count, this.textBuffer.getLength());
        while (i < n) {
            charBuffer.append(this.textBuffer.getChar(i));
            ++i;
        }
        return charBuffer.toString();
    }

    private void skipLine() {
        while (true) {
            char c = this.textBuffer.getChar(this.currentPos);
            switch (c) {
                case '\n': 
                case '\r': {
                    return;
                }
            }
            ++this.currentPos;
        }
    }

    private int fillLexerToken(LexerToken lexedToken) {
        AbstractLexer.DefaultLexerToken outToken = (AbstractLexer.DefaultLexerToken)lexedToken;
        outToken.setToken(this.lastToken);
        outToken.setStartOffset(this.startOffset);
        outToken.setEndOffset(this.endOffset);
        return this.lastToken;
    }

    public static String tokenToString(int token) {
        switch (token) {
            case 11: {
                return "TK_HEADER";
            }
            case 12: {
                return "TK_ADDITION";
            }
            case 13: {
                return "TK_REMOVAL";
            }
        }
        return "**UNKNOWN**";
    }

    public static String tokenToText(int token) {
        switch (token) {
            case 11: {
                return "Diff Header";
            }
            case 12: {
                return "Diff Addition";
            }
            case 13: {
                return "Diff Removal";
            }
        }
        return "**UNKNOWN**";
    }
}

