/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.html;

import oracle.javatools.parser.AbstractLexer;
import oracle.javatools.parser.LexerToken;
import oracle.javatools.parser.html.EmbeddedLexer;
import oracle.javatools.parser.html.TagTokens;

public class TagLexer
extends EmbeddedLexer
implements TagTokens {
    private int lastToken = -1;
    private int startOffset = -1;
    private int endOffset = -1;
    private boolean useLastToken = false;
    private boolean skipSymbols = false;
    private boolean recognizeSlash = false;
    private int nextNameType;

    public TagLexer() {
        this.setTextBuffer(null);
        this.setPosition(0);
    }

    public void setSkipSymbols(boolean skipSymbols) {
        this.skipSymbols = skipSymbols;
    }

    public void setRecognizeSlash(boolean recognizeSlash) {
        this.recognizeSlash = recognizeSlash;
    }

    public int lex(LexerToken lexedToken) {
        block21: {
            if (this.useLastToken) {
                this.useLastToken = false;
                return this.fillLexerToken(lexedToken);
            }
            this.lastToken = 0;
            try {
                block12: while (true) {
                    char c = this.textBuffer.getChar(this.currentPos++);
                    switch (c) {
                        case '\t': 
                        case '\n': 
                        case '\f': 
                        case '\r': 
                        case ' ': {
                            continue block12;
                        }
                    }
                    this.startOffset = this.currentPos - 1;
                    switch (c) {
                        case '=': {
                            this.nextNameType = 22;
                        }
                        case '$': 
                        case '<': {
                            if ((this.nextNameType == 21 || this.nextNameType == 22) && this.isEmbeddedTagStart(this.startOffset)) {
                                this.lastToken = this.nextNameType;
                                this.nextNameType = 21;
                                --this.currentPos;
                                this.skipNameOrValue();
                                break block12;
                            }
                        }
                        case '>': {
                            this.lastToken = 31;
                            if (this.recognizeJSP && c == '<' && this.textBuffer.getChar(this.currentPos) == '%' && this.textBuffer.getChar(this.currentPos + 1) == '@') {
                                this.currentPos += 2;
                            }
                            if (this.skipSymbols) {
                                this.lastToken = 0;
                                continue block12;
                            }
                            break block21;
                        }
                        case '/': {
                            if (this.recognizeSlash) {
                                this.lastToken = 31;
                                if (this.skipSymbols) {
                                    this.lastToken = 0;
                                    continue block12;
                                }
                                break block21;
                            }
                        }
                        case '%': {
                            this.lastToken = 31;
                            if (this.recognizeJSP && this.textBuffer.getChar(this.currentPos) == '>') {
                                ++this.currentPos;
                                if (this.skipSymbols) {
                                    this.lastToken = 0;
                                    continue block12;
                                }
                                break block21;
                            }
                        }
                        default: {
                            this.lastToken = this.nextNameType;
                            this.nextNameType = 21;
                            --this.currentPos;
                            this.skipNameOrValue();
                            break block12;
                        }
                    }
                    break;
                }
            }
            catch (IndexOutOfBoundsException e) {
                this.currentPos = this.textBuffer.getLength();
                if (this.lastToken != 0) break block21;
                this.startOffset = this.currentPos;
            }
        }
        this.endOffset = this.currentPos;
        this.useLastToken = false;
        return this.fillLexerToken(lexedToken);
    }

    public void backup() {
        this.useLastToken = true;
    }

    public void setPosition(int offset) {
        super.setPosition(offset);
        this.useLastToken = false;
        this.nextNameType = 11;
    }

    public int skipNameOrValue(boolean recognizeOpenSquareBracket) {
        char c = '\u0000';
        char quote = '\u0000';
        int endSymbol = 0;
        boolean insideEL = false;
        block11: while (true) {
            char lastChar = c;
            c = this.textBuffer.getChar(this.currentPos++);
            switch (c) {
                case '[': {
                    if (!recognizeOpenSquareBracket) continue block11;
                }
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': {
                    if (insideEL) continue block11;
                }
                case '=': 
                case '>': {
                    if (quote != '\u0000') continue block11;
                    --this.currentPos;
                    if (this.recognizeSlash && this.textBuffer.getChar(this.currentPos - 1) == '/') {
                        --this.currentPos;
                    }
                    return this.currentPos;
                }
                case '{': {
                    if (this.recognizeJSP) {
                        if (lastChar != '$') continue block11;
                        this.lastToken = 22;
                        insideEL = true;
                        continue block11;
                    }
                }
                case '}': {
                    if (this.recognizeJSP) {
                        if (!insideEL) continue block11;
                        insideEL = false;
                        continue block11;
                    }
                }
                case '$': 
                case '<': {
                    if (this.lastToken != 21 && this.lastToken != 22 || !this.isEmbeddedTagStart(this.currentPos - 1)) continue block11;
                    if (this.lastToken == 21) {
                        this.lastToken = 23;
                    } else if (this.lastToken == 22) {
                        this.lastToken = 24;
                    }
                    this.skipEmbeddedTag();
                    continue block11;
                }
                case '\\': {
                    ++this.currentPos;
                    continue block11;
                }
                case '\"': 
                case '\'': {
                    if (quote != '\u0000') {
                        if (quote != c) continue block11;
                        quote = '\u0000';
                        continue block11;
                    }
                    quote = c;
                    if (this.lastToken != 22 || !this.isEmbeddedTagStart(this.currentPos)) continue block11;
                    this.lastToken = 24;
                    this.skipEmbeddedTag();
                    continue block11;
                }
                case '%': {
                    if (!this.recognizeJSP || quote != '\u0000' || this.textBuffer.getChar(this.currentPos) != '>') break;
                    --this.currentPos;
                    return this.currentPos;
                }
            }
            if (endSymbol == 0 && c == '&') {
                ++endSymbol;
                continue;
            }
            if (endSymbol == 1 && lastChar == '&' && c == 'g') {
                ++endSymbol;
                continue;
            }
            if (endSymbol == 2 && lastChar == 'g' && c == 't') {
                ++endSymbol;
                continue;
            }
            if (endSymbol == 3 && lastChar == 't' && c == ';') {
                endSymbol = 0;
                if (quote != '\u0000') continue;
                --this.currentPos;
                return this.currentPos;
            }
            endSymbol = 0;
        }
    }

    private void skipNameOrValue() {
        this.skipNameOrValue(false);
    }

    private int fillLexerToken(LexerToken lexedToken) {
        AbstractLexer.DefaultLexerToken outToken = (AbstractLexer.DefaultLexerToken)lexedToken;
        outToken.setToken(this.lastToken);
        outToken.setStartOffset(this.startOffset);
        outToken.setEndOffset(this.endOffset);
        return this.lastToken;
    }

    public static String tokenToString(int token) {
        switch (token) {
            case 11: {
                return "TK_ELEMENT_NAME";
            }
            case 21: {
                return "TK_ATTRIBUTE_NAME";
            }
            case 22: {
                return "TK_ATTRIBUTE_VALUE";
            }
            case 31: {
                return "TK_SYMBOL";
            }
            case 23: {
                return "TK_ATTRIBUTE_NAME_EMBEDDED";
            }
            case 24: {
                return "TK_ATTRIBUTE_VALUE_EMBEDDED";
            }
        }
        return "**UNKNOWN**";
    }

    public static String tokenToText(int token) {
        switch (token) {
            case 11: {
                return "Element name";
            }
            case 21: {
                return "Attribute name";
            }
            case 22: {
                return "Attribute value";
            }
            case 31: {
                return "Tag symbol";
            }
            case 23: {
                return "Embedded Tag in Attribute Name";
            }
            case 24: {
                return "Embedded Tag in Attribute Value";
            }
        }
        return "**UNKNOWN**";
    }
}

