/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v1;

import oracle.javatools.parser.AbstractLexer;
import oracle.javatools.parser.LexerToken;
import oracle.javatools.parser.java.v1.JavaLexer;
import oracle.javatools.parser.java.v1.JavaTokens;

class CommentPreprocessor
extends JavaLexer
implements JavaTokens {
    public static final int COMMENTS_NONE = 0;
    public static final int COMMENTS_JAVADOC_ONLY = 1;
    public static final int COMMENTS_ALL = 2;
    private boolean prevCommentSaved;
    private LexerToken prevComment;
    private boolean commentSaved;
    private LexerToken curComment;
    private int nonCommentLastToken;
    private int nonCommentStartOffset;
    private int nonCommentEndOffset;
    private boolean backedup;
    private int collectComments;

    public void setCommentLevel(int commentLevel) {
        this.collectComments = commentLevel;
    }

    public boolean hasSavedComment() {
        return this.backedup ? this.prevCommentSaved : this.commentSaved;
    }

    public boolean grabSavedComment(LexerToken lexedToken) {
        boolean hasSaved = this.hasSavedComment();
        if (hasSaved) {
            AbstractLexer.DefaultLexerToken outToken = (AbstractLexer.DefaultLexerToken)lexedToken;
            if (this.backedup) {
                outToken.setToken(this.prevComment.getToken());
                outToken.setStartOffset(this.prevComment.getStartOffset());
                outToken.setEndOffset(this.prevComment.getEndOffset());
            } else {
                outToken.setToken(this.curComment.getToken());
                outToken.setStartOffset(this.curComment.getStartOffset());
                outToken.setEndOffset(this.curComment.getEndOffset());
            }
        }
        return hasSaved;
    }

    private void $init$() {
        this.prevCommentSaved = false;
        this.commentSaved = false;
        this.backedup = false;
        this.collectComments = 0;
    }

    public CommentPreprocessor() {
        this.$init$();
        super.setSkipComments(false);
        this.prevComment = this.createLexerToken();
        this.curComment = this.createLexerToken();
    }

    public void backup() {
        this.backedup = true;
    }

    public int lex(LexerToken lexedToken) {
        if (this.backedup) {
            this.backedup = false;
            AbstractLexer.DefaultLexerToken outToken = (AbstractLexer.DefaultLexerToken)lexedToken;
            outToken.setToken(this.nonCommentLastToken);
            outToken.setStartOffset(this.nonCommentStartOffset);
            outToken.setEndOffset(this.nonCommentEndOffset);
            return this.nonCommentLastToken;
        }
        this.nonCommentLastToken = 0;
        this.prevCommentSaved = this.commentSaved;
        if (this.prevCommentSaved) {
            LexerToken tmp = this.prevComment;
            this.prevComment = this.curComment;
            this.curComment = tmp;
        }
        this.commentSaved = false;
        while (true) {
            int token;
            if ((token = super.lex(lexedToken)) == 26) {
                if (this.collectComments < 1) continue;
                this.saveComment(lexedToken);
                continue;
            }
            if (token != 25 && token != 24) break;
            if (this.collectComments != 2) continue;
            this.saveComment(lexedToken);
        }
        this.nonCommentLastToken = lexedToken.getToken();
        this.nonCommentStartOffset = lexedToken.getStartOffset();
        this.nonCommentEndOffset = lexedToken.getEndOffset();
        return this.nonCommentLastToken;
    }

    public void setSkipComments(boolean skipComments) {
        this.setCommentLevel(skipComments ? 0 : 2);
    }

    private void saveComment(LexerToken lexedToken) {
        AbstractLexer.DefaultLexerToken curComment = (AbstractLexer.DefaultLexerToken)this.curComment;
        curComment.setToken(lexedToken.getToken());
        curComment.setStartOffset(lexedToken.getStartOffset());
        curComment.setEndOffset(lexedToken.getEndOffset());
        this.commentSaved = true;
    }
}

