/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v1;

import oracle.javatools.parser.AbstractLexer;
import oracle.javatools.parser.LexerToken;
import oracle.javatools.parser.java.v1.JavaDocTokens;
import oracle.javatools.parser.util.KeywordTable;

public class JavaDocLexer
extends AbstractLexer
implements JavaDocTokens {
    private int lastToken = -1;
    private int startOffset = -1;
    private int endOffset = -1;
    private boolean useLastToken = false;
    private boolean inTagText;
    private int lexerState;
    private boolean recognizeUnknownTags = false;
    private boolean skipCommentText = true;
    private static final int STATE_COMMENT_START = 1;
    private static final int STATE_LINE_START = 2;
    private static final int STATE_COMMENT_TEXT = 3;
    private static final int STATE_COMMENT_END = 4;
    private static final int STATE_EOF = 5;
    private static KeywordTable keywordTable;

    public JavaDocLexer() {
        this.setTextBuffer(null);
        this.setPosition(0);
    }

    public void setRecognizeUnknownTags(boolean recognizeUnknownTags) {
        this.recognizeUnknownTags = recognizeUnknownTags;
    }

    public void setSkipCommentText(boolean skipCommentText) {
        this.skipCommentText = skipCommentText;
    }

    /*
     * Unable to fully structure code
     */
    public int lex(LexerToken lexedToken) {
        block20: {
            if (this.useLastToken) {
                this.useLastToken = false;
                return this.fillLexerToken(lexedToken);
            }
            this.lastToken = 0;
            try {
                block9: while (true) {
                    switch (this.lexerState) {
                        case 1: {
                            this.lexerState = 3;
                            this.skipCommentStart();
                            continue block9;
                        }
                        case 2: {
                            this.lexerState = 3;
                            this.skipLineStart();
                            continue block9;
                        }
                        case 3: {
                            this.startOffset = this.currentPos;
                            this.skipSpaces();
                            if (this.inTagText) {
                                this.lastToken = 2001;
                            } else if (!this.skipCommentText) {
                                this.lastToken = 2002;
                            }
                            if (this.textBuffer.getChar(this.currentPos) != '@') ** GOTO lbl-1000
                            hash = KeywordTable.computePartialHash('@', 0);
                            ++this.currentPos;
                            while (!Character.isWhitespace(c = this.textBuffer.getChar(this.currentPos))) {
                                ++this.currentPos;
                                hash = KeywordTable.computePartialHash(c, hash);
                            }
                            tagType = JavaDocLexer.keywordTable.lookupKeyword(this.textBuffer, tagStartOffset, this.currentPos, hash);
                            if (tagType != -1) {
                                this.lastToken = tagType;
                                this.inTagText = true;
                                this.lexerState = 3;
                            } else if (this.recognizeUnknownTags) {
                                this.lastToken = 2040;
                                this.inTagText = true;
                                this.lexerState = 3;
                            } else lbl-1000:
                            // 2 sources

                            {
                                this.lexerState = 2;
                                this.skipToEndOfLine();
                                if (!this.inTagText && this.skipCommentText) {
                                    continue block9;
                                }
                            }
                            break block20;
                        }
                        case 4: {
                            this.currentPos += 2;
                            this.startOffset = this.currentPos;
                            this.lexerState = 5;
                        }
                        case 5: {
                            break block20;
                        }
                        default: {
                            throw new IllegalStateException("Unknown state: " + this.lexerState);
                        }
                    }
                    break;
                }
            }
            catch (IndexOutOfBoundsException e) {
                this.lexerState = 5;
                this.currentPos = this.textBuffer.getLength();
                if (this.lastToken != 0) break block20;
                this.startOffset = this.currentPos;
            }
        }
        this.endOffset = this.currentPos;
        this.useLastToken = false;
        return this.fillLexerToken(lexedToken);
    }

    public void backup() {
        this.useLastToken = true;
    }

    public void setPosition(int offset) {
        super.setPosition(offset);
        this.useLastToken = false;
        this.lexerState = 1;
        this.inTagText = false;
    }

    private void skipCommentStart() {
        if (this.textBuffer.getChar(this.currentPos) == '/') {
            ++this.currentPos;
        }
        this.skipAsterisks();
        this.skipSpaces();
    }

    private void skipLineStart() {
        this.skipSpaces();
        this.skipAsterisks();
    }

    private void skipToEndOfLine() {
        while (true) {
            char c = this.textBuffer.getChar(this.currentPos);
            switch (c) {
                case '\r': {
                    ++this.currentPos;
                    if (this.textBuffer.getChar(this.currentPos) != '\n') {
                        return;
                    }
                }
                case '\n': {
                    ++this.currentPos;
                    return;
                }
                case '*': {
                    if (this.textBuffer.getChar(this.currentPos + 1) != '/') break;
                    this.lexerState = 4;
                    return;
                }
            }
            ++this.currentPos;
        }
    }

    private void skipAsterisks() {
        int skipStart = this.currentPos;
        block4: while (true) {
            char c = this.textBuffer.getChar(this.currentPos);
            switch (c) {
                case '*': {
                    ++this.currentPos;
                    continue block4;
                }
                case '/': {
                    if (this.currentPos <= skipStart) break block4;
                    --this.currentPos;
                    this.lexerState = 4;
                }
            }
            break;
        }
    }

    private void skipSpaces() {
        block3: while (true) {
            char c = this.textBuffer.getChar(this.currentPos);
            switch (c) {
                case '\t': 
                case ' ': {
                    ++this.currentPos;
                    continue block3;
                }
            }
            break;
        }
    }

    private int fillLexerToken(LexerToken lexedToken) {
        AbstractLexer.DefaultLexerToken outToken = (AbstractLexer.DefaultLexerToken)lexedToken;
        outToken.setToken(this.lastToken);
        outToken.setStartOffset(this.startOffset);
        outToken.setEndOffset(this.endOffset);
        return this.lastToken;
    }

    private static void initialize() {
        keywordTable = new KeywordTable(12);
        keywordTable.addKeyword("@author", 2011);
        keywordTable.addKeyword("@deprecated", 2012);
        keywordTable.addKeyword("@exception", 2013);
        keywordTable.addKeyword("@hidden", 2100);
        keywordTable.addKeyword("@param", 2014);
        keywordTable.addKeyword("@return", 2015);
        keywordTable.addKeyword("@see", 2016);
        keywordTable.addKeyword("@serial", 2017);
        keywordTable.addKeyword("@serialData", 2018);
        keywordTable.addKeyword("@serialField", 2019);
        keywordTable.addKeyword("@since", 2020);
        keywordTable.addKeyword("@throws", 2021);
        keywordTable.addKeyword("@version", 2022);
    }

    public static String tokenToString(int token) {
        switch (token) {
            case 2001: {
                return "TK_DOC_TAGTEXT";
            }
            case 2002: {
                return "TK_DOC_COMMENTTEXT";
            }
            case 2040: {
                return "TK_DOC_UNKNOWNTAG";
            }
            case 2011: {
                return "TK_DOC_AUTHOR";
            }
            case 2012: {
                return "TK_DOC_DEPRECATED";
            }
            case 2013: {
                return "TK_DOC_EXCEPTION";
            }
            case 2100: {
                return "TK_DOC_HIDDEN";
            }
            case 2014: {
                return "TK_DOC_PARAM";
            }
            case 2015: {
                return "TK_DOC_RETURN";
            }
            case 2016: {
                return "TK_DOC_SEE";
            }
            case 2017: {
                return "TK_DOC_SERIAL";
            }
            case 2018: {
                return "TK_DOC_SERIALDATA";
            }
            case 2019: {
                return "TK_DOC_SERIALFIELD";
            }
            case 2020: {
                return "TK_DOC_SINCE";
            }
            case 2021: {
                return "TK_DOC_THROWS";
            }
            case 2022: {
                return "TK_DOC_VERSION";
            }
        }
        return "**UNKNOWN**";
    }

    public static String tokenToText(int token) {
        switch (token) {
            case 2001: {
                return "JavaDoc tag text";
            }
            case 2002: {
                return "JavaDoc comment text";
            }
            case 2040: {
                return "unknown JavaDoc tag";
            }
            case 2011: {
                return "@author tag";
            }
            case 2012: {
                return "@deprecated tag";
            }
            case 2013: {
                return "@exception tag";
            }
            case 2100: {
                return "@hidden tag";
            }
            case 2014: {
                return "@param tag";
            }
            case 2015: {
                return "@return tag";
            }
            case 2016: {
                return "@see tag";
            }
            case 2017: {
                return "@serial tag";
            }
            case 2018: {
                return "@serialdata tag";
            }
            case 2019: {
                return "@serialfield tag";
            }
            case 2020: {
                return "@since tag";
            }
            case 2021: {
                return "@throws tag";
            }
            case 2022: {
                return "@version tag";
            }
        }
        return "**UNKNOWN**";
    }

    static {
        JavaDocLexer.initialize();
    }
}

