/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v1.symbol;

import java.util.ArrayList;
import oracle.javatools.parser.java.v1.symbol.JavaSymbol;
import oracle.javatools.parser.java.v1.symbol.NameSymbol;
import oracle.javatools.parser.java.v1.symbol.TypeSymbol;

class ClassListSymbol
extends JavaSymbol {
    private ArrayList types;
    private NameSymbol[] nameArray;
    private TypeSymbol[] typeArray;

    private void $init$() {
        this.types = ClassListSymbol.allocArrayList();
        this.nameArray = null;
        this.typeArray = null;
    }

    ClassListSymbol(int code) {
        super(code);
        this.$init$();
        if (code != 352 && code != 212) {
            this.internalError("Wrong code for a ClassListSymbol");
        }
    }

    void addClass(TypeSymbol type) {
        this.types.add(type);
    }

    void doneParsing() {
        this.generateNameArray();
    }

    NameSymbol[] listClasses() {
        if (this.nameArray == null) {
            this.generateNameArray();
        }
        return this.nameArray;
    }

    TypeSymbol[] listClassTypes() {
        if (this.typeArray == null) {
            this.generateTypeArray();
        }
        return this.typeArray;
    }

    private void generateNameArray() {
        int count;
        if (this.typeArray == null) {
            this.generateTypeArray();
        }
        if ((count = this.typeArray.length) == 0) {
            this.nameArray = NameSymbol.EMPTY_ARRAY;
        } else {
            this.nameArray = new NameSymbol[count];
            int i = 0;
            while (i < count) {
                this.nameArray[i] = this.typeArray[i].getName();
                ++i;
            }
        }
    }

    private void generateTypeArray() {
        int size = this.types.size();
        this.typeArray = size > 0 ? this.types.toArray(new TypeSymbol[size]) : TypeSymbol.EMPTY_ARRAY;
        ClassListSymbol.freeArrayList(this.types);
        this.types = null;
    }
}

