/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v1.symbol;

import java.util.ArrayList;
import oracle.javatools.parser.java.v1.symbol.CatchClause;
import oracle.javatools.parser.java.v1.symbol.ClassBodySymbol;
import oracle.javatools.parser.java.v1.symbol.ClassSymbol;
import oracle.javatools.parser.java.v1.symbol.CodeBlockSymbol;
import oracle.javatools.parser.java.v1.symbol.CommentSymbol;
import oracle.javatools.parser.java.v1.symbol.Commentable;
import oracle.javatools.parser.java.v1.symbol.HasModifiers;
import oracle.javatools.parser.java.v1.symbol.NameSymbol;
import oracle.javatools.parser.java.v1.symbol.Scope;
import oracle.javatools.parser.java.v1.symbol.TypeSymbol;
import oracle.javatools.parser.java.v1.symbol.VariableSymbol;

public class MemberSymbol
extends HasModifiers
implements Scope,
Commentable {
    public static final MemberSymbol[] EMPTY_ARRAY = new MemberSymbol[0];
    public static final int METHOD = 340;
    public static final int CONSTRUCTOR = 370;
    public static final int FIELD = 300;
    public static final int INNER_CLASS = 289;
    public static final int INITIALIZER = 260;
    private CommentSymbol comment;
    private TypeSymbol type;
    private MemberSymbol child;
    private CodeBlockSymbol block;
    private ClassSymbol[] localClassArray;
    private ArrayList localClasses;
    private Scope scope;

    public int whatAmI() {
        return this.code;
    }

    public CodeBlockSymbol getBlock() {
        return this.block;
    }

    public ClassSymbol[] getLocalClasses() {
        if (this.localClassArray == null) {
            this.generateLocalClassArray();
        }
        return this.localClassArray;
    }

    public boolean isDeprecated() {
        if (this.whatAmI() == 260) {
            return false;
        }
        if (this.comment != null) {
            return this.comment.isDeprecated();
        }
        return false;
    }

    public boolean isHidden() {
        if (this.whatAmI() == 260) {
            return false;
        }
        if (this.comment != null) {
            return this.comment.isHidden();
        }
        return false;
    }

    public int getScopeType() {
        return 2;
    }

    public Scope getEnclosingScope() {
        return this.scope;
    }

    public void setEnclosingScope(Scope scope) {
        this.scope = scope;
    }

    public boolean findLabel(String name) {
        return false;
    }

    public VariableSymbol findVariable(String name) {
        return null;
    }

    public ClassSymbol findType(String name) {
        return null;
    }

    public NameSymbol[] getLabels() {
        return NameSymbol.EMPTY_ARRAY;
    }

    public VariableSymbol[] getVariables() {
        return VariableSymbol.EMPTY_ARRAY;
    }

    public ClassSymbol[] getClasses() {
        return ClassSymbol.EMPTY_ARRAY;
    }

    public CatchClause[] getCatchClauses() {
        return CatchClause.EMPTY_ARRAY;
    }

    private void $init$() {
        this.comment = null;
        this.type = null;
        this.child = null;
        this.block = null;
        this.localClassArray = null;
        this.localClasses = null;
    }

    MemberSymbol(int code) {
        super(code);
        this.$init$();
    }

    void addLocalClass(ClassSymbol clazz) {
        if (this.localClasses == null) {
            this.localClasses = MemberSymbol.allocArrayList();
        }
        this.localClasses.add(clazz);
    }

    TypeSymbol getType() {
        return this.type;
    }

    void setType(TypeSymbol type) {
        this.type = type;
    }

    void setChild(MemberSymbol child) {
        this.child = child;
    }

    void setBlock(CodeBlockSymbol block) {
        this.block = block;
    }

    MemberSymbol getChild() {
        return this.child;
    }

    void addToClass(ClassBodySymbol body) {
    }

    void doneParsing() {
        super.doneParsing();
        if (this.whatAmI() == 260) {
            ClassBodySymbol body = (ClassBodySymbol)this.parent;
            body.addInitializer(this);
        } else if (this.parent.code == 280) {
            MemberSymbol m = (MemberSymbol)this.parent;
            m.setChild(this);
            this.setType(m.getType());
            this.setModifiers(m.getModifiers());
            this.setComment(m.getComment());
            if (m.getEnclosingScope() != null) {
                this.internalError("Outer member should not have a scope ptr!");
            }
        } else if (this.child != null) {
            ClassBodySymbol body = (ClassBodySymbol)this.parent;
            this.child.addToClass(body);
        }
        this.generateLocalClassArray();
    }

    private void generateLocalClassArray() {
        if (this.localClasses == null) {
            this.localClassArray = ClassSymbol.EMPTY_ARRAY;
        } else {
            int size = this.localClasses.size();
            this.localClassArray = this.localClasses.toArray(new ClassSymbol[size]);
            MemberSymbol.freeArrayList(this.localClasses);
            this.localClasses = null;
        }
    }

    public CommentSymbol getComment() {
        return this.comment;
    }

    public void setComment(CommentSymbol comment) {
        this.comment = comment;
    }
}

