/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v1.symbol;

import java.util.Map;
import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.parser.java.v1.symbol.JavaSymbol;

public class NameSymbol
extends JavaSymbol {
    private String value;
    static final NameSymbol[] EMPTY_ARRAY = new NameSymbol[0];

    public String getValue() {
        return this.value;
    }

    NameSymbol(int code) {
        super(code);
    }

    void uniquefy(Map nameMap) {
        Object existingName = nameMap.get(this.value);
        if (existingName != null) {
            this.value = existingName.toString();
        } else {
            nameMap.put(this.value, this.value);
        }
    }

    void recordName(ReadTextBuffer buffer) {
        this.value = buffer.getString(this.startOffset, this.endOffset - this.startOffset);
    }

    void recordName(ReadTextBuffer buffer, int tokenValue) {
        switch (tokenValue) {
            case 15: {
                this.value = "null";
                return;
            }
            case 97: {
                this.value = "boolean";
                return;
            }
            case 99: {
                this.value = "byte";
                return;
            }
            case 102: {
                this.value = "char";
                return;
            }
            case 108: {
                this.value = "double";
                return;
            }
            case 113: {
                this.value = "float";
                return;
            }
            case 120: {
                this.value = "int";
                return;
            }
            case 122: {
                this.value = "long";
                return;
            }
            case 141: {
                this.value = "void";
                return;
            }
            case 12: {
                int length = this.endOffset - this.startOffset;
                if (length == 5) {
                    this.value = "false";
                    return;
                }
                if (length == 4) {
                    this.value = "true";
                    return;
                }
                System.out.println("NameSymbol: warning, unexpected");
            }
        }
        this.recordName(buffer);
    }
}

