/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v1.symbol;

import java.util.ArrayList;
import oracle.javatools.parser.java.v1.symbol.CatchClause;
import oracle.javatools.parser.java.v1.symbol.ClassSymbol;
import oracle.javatools.parser.java.v1.symbol.ErrorReporter;
import oracle.javatools.parser.java.v1.symbol.ErrorSymbol;
import oracle.javatools.parser.java.v1.symbol.ImportSymbol;
import oracle.javatools.parser.java.v1.symbol.JavaSymbol;
import oracle.javatools.parser.java.v1.symbol.NameSymbol;
import oracle.javatools.parser.java.v1.symbol.PackageSymbol;
import oracle.javatools.parser.java.v1.symbol.Scope;
import oracle.javatools.parser.java.v1.symbol.VariableSymbol;

public class RootSymbol
extends JavaSymbol
implements ErrorReporter,
Scope {
    private PackageSymbol p;
    private NameSymbol sqlContext;
    private ImportSymbol[] importArray;
    private ClassSymbol[] classArray;
    private ErrorSymbol[] errorArray;
    private ArrayList imports;
    private ArrayList classes;

    public PackageSymbol getPackage() {
        return this.p;
    }

    public ImportSymbol[] getImports() {
        if (this.importArray == null) {
            this.generateImportArray();
        }
        return this.importArray;
    }

    public ClassSymbol[] getClasses() {
        if (this.classArray == null) {
            this.generateClassArray();
        }
        return this.classArray;
    }

    public NameSymbol getSqlContext() {
        return this.sqlContext;
    }

    public boolean hasErrors() {
        if (this.errorArray == null) {
            this.errorArray = ErrorSymbol.EMPTY_ARRAY;
        }
        return this.errorArray.length > 0;
    }

    public ErrorSymbol[] getErrors() {
        if (this.errorArray == null) {
            this.errorArray = ErrorSymbol.EMPTY_ARRAY;
        }
        return this.errorArray;
    }

    public final void setErrorArray(ErrorSymbol[] errorArray) {
        this.errorArray = errorArray;
    }

    public int getScopeType() {
        return 0;
    }

    public Scope getEnclosingScope() {
        return null;
    }

    public void setEnclosingScope(Scope scope) {
    }

    public int getModifiers() {
        return 0;
    }

    public boolean findLabel(String name) {
        return false;
    }

    public VariableSymbol findVariable(String name) {
        return null;
    }

    public ClassSymbol findType(String name) {
        ClassSymbol[] classSyms = this.getClasses();
        int classCount = classSyms.length;
        int i = 0;
        while (i < classCount) {
            ClassSymbol classSym = classSyms[i];
            if (RootSymbol.matches(classSym, name)) {
                return classSym;
            }
            ++i;
        }
        return null;
    }

    public NameSymbol[] getLabels() {
        return NameSymbol.EMPTY_ARRAY;
    }

    public VariableSymbol[] getVariables() {
        return VariableSymbol.EMPTY_ARRAY;
    }

    public CatchClause[] getCatchClauses() {
        return CatchClause.EMPTY_ARRAY;
    }

    private void $init$() {
        this.importArray = null;
        this.classArray = null;
        this.errorArray = null;
        this.imports = RootSymbol.allocArrayList();
        this.classes = RootSymbol.allocArrayList();
    }

    RootSymbol() {
        super(25);
        this.$init$();
    }

    private void generateImportArray() {
        int size = this.imports.size();
        this.importArray = size > 0 ? this.imports.toArray(new ImportSymbol[size]) : ImportSymbol.EMPTY_ARRAY;
        RootSymbol.freeArrayList(this.imports);
        this.imports = null;
    }

    private void generateClassArray() {
        int size = this.classes.size();
        this.classArray = size > 0 ? this.classes.toArray(new ClassSymbol[size]) : ClassSymbol.EMPTY_ARRAY;
        RootSymbol.freeArrayList(this.classes);
        this.classes = null;
    }

    final void setPackage(PackageSymbol p) {
        this.p = p;
    }

    final void addImport(ImportSymbol i) {
        this.imports.add(i);
    }

    final void addClass(ClassSymbol c) {
        this.classes.add(c);
    }

    final void setSqlContext(NameSymbol sql) {
        this.sqlContext = sql;
    }

    void doneParsing() {
        super.doneParsing();
        this.generateImportArray();
        this.generateClassArray();
    }
}

