/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.classfile;

public class Convert {
    static byte[] source = new byte[1024];
    public static byte[] ascii = new byte[1024];

    public static String makeString(byte[] buf, int hibyte, int offset, int length) {
        return new String(buf, hibyte, offset, length);
    }

    public static String makeString(byte[] buf, int hibyte) {
        return Convert.makeString(buf, 0, 0, buf.length);
    }

    public static int digit2int(byte ch, int base) {
        if (48 <= ch && ch <= 57 && ch < 48 + base) {
            return ch - 48;
        }
        if (65 <= ch && ch < 65 + base - 10) {
            return ch - 65 + 10;
        }
        if (97 <= ch && ch < 97 + base - 10) {
            return ch - 97 + 10;
        }
        return -1;
    }

    public static byte int2digit(int x) {
        if (x <= 9) {
            return (byte)(x + 48);
        }
        return (byte)(x - 10 + 65);
    }

    /*
     * Unable to fully structure code
     */
    public static int source2ascii_inplace(byte[] source, int offset, int len) {
        if (len * 2 > Convert.ascii.length) {
            Convert.ascii = new byte[len * 2];
        }
        j = 0;
        i = 0;
        while (i < len) {
            if (source[offset + i] != 92 || i + 1 >= len) ** GOTO lbl-1000
            switch ((char)source[offset + ++i]) {
                case 'n': {
                    Convert.ascii[j++] = 10;
                    ++i;
                    break;
                }
                case 't': {
                    Convert.ascii[j++] = 9;
                    ++i;
                    break;
                }
                case 'b': {
                    Convert.ascii[j++] = 8;
                    ++i;
                    break;
                }
                case 'r': {
                    Convert.ascii[j++] = 13;
                    ++i;
                    break;
                }
                case 'f': {
                    Convert.ascii[j++] = 12;
                    ++i;
                    break;
                }
                case 'u': {
                    l = i + 1;
                    while (l < len && source[offset + l] == 117) {
                        ++l;
                    }
                    if (l + 4 <= len) {
                        code = 0;
                        k = 0;
                        d = 0;
                        while (k < 4 && d >= 0) {
                            d = Convert.digit2int(source[offset + l + k], 16);
                            code = code * 16 + d;
                            ++k;
                        }
                        if (d >= 0) {
                            if (code > 0 && code <= 127) {
                                Convert.ascii[j++] = (byte)code;
                            } else if (code <= 2047) {
                                Convert.ascii[j++] = (byte)(192 | code >> 6);
                                Convert.ascii[j++] = (byte)(128 | code & 63);
                            } else {
                                Convert.ascii[j++] = (byte)(224 | code >> 12);
                                Convert.ascii[j++] = (byte)(128 | code >> 6 & 63);
                                Convert.ascii[j++] = (byte)(128 | code & 63);
                            }
                            i = l + 4;
                            break;
                        }
                    }
                }
                default: lbl-1000:
                // 2 sources

                {
                    if ((b = source[offset + i++]) > 0) {
                        Convert.ascii[j++] = b;
                        break;
                    }
                    Convert.ascii[j++] = (byte)(192 | b >> 6 & 3);
                    Convert.ascii[j++] = (byte)(128 | b & 63);
                }
            }
        }
        return j;
    }

    public static String ascii2string(byte[] ascii, int offset, int len) {
        char[] cs = new char[len];
        int i = 0;
        int j = 0;
        while (i < len) {
            int b;
            if ((b = ascii[offset + i++] & 0xFF) >= 224) {
                b = (b & 0xF) << 12;
                b |= (ascii[offset + i++] & 0x3F) << 6;
                b |= ascii[offset + i++] & 0x3F;
            } else if (b >= 192) {
                b = (b & 0x1F) << 6;
                b |= ascii[offset + i++] & 0x3F;
            }
            cs[j++] = (char)b;
        }
        return new String(cs, 0, j);
    }

    public static String source2string(byte[] source, int offset, int len) {
        int alen = Convert.source2ascii_inplace(source, offset, len);
        return Convert.ascii2string(ascii, 0, alen);
    }

    public static int string2source_inplace(String s) {
        int len = s.length();
        if (len * 6 > source.length) {
            source = new byte[len * 6];
        }
        int j = 0;
        int i = 0;
        while (i < len) {
            char ch = s.charAt(i);
            switch (ch) {
                case '\n': {
                    Convert.source[j++] = 92;
                    Convert.source[j++] = 110;
                    break;
                }
                case '\t': {
                    Convert.source[j++] = 92;
                    Convert.source[j++] = 116;
                    break;
                }
                case '\b': {
                    Convert.source[j++] = 92;
                    Convert.source[j++] = 98;
                    break;
                }
                case '\r': {
                    Convert.source[j++] = 92;
                    Convert.source[j++] = 114;
                    break;
                }
                case '\f': {
                    Convert.source[j++] = 92;
                    Convert.source[j++] = 102;
                    break;
                }
                case '\\': {
                    Convert.source[j++] = 92;
                    Convert.source[j++] = 92;
                    break;
                }
                default: {
                    if (' ' <= ch && ch <= '\u007f') {
                        Convert.source[j++] = (byte)ch;
                        break;
                    }
                    Convert.source[j++] = 92;
                    Convert.source[j++] = 117;
                    Convert.source[j++] = Convert.int2digit(ch >> 12 & 0xF);
                    Convert.source[j++] = Convert.int2digit(ch >> 8 & 0xF);
                    Convert.source[j++] = Convert.int2digit(ch >> 4 & 0xF);
                    Convert.source[j++] = Convert.int2digit(ch & 0xF);
                }
            }
            ++i;
        }
        return j;
    }

    public static byte[] string2source(String s) {
        byte[] res = new byte[Convert.string2source_inplace(s)];
        System.arraycopy(source, 0, res, 0, res.length);
        return res;
    }

    public static int string2ascii_inplace(String s) {
        int slen = Convert.string2source_inplace(s);
        return Convert.source2ascii_inplace(source, 0, slen);
    }

    public static byte[] string2ascii(String s) {
        byte[] res = new byte[Convert.string2ascii_inplace(s)];
        System.arraycopy(ascii, 0, res, 0, res.length);
        return res;
    }

    public static String escape(String s) {
        byte[] st = Convert.string2ascii(s);
        return Convert.makeString(st, 0, 0, st.length);
    }

    public static String escape(char c) {
        char[] s = new char[]{c};
        return Convert.escape(new String(s));
    }
}

