/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.common;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.buffer.TextBufferFactory;
import oracle.javatools.parser.java.v2.JavaConstants;
import oracle.javatools.parser.java.v2.JavaProvider;
import oracle.javatools.parser.java.v2.common.ArrayType;
import oracle.javatools.parser.java.v2.common.ParameterizedClass;
import oracle.javatools.parser.java.v2.common.ParameterizedMethod;
import oracle.javatools.parser.java.v2.common.PrimitiveType;
import oracle.javatools.parser.java.v2.common.QuickSignatureParser;
import oracle.javatools.parser.java.v2.common.SignatureHasType;
import oracle.javatools.parser.java.v2.common.TypeErasedClass;
import oracle.javatools.parser.java.v2.common.WildcardType;
import oracle.javatools.parser.java.v2.model.JavaAnnotation;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaElement;
import oracle.javatools.parser.java.v2.model.JavaField;
import oracle.javatools.parser.java.v2.model.JavaFile;
import oracle.javatools.parser.java.v2.model.JavaHasAnnotations;
import oracle.javatools.parser.java.v2.model.JavaIsGeneric;
import oracle.javatools.parser.java.v2.model.JavaMember;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaPackage;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.JavaTypeVariable;
import oracle.javatools.parser.java.v2.model.JavaVariable;
import oracle.javatools.parser.java.v2.model.JavaWildcardType;
import oracle.javatools.parser.java.v2.model.SourceAnnotation;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceHasModifiers;
import oracle.javatools.parser.java.v2.model.SourceMemberVariable;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.javatools.parser.java.v2.util.Conversions;

public class CommonUtilities
extends Conversions
implements JavaConstants {
    private static WeakReference textBufferRef = null;
    private static byte OPTYPE_ASSIGNMENT = 0;
    private static byte OPTYPE_RELATIONAL = 1;
    private static byte OPTYPE_SHIFT = (byte)2;
    private static byte OPTYPE_INFIX = (byte)3;
    private static byte OPTYPE_PREFIX = (byte)4;
    private static byte OPTYPE_POSTFIX = (byte)5;
    private static byte OPTYPE_max = (byte)6;
    private static byte[][] op2optTable = new byte[OPTYPE_max][49];

    public static int provider2jdkVersion(JavaProvider provider) {
        if (!CommonUtilities.isClassPresent(provider, "java/lang/Enum") || !CommonUtilities.isClassPresent(provider, "java/lang/annotation/Annotation")) {
            return 2;
        }
        if (!CommonUtilities.isClassPresent(provider, "java/util/Deque") || !CommonUtilities.isClassPresent(provider, "java/util/ServiceLoader")) {
            return 3;
        }
        return 4;
    }

    private static boolean isClassPresent(JavaProvider provider, String vmName) {
        return provider.getClassByVMName(vmName) != null;
    }

    protected static synchronized TextBuffer acquireTextBuffer() {
        TextBuffer textBuffer = null;
        if (textBufferRef != null && (textBuffer = (TextBuffer)textBufferRef.get()) != null) {
            textBuffer.remove(0, textBuffer.getLength());
        }
        if (textBuffer == null) {
            textBuffer = TextBufferFactory.createGapTextBuffer();
        } else {
            textBuffer.remove(0, textBuffer.getLength());
        }
        textBufferRef = null;
        return textBuffer;
    }

    protected static synchronized void releaseTextBuffer(TextBuffer textBuffer) {
        textBufferRef = new WeakReference<TextBuffer>(textBuffer);
    }

    public static PrimitiveType getPrimitiveType(String name) {
        return PrimitiveType.lookupPrimitive(name);
    }

    public static JavaType createArrayType(JavaProvider provider, JavaType component, int dimensions) {
        if (dimensions == 0) {
            return component;
        }
        if (dimensions < 0) {
            throw new IllegalArgumentException();
        }
        ArrayType out = new ArrayType(provider, component);
        int i = dimensions - 1;
        while (i > 0) {
            out = new ArrayType(provider, out);
            --i;
        }
        return out;
    }

    public static JavaType createParameterizedType(JavaType generic, JavaType[] arguments) {
        return CommonUtilities.createParameterizedType(null, generic, arguments);
    }

    public static JavaType createTypeErasedClass(JavaType type) {
        return new TypeErasedClass((JavaClass)type);
    }

    public static JavaType createParameterizedType(JavaProvider provider, JavaType generic, JavaType[] arguments) {
        if (generic == null) {
            return null;
        }
        if (generic.isArray()) {
            String message = "Cannot bind an array type: " + generic.getQualifiedName();
            throw new IllegalArgumentException(message);
        }
        Collection parameters = generic.getTypeParameters();
        int parameterCount = parameters.size();
        if (parameterCount == 0) {
            String message = "Not a generic type: " + generic.getQualifiedName();
            throw new IllegalArgumentException(message);
        }
        int argumentCount = arguments.length;
        if (parameterCount != argumentCount) {
            String message = "Arguments mismatch: " + generic.getQualifiedName();
            throw new IllegalArgumentException(message);
        }
        try {
            JavaClass genericClass = (JavaClass)generic;
            ParameterizedClass parameterizedClass = new ParameterizedClass(provider, genericClass, arguments);
            return parameterizedClass;
        }
        catch (ClassCastException e) {
            JavaType javaType = generic;
            return javaType;
        }
    }

    public static JavaMethod createParameterizedMethod(JavaProvider provider, JavaMethod generic, JavaType[] arguments) {
        Collection parameters = generic.getTypeParameters();
        int parameterCount = parameters.size();
        if (parameterCount == 0) {
            throw new IllegalArgumentException("Not a generic type");
        }
        int argumentCount = arguments.length;
        if (parameterCount != argumentCount) {
            throw new IllegalArgumentException("Arguments mismatch");
        }
        return new ParameterizedMethod(provider, generic, arguments);
    }

    public static JavaType createWildcardType(byte bound, JavaType t, JavaProvider provider) {
        switch (bound) {
            case 0: {
                return t;
            }
            case 2: {
                if (t != null) {
                    return new WildcardType(null, t, provider);
                }
                throw new IllegalArgumentException();
            }
            case 1: {
                return new WildcardType(t, null, provider);
            }
            case 3: {
                if (t != null) break;
                return new WildcardType(null, null, provider);
            }
        }
        throw new IllegalArgumentException();
    }

    public static boolean matchMethod(JavaMethod method, JavaType[] targetTypes) {
        Collection parameterCollection = method.getParameters();
        if (targetTypes.length != parameterCollection.size()) {
            return false;
        }
        Iterator parameters = parameterCollection.iterator();
        int p = 0;
        while (parameters.hasNext()) {
            JavaType targetType = targetTypes[p++];
            JavaVariable parameter = (JavaVariable)parameters.next();
            if (targetType == null) continue;
            JavaType parameterType = parameter.getResolvedType();
            if (parameterType == null) {
                return false;
            }
            if (targetType.equals(parameterType)) continue;
            return false;
        }
        return true;
    }

    protected static boolean isInheritedAnnotation(JavaAnnotation annotation) {
        if (annotation == null) {
            return false;
        }
        JavaType annotationType = annotation.getResolvedType();
        return CommonUtilities.isInheritedAnnotation(annotationType);
    }

    protected static boolean isInheritedAnnotation(JavaType annotationType) {
        if (annotationType == null) {
            return false;
        }
        for (JavaAnnotation thing : annotationType.getDeclaredAnnotations()) {
            JavaType type = thing.getAnnotationType();
            if (type == null || !"java/lang/annotation/Inherited".equals(type.getVMName())) continue;
            return true;
        }
        return false;
    }

    protected static boolean classProcessed(ArrayList processed, JavaType javaClass) {
        if (processed == null) {
            return false;
        }
        String targetClassName = javaClass.getTypeSignature();
        if (processed.contains(targetClassName)) {
            return true;
        }
        processed.add(targetClassName);
        return false;
    }

    private static void set_op2opt(byte optype, short tk, byte opt) {
        CommonUtilities.op2optTable[optype][tk - 32] = opt;
    }

    static {
        CommonUtilities.set_op2opt(OPTYPE_ASSIGNMENT, (short)33, (byte)6);
        CommonUtilities.set_op2opt(OPTYPE_ASSIGNMENT, (short)68, (byte)2);
        CommonUtilities.set_op2opt(OPTYPE_ASSIGNMENT, (short)60, (byte)32);
        CommonUtilities.set_op2opt(OPTYPE_ASSIGNMENT, (short)64, (byte)36);
        CommonUtilities.set_op2opt(OPTYPE_ASSIGNMENT, (short)42, (byte)18);
        CommonUtilities.set_op2opt(OPTYPE_ASSIGNMENT, (short)62, (byte)34);
        CommonUtilities.set_op2opt(OPTYPE_ASSIGNMENT, (short)32, (byte)8);
        CommonUtilities.set_op2opt(OPTYPE_ASSIGNMENT, (short)66, (byte)11);
        CommonUtilities.set_op2opt(OPTYPE_ASSIGNMENT, (short)78, (byte)13);
        CommonUtilities.set_op2opt(OPTYPE_ASSIGNMENT, (short)57, (byte)29);
        CommonUtilities.set_op2opt(OPTYPE_ASSIGNMENT, (short)74, (byte)52);
        CommonUtilities.set_op2opt(OPTYPE_ASSIGNMENT, (short)77, (byte)57);
        CommonUtilities.set_op2opt(OPTYPE_RELATIONAL, (short)58, (byte)30);
        CommonUtilities.set_op2opt(OPTYPE_RELATIONAL, (short)51, (byte)25);
        CommonUtilities.set_op2opt(OPTYPE_RELATIONAL, (short)46, (byte)22);
        CommonUtilities.set_op2opt(OPTYPE_RELATIONAL, (short)45, (byte)21);
        CommonUtilities.set_op2opt(OPTYPE_RELATIONAL, (short)44, (byte)20);
        CommonUtilities.set_op2opt(OPTYPE_RELATIONAL, (short)65, (byte)42);
        CommonUtilities.set_op2opt(OPTYPE_SHIFT, (short)56, (byte)28);
        CommonUtilities.set_op2opt(OPTYPE_SHIFT, (short)73, (byte)51);
        CommonUtilities.set_op2opt(OPTYPE_SHIFT, (short)76, (byte)56);
        CommonUtilities.set_op2opt(OPTYPE_INFIX, (short)67, (byte)1);
        CommonUtilities.set_op2opt(OPTYPE_INFIX, (short)59, (byte)31);
        CommonUtilities.set_op2opt(OPTYPE_INFIX, (short)63, (byte)35);
        CommonUtilities.set_op2opt(OPTYPE_INFIX, (short)41, (byte)17);
        CommonUtilities.set_op2opt(OPTYPE_INFIX, (short)61, (byte)33);
        CommonUtilities.set_op2opt(OPTYPE_INFIX, (short)52, (byte)3);
        CommonUtilities.set_op2opt(OPTYPE_INFIX, (short)54, (byte)43);
        CommonUtilities.set_op2opt(OPTYPE_INFIX, (short)34, (byte)7);
        CommonUtilities.set_op2opt(OPTYPE_INFIX, (short)36, (byte)10);
        CommonUtilities.set_op2opt(OPTYPE_INFIX, (short)37, (byte)12);
        short tk = 32;
        while (tk < 81) {
            byte opt = 0;
            if (opt == 0) {
                opt = CommonUtilities.asg_op(tk);
            }
            if (opt == 0) {
                opt = CommonUtilities.rel_op(tk);
            }
            if (opt == 0) {
                opt = CommonUtilities.shift_op(tk);
            }
            if (opt != 0) {
                CommonUtilities.set_op2opt(OPTYPE_INFIX, tk, opt);
            }
            tk = (short)(tk + 1);
        }
        CommonUtilities.set_op2opt(OPTYPE_PREFIX, (short)48, (byte)48);
        CommonUtilities.set_op2opt(OPTYPE_PREFIX, (short)40, (byte)47);
        CommonUtilities.set_op2opt(OPTYPE_PREFIX, (short)53, (byte)41);
        CommonUtilities.set_op2opt(OPTYPE_PREFIX, (short)35, (byte)9);
        CommonUtilities.set_op2opt(OPTYPE_PREFIX, (short)67, (byte)44);
        CommonUtilities.set_op2opt(OPTYPE_PREFIX, (short)59, (byte)37);
        CommonUtilities.set_op2opt(OPTYPE_POSTFIX, (short)48, (byte)46);
        CommonUtilities.set_op2opt(OPTYPE_POSTFIX, (short)40, (byte)45);
    }

    protected static byte asg_op(int token) {
        if (32 <= token && token < 81) {
            return op2optTable[OPTYPE_ASSIGNMENT][token - 32];
        }
        return 0;
    }

    protected static byte rel_op(int token) {
        if (32 <= token && token < 81) {
            return op2optTable[OPTYPE_RELATIONAL][token - 32];
        }
        return 0;
    }

    protected static byte shift_op(int token) {
        if (32 <= token && token < 81) {
            return op2optTable[OPTYPE_SHIFT][token - 32];
        }
        return 0;
    }

    protected static byte infix_op(int token) {
        if (32 <= token && token < 81) {
            return op2optTable[OPTYPE_INFIX][token - 32];
        }
        return 0;
    }

    protected static byte prefix_op(int token) {
        if (32 <= token && token < 81) {
            return op2optTable[OPTYPE_PREFIX][token - 32];
        }
        return 0;
    }

    protected static byte postfix_op(int token) {
        if (32 <= token && token < 81) {
            return op2optTable[OPTYPE_POSTFIX][token - 32];
        }
        return 0;
    }

    public static String getDescriptor(JavaMethod input) {
        StringBuilder buffer = new StringBuilder();
        Collection parameters = input.getParameters();
        if (parameters.isEmpty()) {
            buffer.append("()");
        } else {
            buffer.append('(');
            for (JavaVariable parameter : parameters) {
                JavaType parameterType = parameter.getResolvedType();
                if (parameterType != null) {
                    buffer.append(parameterType.getDescriptor());
                    continue;
                }
                buffer.append('V');
            }
            buffer.append(')');
        }
        JavaType returnType = input.getReturnType();
        if (returnType != null) {
            buffer.append(returnType.getDescriptor());
        } else {
            buffer.append('V');
        }
        return buffer.toString();
    }

    public static String getTypeSignature(JavaMethod input) {
        Collection parameters;
        StringBuilder buffer = new StringBuilder();
        if (input.hasActualTypeArguments()) {
            buffer.append('<');
            for (JavaType type : input.getActualTypeArguments()) {
                if (type != null) {
                    buffer.append(type.getTypeSignature());
                    continue;
                }
                buffer.append("*");
            }
            buffer.append('>');
        }
        if ((parameters = input.getParameters()).isEmpty()) {
            buffer.append("()");
        } else {
            buffer.append('(');
            for (JavaVariable parameter : parameters) {
                JavaType parameterType = parameter.getResolvedType();
                if (parameterType != null) {
                    buffer.append(parameterType.getTypeSignature());
                    continue;
                }
                buffer.append('V');
            }
            buffer.append(')');
        }
        JavaType returnType = input.getReturnType();
        if (returnType != null) {
            buffer.append(returnType.getTypeSignature());
        } else {
            buffer.append('V');
        }
        return buffer.toString();
    }

    public static String getSignature(JavaMethod input) {
        Collection parameters;
        StringBuilder buffer = new StringBuilder();
        if (input.hasTypeParameters()) {
            buffer.append('<');
            for (JavaTypeVariable variable : input.getTypeParameters()) {
                buffer.append(variable.getSignature());
            }
            buffer.append('>');
        }
        if ((parameters = input.getParameters()).isEmpty()) {
            buffer.append("()");
        } else {
            buffer.append('(');
            for (JavaVariable parameter : parameters) {
                JavaType parameterType = parameter.getResolvedType();
                if (parameterType != null) {
                    buffer.append(parameterType.getTypeSignature());
                    continue;
                }
                buffer.append('V');
            }
            buffer.append(')');
        }
        JavaType returnType = input.getReturnType();
        if (returnType != null) {
            buffer.append(returnType.getTypeSignature());
        } else {
            buffer.append('V');
        }
        for (JavaType exception : input.getExceptions()) {
            buffer.append('^');
            buffer.append(exception.getTypeSignature());
        }
        return buffer.toString();
    }

    public static String getDescriptor(JavaField input) {
        JavaType type = input.getResolvedType();
        if (type == null) {
            return "java/lang/Object";
        }
        return type.getDescriptor();
    }

    public static String getSignature(JavaField input) {
        JavaType type = input.getResolvedType();
        if (type == null) {
            return "java/lang/Object";
        }
        return type.getTypeSignature();
    }

    public static String getDescriptor(JavaClass input) {
        StringBuilder buffer = new StringBuilder();
        buffer.append('L');
        buffer.append(input.getVMName());
        buffer.append(';');
        return buffer.toString();
    }

    public static String getTypeSignature(JavaClass input) {
        StringBuilder buffer = new StringBuilder();
        if (input.isMemberClass() && !input.isStatic()) {
            String owningTypeSignature;
            JavaClass owningClass = input.getOwningClass();
            String owningDescriptor = owningClass.getDescriptor();
            if (!owningDescriptor.equals(owningTypeSignature = owningClass.getTypeSignature())) {
                buffer.append(owningTypeSignature);
                buffer.setLength(buffer.length() - 1);
                buffer.append('.');
                buffer.append(input.getName());
            } else {
                buffer.append('L');
                buffer.append(input.getVMName());
            }
        } else {
            buffer.append('L');
            buffer.append(input.getVMName());
        }
        if (input.hasActualTypeArguments()) {
            buffer.append('<');
            for (JavaType type : input.getActualTypeArguments()) {
                if (type != null) {
                    buffer.append(type.getTypeSignature());
                    continue;
                }
                buffer.append("*");
            }
            buffer.append('>');
        }
        buffer.append(';');
        return buffer.toString();
    }

    public static String getSignature(JavaClass input) {
        JavaType superclass;
        StringBuilder buffer = new StringBuilder();
        if (input.hasTypeParameters()) {
            buffer.append('<');
            for (JavaTypeVariable variable : input.getTypeParameters()) {
                buffer.append(variable.getSignature());
            }
            buffer.append('>');
        }
        if ((superclass = input.getSuperclass()) != null) {
            buffer.append(superclass.getDescriptor());
        }
        for (JavaType type : input.getInterfaces()) {
            buffer.append(type.getDescriptor());
        }
        return buffer.toString();
    }

    public static String getDescriptor(JavaTypeVariable input) {
        JavaClass erasure = input.getTypeErasure();
        if (erasure != null) {
            return erasure.getDescriptor();
        }
        return "Ljava/lang/Object;";
    }

    public static String getTypeSignature(JavaTypeVariable input) {
        StringBuilder buffer = new StringBuilder();
        buffer.append('T');
        buffer.append(input.getName());
        buffer.append(';');
        return buffer.toString();
    }

    public static String getSignature(JavaTypeVariable input) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(input.getName());
        for (JavaType bound : input.getBounds()) {
            buffer.append(':');
            buffer.append(bound.getTypeSignature());
        }
        return buffer.toString();
    }

    public static String getUniqueIdentifier(JavaPackage thing) {
        return 'p' + thing.getQualifiedName().replace('.', '/');
    }

    public static String getUniqueIdentifier(JavaClass thing) {
        return thing.getTypeSignature();
    }

    public static String getUniqueIdentifier(JavaTypeVariable thing) {
        JavaIsGeneric owner = (JavaIsGeneric)thing.getOwningMember();
        String prefix = owner != null ? owner.getUniqueIdentifier() : "<unknown>";
        return prefix + ':' + thing.getTypeSignature();
    }

    public static String getUniqueIdentifier(JavaWildcardType thing) {
        return thing.getTypeSignature();
    }

    public static String getUniqueIdentifier(JavaField thing) {
        JavaClass owner = thing.getOwningClass();
        String ownerUnique = owner != null ? owner.getUniqueIdentifier() : "class-unknown";
        return 'f' + ownerUnique + '.' + thing.getName() + ' ' + CommonUtilities.getSignature(thing);
    }

    public static String getUniqueIdentifier(JavaMethod thing) {
        JavaClass owner = thing.getOwningClass();
        String ownerUnique = owner != null ? owner.getUniqueIdentifier() : "class-unknown";
        String signature = thing.getTypeSignature();
        int firstExp = signature.indexOf(94);
        String signatureToUse = firstExp >= 0 ? signature.substring(0, firstExp) : signature;
        return 'm' + ownerUnique + '.' + thing.getName() + ' ' + signatureToUse;
    }

    public static boolean equals(JavaPackage one, JavaPackage two) {
        if (one == two) {
            return true;
        }
        return one.getQualifiedName().equals(two.getQualifiedName());
    }

    public static boolean equals(JavaMember one, JavaMember two) {
        if (one == two) {
            return true;
        }
        return one.getUniqueIdentifier().equals(two.getUniqueIdentifier());
    }

    public static int hashCode(JavaPackage thing) {
        if (thing == null) {
            return 0;
        }
        return thing.getQualifiedName().hashCode();
    }

    public static int hashCode(JavaMember thing) {
        if (thing == null) {
            return 0;
        }
        return thing.getUniqueIdentifier().hashCode();
    }

    public static JavaField getDeclaredField(JavaType target, String name) {
        for (JavaField thing : target.getDeclaredFields()) {
            if (!name.equals(thing.getName())) continue;
            return thing;
        }
        return null;
    }

    public static Collection getDeclaredMethods(JavaType target, String name) {
        ArrayList<JavaMethod> list = new ArrayList<JavaMethod>();
        for (JavaMethod thing : target.getDeclaredMethods()) {
            if (!name.equals(thing.getName())) continue;
            list.add(thing);
        }
        return list;
    }

    public static JavaMethod getDeclaredMethod(JavaType target, String name, JavaType[] targetTypes) {
        if (targetTypes == null) {
            targetTypes = JavaType.EMPTY_ARRAY;
        }
        for (JavaMethod thing : target.getDeclaredMethods()) {
            if (!name.equals(thing.getName()) || !CommonUtilities.matchMethod(thing, targetTypes)) continue;
            return thing;
        }
        return null;
    }

    public static JavaMethod getDeclaredConstructor(JavaType target, JavaType[] targetTypes) {
        if (targetTypes == null) {
            targetTypes = JavaType.EMPTY_ARRAY;
        }
        for (JavaMethod thing : target.getDeclaredConstructors()) {
            if (!CommonUtilities.matchMethod(thing, targetTypes)) continue;
            return thing;
        }
        return null;
    }

    public static JavaClass getDeclaredClass(JavaType target, String name) {
        for (JavaClass thing : target.getDeclaredClasses()) {
            String thingName = thing.getName();
            if (!name.equals(thing.getName())) continue;
            return thing;
        }
        return null;
    }

    public static JavaTypeVariable getTypeParameter(JavaIsGeneric target, String name) {
        if (!target.hasTypeParameters()) {
            return null;
        }
        for (JavaTypeVariable thing : target.getTypeParameters()) {
            if (!name.equals(thing.getName())) continue;
            return thing;
        }
        return null;
    }

    public static JavaAnnotation getDeclaredAnnotation(JavaHasAnnotations target, JavaType annotationType) {
        if (annotationType == null) {
            return null;
        }
        for (JavaAnnotation thing : target.getDeclaredAnnotations()) {
            JavaType type = thing.getResolvedType();
            if (type == null || !type.equals(annotationType)) continue;
            return thing;
        }
        return null;
    }

    public static Collection getFields(JavaType target) {
        ArrayList list = new ArrayList();
        list.addAll(target.getDeclaredFields());
        for (JavaType type : target.getHierarchy()) {
            list.addAll(type.getDeclaredFields());
        }
        return list;
    }

    public static JavaField getField(JavaType target, String name) {
        JavaField thing = target.getDeclaredField(name);
        if (thing != null) {
            return thing;
        }
        for (JavaType type : target.getHierarchy()) {
            thing = type.getDeclaredField(name);
            if (thing == null) continue;
            return thing;
        }
        return null;
    }

    public static Collection getMethods(JavaType target) {
        ArrayList list = new ArrayList();
        list.addAll(target.getDeclaredMethods());
        for (JavaType type : target.getHierarchy()) {
            list.addAll(type.getDeclaredMethods());
        }
        return list;
    }

    public static Collection getMethods(JavaType target, String name) {
        ArrayList list = new ArrayList();
        list.addAll(target.getDeclaredMethods(name));
        for (JavaType type : target.getHierarchy()) {
            list.addAll(type.getDeclaredMethods(name));
        }
        return list;
    }

    public static JavaMethod getMethod(JavaType target, String name, JavaType[] targetTypes) {
        if (targetTypes == null) {
            targetTypes = JavaType.EMPTY_ARRAY;
        }
        Collection things = target.getMethods(name);
        for (JavaMethod thing : things) {
            if (!CommonUtilities.matchMethod(thing, targetTypes)) continue;
            return thing;
        }
        return null;
    }

    public static Collection getClasses(JavaType target) {
        ArrayList list = new ArrayList();
        list.addAll(target.getDeclaredClasses());
        for (JavaType type : target.getHierarchy()) {
            list.addAll(type.getDeclaredClasses());
        }
        return list;
    }

    public static JavaClass getClass(JavaType target, String name) {
        JavaClass thing = target.getDeclaredClass(name);
        if (thing != null) {
            return thing;
        }
        for (JavaType type : target.getHierarchy()) {
            thing = type.getDeclaredClass(name);
            if (thing == null) continue;
            return thing;
        }
        return null;
    }

    public static JavaClass getClass(JavaFile target, String name) {
        for (JavaClass thing : target.getClasses()) {
            if (!name.equals(thing.getName())) continue;
            return thing;
        }
        return null;
    }

    public static Collection getAnnotations(JavaType target) {
        ArrayList<JavaAnnotation> list = new ArrayList<JavaAnnotation>();
        list.addAll(target.getDeclaredAnnotations());
        for (JavaType type : target.getHierarchy()) {
            for (JavaAnnotation a : type.getDeclaredAnnotations()) {
                if (!a.isInherited()) continue;
                list.add(a);
            }
        }
        return list;
    }

    public static JavaAnnotation getAnnotation(JavaType target, JavaType annotationType) {
        if (annotationType == null) {
            return null;
        }
        for (JavaAnnotation thing : target.getAnnotations()) {
            JavaType type = thing.getResolvedType();
            if (type == null || !type.equals(annotationType)) continue;
            return thing;
        }
        return null;
    }

    public static JavaType[] getParameterTypes(JavaMethod target) {
        Collection parameters = target.getParameters();
        int count = parameters.size();
        if (count == 0) {
            return JavaType.EMPTY_ARRAY;
        }
        JavaType[] out = new JavaType[count];
        Iterator iterator = parameters.iterator();
        int i = 0;
        while (iterator.hasNext()) {
            JavaVariable variable = (JavaVariable)iterator.next();
            out[i++] = variable.getResolvedType();
        }
        return out;
    }

    public static JavaElement locateByUniqueIdentifier(String uniqueIdentifier, JavaProvider provider) {
        int totalLength = uniqueIdentifier.length();
        if (totalLength == 0) {
            return null;
        }
        char first = uniqueIdentifier.charAt(0);
        switch (first) {
            case 'p': {
                if (totalLength == 1) {
                    return provider.getPackage("");
                }
                String packageName = uniqueIdentifier.substring(1).replace('/', '.');
                return provider.getPackage(packageName);
            }
            case 'f': {
                int dot = uniqueIdentifier.indexOf(46, 1);
                if (dot <= 1) {
                    return null;
                }
                String classIdentifier = uniqueIdentifier.substring(1, dot);
                JavaType classThing = CommonUtilities.getTypeByUniqueIdentifier0(classIdentifier, provider);
                if (classThing == null) {
                    return null;
                }
                int space = uniqueIdentifier.indexOf(32, dot + 1);
                if (space < 0 || space == dot + 1) {
                    return null;
                }
                String name = uniqueIdentifier.substring(dot + 1, space);
                return classThing.getDeclaredField(name);
            }
            case 'm': {
                int dot = uniqueIdentifier.indexOf(46, 1);
                if (dot <= 1) {
                    return null;
                }
                String classIdentifier = uniqueIdentifier.substring(1, dot);
                JavaType classThing = CommonUtilities.getTypeByUniqueIdentifier0(classIdentifier, provider);
                if (classThing == null) {
                    return null;
                }
                int space = uniqueIdentifier.indexOf(32, dot + 1);
                if (space < 0 || space == dot + 1) {
                    return null;
                }
                String name = uniqueIdentifier.substring(dot + 1, space);
                int lparen = uniqueIdentifier.indexOf(40, space + 1);
                if (lparen < 0) {
                    return null;
                }
                int rparen = uniqueIdentifier.indexOf(41, lparen + 1);
                if (rparen < 0) {
                    return null;
                }
                JavaType[] formals = JavaType.EMPTY_ARRAY;
                if (rparen != lparen + 1) {
                    String formalsString = uniqueIdentifier.substring(lparen + 1, rparen);
                    formals = CommonUtilities.getTypesByUniqueIdentifier0(formalsString, provider);
                }
                return classThing.getDeclaredMethod(name, formals);
            }
        }
        return CommonUtilities.getTypeByUniqueIdentifier0(uniqueIdentifier, provider);
    }

    private static JavaType getTypeByUniqueIdentifier0(String identifier, JavaProvider provider) {
        char first;
        int length = identifier.length();
        if (length == 1 && 'A' <= (first = identifier.charAt(0)) && first <= 'Z') {
            return PrimitiveType.PRIMITIVE_alpha[first - 65];
        }
        try {
            QuickSignatureParser parser = new QuickSignatureParser(identifier, null, provider);
            SignatureHasType hasType = (SignatureHasType)parser.parseTypeSignature0();
            if (hasType != null) {
                JavaType javaType = hasType.getResolvedType();
                return javaType;
            }
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        return null;
    }

    private static JavaType[] getTypesByUniqueIdentifier0(String identifier, JavaProvider provider) {
        try {
            QuickSignatureParser parser = new QuickSignatureParser(identifier, null, provider);
            ArrayList<JavaType> list = new ArrayList<JavaType>();
            while (parser.curToken != 0) {
                SignatureHasType hasType = (SignatureHasType)parser.parseTypeSignature0();
                if (hasType == null) break;
                list.add(hasType.getResolvedType());
            }
            int count = list.size();
            if (count == 0) {
                JavaType[] javaTypeArray = JavaType.EMPTY_ARRAY;
                return javaTypeArray;
            }
            JavaType[] javaTypeArray = list.toArray(new JavaType[count]);
            return javaTypeArray;
        }
        catch (IllegalStateException e) {
            return null;
        }
    }

    public static SourceElement getSourceElement(JavaElement target, SourceFile searchSpace) {
        if (searchSpace == null) {
            return null;
        }
        if (target == null) {
            throw new IllegalArgumentException();
        }
        switch (target.getElementKind()) {
            case 3: {
                JavaClass thing = (JavaClass)target;
                SourceClass found = CommonUtilities.getSourceElement(thing, searchSpace);
                if (found != null) {
                    return found;
                }
                JavaClass owning = thing.getOwningClass();
                if (owning == null) {
                    return null;
                }
                SourceClass searchClass = CommonUtilities.getSourceElement(owning, searchSpace);
                return CommonUtilities.getSourceElement(thing, searchClass);
            }
            case 5: {
                JavaField thing = (JavaField)target;
                JavaClass owning = thing.getOwningClass();
                SourceClass searchClass = CommonUtilities.getSourceElement(owning, searchSpace);
                return CommonUtilities.getSourceElement(thing, searchClass);
            }
            case 4: 
            case 8: {
                JavaMethod thing = (JavaMethod)target;
                JavaClass owning = thing.getOwningClass();
                SourceClass searchClass = CommonUtilities.getSourceElement(owning, searchSpace);
                return CommonUtilities.getSourceElement(thing, searchClass);
            }
        }
        return null;
    }

    public static SourceClass getSourceElement(JavaClass target, SourceFile searchSpace) {
        if (searchSpace == null) {
            return null;
        }
        SourceFile sourceFile = searchSpace;
        if (target == null) {
            throw new IllegalArgumentException();
        }
        String targetName = target.getDescriptor();
        for (SourceClass thing : sourceFile.getSourceClasses()) {
            if (!targetName.equals(thing.getDescriptor())) continue;
            return thing;
        }
        return null;
    }

    public static SourceClass getSourceElement(JavaClass target, SourceClass searchSpace) {
        if (searchSpace == null) {
            return null;
        }
        SourceClass sourceClass = searchSpace;
        if (target == null) {
            throw new IllegalArgumentException();
        }
        String targetName = target.getName();
        for (SourceClass thing : sourceClass.getSourceClasses()) {
            if (!targetName.equals(thing.getName())) continue;
            return thing;
        }
        return null;
    }

    public static SourceMemberVariable getSourceElement(JavaField target, SourceClass searchSpace) {
        if (searchSpace == null) {
            return null;
        }
        SourceClass sourceClass = searchSpace;
        if (target == null) {
            throw new IllegalArgumentException();
        }
        String targetName = target.getName();
        for (SourceMemberVariable thing : sourceClass.getSourceMemberVariables()) {
            if (!targetName.equals(thing.getName())) continue;
            return thing;
        }
        return null;
    }

    public static SourceMethod getSourceElement(JavaMethod target, SourceClass searchSpace) {
        if (searchSpace == null) {
            return null;
        }
        SourceClass sourceClass = searchSpace;
        if (target == null) {
            throw new IllegalArgumentException();
        }
        boolean isConstructor = target.isConstructor();
        String targetName = target.getName();
        Iterator methods = isConstructor ? sourceClass.getSourceConstructors().iterator() : sourceClass.getSourceMethods().iterator();
        boolean isVarargs = target.isVarargs();
        String descriptor = target.getDescriptor();
        while (methods.hasNext()) {
            SourceMethod method = (SourceMethod)methods.next();
            if (!isConstructor && (!targetName.equals(method.getName()) || isVarargs != method.isVarargs()) || !descriptor.equals(method.getDescriptor())) continue;
            return method;
        }
        return null;
    }

    public static SourceAnnotation getSourceElement(JavaAnnotation target, SourceHasModifiers searchSpace) {
        if (searchSpace == null) {
            return null;
        }
        if (target == null) {
            throw new IllegalArgumentException();
        }
        JavaType targetType = target.getResolvedType();
        if (targetType == null) {
            return null;
        }
        for (SourceAnnotation sourceThing : searchSpace.getSourceAnnotations()) {
            JavaType thingType;
            JavaAnnotation thing = (JavaAnnotation)sourceThing.getCompiledObject();
            if (thing == null || (thingType = thing.getResolvedType()) == null || !targetType.equals(thingType)) continue;
            return sourceThing;
        }
        return null;
    }

    public static boolean isValidImportName(String name) {
        return CommonUtilities.isValidName(name, true, true);
    }

    public static boolean isValidQualifiedName(String name) {
        return CommonUtilities.isValidName(name, true, false);
    }

    public static boolean isValidSimpleName(String name) {
        return CommonUtilities.isValidName(name, false, false);
    }

    private static boolean isValidName(String name, boolean qualified, boolean star) {
        int count = name.length();
        if (count == 0) {
            return false;
        }
        char firstch = name.charAt(0);
        if (!Character.isJavaIdentifierStart(firstch)) {
            return false;
        }
        int i = 1;
        while (i < count) {
            char ch = name.charAt(i);
            if (!(Character.isJavaIdentifierPart(ch) || ch == '.' && qualified || ch == '*' && star && i == count - 1)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean containsClassThisSuper(String qualifiedName) {
        int length = qualifiedName.length();
        int afterLastDot = 0;
        while (afterLastDot < length) {
            int segmentLength;
            int nextDot = qualifiedName.indexOf(46, afterLastDot);
            if (nextDot < 0) {
                nextDot = length;
            }
            if (4 <= (segmentLength = nextDot - afterLastDot) && segmentLength <= 5) {
                String segment = qualifiedName.substring(afterLastDot, nextDot);
                if (segment.equals("class")) {
                    return true;
                }
                if (segment.equals("this")) {
                    return true;
                }
                if (segment.equals("super")) {
                    return true;
                }
            }
            afterLastDot = nextDot + 1;
        }
        return false;
    }

    public static JavaClass getTypeErasure(JavaTypeVariable thing) {
        Collection bounds = thing.getBounds();
        if (!bounds.isEmpty()) {
            JavaType firstBound = (JavaType)bounds.iterator().next();
            return firstBound.getTypeErasure();
        }
        JavaType superclass = thing.getSuperclass();
        if (superclass != null) {
            return superclass.getTypeErasure();
        }
        Collection interfaces = thing.getInterfaces();
        if (interfaces.isEmpty()) {
            return null;
        }
        JavaType firstInterface = (JavaType)interfaces.iterator().next();
        return firstInterface.getTypeErasure();
    }

    public static String getInstantiatedTypeToString(JavaType type) {
        StringBuilder buf = new StringBuilder();
        if (type.isArray()) {
            buf.append(CommonUtilities.getInstantiatedTypeToString(type.getComponentType()));
            buf.append("[]");
        } else {
            buf.append(type.getName());
            if (type.getElementKind() == 11) {
                JavaWildcardType wildCardType = (JavaWildcardType)type;
                String snippet = null;
                Collection c = wildCardType.getUpperBounds();
                if (c != null && c.iterator().hasNext()) {
                    snippet = " extends ";
                } else {
                    c = wildCardType.getLowerBounds();
                    if (c != null && c.iterator().hasNext()) {
                        snippet = " super ";
                    }
                }
                if (snippet != null) {
                    buf.append(snippet);
                    JavaType boundType = (JavaType)c.iterator().next();
                    buf.append(CommonUtilities.getInstantiatedTypeToString(boundType));
                }
            } else if (type.hasActualTypeArguments()) {
                buf.append('<');
                Collection args = type.getActualTypeArguments();
                Iterator iter = args.iterator();
                while (iter.hasNext()) {
                    buf.append(CommonUtilities.getInstantiatedTypeToString((JavaType)iter.next()));
                    if (!iter.hasNext()) continue;
                    buf.append(',');
                }
                buf.append('>');
            }
        }
        return buf.toString();
    }

    public static List immutableCopy(Collection src) {
        Object[] array = src.toArray();
        return Arrays.asList(array);
    }

    public static ArrayList mutableCopy(Collection src) {
        ArrayList dst = new ArrayList();
        dst.addAll(src);
        return dst;
    }

    public static String format(String input, String arg0) {
        int index;
        if (arg0 != null && (index = input.indexOf("{0}")) >= 0) {
            String prefix = input.substring(0, index);
            String suffix = input.substring(index + 3);
            input = prefix + arg0 + suffix;
        }
        return input;
    }

    public static String format(String input, String arg0, String arg1) {
        int index;
        int index2;
        if (arg0 != null && (index2 = input.indexOf("{0}")) >= 0) {
            String prefix = input.substring(0, index2);
            String suffix = input.substring(index2 + 3);
            input = prefix + arg0 + suffix;
        }
        if (arg1 != null && (index = input.indexOf("{1}")) >= 0) {
            String prefix = input.substring(0, index);
            String suffix = input.substring(index + 3);
            input = prefix + arg1 + suffix;
        }
        return input;
    }

    public static void panic(String msg) {
        throw new IllegalStateException(msg);
    }

    public static void panic() {
        throw new IllegalStateException();
    }

    public static void unsupported(String msg) {
        throw new UnsupportedOperationException(msg);
    }

    public static void unsupported() {
        throw new UnsupportedOperationException();
    }

    public static void notImplementedYet() {
        throw new UnsupportedOperationException("Not implemented yet");
    }
}

