/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.common;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import oracle.javatools.parser.java.v2.JavaConstants;
import oracle.javatools.parser.java.v2.JavaProvider;
import oracle.javatools.parser.java.v2.common.Parameterization;
import oracle.javatools.parser.java.v2.common.PrimitiveType;
import oracle.javatools.parser.java.v2.common.WrapperClass;
import oracle.javatools.parser.java.v2.common.WrapperField;
import oracle.javatools.parser.java.v2.common.WrapperLocalVariable;
import oracle.javatools.parser.java.v2.common.WrapperMethod;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaElement;
import oracle.javatools.parser.java.v2.model.JavaField;
import oracle.javatools.parser.java.v2.model.JavaLocalVariable;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.UnresolvedType;

final class ParameterizedClass
extends WrapperClass {
    private final JavaClass owningClass;
    final Parameterization params;
    private JavaType boundSuperclass;
    private Collection boundInterfaces;
    private Collection fields;
    private Collection methods;
    private Collection constructors;
    private Collection classes;

    private void $init$() {
        this.boundSuperclass = null;
        this.boundInterfaces = null;
        this.fields = null;
        this.methods = null;
        this.constructors = null;
        this.classes = null;
    }

    ParameterizedClass(JavaProvider provider, JavaClass baseType, JavaType[] arguments) {
        super(baseType);
        this.$init$();
        this.params = new Parameterization(provider, baseType, arguments);
        this.owningClass = null;
    }

    private ParameterizedClass(JavaClass owningClass, Parameterization params) {
        super((JavaClass)params.baseObject);
        this.$init$();
        this.params = params;
        this.owningClass = owningClass;
    }

    public JavaClass getOwningClass() {
        if (this.owningClass == null) {
            return super.getOwningClass();
        }
        return this.owningClass;
    }

    public boolean hasActualTypeArguments() {
        return this.params.boundArguments.length > 0;
    }

    public Collection getActualTypeArguments() {
        if (this.params.boundArguments.length == 0) {
            return JavaConstants.kEmptyCollection;
        }
        return Arrays.asList(this.params.boundArguments);
    }

    public JavaClass getTypeErasure() {
        return super.getTypeErasure();
    }

    private String getNameImpl(boolean qualified) {
        JavaClass owningClass = this.getOwningClass();
        String prefix = owningClass == null ? (qualified ? this.thing.getQualifiedName() : this.thing.getUnqualifiedName()) : (qualified ? owningClass.getQualifiedName() + '.' + this.getName() : owningClass.getUnqualifiedName() + '.' + this.getName());
        if (prefix.length() == 0) {
            return "";
        }
        int count = this.params.boundArguments.length;
        if (count == 0) {
            return prefix;
        }
        StringBuilder buffer = new StringBuilder(prefix);
        buffer.append('<');
        boolean needComma = false;
        int i = 0;
        while (i < count) {
            JavaType arg;
            if (needComma) {
                buffer.append(',');
            }
            if ((arg = this.params.boundArguments[i]) != null) {
                if (qualified) {
                    buffer.append(arg.getQualifiedName());
                } else {
                    buffer.append(arg.getUnqualifiedName());
                }
            } else {
                buffer.append('N');
            }
            needComma = true;
            ++i;
        }
        buffer.append('>');
        return buffer.toString();
    }

    public String getUnqualifiedName() {
        return this.getNameImpl(false);
    }

    public String getQualifiedName() {
        return this.getNameImpl(true);
    }

    public String getDescriptor() {
        JavaClass erasure = this.getTypeErasure();
        if (erasure != null) {
            return erasure.getDescriptor();
        }
        return super.getDescriptor();
    }

    public JavaType getSuperclass() {
        if (this.boundSuperclass == null) {
            JavaType superclass = super.getSuperclass();
            if (superclass == null) {
                return null;
            }
            this.boundSuperclass = this.params.bind(superclass);
        }
        return this.boundSuperclass;
    }

    public Collection getInterfaces() {
        if (this.boundInterfaces == null) {
            this.boundInterfaces = this.params.bind(super.getInterfaces());
        }
        return this.boundInterfaces;
    }

    public Collection getDeclaredFields() {
        if (this.fields == null) {
            Collection thingFields = super.getDeclaredFields();
            if (thingFields.isEmpty()) {
                this.fields = thingFields;
            } else {
                BoundMemberField[] array = new BoundMemberField[thingFields.size()];
                Iterator iterator = thingFields.iterator();
                int i = 0;
                while (iterator.hasNext()) {
                    JavaField thing = (JavaField)iterator.next();
                    array[i++] = new BoundMemberField(thing, null);
                }
                this.fields = Arrays.asList(array);
            }
        }
        return this.fields;
    }

    public Collection getDeclaredMethods() {
        if (this.methods == null) {
            Collection thingMethods = super.getDeclaredMethods();
            if (thingMethods.isEmpty()) {
                this.methods = thingMethods;
            } else {
                BoundMemberMethod[] array = new BoundMemberMethod[thingMethods.size()];
                Iterator iterator = thingMethods.iterator();
                int i = 0;
                while (iterator.hasNext()) {
                    JavaMethod thing = (JavaMethod)iterator.next();
                    array[i++] = new BoundMemberMethod(thing, null);
                }
                this.methods = Arrays.asList(array);
            }
        }
        return this.methods;
    }

    public Collection getDeclaredConstructors() {
        if (this.constructors == null) {
            Collection thingConstructors = super.getDeclaredConstructors();
            if (thingConstructors.isEmpty()) {
                this.constructors = thingConstructors;
            } else {
                BoundMemberMethod[] array = new BoundMemberMethod[thingConstructors.size()];
                Iterator iterator = thingConstructors.iterator();
                int i = 0;
                while (iterator.hasNext()) {
                    JavaMethod thing = (JavaMethod)iterator.next();
                    array[i++] = new BoundMemberMethod(thing, null);
                }
                this.constructors = Arrays.asList(array);
            }
        }
        return this.constructors;
    }

    public Collection getDeclaredClasses() {
        if (this.classes == null) {
            Collection thingClasses = super.getDeclaredClasses();
            if (thingClasses.isEmpty()) {
                this.classes = thingClasses;
            } else {
                ParameterizedClass[] array = new ParameterizedClass[thingClasses.size()];
                Iterator iterator = thingClasses.iterator();
                int i = 0;
                while (iterator.hasNext()) {
                    JavaClass thing = (JavaClass)iterator.next();
                    Parameterization thingParams = new Parameterization(thing, this.params);
                    array[i++] = new ParameterizedClass(this, thingParams);
                }
                this.classes = Arrays.asList(array);
            }
        }
        return this.classes;
    }

    private class BoundMemberField
    extends WrapperField {
        private JavaType type;

        private void $init$() {
            this.type = null;
        }

        private BoundMemberField(JavaField thing) {
            super(thing);
            this.$init$();
        }

        public JavaType getResolvedType() {
            if (this.type == null) {
                this.type = ParameterizedClass.this.params.bind(this.thing.getResolvedType());
            }
            return this.type;
        }

        public JavaClass getOwningClass() {
            return ParameterizedClass.this;
        }

        BoundMemberField(JavaField javaField, 1 var3_3) {
            this(javaField);
        }

        public final class 1 {
        }
    }

    private class BoundMemberMethod
    extends WrapperMethod {
        private JavaType type;
        private Collection parameters;
        private Collection exceptions;

        private void $init$() {
            this.type = null;
            this.parameters = null;
            this.exceptions = null;
        }

        private BoundMemberMethod(JavaMethod thing) {
            super(thing);
            this.$init$();
        }

        public JavaType getReturnType() {
            if (this.type == null) {
                this.type = ParameterizedClass.this.params.bind(this.thing.getResolvedType());
                if (this.type == null) {
                    this.type = PrimitiveType.PRIMITIVE_objects[9];
                }
            }
            return this.type;
        }

        public JavaType getResolvedType() {
            return this.getReturnType();
        }

        public Collection getParameters() {
            if (this.parameters == null) {
                Collection thingParameters = this.thing.getParameters();
                if (thingParameters.isEmpty()) {
                    this.parameters = thingParameters;
                } else {
                    BoundParameter[] array = new BoundParameter[thingParameters.size()];
                    Iterator iterator = thingParameters.iterator();
                    int i = 0;
                    while (iterator.hasNext()) {
                        JavaLocalVariable parameter = (JavaLocalVariable)iterator.next();
                        array[i++] = new BoundParameter(parameter, null);
                    }
                    this.parameters = Arrays.asList(array);
                }
            }
            return this.parameters;
        }

        public Collection getExceptions() {
            if (this.exceptions == null) {
                this.exceptions = ParameterizedClass.this.params.bind(this.thing.getExceptions());
            }
            return this.exceptions;
        }

        public JavaClass getOwningClass() {
            return ParameterizedClass.this;
        }

        BoundMemberMethod(JavaMethod javaMethod, 1 var3_3) {
            this(javaMethod);
        }

        private class BoundParameter
        extends WrapperLocalVariable {
            private JavaType type;

            private void $init$() {
                this.type = null;
            }

            private BoundParameter(JavaLocalVariable thing) {
                super(thing);
                this.$init$();
            }

            public JavaType getResolvedType() {
                if (this.type == null) {
                    this.type = ParameterizedClass.this.params.bind(this.thing.getResolvedType());
                }
                return this.type;
            }

            public UnresolvedType getUnresolvedType() {
                return this.thing.getUnresolvedType();
            }

            public JavaElement getOwner() {
                return BoundMemberMethod.this;
            }

            BoundParameter(JavaLocalVariable javaLocalVariable, 1 var3_3) {
                this(javaLocalVariable);
            }

            public final class 1 {
            }
        }

        public final class 1 {
        }
    }
}

