/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.common;

import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.buffer.TextBufferFactory;
import oracle.javatools.parser.java.v2.JavaConstants;
import oracle.javatools.parser.java.v2.common.CommonUtilities;
import oracle.javatools.parser.java.v2.common.PrimitiveType;
import oracle.javatools.parser.java.v2.scanner.JavaLexer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SignatureParser<T>
implements JavaConstants {
    protected final ReadTextBuffer buffer;
    protected final JavaLexer lexer;
    protected int curToken;
    protected String errorMessage;

    private void $init$() {
        this.lexer = new JavaLexer(3);
        this.errorMessage = "Unknown error.";
    }

    protected SignatureParser(String text) {
        this(TextBufferFactory.createReadTextBuffer(text));
    }

    protected SignatureParser(ReadTextBuffer buffer) {
        this.$init$();
        this.buffer = buffer;
        this.lexer.setTextBuffer(buffer);
        this.lexer.setPosition(0);
        this.skipToken();
    }

    protected abstract T getUnboundedWildcard();

    protected abstract T getBoundedWildcard(boolean var1, T var2);

    protected abstract void addTypeArgument(T var1, T var2);

    protected abstract T getClassType(char var1, String var2);

    protected abstract void pushInnerClassType(T var1, String var2);

    protected abstract T getTypeVariable(String var1);

    protected abstract T getArrayType(T var1);

    protected abstract T getPrimitiveType(PrimitiveType var1);

    protected final void nextToken(short tk) {
        if (this.curToken == tk) {
            this.skipToken();
        } else {
            this.error();
        }
    }

    protected final void nextToken(short tk1, short tk2) {
        if (this.curToken == tk1 || this.curToken == tk2) {
            this.skipToken();
        } else {
            this.error();
        }
    }

    protected final boolean optionalToken(short tk) {
        if (this.curToken != tk) {
            return false;
        }
        this.skipToken();
        return true;
    }

    protected final boolean optionalToken(short tk1, short tk2) {
        if (this.curToken != tk1 && this.curToken != tk2) {
            return false;
        }
        this.skipToken();
        return true;
    }

    protected final void skipToken() {
        this.curToken = this.lexer.lex();
    }

    private final T parseTypeArgument0() {
        int bound = 0;
        switch (this.curToken) {
            case 63: {
                this.skipToken();
                return this.getUnboundedWildcard();
            }
            case 67: {
                bound = 1;
                this.skipToken();
                break;
            }
            case 59: {
                bound = 2;
                this.skipToken();
                break;
            }
        }
        T argument = this.parseTypeSignature0();
        if (bound == 0) {
            return argument;
        }
        return this.getBoundedWildcard(bound == 1, argument);
    }

    private final void parseTypeArguments_opt0(T type) {
        if (this.optionalToken((short)58)) {
            while (this.curToken != 46 && this.curToken != 0) {
                T argument = this.parseTypeArgument0();
                this.addTypeArgument(type, argument);
            }
            this.nextToken((short)46);
        }
    }

    /*
     * Unable to fully structure code
     */
    public final T parseTypeSignature0() {
        start = this.lexer.getStartOffset();
        if (start == -1) {
            SignatureParser.panic("No token");
        }
        ch = this.buffer.getChar(start);
        savedError = this.errorMessage;
        try {
            this.lexer.setPosition(start + 1);
            this.skipToken();
            switch (ch) {
                case 'L': {
                    this.errorMessage = "Invalid class reference.";
                    nameStart = this.lexer.getStartOffset();
                    do {
                        if (this.curToken != 4 && this.curToken != 145) {
                            this.error();
                        }
                        nameEnd = this.lexer.getEndOffset();
                        this.skipToken();
                    } while (this.optionalToken((short)41));
                    name = this.buffer.getString(nameStart, nameEnd - nameStart);
                    type = this.getClassType(ch, name);
                    this.parseTypeArguments_opt0(type);
                    while (this.optionalToken((short)43)) {
                        if (this.curToken != 4) {
                            this.error();
                        }
                        innerStart = this.lexer.getStartOffset();
                        innerEnd = this.lexer.getEndOffset();
                        this.skipToken();
                        innerName = this.buffer.getString(innerStart, innerEnd - innerStart);
                        this.pushInnerClassType(type, innerName);
                        this.parseTypeArguments_opt0(type);
                    }
                    this.nextToken((short)75);
                    var16_11 = type;
                    return var16_11;
                }
                case 'T': {
                    this.errorMessage = "Invalid type variable reference.";
                    nameStart = start + 1;
                    if (this.curToken != 4) {
                        this.error();
                    }
                    nameEnd = this.lexer.getEndOffset();
                    name = this.buffer.getString(nameStart, nameEnd - nameStart);
                    this.skipToken();
                    this.nextToken((short)75);
                    var17_15 = this.getTypeVariable(name);
                    return var17_15;
                }
                case '[': {
                    type = this.parseTypeSignature0();
                    var18_17 = this.getArrayType(type);
                    return var18_17;
                }
            }
            this.errorMessage = "Invalid class type signature.";
            if (ch < 'A' || 'Z' < ch) {
                this.error();
            }
            if ((primitive = PrimitiveType.PRIMITIVE_alpha[ch - 65]) == null) {
                this.error();
            }
            var19_19 = this.getPrimitiveType(primitive);
            ** try [egrp 4[TRYBLOCK] [4 : 424->427)] { 
        }
lbl61:
        // 1 sources

        catch (Throwable var20_20) {
            throw var20_20;
        }
        finally {
            this.errorMessage = savedError;
        }
lbl60:
        // 1 sources

        return var19_19;
    }

    protected final void error(String errorMessage) {
        errorMessage = errorMessage + ": " + this.buffer.getString(0, this.buffer.getLength());
        CommonUtilities.panic(errorMessage);
    }

    protected final void error() {
        String errorMessage = this.buffer.getString(0, this.buffer.getLength());
        CommonUtilities.panic(errorMessage);
    }

    private static void panic(String message) {
        CommonUtilities.panic(message);
    }
}

