/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.internal;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import oracle.javatools.parser.java.v2.JavaErrors;
import oracle.javatools.parser.java.v2.JavaTokens;
import oracle.javatools.parser.java.v2.JavadocTokens;
import oracle.javatools.parser.java.v2.common.CommonUtilities;
import oracle.javatools.parser.java.v2.internal.InternalAnnotationComponent;
import oracle.javatools.parser.java.v2.internal.InternalConstants;
import oracle.javatools.parser.java.v2.internal.symbol.ClassSym;
import oracle.javatools.parser.java.v2.internal.symbol.Sym;
import oracle.javatools.parser.java.v2.model.JavaAnnotation;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaField;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.resource.BundleHelper;

public abstract class InternalUtilities
extends CommonUtilities
implements InternalConstants {
    protected static final BundleHelper resources = new BundleHelper("oracle.javatools.parser.resource.ParserBundle");
    protected static final String[] ERROR_loaded = new String[JavaErrors.ERROR_words.length];

    public static boolean isCommentToken(int tk) {
        switch (tk) {
            case 24: 
            case 25: 
            case 26: {
                return true;
            }
        }
        return false;
    }

    public static boolean srcIsStmt(int k) {
        return 28 <= k && k < 46;
    }

    public static boolean srcIsExpr(int k) {
        return 46 <= k && k < 62;
    }

    public static boolean srcIsLexical(int k) {
        return 69 <= k && k < 72;
    }

    public static String op2text(short op) {
        return JavaTokens.OP_words[op - 32];
    }

    public static String kw2text(short kw) {
        return JavaTokens.KW_words[kw - 96];
    }

    public static char ty2access(byte tykind) {
        switch (tykind) {
            case 0: {
                return '\u0000';
            }
            case 1: {
                return '\u0200';
            }
            case 2: {
                return '\u4000';
            }
            case 3: {
                return '\u2200';
            }
        }
        throw new IllegalArgumentException("Unknown tykind: " + tykind);
    }

    public static byte access2ty(char access) {
        if ((access & 0x2000) != 0) {
            return 3;
        }
        if ((access & 0x4000) != 0) {
            return 2;
        }
        if ((access & 0x200) != 0) {
            return 1;
        }
        return 0;
    }

    public static String tag2name(short tag) {
        if (202 <= tag && tag < 222) {
            return JavadocTokens.TAG_words[tag - 202];
        }
        return "@unknown";
    }

    public static int error2severity(int error) {
        if (error == 2) {
            return 4;
        }
        int warningCount = JavaErrors.ERROR_warnings.length;
        int i = 0;
        while (i < warningCount) {
            if (error == JavaErrors.ERROR_warnings[i]) {
                return 2;
            }
            ++i;
        }
        return 3;
    }

    public static int error2category(int error) {
        if (4 <= error && error < 8) {
            return 1;
        }
        if (8 <= error && error < 33) {
            return 2;
        }
        if (33 <= error && error < 78) {
            return 4;
        }
        return 0;
    }

    private static String loadErrorMessage(int index) {
        if (resources != null) {
            String key = JavaErrors.ERROR_keys[index];
            String value = resources.getString(key);
            if (value != null) {
                return value;
            }
            return "Missing resource '" + key + "'";
        }
        return JavaErrors.ERROR_words[index];
    }

    public static String error2message(int error) {
        if (1 <= error && error < 78) {
            String loaded;
            int index = error - 1;
            String alreadyLoaded = ERROR_loaded[index];
            if (alreadyLoaded != null) {
                return alreadyLoaded;
            }
            InternalUtilities.ERROR_loaded[index] = loaded = InternalUtilities.loadErrorMessage(index);
            return loaded;
        }
        return "Error";
    }

    public static JavaType getOuterClassOfNonstaticInner(ClassSym classSym) {
        Sym parentSym = classSym.getParentSym();
        if (parentSym == null) {
            return null;
        }
        switch (parentSym.symKind) {
            case 73: {
                return null;
            }
            case 4: {
                if (classSym.isStatic()) {
                    return null;
                }
                return classSym.getOwningClassSym();
            }
        }
        Sym sym = parentSym;
        while (sym != null) {
            switch (sym.symKind) {
                case 4: {
                    return sym.getOwningClassSym();
                }
            }
            if (sym.isStatic()) {
                return null;
            }
            sym = sym.symParent;
        }
        return null;
    }

    protected static JavaType getOuterClassOfNonstaticInner(JavaType subject) {
        if (subject == null) {
            return null;
        }
        if (subject instanceof ClassSym) {
            return InternalUtilities.getOuterClassOfNonstaticInner((ClassSym)subject);
        }
        if (subject.isExported()) {
            if (subject.isStatic()) {
                return null;
            }
        } else {
            boolean nonstatic;
            JavaField thisDollarZero = subject.getDeclaredField("this$0");
            boolean bl = nonstatic = thisDollarZero != null && thisDollarZero.isSynthetic();
            if (!nonstatic) {
                return null;
            }
        }
        JavaClass owningClass = subject.getOwningClass();
        return owningClass;
    }

    public static Map getAnnotationArguments(JavaAnnotation javaAnnotation) {
        Map componentMap = javaAnnotation.getComponents();
        if (componentMap == null) {
            return Collections.emptyMap();
        }
        HashMap<Object, Object> argumentMap = new HashMap<Object, Object>(componentMap.size());
        Set entrySet = componentMap.entrySet();
        for (InternalAnnotationComponent internalAnnotationComponent : entrySet) {
            if (!internalAnnotationComponent.isAnnotationArgument()) continue;
            argumentMap.put(internalAnnotationComponent.getKey(), internalAnnotationComponent.getValue());
        }
        return argumentMap;
    }
}

