/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.internal.compiler;

import oracle.javatools.parser.java.v2.common.PrimitiveType;
import oracle.javatools.parser.java.v2.internal.compiler.CompilerDriver;
import oracle.javatools.parser.java.v2.internal.compiler.CompilerLayer3b;
import oracle.javatools.parser.java.v2.internal.symbol.AnnotateSym;
import oracle.javatools.parser.java.v2.internal.symbol.ClassSym;
import oracle.javatools.parser.java.v2.internal.symbol.TypeSym;
import oracle.javatools.parser.java.v2.internal.symbol.expr.AnnotateExpr;
import oracle.javatools.parser.java.v2.internal.symbol.expr.ArrayAccessExpr;
import oracle.javatools.parser.java.v2.internal.symbol.expr.ArrayCreatorExpr;
import oracle.javatools.parser.java.v2.internal.symbol.expr.AssignExpr;
import oracle.javatools.parser.java.v2.internal.symbol.expr.Expr;
import oracle.javatools.parser.java.v2.internal.symbol.expr.InfixExpr;
import oracle.javatools.parser.java.v2.internal.symbol.expr.ListExpr;
import oracle.javatools.parser.java.v2.internal.symbol.expr.LiteralExpr;
import oracle.javatools.parser.java.v2.internal.symbol.expr.QuestionExpr;
import oracle.javatools.parser.java.v2.internal.symbol.expr.TypeExpr;
import oracle.javatools.parser.java.v2.internal.symbol.expr.TypecastExpr;
import oracle.javatools.parser.java.v2.internal.symbol.expr.UnaryExpr;
import oracle.javatools.parser.java.v2.internal.symbol.expr.WrapperExpr;
import oracle.javatools.parser.java.v2.model.JavaAnnotation;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaHasType;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.expression.CompiledTmpVariable;
import oracle.javatools.parser.java.v2.scanner.LexerLiteral;

abstract class CompilerLayer3c
extends CompilerLayer3b {
    private static final byte PRIMOP_ADD = 0;
    private static final byte PRIMOP_ARITHMETIC = 1;
    private static final byte PRIMOP_BITWISE = 2;
    private static final byte PRIMOP_LOGICAL = 3;
    private static final byte BINOP_ASSIGNMENT = 0;
    private static final byte BINOP_COMPARISON = 1;
    private static final byte BINOP_EQUALITY = 2;
    private static final byte BINOP_SHIFT = 3;

    public final JavaHasType resolve(LiteralExpr e) {
        JavaClass type;
        LexerLiteral literal = e.literal;
        if (literal == null) {
            return null;
        }
        switch (literal.literalToken) {
            case 8: {
                type = PrimitiveType.PRIMITIVE_objects[4];
                break;
            }
            case 9: {
                type = PrimitiveType.PRIMITIVE_objects[5];
                break;
            }
            case 10: {
                type = PrimitiveType.PRIMITIVE_objects[6];
                break;
            }
            case 11: {
                type = PrimitiveType.PRIMITIVE_objects[7];
                break;
            }
            case 12: {
                type = PrimitiveType.PRIMITIVE_objects[0];
                break;
            }
            case 13: {
                type = PrimitiveType.PRIMITIVE_objects[2];
                break;
            }
            case 15: {
                type = PrimitiveType.PRIMITIVE_objects[8];
                break;
            }
            case 14: {
                type = this.getPreloadedClass((byte)6);
                break;
            }
            default: {
                CompilerLayer3c.panic(e);
                return null;
            }
        }
        if (type != null) {
            return type.getThisValue();
        }
        return null;
    }

    public final JavaHasType resolve(AnnotateExpr e) {
        AnnotateSym annotateSym = e.getAnnotateSym();
        if (annotateSym == null) {
            return null;
        }
        return (JavaAnnotation)annotateSym.resolve((CompilerDriver)this);
    }

    public final JavaHasType resolve(TypeExpr e) {
        TypeSym typeSym = e.getTypeSym();
        if (typeSym == null) {
            return null;
        }
        return (JavaType)typeSym.resolve((CompilerDriver)this);
    }

    public final JavaHasType resolve(WrapperExpr e) {
        return this.processNthOperand(e, 0);
    }

    public final JavaHasType resolve(ListExpr e) {
        if (e.exprOptcode != 5) {
            return null;
        }
        PrimitiveType nullType = PrimitiveType.PRIMITIVE_objects[8];
        return this.provider.getArrayType(nullType, 1).getThisValue();
    }

    public final JavaHasType resolve(QuestionExpr e) {
        return this.handleQuestion(e);
    }

    public final JavaHasType resolve(TypecastExpr e) {
        return this.handleTypecast(e);
    }

    public final JavaHasType resolve(ArrayAccessExpr e) {
        return this.handleArrayDereference(e);
    }

    public final JavaHasType resolve(ArrayCreatorExpr e) {
        int operandCount;
        TypeSym typeSym = e.getTypeSym();
        JavaType type = typeSym.getResolvedType();
        if (type == null) {
            return null;
        }
        Expr list = e.getNthOperandSym(0);
        if (list.getExpressionCode() == 26 && (operandCount = list.getOperandCount()) > 0) {
            type = CompilerLayer3c.createArrayType(this.provider, type, list.getOperandCount());
        }
        return type.getThisValue();
    }

    public final JavaHasType resolve(AssignExpr e) {
        return this.processInfix(e);
    }

    public final JavaHasType resolve(InfixExpr e) {
        return this.processInfix(e);
    }

    public final JavaHasType resolve(UnaryExpr e) {
        JavaType type;
        int op = e.getOperatorCode();
        switch (op) {
            case 37: 
            case 44: {
                type = this.handlePrimitiveOperator(e, (byte)1);
                break;
            }
            case 41: {
                type = this.handlePrimitiveOperator(e, (byte)3);
                break;
            }
            case 45: 
            case 46: {
                return this.processNthOperand(e, 0);
            }
            case 47: 
            case 48: {
                type = this.handlePreincPredec(e);
                break;
            }
            case 9: {
                type = this.handlePrimitiveOperator(e, (byte)2);
                break;
            }
            case 50: {
                return this.handleQualifiedThis(e);
            }
            case 49: {
                return this.handleQualifiedSuper(e);
            }
            case 14: {
                type = this.handleClassLiteral(e);
                break;
            }
            default: {
                CompilerLayer3c.panic(e);
                return null;
            }
        }
        if (type != null) {
            return type.getThisValue();
        }
        return null;
    }

    private JavaHasType processNthOperand(Expr e, int n) {
        Expr opnp = (Expr)e.getNthChild((byte)83, n);
        if (opnp == null) {
            return null;
        }
        if (e.flag_lvalue()) {
            // empty if block
        }
        return this.processExpression(opnp);
    }

    private JavaType processNthOperandType(Expr e, int n) {
        JavaHasType result = this.processNthOperand(e, n);
        return this.processHasType(result);
    }

    private JavaType processHasType(JavaHasType hasType) {
        if (hasType != null) {
            return hasType.getResolvedType();
        }
        return null;
    }

    public final JavaHasType processInfix(Expr e) {
        JavaType type;
        int op = e.getOperatorCode();
        switch (op) {
            case 6: {
                type = this.handleBinaryOperator(e, (byte)0);
                break;
            }
            case 1: 
            case 2: {
                type = this.handlePrimitiveOperator(e, (byte)0);
                break;
            }
            case 17: 
            case 18: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                type = this.handlePrimitiveOperator(e, (byte)1);
                break;
            }
            case 3: 
            case 43: {
                type = this.handlePrimitiveOperator(e, (byte)3);
                break;
            }
            case 20: 
            case 42: {
                type = this.handleBinaryOperator(e, (byte)2);
                break;
            }
            case 21: 
            case 22: 
            case 25: 
            case 30: {
                type = this.handleBinaryOperator(e, (byte)1);
                break;
            }
            case 23: {
                return this.handleInstanceof(e);
            }
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                type = this.handlePrimitiveOperator(e, (byte)2);
                break;
            }
            case 28: 
            case 29: 
            case 51: 
            case 52: 
            case 56: 
            case 57: {
                type = this.handleBinaryOperator(e, (byte)3);
                break;
            }
            default: {
                CompilerLayer3c.panic(e);
                return null;
            }
        }
        switch (op) {
            case 2: 
            case 8: 
            case 11: 
            case 13: 
            case 18: 
            case 29: 
            case 32: 
            case 34: 
            case 36: 
            case 52: 
            case 57: {
                JavaType assignedToType = this.processNthOperandType(e, 0);
                if (assignedToType == null) break;
                type = assignedToType;
                break;
            }
        }
        if (type != null) {
            return type.getThisValue();
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    private JavaType handlePrimitiveOperator(Expr e, byte primop) {
        switch (primop) {
            case 3: {
                defaultReturn = PrimitiveType.PRIMITIVE_objects[0];
                if (!this.flag_forgiving) break;
                return defaultReturn;
            }
            default: {
                defaultReturn = PrimitiveType.PRIMITIVE_objects[4];
                break;
            }
        }
        if ((opnCount = e.getOperandCount()) == 0) {
            return defaultReturn;
        }
        attempt = this.processNthOperandType(e, 0);
        isString = false;
        lhsType = null;
        if (attempt != null && !CompilerLayer3c.isVoidType(attempt)) {
            switch (primop) {
                case 0: {
                    lhsType = attempt;
                    isString = "java.lang.String".equals(lhsType.getQualifiedName());
                    break;
                }
                case 1: {
                    if (!CompilerLayer3c.isNumericType(attempt)) break;
                    lhsType = attempt;
                    break;
                }
                case 2: {
                    if (!CompilerLayer3c.isIntegralOrBooleanType(attempt)) break;
                    lhsType = attempt;
                    break;
                }
                case 3: {
                    if (!CompilerLayer3c.isBooleanType(attempt)) break;
                    lhsType = attempt;
                    break;
                }
            }
            if (lhsType == null) {
                this.error(e.getNthOperandSym(0), (short)51, attempt);
            }
        }
        if (lhsType == null) {
            lhsType = defaultReturn;
        }
        if (opnCount == 1) {
            unary = CompilerLayer3c.applyUnaryPromotion(lhsType);
            if (unary != null) {
                return unary;
            }
            this.error(e.getNthOperandSym(0), (short)51, lhsType);
            return null;
        }
        opn = 1;
        while (opn < opnCount) {
            rhsType = this.processNthOperandType(e, opn);
            if (rhsType == null) {
                rhsType = defaultReturn;
            } else if (CompilerLayer3c.isVoidType(rhsType)) {
                this.error(e.getNthOperandSym(opn), (short)51, rhsType);
                rhsType = defaultReturn;
            }
            switch (primop) {
                case 0: {
                    if (isString) break;
                    if (rhsType != null && "java.lang.String".equals(rhsType.getQualifiedName())) {
                        isString = true;
                        lhsType = rhsType;
                        break;
                    }
                    if (opn == 1) {
                        attempt0 = lhsType;
                        lhsType = null;
                        if (CompilerLayer3c.isNumericType(attempt0)) {
                            lhsType = attempt0;
                        }
                        if (lhsType == null) {
                            this.error(e.getNthOperandSym(0), (short)51, attempt0);
                            lhsType = defaultReturn;
                        }
                    }
                }
                case 1: {
                    newType = CompilerLayer3c.applyBinaryPromotion(lhsType, rhsType);
                    if (newType != null) {
                        lhsType = newType;
                        break;
                    }
                    ** GOTO lbl82
                }
                case 2: {
                    if (CompilerLayer3c.isIntegralOrBooleanType(attempt) && (lhsType = CompilerLayer3c.applyBinaryPromotion(lhsType, rhsType)) != null) break;
                    lhsType = CompilerLayer3c.applyBinaryPromotion(lhsType, lhsType);
                    ** GOTO lbl82
                }
                case 3: {
                    if (CompilerLayer3c.isBooleanType(rhsType)) break;
                }
lbl82:
                // 4 sources

                default: {
                    this.error(e.getNthOperandSym(opn), (short)51, rhsType);
                }
            }
            ++opn;
        }
        return lhsType;
    }

    private JavaType handleBinaryOperator(Expr e, byte binop) {
        PrimitiveType defaultReturn;
        switch (binop) {
            case 0: {
                defaultReturn = null;
                break;
            }
            case 1: 
            case 2: {
                defaultReturn = PrimitiveType.PRIMITIVE_objects[0];
                if (!this.flag_forgiving) break;
                return defaultReturn;
            }
            default: {
                defaultReturn = PrimitiveType.PRIMITIVE_objects[4];
                break;
            }
        }
        int opnCount = e.getOperandCount();
        if (opnCount == 0) {
            return defaultReturn;
        }
        JavaType lhsType = this.processNthOperandType(e, 0);
        if (opnCount == 1) {
            switch (binop) {
                case 0: {
                    return lhsType;
                }
                case 3: {
                    if (lhsType != null) {
                        lhsType = CompilerLayer3c.applyUnaryPromotion(lhsType);
                        break;
                    }
                    lhsType = defaultReturn;
                    break;
                }
                default: {
                    return defaultReturn;
                }
            }
        }
        if (opnCount > 2) {
            // empty if block
        }
        JavaType rhsType = this.processNthOperandType(e, 1);
        switch (binop) {
            case 0: {
                JavaType targetType;
                JavaHasType rhsHasType;
                if (this.flag_forgiving) {
                    return lhsType;
                }
                JavaHasType lhsHasType = this.processNthOperand(e, 0);
                if (lhsHasType != null && lhsHasType instanceof JavaType) {
                    this.error(e.getNthOperandSym(0), (short)59, lhsHasType);
                }
                if ((rhsHasType = this.processNthOperand(e, 1)) != null && rhsHasType instanceof JavaType) {
                    this.error(e.getNthOperandSym(1), (short)68, rhsHasType);
                }
                if (CompilerLayer3c.applyAssignmentConversion(rhsType, lhsType, false, this.provider)) break;
                boolean constant = true;
                if (CompilerLayer3c.applyAssignmentConversion(rhsType, lhsType, true, this.provider) || lhsType.isArray() && CompilerLayer3c.isComponentAssignment(e) && CompilerLayer3c.applyAssignmentConversion(rhsType, targetType = lhsType.getComponentType(), true, this.provider)) break;
                this.error(e.getNthOperandSym(1), (short)37, rhsType, lhsType);
                break;
            }
            case 1: {
                PrimitiveType rhs;
                if (rhsType == null) {
                    return defaultReturn;
                }
                PrimitiveType lhs = CompilerLayer3c.applyUnboxingConversion(lhsType);
                if (lhs == null || !lhs.isNumeric()) {
                    this.error(e.getNthOperandSym(0), (short)51, lhsType);
                }
                if ((rhs = CompilerLayer3c.applyUnboxingConversion(rhsType)) == null || !rhs.isNumeric()) {
                    this.error(e.getNthOperandSym(0), (short)51, rhsType);
                }
                JavaType result = CompilerLayer3c.applyBinaryPromotion(lhs, rhs);
                return defaultReturn;
            }
            case 2: {
                return defaultReturn;
            }
            case 3: {
                JavaType promotedRhs;
                JavaType promotedLhs = CompilerLayer3c.applyUnaryPromotion(lhsType);
                if (!CompilerLayer3c.isNumericType(promotedLhs)) {
                    this.error(e.getNthOperandSym(0), (short)51, lhsType);
                }
                if (CompilerLayer3c.isNumericType(promotedRhs = CompilerLayer3c.applyUnaryPromotion(rhsType))) break;
                this.error(e.getNthOperandSym(0), (short)51, rhsType);
                break;
            }
            default: {
                CompilerLayer3c.panic(e);
                return null;
            }
        }
        return lhsType;
    }

    private JavaHasType handleArrayDereference(Expr e) {
        JavaType lhsType = this.processNthOperandType(e, 0);
        JavaType componentType = null;
        Expr list = e.getNthOperandSym(1);
        int count = list.getOperandCount();
        int i = 0;
        while (i < count) {
            if (lhsType == null) {
                return null;
            }
            componentType = lhsType.getComponentType();
            if (componentType == null) {
                return (JavaHasType)this.error(e.getNthOperandSym(0), (short)63, lhsType);
            }
            JavaType rhsType = this.processNthOperandType(list, i);
            if (rhsType == null || this.flag_forgiving) {
                return componentType.getThisValue();
            }
            if ((rhsType = CompilerLayer3c.applyUnaryPromotion(rhsType)) != null && !CompilerLayer3c.isIntegralType(rhsType)) {
                this.error(e.getNthOperandSym(1), (short)51, rhsType);
            }
            lhsType = componentType;
            ++i;
        }
        if (componentType == null) {
            return null;
        }
        return componentType.getThisValue();
    }

    private JavaType handleClassLiteral(UnaryExpr e) {
        JavaClass javaLangClass = this.getPreloadedClass((byte)0);
        if (javaLangClass == null) {
            return null;
        }
        if (!javaLangClass.hasTypeParameters()) {
            return javaLangClass;
        }
        JavaType lhsType = this.processNthOperandType(e, 0);
        if (lhsType != null) {
            try {
                JavaType[] arguments = new JavaType[]{lhsType};
                JavaType javaType = CompilerLayer3c.createParameterizedType(this.provider, javaLangClass, arguments);
                return javaType;
            }
            catch (IllegalArgumentException ex) {
                // empty catch block
            }
        }
        return javaLangClass;
    }

    private JavaHasType handleInstanceof(Expr e) {
        PrimitiveType booleanType = PrimitiveType.PRIMITIVE_objects[0];
        CompiledTmpVariable booleanVar = booleanType.getThisValue();
        if (this.flag_forgiving) {
            return booleanVar;
        }
        JavaType rhsType = this.processNthOperandType(e, 1);
        if (rhsType == null) {
            return booleanVar;
        }
        JavaType lhsType = this.processNthOperandType(e, 0);
        if (lhsType == null) {
            return booleanVar;
        }
        if (lhsType.isPrimitive()) {
            return booleanVar;
        }
        return booleanVar;
    }

    private JavaType handlePreincPredec(Expr e) {
        PrimitiveType integerType = PrimitiveType.PRIMITIVE_objects[4];
        int opnCount = e.getOperandCount();
        if (opnCount == 0) {
            return integerType;
        }
        JavaType lhsType = this.processNthOperandType(e, 0);
        if (lhsType == null) {
            return integerType;
        }
        if (this.flag_forgiving) {
            return lhsType;
        }
        JavaType result = CompilerLayer3c.applyBinaryPromotion(lhsType, integerType);
        if (result == null) {
            this.error(e.getNthOperandSym(0), (short)51, lhsType);
        }
        return lhsType;
    }

    private JavaHasType handleQualifiedThis(Expr e) {
        JavaType lhsType = this.processNthOperandType(e, 0);
        if (lhsType == null) {
            return null;
        }
        if (this.flag_forgiving) {
            return lhsType.getThisValue();
        }
        ClassSym found = this.resolveEnclosingScope(e, lhsType);
        if (found != null) {
            return found.getThisVariable();
        }
        return null;
    }

    private JavaHasType handleQualifiedSuper(Expr e) {
        JavaHasType qualifiedThis = this.handleQualifiedThis(e);
        JavaType thisType = this.processHasType(qualifiedThis);
        if (thisType == null) {
            return null;
        }
        JavaType superType = thisType.getSuperclass();
        if (superType != null) {
            return superType.getThisValue();
        }
        return null;
    }

    private JavaHasType handleQuestion(Expr e) {
        JavaType firstType = this.processNthOperandType(e, 0);
        if (firstType != null && !CompilerLayer3c.isBooleanType(firstType)) {
            this.error(e.getNthOperandSym(0), (short)51, firstType);
        }
        JavaHasType lhs = this.processNthOperand(e, 1);
        JavaHasType rhs = this.processNthOperand(e, 2);
        if (lhs == null) {
            return rhs;
        }
        if (rhs == null) {
            return lhs;
        }
        JavaType lhsType = lhs.getResolvedType();
        if (lhsType == null) {
            return rhs;
        }
        JavaType rhsType = rhs.getResolvedType();
        if (rhsType == null) {
            return lhs;
        }
        JavaType resultType = this.handleQuestion(lhsType, rhsType);
        if (resultType == lhsType) {
            return lhs;
        }
        if (resultType == rhsType) {
            return rhs;
        }
        if (resultType == null) {
            this.error(e.getNthOperandSym(2), (short)37, rhsType, lhsType);
            return lhs;
        }
        return resultType.getThisValue();
    }

    private JavaHasType handleTypecast(Expr e) {
        JavaType lhsType = this.processNthOperandType(e, 0);
        if (lhsType == null) {
            JavaClass object = this.getPreloadedClass((byte)4);
            if (object != null) {
                return object.getThisValue();
            }
            return null;
        }
        if (this.flag_forgiving) {
            return lhsType.getThisValue();
        }
        JavaType rhsType = this.processNthOperandType(e, 1);
        if (rhsType != null && !CompilerLayer3c.applyCastingConversion(rhsType, lhsType, this.provider)) {
            this.error(e, (short)42, rhsType, lhsType);
        }
        return lhsType.getThisValue();
    }

    private JavaType handleQuestion(JavaType one, JavaType two) {
        if (one.equals(two)) {
            return one;
        }
        boolean oneIsPrimitive = one.isPrimitive();
        boolean twoIsPrimitive = two.isPrimitive();
        if (!oneIsPrimitive && !twoIsPrimitive) {
            return this.handleQuestionImpl(one, two);
        }
        if (oneIsPrimitive && twoIsPrimitive) {
            return this.handleQuestionImpl((PrimitiveType)one, (PrimitiveType)two);
        }
        if (oneIsPrimitive) {
            return this.handleQuestionImpl((PrimitiveType)one, two);
        }
        return this.handleQuestionImpl((PrimitiveType)two, one);
    }

    private JavaType handleQuestionImpl(JavaType one, JavaType two) {
        if (one.isSubtypeOf(two)) {
            return two;
        }
        if (two.isSubtypeOf(one)) {
            return one;
        }
        return this.j2se < 3 ? null : CompilerLayer3c.leastUpperBound(one, two);
    }

    private JavaType handleQuestionImpl(PrimitiveType one, JavaType two) {
        if ("null".equals(one.getName())) {
            return two;
        }
        PrimitiveType twoUnboxed = CompilerLayer3c.applyUnboxingConversion(two);
        if (twoUnboxed != null) {
            return this.handleQuestionImpl(one, twoUnboxed);
        }
        return null;
    }

    private JavaType handleQuestionImpl(PrimitiveType one, PrimitiveType two) {
        if (one.isSubtypeOf(two)) {
            return two;
        }
        if (two.isSubtypeOf(one)) {
            return one;
        }
        JavaType promoted = CompilerLayer3c.applyBinaryPromotion(one, two);
        if (promoted != null) {
            return promoted;
        }
        if ("null".equals(one.getName())) {
            return CompilerLayer3c.applyBoxingConversion(two, this.provider);
        }
        if ("null".equals(two.getName())) {
            return CompilerLayer3c.applyBoxingConversion(one, this.provider);
        }
        return null;
    }

    CompilerLayer3c() {
    }
}

