/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.internal.compiler;

import java.util.Collection;
import java.util.HashMap;
import oracle.javatools.parser.java.v2.common.AnnotationComponents;
import oracle.javatools.parser.java.v2.common.PrimitiveType;
import oracle.javatools.parser.java.v2.common.QuickComponent;
import oracle.javatools.parser.java.v2.internal.compiler.AnnotateObj;
import oracle.javatools.parser.java.v2.internal.compiler.CompilerContext;
import oracle.javatools.parser.java.v2.internal.compiler.CompilerLayer3;
import oracle.javatools.parser.java.v2.internal.symbol.AnnotateSym;
import oracle.javatools.parser.java.v2.internal.symbol.BlockSym;
import oracle.javatools.parser.java.v2.internal.symbol.MemberSym;
import oracle.javatools.parser.java.v2.internal.symbol.MethodSym;
import oracle.javatools.parser.java.v2.internal.symbol.NameSym;
import oracle.javatools.parser.java.v2.internal.symbol.Sym;
import oracle.javatools.parser.java.v2.internal.symbol.VariableSym;
import oracle.javatools.parser.java.v2.internal.symbol.expr.Expr;
import oracle.javatools.parser.java.v2.internal.symbol.expr.ListExpr;
import oracle.javatools.parser.java.v2.internal.symbol.stmt.ExpressionStmt;
import oracle.javatools.parser.java.v2.internal.symbol.stmt.ForStmt;
import oracle.javatools.parser.java.v2.internal.symbol.stmt.ReturnStmt;
import oracle.javatools.parser.java.v2.internal.symbol.stmt.SynchStmt;
import oracle.javatools.parser.java.v2.internal.symbol.stmt.ThrowStmt;
import oracle.javatools.parser.java.v2.model.JavaAnnotation;
import oracle.javatools.parser.java.v2.model.JavaElement;
import oracle.javatools.parser.java.v2.model.JavaHasType;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.JavaVariable;

abstract class CompilerLayer4
extends CompilerLayer3 {
    public final JavaAnnotation resolve(AnnotateSym sym) {
        JavaType result;
        AnnotateObj obj = sym.getObj();
        if (obj.flag_resolved) {
            return obj;
        }
        String name = sym.getName();
        if (name.length() == 0) {
            return (JavaAnnotation)this.error(sym, (short)50);
        }
        Sym cookie = sym;
        NameSym nameSym = sym.getNameSym();
        if (nameSym != null) {
            cookie = nameSym;
        }
        if ((result = this.resolveType(cookie, name)) == null) {
            return (JavaAnnotation)this.error(cookie, (short)69, name);
        }
        if (!result.isAnnotation()) {
            return (JavaAnnotation)this.error(cookie, (short)58, result);
        }
        this.recordUsage(sym, result);
        obj.annotateType = result;
        obj.flag_resolved = true;
        obj.annotateComponents = AnnotationComponents.createInstance(result);
        if (obj.annotateComponents == null) {
            CompilerLayer4.panic("Creating the component map failed!");
        }
        return obj;
    }

    public final JavaAnnotation compile(AnnotateSym sym) {
        this.resolve(sym);
        AnnotateObj obj = sym.getObj();
        if (obj.flag_compiled) {
            return obj;
        }
        if (obj.annotateType == null) {
            return obj;
        }
        ListExpr args = sym.getArgumentListSym();
        CompilerContext savedContext = this.context;
        try {
            this.context = this.newContext(sym);
            this.processComponents(obj, args);
        }
        finally {
            this.context = savedContext;
        }
        obj.flag_compiled = true;
        return obj;
    }

    public final JavaElement resolve(BlockSym sym) {
        if (sym.getChild((byte)18) != null) {
            this.processDuplicates(sym.getLocalVariables());
        }
        return null;
    }

    public final JavaVariable resolve(VariableSym sym) {
        String name = sym.getName();
        if (name != null && name.length() > 0) {
            this.recordDefine(sym);
            CompilerContext savedContext = this.context;
            try {
                this.context = this.newContext(sym);
                JavaVariable found = this.lookupExclusiveLocal(sym, name);
                if (found != null) {
                    this.error(sym, (short)46, name, found);
                }
            }
            finally {
                this.context = savedContext;
            }
        }
        return this.process(sym);
    }

    public final JavaElement resolve(ExpressionStmt sym) {
        this.processExpressionStatement(sym.getExpressionSym());
        return null;
    }

    public final JavaElement resolve(ForStmt sym) {
        this.processExpressionStatements(sym.getInitializationsSym());
        this.processExpressionStatements(sym.getUpdatesSym());
        return null;
    }

    public final JavaElement resolve(ReturnStmt sym) {
        JavaType returnType = null;
        MemberSym owningMember = sym.getOwningMemberSym();
        if (owningMember != null && owningMember.symKind == 19) {
            MethodSym methodSym = (MethodSym)owningMember;
            returnType = methodSym.getReturnType();
        }
        Expr e = sym.getExpressionSym();
        if (CompilerLayer4.isVoidType(returnType)) {
            if (e != null) {
                this.error(e, (short)70);
            }
        } else if (returnType != null) {
            if (e != null) {
                JavaType type;
                JavaHasType hasType = e.getResolvedObject();
                if (hasType != null && hasType instanceof JavaType) {
                    this.error(e, (short)68, hasType);
                }
                if ((type = e.getResolvedType()) != null) {
                    this.processAssignment(returnType, e);
                }
            } else {
                PrimitiveType voidType = PrimitiveType.PRIMITIVE_objects[9];
                this.error(sym, (short)37, voidType, returnType);
            }
        }
        return null;
    }

    public final JavaElement resolve(SynchStmt sym) {
        Expr e = sym.getExpressionSym();
        if (e == null) {
            return null;
        }
        JavaHasType lhs = this.processExpression(e);
        if (lhs == null) {
            return null;
        }
        if (lhs instanceof JavaType) {
            this.error(e, (short)65, lhs);
        }
        return null;
    }

    public final JavaElement resolve(ThrowStmt sym) {
        Expr e = sym.getExpressionSym();
        if (e == null) {
            return null;
        }
        JavaType type = e.getResolvedType();
        if (type == null) {
            return null;
        }
        this.checkException(sym, type);
        return null;
    }

    private void processComponents(AnnotateObj obj, ListExpr args) {
        Expr e;
        if (args == null) {
            return;
        }
        int count = args.getOperandCount();
        if (count == 0) {
            return;
        }
        if (count == 1 && (e = args.getNthOperandSym(0)) != null && e.exprOptcode != 6) {
            this.processSingleComponent(obj, e);
            return;
        }
        int i = 0;
        while (i < count) {
            Expr arg = args.getNthOperandSym(i);
            this.processNormalComponent(obj, arg);
            ++i;
        }
    }

    private void processSingleComponent(AnnotateObj obj, Expr arg) {
        JavaType type = obj.annotateType;
        JavaMethod valueM = type.getDeclaredMethod("value", JavaType.EMPTY_ARRAY);
        if (valueM == null) {
            this.error(arg, (short)53, "value", type);
            return;
        }
        Collection methods = type.getDeclaredMethods();
        for (JavaMethod thing : methods) {
            String name = thing.getName();
            if ("value".equals(name) || thing.getDefaultValue() != null) continue;
            this.error(arg, (short)55);
            return;
        }
        this.recordUsage(this.context.symCookie, valueM);
        JavaType expected = valueM.getResolvedType();
        Object value = this.processComponentValue(expected, arg);
        if (value != null) {
            obj.annotateComponents.assignValue("value", value);
        }
    }

    private void processNormalComponent(AnnotateObj obj, Expr arg) {
        JavaType expected;
        Object value;
        if (arg.exprOptcode != 6) {
            return;
        }
        Expr lhs = arg.getNthOperandSym(0);
        JavaHasType result = lhs.getResolvedObject();
        if (result == null) {
            return;
        }
        if (result.getElementKind() != 4) {
            return;
        }
        Expr rhs = arg.getNthOperandSym(1);
        QuickComponent qc = (QuickComponent)result;
        JavaMethod method = qc.getMethod();
        if (method != null) {
            this.recordUsage(this.context.symCookie, method);
        }
        if ((value = this.processComponentValue(expected = qc.getResolvedType(), rhs)) != null) {
            obj.annotateComponents.assignValue(qc.getName(), value);
        }
    }

    private Object processComponentValue(JavaType expected, Expr arg) {
        JavaType baseExpected;
        Object value = arg.getConstantValue();
        if (value == null) {
            return null;
        }
        JavaType argType = arg.getResolvedType();
        if (argType == null) {
            return null;
        }
        if (expected == null || expected.isAssignableFrom(argType)) {
            return value;
        }
        if (expected.isArray() && ((baseExpected = expected.getComponentType()) == null || baseExpected.isAssignableFrom(argType))) {
            return new Object[]{value};
        }
        return null;
    }

    public final JavaVariable process(VariableSym sym) {
        Expr e = sym.getExpressionSym();
        if (e != null) {
            JavaType lhsType = sym.getResolvedType();
            this.processAssignment(lhsType, e);
        }
        return sym;
    }

    /*
     * Unable to fully structure code
     */
    private JavaVariable lookupExclusiveLocal(VariableSym cookie, String name) {
        scope = this.context.cleanScope();
        if (scope != null) ** GOTO lbl8
        return null;
        while (scope.symKind != 3) {
            if (scope.symKind != 18 && (foundVariable = this.context.findVariable(scope, name, true)) != null && foundVariable != cookie) {
                return foundVariable;
            }
            scope = this.context.nextScope();
lbl8:
            // 2 sources

            if (scope != null) continue;
        }
        return null;
    }

    protected final void processDuplicates(Collection variables) {
        HashMap<String, VariableSym> locals = null;
        for (VariableSym thing : variables) {
            VariableSym found;
            String name = thing.getName();
            if (locals == null) {
                locals = new HashMap<String, VariableSym>();
            }
            if ((found = (VariableSym)locals.get(name)) != null) {
                Sym cookie = thing;
                NameSym nameSym = thing.getNameSym();
                if (nameSym != null) {
                    cookie = nameSym;
                }
                this.error(cookie, (short)46, name, found);
            }
            locals.put(name, thing);
        }
    }

    private void processAssignment(JavaType lhsType, Expr e) {
        if (e == null || lhsType == null) {
            return;
        }
        JavaType rhsType = e.getResolvedType();
        if (rhsType == null) {
            return;
        }
        JavaHasType hasType = e.getResolvedObject();
        if (hasType != null && hasType instanceof JavaType) {
            this.error(e, (short)68, hasType);
        }
        if (CompilerLayer4.applyAssignmentConversion(rhsType, lhsType, false, this.provider)) {
            return;
        }
        boolean constant = true;
        if (CompilerLayer4.applyAssignmentConversion(rhsType, lhsType, true, this.provider)) {
            return;
        }
        this.error(e, (short)37, rhsType, lhsType);
    }

    public final void processExpressionStatements(ListExpr list) {
        if (list == null) {
            return;
        }
        for (Expr e : list.getOperands()) {
            this.processExpressionStatement(e);
        }
    }

    public final void processExpressionStatement(Expr e) {
        if (e == null) {
            return;
        }
        switch (e.symKind) {
            case 48: 
            case 53: 
            case 55: {
                return;
            }
            case 60: {
                boolean okay = false;
                switch (e.exprOptcode) {
                    case 45: 
                    case 46: 
                    case 47: 
                    case 48: {
                        return;
                    }
                }
            }
        }
        this.error(e, (short)49);
    }

    CompilerLayer4() {
    }
}

