/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.internal.compiler;

import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import oracle.javatools.parser.java.v2.JavaConstants;
import oracle.javatools.parser.java.v2.common.PrimitiveType;
import oracle.javatools.parser.java.v2.internal.InternalUtilities;
import oracle.javatools.parser.java.v2.internal.compiler.CallerContextImpl;
import oracle.javatools.parser.java.v2.internal.compiler.FileObj;
import oracle.javatools.parser.java.v2.internal.compiler.ObjConstants;
import oracle.javatools.parser.java.v2.internal.symbol.ErrorSym;
import oracle.javatools.parser.java.v2.internal.symbol.FileSym;
import oracle.javatools.parser.java.v2.internal.symbol.Sym;
import oracle.javatools.parser.java.v2.internal.symbol.SymFactory;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaElement;
import oracle.javatools.parser.java.v2.model.JavaField;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaPackage;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.JavaVariable;
import oracle.javatools.parser.java.v2.model.UnresolvedType;

abstract class CompilerUtilities
extends InternalUtilities
implements ObjConstants {
    protected static final String kJavaLang = "java.lang";
    protected static final String kJavaLangStar = "java.lang.*";
    protected static final String kJavaLangObject = "java.lang.Object";
    protected static final String kJavaLangString = "java.lang.String";
    static final String kThis = "this";
    static final String kSuper = "super";
    static final String kInit = "<init>";

    protected static boolean isComponentAssignment(Sym e) {
        Sym grandpa;
        Sym parent = e.getParentSym();
        return parent != null && parent.symKind == 51 && (grandpa = parent.getParentSym()) != null && grandpa.symKind == 1;
    }

    protected static boolean isMoreSpecific(JavaMethod subject, JavaMethod target) {
        Collection subjectThings = subject.getParameters();
        Collection targetThings = target.getParameters();
        if (subjectThings.size() != targetThings.size()) {
            return false;
        }
        Iterator subjectParams = subjectThings.iterator();
        Iterator targetParams = targetThings.iterator();
        while (subjectParams.hasNext()) {
            JavaVariable subjectVar = (JavaVariable)subjectParams.next();
            JavaVariable targetVar = (JavaVariable)targetParams.next();
            JavaType subjectVarType = subjectVar.getResolvedType();
            JavaType targetVarType = targetVar.getResolvedType();
            if (subjectVarType == null && targetVarType == null) continue;
            if (subjectVarType == null || targetVarType == null) {
                return false;
            }
            if (CompilerUtilities.applyMethodConversion(subjectVarType, targetVarType, false, null)) continue;
            return false;
        }
        return true;
    }

    protected static final boolean isBooleanType(JavaType type) {
        if (type == null) {
            return false;
        }
        if (!type.isPrimitive()) {
            type = CompilerUtilities.applyUnboxingConversion(type);
        }
        if (type == null) {
            return false;
        }
        PrimitiveType primitive = (PrimitiveType)type;
        return primitive.primCode == 0;
    }

    protected static final boolean isVoidType(JavaType type) {
        if (type == null) {
            return false;
        }
        if (!type.isPrimitive()) {
            return false;
        }
        PrimitiveType primitive = (PrimitiveType)type;
        return primitive.primCode == 9;
    }

    protected static final boolean isNumericType(JavaType type) {
        if (type == null) {
            return false;
        }
        if (!type.isPrimitive()) {
            type = CompilerUtilities.applyUnboxingConversion(type);
        }
        if (type == null) {
            return false;
        }
        PrimitiveType primitive = (PrimitiveType)type;
        return primitive.isNumeric();
    }

    protected static final boolean isIntegralType(JavaType type) {
        if (type == null) {
            return false;
        }
        if (!type.isPrimitive()) {
            type = CompilerUtilities.applyUnboxingConversion(type);
        }
        if (type == null) {
            return false;
        }
        PrimitiveType primitive = (PrimitiveType)type;
        return primitive.isIntegral();
    }

    protected static final boolean isIntegralOrBooleanType(JavaType type) {
        if (type == null) {
            return false;
        }
        if (!type.isPrimitive()) {
            type = CompilerUtilities.applyUnboxingConversion(type);
        }
        if (type == null) {
            return false;
        }
        PrimitiveType primitive = (PrimitiveType)type;
        return primitive.isIntegral() || primitive.primCode == 0;
    }

    protected static final JavaType leastUpperBound(JavaType one, JavaType two) {
        Set oneHierarchy = one.getHierarchy();
        Set twoHierarchy = two.getHierarchy();
        Iterator oneIterator = oneHierarchy.iterator();
        Iterator twoIterator = twoHierarchy.iterator();
        JavaType oneAncestor = null;
        while (oneIterator.hasNext()) {
            JavaType ancestor = (JavaType)oneIterator.next();
            if (!ancestor.isAssignableFrom(two)) continue;
            oneAncestor = ancestor;
            break;
        }
        JavaType twoAncestor = null;
        while (twoIterator.hasNext()) {
            JavaType ancestor = (JavaType)twoIterator.next();
            if (!ancestor.isAssignableFrom(one)) continue;
            twoAncestor = ancestor;
            break;
        }
        if (oneAncestor == null) {
            return twoAncestor;
        }
        if (twoAncestor == null) {
            return oneAncestor;
        }
        if (oneAncestor.isAssignableFrom(twoAncestor)) {
            return twoAncestor;
        }
        return oneAncestor;
    }

    public final ErrorSym generateError(FileSym symFile, Sym cookie, short errorCode) {
        return this.generateErrorImpl(symFile, cookie, errorCode, JavaConstants.EMPTY_OBJECT_ARRAY);
    }

    public final ErrorSym generateError(FileSym symFile, Sym cookie, short errorCode, Object data) {
        if (data != null) {
            return this.generateErrorImpl(symFile, cookie, errorCode, new Object[]{data});
        }
        return this.generateError(symFile, cookie, errorCode);
    }

    public final ErrorSym generateError(FileSym symFile, Sym cookie, short errorCode, Object data0, Object data1) {
        if (data1 != null) {
            return this.generateErrorImpl(symFile, cookie, errorCode, new Object[]{data0, data1});
        }
        return this.generateError(symFile, cookie, errorCode, data0);
    }

    public final ErrorSym generateErrorImpl(FileSym symFile, Sym cookie, short errorCode, Object[] data) {
        boolean validRange;
        CallerContextImpl context = cookie.getContextImpl();
        if (context != null) {
            cookie = context.scopeCookie;
        }
        if (cookie == null) {
            return null;
        }
        if (cookie.is((byte)85)) {
            return null;
        }
        boolean bl = validRange = 33 <= errorCode && errorCode < 78;
        if (!validRange) {
            CompilerUtilities.panic(cookie);
        }
        FileObj fileObj = symFile.getFileObj();
        ErrorSym errorSym = (ErrorSym)SymFactory.createNode(symFile, 8);
        errorSym.symFile = symFile;
        if (cookie != null) {
            errorSym.symStart = cookie.symStart;
            errorSym.symEnd = cookie.symEnd;
            errorSym.errorSymbol = cookie;
        } else {
            errorSym.symStart = 0;
            errorSym.symEnd = 0;
        }
        errorSym.errorCode = errorCode;
        errorSym.errorRefData = data;
        String message = CompilerUtilities.error2message(errorCode);
        switch (errorCode) {
            case 46: 
            case 48: 
            case 56: 
            case 62: 
            case 69: 
            case 72: {
                String name = (String)errorSym.getErrorRefData(0);
                message = CompilerUtilities.format(message, name);
                break;
            }
            case 43: 
            case 51: 
            case 52: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 63: 
            case 66: 
            case 67: {
                JavaElement thing = (JavaElement)errorSym.getErrorRefData(0);
                message = CompilerUtilities.format(message, CompilerUtilities.elementToDisplayText(thing));
                break;
            }
            case 53: {
                String name = (String)errorSym.getErrorRefData(0);
                Object owner = errorSym.getErrorRefData(1);
                message = CompilerUtilities.format(message, name, CompilerUtilities.elementToDisplayText(owner));
                break;
            }
            case 37: 
            case 42: {
                JavaType rhsType = (JavaType)errorSym.getErrorRefData(0);
                JavaType lhsType = (JavaType)errorSym.getErrorRefData(1);
                message = CompilerUtilities.format(message, CompilerUtilities.elementToDisplayText(rhsType), CompilerUtilities.elementToDisplayText(lhsType));
                break;
            }
            case 54: {
                String string0;
                String name = (String)errorSym.getErrorRefData(0);
                JavaType[] arguments = (JavaType[])errorSym.getErrorRefData(1);
                if (arguments != null) {
                    StringBuilder buffer = new StringBuilder(name);
                    int count = arguments.length;
                    buffer.append('(');
                    if (count > 0) {
                        boolean needComma = false;
                        int i = 0;
                        while (i < count) {
                            if (needComma) {
                                buffer.append(',');
                            }
                            buffer.append(CompilerUtilities.elementToDisplayText(arguments[i]));
                            needComma = true;
                            ++i;
                        }
                    }
                    buffer.append(')');
                    string0 = buffer.toString();
                } else {
                    string0 = name;
                }
                Object scopeClass = errorSym.getErrorRefData(2);
                String string1 = scopeClass != null ? CompilerUtilities.elementToDisplayText(scopeClass) : "<unknown>";
                message = CompilerUtilities.format(message, string0, string1);
                break;
            }
        }
        errorSym.errorMessage = message;
        errorSym.symParent = symFile.compileErrors;
        errorSym.buildSelf();
        if (fileObj.errorData != null) {
            fileObj.errorData.addKid(errorSym);
        }
        return errorSym;
    }

    protected static String elementToDisplayText(JavaType thing) {
        if (thing != null) {
            return thing.getQualifiedName();
        }
        return "<unknown>";
    }

    protected static String elementToDisplayText(JavaMethod thing) {
        if (thing == null) {
            return "<unknown>";
        }
        String name = thing.isConstructor() ? kInit : thing.getName();
        StringBuilder buffer = new StringBuilder(thing.getName());
        buffer.append('(');
        Collection parameters = thing.getParameters();
        if (!parameters.isEmpty()) {
            Iterator things = parameters.iterator();
            boolean needComma = false;
            while (things.hasNext()) {
                if (needComma) {
                    buffer.append(',');
                }
                JavaVariable v = (JavaVariable)things.next();
                buffer.append(CompilerUtilities.elementToDisplayText(v.getResolvedType()));
                needComma = true;
            }
        }
        buffer.append(')');
        String text = buffer.toString();
        JavaClass owningThing = thing.getOwningClass();
        if (owningThing != null) {
            return owningThing.getQualifiedName() + '.' + text;
        }
        return text;
    }

    protected static String elementToDisplayText(JavaField thing) {
        if (thing == null) {
            return "<unknown>";
        }
        String text = thing.getName();
        JavaClass owningThing = thing.getOwningClass();
        if (owningThing != null) {
            return owningThing.getQualifiedName() + '.' + text;
        }
        return text;
    }

    protected static String elementToDisplayText(JavaPackage thing) {
        if (thing == null) {
            return "<unknown>";
        }
        return thing.getQualifiedName();
    }

    protected static String elementToDisplayText(UnresolvedType thing) {
        if (thing == null) {
            return "<unknown>";
        }
        return thing.getSimplifiedName();
    }

    public static String elementToDisplayText(Object thing) {
        if (thing != null) {
            if (thing instanceof JavaType) {
                return CompilerUtilities.elementToDisplayText((JavaType)thing);
            }
            if (thing instanceof JavaField) {
                return CompilerUtilities.elementToDisplayText((JavaField)thing);
            }
            if (thing instanceof JavaMethod) {
                return CompilerUtilities.elementToDisplayText((JavaMethod)thing);
            }
            if (thing instanceof JavaPackage) {
                return CompilerUtilities.elementToDisplayText((JavaPackage)thing);
            }
            if (thing instanceof UnresolvedType) {
                return CompilerUtilities.elementToDisplayText((UnresolvedType)thing);
            }
        }
        return "<unknown>";
    }

    protected static final void panic(Sym sym) {
        System.out.println(sym.toString());
        CompilerUtilities.panic();
    }

    CompilerUtilities() {
    }
}

