/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.internal.format;

import oracle.javatools.parser.java.v2.JavaOperators;
import oracle.javatools.parser.java.v2.internal.format.FormatLayer2;
import oracle.javatools.parser.java.v2.internal.symbol.ClassSym;
import oracle.javatools.parser.java.v2.internal.symbol.Sym;
import oracle.javatools.parser.java.v2.internal.symbol.TreeSym;
import oracle.javatools.parser.java.v2.internal.symbol.TypeSym;
import oracle.javatools.parser.java.v2.internal.symbol.expr.AnnotateExpr;
import oracle.javatools.parser.java.v2.internal.symbol.expr.ArrayAccessExpr;
import oracle.javatools.parser.java.v2.internal.symbol.expr.ArrayCreatorExpr;
import oracle.javatools.parser.java.v2.internal.symbol.expr.AssignExpr;
import oracle.javatools.parser.java.v2.internal.symbol.expr.ClassCreatorExpr;
import oracle.javatools.parser.java.v2.internal.symbol.expr.DotExpr;
import oracle.javatools.parser.java.v2.internal.symbol.expr.Expr;
import oracle.javatools.parser.java.v2.internal.symbol.expr.InfixExpr;
import oracle.javatools.parser.java.v2.internal.symbol.expr.ListExpr;
import oracle.javatools.parser.java.v2.internal.symbol.expr.LiteralExpr;
import oracle.javatools.parser.java.v2.internal.symbol.expr.MethodCallExpr;
import oracle.javatools.parser.java.v2.internal.symbol.expr.QuestionExpr;
import oracle.javatools.parser.java.v2.internal.symbol.expr.SimpleNameExpr;
import oracle.javatools.parser.java.v2.internal.symbol.expr.TypeExpr;
import oracle.javatools.parser.java.v2.internal.symbol.expr.TypecastExpr;
import oracle.javatools.parser.java.v2.internal.symbol.expr.UnaryExpr;
import oracle.javatools.parser.java.v2.internal.symbol.expr.WrapperExpr;

abstract class FormatLayer3
extends FormatLayer2 {
    public final void print(AnnotateExpr e) {
        this.print((TreeSym)e);
    }

    public final void print(ArrayAccessExpr e) {
        Expr lhs = e.getLhsOperandSym();
        if (lhs != null) {
            this.handle(lhs);
        } else {
            this.print((short)15);
        }
        ListExpr list = (ListExpr)e.getNthOperandSym(1);
        this.handleArrayDereferences(list);
    }

    public final void print(ArrayCreatorExpr e) {
        ListExpr list = (ListExpr)e.getNthOperandSym(0);
        boolean initialized = list.exprOptcode == 5;
        this.print((short)124, ' ');
        TypeSym typeSym = e.getTypeSym();
        if (typeSym != null) {
            if (initialized) {
                this.handle(typeSym);
            } else {
                this.enter(typeSym);
                this.handle(typeSym.getNameSym());
                this.handleTypeArguments(typeSym.getTypeArguments());
                this.leave(typeSym);
            }
        }
        if (initialized) {
            this.handle(list);
        } else {
            this.handleArrayDereferences(list);
            int dimensions = typeSym.getArrayDimension();
            int i = 0;
            while (i < dimensions) {
                this.print((short)50);
                this.print((short)71);
                ++i;
            }
        }
    }

    public final void print(AssignExpr e) {
        this.handle(e.getNthOperandSym(0));
        this.print(FormatLayer3.opt2tk(e.exprOptcode));
        this.indent(1);
        this.markWrapBoundary(58);
        this.handle(e.getNthOperandSym(1));
    }

    public final void print(ClassCreatorExpr e) {
        ClassSym sym;
        Expr lhs = e.getLhsOperandSym();
        if (lhs != null) {
            this.handle(lhs);
            this.print('.');
        }
        this.print((short)124, ' ');
        this.handleTypeArguments(e.getTypeArguments());
        this.handle(e.getTypeSym());
        ListExpr args = e.getArgumentListSym();
        if (args != null) {
            this.handleArguments(args);
        }
        if ((sym = e.getClassSym()) != null) {
            if (this.preferences.getBoolean(21)) {
                this.ensureNewlines(1);
            }
            this.enter(sym);
            this.handle(e.getBodySym());
            this.leave(sym);
        }
    }

    public final void print(DotExpr e) {
        Expr lhs = e.getNthOperandSym(0);
        if (lhs != null) {
            this.handle(lhs);
            boolean markBoundary = true;
            switch (lhs.symKind) {
                case 49: 
                case 57: {
                    markBoundary = false;
                    break;
                }
            }
            if (markBoundary) {
                this.markWrapBoundary(56);
            }
            this.print((short)43);
        }
        this.handle(e.getNameSym());
    }

    public final void print(InfixExpr e) {
        int count = e.getOperandCount();
        short tk = FormatLayer3.opt2tk(e.exprOptcode);
        boolean needOperator = false;
        Expr lastE = null;
        int i = 0;
        while (i < count) {
            if (needOperator) {
                this.handleInfixOperator(tk);
                switch (tk) {
                    case 67: {
                        if (lastE == null || lastE.exprOptcode != 27) break;
                        LiteralExpr le = (LiteralExpr)lastE;
                        String s = le.literalString;
                        if (!s.endsWith("\\n\"")) break;
                        this.println();
                    }
                }
                this.markWrapBoundary(58);
            }
            lastE = e.getNthOperandSym(i);
            this.handle(lastE);
            needOperator = true;
            ++i;
        }
    }

    public final void print(ListExpr e) {
        if (e.exprOptcode == 26) {
            return;
        }
        boolean newlineArrayBraces = this.preferences.getBoolean(24);
        if (newlineArrayBraces) {
            this.ensureNewlines(1);
        }
        this.print((short)49, ' ');
        int id = this.push();
        try {
            this.indent(1);
            this.markWrapAlignment();
            int count = e.getOperandCount();
            boolean needComma = false;
            int i = 0;
            while (i < count) {
                if (needComma) {
                    this.print((short)39);
                    this.markWrapBoundary(60);
                }
                this.handle(e.getNthOperandSym(i));
                needComma = true;
                ++i;
            }
            if (e.flag_extraComma()) {
                this.print((short)39);
            }
            int i2 = count > 0 ? e.getNthOperandSym((int)(count - 1)).symSiblingIndex + 1 : 0;
            while (i2 < e.treeChildren.length) {
                Sym sym = e.treeChildren[i2];
                if (sym.symKind == 69) {
                    this.handle(sym);
                }
                ++i2;
            }
            this.print(' ');
            this.print((short)70);
        }
        finally {
            this.pop(id);
        }
    }

    public final void print(LiteralExpr e) {
        this.print(e.getText());
    }

    public final void print(MethodCallExpr e) {
        Expr lhs = e.getLhsOperandSym();
        if (lhs != null) {
            this.handle(lhs);
            boolean markBoundary = true;
            switch (lhs.symKind) {
                case 49: 
                case 57: {
                    markBoundary = false;
                    break;
                }
            }
            if (markBoundary) {
                this.markWrapBoundary(56);
            }
            this.print((short)43);
        }
        this.handleTypeArguments(e.getTypeArguments());
        this.handle(e.getNameSym());
        ListExpr args = e.getArgumentListSym();
        if (args != null) {
            this.handleArguments(args);
        }
    }

    public final void print(QuestionExpr e) {
        this.markWrapAlignment();
        this.handle(e.getNthOperandSym(0));
        boolean spaceQuestionAfter = this.preferences.getBoolean(38);
        boolean spaceQuestionBefore = this.preferences.getBoolean(37);
        boolean spaceColonBefore = this.preferences.getBoolean(39);
        if (spaceQuestionBefore) {
            this.print(' ');
        }
        this.print((short)69);
        if (spaceQuestionAfter) {
            this.print(' ');
        }
        this.markWrapBoundary(59);
        this.handle(e.getNthOperandSym(1));
        if (spaceColonBefore) {
            this.print(' ');
        }
        this.print((short)38);
        this.markWrapBoundary(59);
        this.handle(e.getNthOperandSym(2));
    }

    public final void print(SimpleNameExpr e) {
        this.print((TreeSym)e);
    }

    public final void print(TypecastExpr e) {
        this.print((short)55);
        this.handle(e.getNthOperandSym(0));
        this.print((short)72);
        boolean spaceTypecastAfter = this.preferences.getBoolean(41);
        if (spaceTypecastAfter) {
            this.print(' ');
        }
        this.handle(e.getNthOperandSym(1));
    }

    public final void print(TypeExpr e) {
        this.print((TreeSym)e);
    }

    public final void print(UnaryExpr e) {
        switch (e.exprOptcode) {
            case 14: {
                this.handle(e.getNthOperandSym(0));
                this.print((short)43);
                this.print((short)103);
                break;
            }
            case 49: {
                this.handle(e.getNthOperandSym(0));
                this.print((short)43);
                this.print((short)133);
                break;
            }
            case 50: {
                this.handle(e.getNthOperandSym(0));
                this.print((short)43);
                this.print((short)136);
                break;
            }
            case 45: 
            case 46: {
                this.handle(e.getNthOperandSym(0));
                this.handlePostfixOperator(FormatLayer3.opt2tk(e.exprOptcode));
                break;
            }
            default: {
                this.handlePrefixOperator(FormatLayer3.opt2tk(e.exprOptcode));
                this.handle(e.getNthOperandSym(0));
                break;
            }
        }
    }

    public final void print(WrapperExpr e) {
        this.print((short)55);
        int id = this.push();
        try {
            this.markWrapAlignment();
            this.handle(e.getNthOperandSym(0));
        }
        finally {
            this.pop(id);
        }
        this.print((short)72);
    }

    protected final void handleArguments(ListExpr e) {
        boolean spaceArgumentsBefore = this.preferences.getBoolean(42);
        if (spaceArgumentsBefore) {
            this.print(' ');
        }
        this.enter(e);
        this.print((short)55);
        int id = this.push();
        try {
            this.indent(1);
            this.markWrapAlignment();
            int count = e.getOperandCount();
            if (count > 0) {
                boolean needComma = false;
                int i = 0;
                while (i < count) {
                    if (needComma) {
                        this.print((short)39);
                        this.markWrapBoundary(61);
                    }
                    this.handle(e.getNthOperandSym(i));
                    needComma = true;
                    ++i;
                }
            }
        }
        finally {
            this.pop(id);
        }
        this.print((short)72);
        this.leave(e);
    }

    private void handleArrayDereferences(ListExpr e) {
        this.enter(e);
        int count = e.getOperandCount();
        int i = 0;
        while (i < count) {
            Expr op = e.getNthOperandSym(i);
            this.print((short)50);
            this.handle(op);
            this.print((short)71);
            ++i;
        }
        this.leave(e);
    }

    protected final void handleInfixOperator(short tk) {
        boolean spaceBinaryopAround = this.preferences.getBoolean(46);
        if (spaceBinaryopAround) {
            this.print(' ');
        }
        this.print(tk);
        if (spaceBinaryopAround) {
            this.print(' ');
        }
    }

    private void handlePrefixOperator(short tk) {
        this.print(tk);
    }

    private void handlePostfixOperator(short tk) {
        this.print(tk);
    }

    protected static short opt2tk(byte opt) {
        short tk;
        if (opt != 0 && (tk = JavaOperators.OPT_tokens[opt - 1]) != 0) {
            return tk;
        }
        FormatLayer3.panic();
        return 0;
    }

    FormatLayer3() {
    }
}

