/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.internal.format;

import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.buffer.TextBufferFactory;
import oracle.javatools.parser.java.v2.internal.format.Emitter;
import oracle.javatools.parser.java.v2.internal.format.FormatDriver;
import oracle.javatools.parser.java.v2.internal.format.LineWrappingEmitter;
import oracle.javatools.parser.java.v2.internal.format.ReindentingEmitter;
import oracle.javatools.parser.java.v2.internal.symbol.Sym;

final class SavedTextEmitter
extends Emitter {
    private final LineWrappingEmitter printer;
    private int savedTextOffset;
    private String savedTextHeader;
    private int savedTextColumn;
    private ReindentingEmitter reindenter;
    private int docDepth;

    private void $init$() {
        this.printer = new LineWrappingEmitter();
        this.savedTextOffset = -1;
        this.savedTextHeader = "";
        this.savedTextColumn = 0;
        this.reindenter = new ReindentingEmitter();
        this.docDepth = 0;
    }

    public TextBuffer getOutputBuffer() {
        TextBuffer textBuffer = TextBufferFactory.createArrayTextBuffer();
        String text = this.toString();
        textBuffer.insert(0, text.toCharArray());
        return textBuffer;
    }

    public String toString() {
        return this.printer.getBuffer().toString();
    }

    void setFormatDriver(FormatDriver formatter) {
        super.setFormatDriver(formatter);
        this.printer.setFormatDriver(formatter);
        this.reindenter.setFormatDriver(formatter);
    }

    void init(Sym s) {
        super.init(s);
        this.printer.init(s);
        this.reindenter.init(s);
    }

    void fini(Sym s) {
        this.reindenter.fini(s);
        this.printer.fini(s);
        super.fini(s);
    }

    boolean isWrapCapable() {
        return this.printer.isWrapCapable();
    }

    int getColumn() {
        return this.printer.getColumn();
    }

    int getColumnStamp() {
        return this.printer.getColumnStamp();
    }

    void markWrapBoundary(int height) {
        this.printer.markWrapBoundary(height);
    }

    void forceLineWrapping() {
        this.printer.forceLineWrapping();
    }

    void enter(Sym s) {
        if (s.is((byte)85)) {
            return;
        }
        if (s.is((byte)87)) {
            ++this.docDepth;
        }
        if ((s.symFormat & '\u0001') != 0) {
            this.dirtyOn(s);
        } else if (s.symKind == 63) {
            s.saveText();
        }
        if ((s.symFormat & 4) != 0) {
            this.savedTextOn(s);
        }
        this.printer.enter(s);
    }

    void leave(Sym s) {
        if (s.is((byte)85)) {
            return;
        }
        if (s.is((byte)87)) {
            --this.docDepth;
        }
        this.printer.leave(s);
        if ((s.symFormat & '\u0001') != 0) {
            this.dirtyOff(s);
        }
        if ((s.symFormat & 4) != 0) {
            this.savedTextOff(s);
        }
        s.symFormat = '\u0000';
    }

    void emitIndent(int spaces) {
        this.printer.emitIndent(spaces);
    }

    void emit(String s) {
        this.printer.emit(s);
    }

    void emit(short tk) {
        this.printer.emit(tk);
    }

    void emit(char ch) {
        this.printer.emit(ch);
    }

    private void dirtyOn(Sym s) {
        this.savedTextOffset = -1;
    }

    private void dirtyOff(Sym s) {
    }

    private void savedTextOn(Sym s) {
        int length;
        if (this.docDepth > 0 && s.symKind != 63) {
            return;
        }
        StringBuffer buffer = this.printer.getBuffer();
        this.savedTextOffset = length = buffer.length();
        int lineStart = LineWrappingEmitter.lastIndexOfNewline(buffer) + 1;
        this.savedTextHeader = lineStart < length ? buffer.substring(lineStart) : "";
        this.savedTextColumn = this.printer.getColumn_forIndentationUse();
    }

    private void savedTextOff(Sym s) {
        int end;
        int start;
        String compareText;
        if (this.savedTextOffset == -1) {
            return;
        }
        StringBuffer buffer = this.printer.getBuffer();
        int length = buffer.length();
        int leading = this.savedTextOffset;
        while (leading < length && Character.isWhitespace(buffer.charAt(leading))) {
            ++leading;
        }
        int trailing = length;
        while (leading < trailing && Character.isWhitespace(buffer.charAt(trailing - 1))) {
            --trailing;
        }
        String savedTrailing = null;
        if (trailing != leading && trailing != length) {
            savedTrailing = buffer.substring(trailing, length);
        }
        String targetText = this.getSavedText(s);
        int targetOffset = leading;
        int headerLength = this.savedTextHeader.length();
        if (headerLength > 0 && !this.savedTextHeader.equals(compareText = buffer.substring(start = this.savedTextOffset - headerLength, end = this.savedTextOffset))) {
            targetOffset = start;
            targetText = this.savedTextHeader + targetText;
        }
        buffer.setLength(targetOffset);
        buffer.append(targetText);
        if (savedTrailing != null) {
            buffer.append(savedTrailing);
        }
        this.printer.clearWrapBoundary();
        this.savedTextOffset = -1;
        ++this.printer.resetCounter;
    }

    private String getSavedText(Sym s) {
        String savedText = s.getText();
        savedText = savedText.replace("\r\n", "\n");
        savedText = savedText.replace('\r', '\n');
        int firstNewline = savedText.indexOf(10);
        if (s.symKind == 63 && firstNewline >= 0) {
            int indentation = this.savedTextColumn;
            int savedLength = savedText.length();
            this.reindenter.clear();
            String firstLine = savedText.substring(0, firstNewline);
            this.reindenter.emit(firstLine);
            this.reindenter.emit('\n');
            int prevNewline = firstNewline;
            while (prevNewline < savedLength) {
                boolean notLastLine;
                int nextNewline = savedText.indexOf(10, prevNewline + 1);
                if (nextNewline < 0) {
                    nextNewline = savedLength;
                }
                String nextLine = savedText.substring(prevNewline + 1, nextNewline);
                boolean indentNextLine = false;
                int star = nextLine.indexOf(42);
                if (star >= 0) {
                    indentNextLine = true;
                    int i = 0;
                    while (i < star) {
                        char ch = nextLine.charAt(i);
                        if (!Character.isWhitespace(ch)) {
                            indentNextLine = false;
                            break;
                        }
                        ++i;
                    }
                }
                if (indentNextLine) {
                    this.reindenter.emitIndent(indentation, false);
                    this.reindenter.emit(" *");
                    String chompedLine = nextLine.substring(star + 1);
                    this.reindenter.emit(chompedLine);
                } else {
                    this.reindenter.emit(nextLine);
                }
                boolean bl = notLastLine = nextNewline < savedLength;
                if (notLastLine) {
                    this.reindenter.emit('\n');
                }
                prevNewline = nextNewline;
            }
            String reindented = this.reindenter.toString();
            return reindented;
        }
        return savedText;
    }

    SavedTextEmitter() {
        this.$init$();
    }
}

