/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.internal.parser;

import java.util.HashSet;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.parser.java.v2.JavaConstants;
import oracle.javatools.parser.java.v2.JavaTokens;
import oracle.javatools.parser.java.v2.internal.parser.ParserLayer1a;
import oracle.javatools.parser.java.v2.internal.parser.SyntaxData;
import oracle.javatools.parser.java.v2.internal.symbol.ClassSym;
import oracle.javatools.parser.java.v2.internal.symbol.ErrorSym;
import oracle.javatools.parser.java.v2.internal.symbol.FileSym;
import oracle.javatools.parser.java.v2.internal.symbol.NameSym;
import oracle.javatools.parser.java.v2.internal.symbol.PlaceholderSym;
import oracle.javatools.parser.java.v2.internal.symbol.Sym;
import oracle.javatools.parser.java.v2.internal.symbol.SymFactory;
import oracle.javatools.parser.java.v2.internal.symbol.WhitespaceSym;

abstract class ParserLayer1b
extends ParserLayer1a {
    Sym stackTop;
    Sym[] stack;
    Sym lastPop;
    Sym stackRoot;
    WhitespaceSym lastWhitespace;
    SyntaxData errorData;
    HashSet possibleTypes;
    short stackHeight;
    int lastTokenIndex;
    int errorCount;
    int lastErrorIndex;

    void initializeParserState(FileSym file) {
        this.stackTop = null;
        this.stack = new Sym[4];
        this.stackHeight = 0;
        if (file == null) {
            file = SymFactory.createFile();
        }
        this.symFile = file;
        this.symFile.symStart = 0;
        this.symFile.symData = new SyntaxData();
        this.symFile.tokens = this.tokens;
        this.symFile.j2se = this.j2se;
        this.errorData = new SyntaxData();
        this.errorData.flag_repushed = true;
        this.symFile.parseErrors.treeChildren = Sym.EMPTY_ARRAY;
        this.symFile.parseErrors.symData = this.errorData;
        if (this.textBuffer instanceof TextBuffer) {
            this.symFile.bufferChangeId = ((TextBuffer)this.textBuffer).getChangeId();
        }
        this.possibleTypes = new HashSet();
        this.errorCount = 0;
        this.lastErrorIndex = -1;
        this.lastWhitespace = null;
        this.skipToken();
        this.node((byte)73);
        this.stackRoot = this.stackTop;
        this.stackRoot.symParent = this.symFile;
    }

    final void simple_name() {
        if (this.curToken == 4) {
            this.node((byte)20);
            this.skipToken();
            NameSym nameSym = (NameSym)this.stackTop;
            nameSym.nameString = this.get_name_value();
            this.pop();
        } else if (ParserLayer1b.kw(this.curToken)) {
            this.node((byte)20);
            switch (this.curToken) {
                case 133: 
                case 136: 
                case 141: {
                    break;
                }
                default: {
                    if (ParserLayer1b.primitive(this.curToken)) break;
                    this.errorExpecting((short)4);
                }
            }
            NameSym nameSym = (NameSym)this.stackTop;
            nameSym.nameString = JavaTokens.KW_words[this.curToken - 96];
            this.skipToken();
            this.pop();
        } else {
            this.errorExpecting((short)4);
        }
    }

    final Sym expr_name() {
        Sym savedLastPop = this.lastPop;
        try {
            this.node((byte)20);
            this.skipToken();
            NameSym nameSym = (NameSym)this.stackTop;
            SyntaxData data = (SyntaxData)nameSym.symData;
            data.flag_noProcess = true;
            nameSym.nameString = this.get_name_value();
            this.pop();
            NameSym nameSym2 = nameSym;
            return nameSym2;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            this.lastPop = savedLastPop;
        }
    }

    final void qualified_name() {
        String nameText;
        this.node((byte)20);
        this.nextToken((short)4);
        if (this.curToken == 43) {
            StringBuilder nameBuffer = new StringBuilder(this.get_name_value());
            while (this.optionalToken((short)43)) {
                this.nextToken((short)4);
                nameBuffer.append('.');
                nameBuffer.append(this.get_name_value());
            }
            nameText = nameBuffer.toString();
        } else {
            nameText = this.get_name_value();
        }
        NameSym nameSym = (NameSym)this.stackTop;
        nameSym.nameString = nameText;
        this.pop();
    }

    final void expr_qualified_name() {
        this.node((byte)20);
        this.nextToken((short)4);
        String nameText = this.get_name_value();
        while (this.curToken == 43 && this.lookaheadToken() == 4) {
            this.nextToken((short)43);
            this.nextToken((short)4);
            nameText = nameText + '.' + this.get_name_value();
        }
        NameSym nameSym = (NameSym)this.stackTop;
        nameSym.nameString = nameText;
        this.pop();
    }

    final void import_qualified_name() {
        String nameText;
        this.node((byte)20);
        this.nextToken((short)4);
        if (this.curToken == 43) {
            StringBuilder nameBuffer = new StringBuilder(this.get_name_value());
            while (this.optionalToken((short)43)) {
                if (this.curToken == 63) {
                    this.skipToken();
                    nameBuffer.append(".*");
                    continue;
                }
                this.nextToken((short)4);
                nameBuffer.append('.');
                nameBuffer.append(this.get_name_value());
            }
            nameText = nameBuffer.toString();
        } else {
            nameText = this.get_name_value();
        }
        NameSym nameSym = (NameSym)this.stackTop;
        nameSym.nameString = nameText;
        this.pop();
    }

    final void synthetic_name(String text) {
        this.synthetic_node((byte)20);
        NameSym nameSym = (NameSym)this.lastPop;
        nameSym.nameString = text;
        nameSym.buildSelf();
    }

    private String get_name_value() {
        int end = this.tokens.tokenEnds[this.lastTokenIndex];
        int start = this.tokens.tokenStarts[this.lastTokenIndex];
        int length = end - start;
        if (length > 0) {
            return this.textBuffer.getString(start, length);
        }
        return "";
    }

    private void set_whitespace_value() {
        WhitespaceSym sym = (WhitespaceSym)this.stackTop;
        int index = sym.symStart;
        int end = this.tokens.tokenEnds[index];
        int start = this.tokens.tokenStarts[index];
        int length = end - start;
        if (length > 0) {
            sym.tokenText = this.textBuffer.getString(start, length);
        }
    }

    final WhitespaceSym getPrecedingWhitespace(Sym sym) {
        SyntaxData data = (SyntaxData)sym.symData;
        if (data != null) {
            return data.precedingWhitespace;
        }
        return null;
    }

    final void setPrecedingWhitespace(Sym sym, WhitespaceSym preceding) {
        SyntaxData data = (SyntaxData)sym.symData;
        if (data != null) {
            data.precedingWhitespace = preceding;
        } else {
            this.internalError();
        }
    }

    final void attachWhitespaceChain(WhitespaceSym commentSym, Sym parent) {
        if (commentSym == null) {
            return;
        }
        if (commentSym.symData == null) {
            return;
        }
        if (parent == null) {
            this.internalError();
        }
        this.attachWhitespaceChain(this.getPrecedingWhitespace(commentSym), parent);
        commentSym.symParent = parent;
        if (commentSym.symStart < parent.symStart) {
            parent.symStart = commentSym.symStart;
        }
        this.processNode(commentSym);
    }

    final void handleWhitespace(WhitespaceSym whitespaceSym, Sym parent) {
        Sym attachedTo = parent;
        while (attachedTo.symParent != null && attachedTo.symParent.symKind != 73 && whitespaceSym.symStart <= attachedTo.symParent.symStart) {
            attachedTo = attachedTo.symParent;
        }
        Sym owner = attachedTo.symParent != null ? attachedTo.symParent : attachedTo;
        this.attachWhitespaceChain(whitespaceSym, owner);
    }

    private void handleWhitespaceBeforeSkipping() {
        if (this.lastWhitespace.symParent == this.stackTop || this.stackTop.symStart < this.lastWhitespace.symStart) {
            this.attachWhitespaceChain(this.lastWhitespace, this.stackTop);
        } else {
            this.handleWhitespace(this.lastWhitespace, this.stackTop);
        }
    }

    private void handleOneWhitespaceToken() {
        boolean isComment;
        boolean bl = isComment = this.curToken != 6;
        if (isComment) {
            this.node((byte)69);
        } else {
            this.node((byte)71);
        }
        SyntaxData data = (SyntaxData)this.stackTop.symData;
        data.flag_noProcess = true;
        WhitespaceSym sym = (WhitespaceSym)this.stackTop;
        sym.tokenValue = this.curToken;
        if (isComment && this.newlineCount > 0) {
            sym.symFlags = (byte)(sym.symFlags | 0x40);
        }
        super.skipToken();
        if (isComment && this.newlineCount > 0) {
            sym.symFlags = (byte)(sym.symFlags | 0xFFFFFF80);
        }
        this.set_whitespace_value();
        this.pop();
        sym.symEnd = sym.symStart;
        if (this.lastWhitespace != null) {
            this.setPrecedingWhitespace(sym, this.lastWhitespace);
        }
        this.lastWhitespace = sym;
    }

    private void saveBlanklines() {
        while (this.newlineCount > 1) {
            this.node((byte)70);
            WhitespaceSym lexicalSym = (WhitespaceSym)this.stackTop;
            SyntaxData data = (SyntaxData)this.stackTop.symData;
            data.flag_noProcess = true;
            this.pop();
            lexicalSym.symEnd = lexicalSym.symStart;
            if (this.lastWhitespace != null) {
                this.setPrecedingWhitespace(lexicalSym, this.lastWhitespace);
            }
            this.lastWhitespace = lexicalSym;
            this.newlineCount = (byte)(this.newlineCount - 1);
        }
    }

    final void skipToken() {
        if (this.lastWhitespace != null) {
            this.handleWhitespaceBeforeSkipping();
        }
        this.lastWhitespace = null;
        this.lastTokenIndex = this.lexer.getTokenIndex();
        if (this.lastTokenIndex == -1) {
            this.lastTokenIndex = 0;
        }
        super.skipToken();
        int count = 0;
        block3: while (true) {
            switch (this.curToken) {
                case 6: 
                case 24: 
                case 25: 
                case 26: {
                    this.saveBlanklines();
                    this.handleOneWhitespaceToken();
                    ++count;
                    continue block3;
                }
            }
            break;
        }
        this.saveBlanklines();
    }

    final void node(byte sy) {
        if (this.flag_frozenlexer) {
            this.internalError();
        }
        Sym sym = SymFactory.createNode(this.symFile, sy);
        sym.symKind = sy;
        if (this.flag_setnew) {
            sym.symFormat = (char)(sym.symFormat | 2);
        }
        this.push(sym);
    }

    final void push(Sym sym) {
        if (this.stack.length == this.stackHeight) {
            Sym[] newStack = new Sym[this.stack.length * 2];
            System.arraycopy(this.stack, 0, newStack, 0, this.stack.length);
            this.stack = newStack;
        }
        if (sym.symData != null) {
            this.internalError();
        }
        SyntaxData data = new SyntaxData();
        sym.symParent = this.stackTop;
        sym.symStart = this.lexer.getTokenIndex();
        sym.symData = data;
        data.stackDepth = this.stackHeight;
        this.lastPop = null;
        short s = this.stackHeight;
        this.stackHeight = (short)(s + 1);
        this.stack[s] = sym;
        this.stackTop = sym;
    }

    final void pop() {
        boolean empty;
        if (this.stackTop != this.stack[this.stackHeight - 1]) {
            this.internalError();
        }
        SyntaxData symData = (SyntaxData)this.stackTop.symData;
        if (this.stackTop.symData == null) {
            this.internalError();
        }
        if (symData.stackDepth != this.stackHeight - 1) {
            this.internalError();
        }
        this.lastPop = this.stackTop;
        if (this.stackHeight == 0) {
            this.internalError();
        }
        this.stackHeight = (short)(this.stackHeight - 1);
        this.stack[this.stackHeight] = null;
        this.stackTop = this.stackHeight == 0 ? null : this.stack[this.stackHeight - 1];
        boolean bl = empty = this.lexer.getTokenIndex() == this.lastPop.symStart && this.lastPop.symKind != 70;
        if (empty && this.lastPop.symKind != 73) {
            this.lastPop = null;
            return;
        }
        this.lastPop.symEnd = this.lastTokenIndex;
        if (!symData.flag_noProcess) {
            this.processNode(this.lastPop);
        }
    }

    final void repush(Sym sym) {
        if (this.stack.length == this.stackHeight) {
            Sym[] newStack = new Sym[this.stack.length * 2];
            System.arraycopy(this.stack, 0, newStack, 0, this.stack.length);
            this.stack = newStack;
        }
        if (sym.symData != null) {
            this.internalError();
        }
        SyntaxData data = new SyntaxData();
        sym.symData = data;
        data.stackDepth = this.stackHeight;
        data.flag_repushed = true;
        this.lastPop = null;
        short s = this.stackHeight;
        this.stackHeight = (short)(s + 1);
        this.stack[s] = sym;
        this.stackTop = sym;
    }

    final void processNode(Sym sym) {
        try {
            SyntaxData data = (SyntaxData)sym.symData;
            boolean repushed = false;
            if (data != null) {
                repushed = data.flag_repushed;
            }
            sym.buildSelf();
            sym.symData = null;
            Sym parent = sym.symParent;
            if (parent != null && !repushed && sym.symKind != 0) {
                SyntaxData parentData = (SyntaxData)parent.symData;
                parentData.addKid(sym);
            }
        }
        catch (NullPointerException e) {
            e.printStackTrace();
            this.error(23);
        }
        catch (IndexOutOfBoundsException e) {
            e.printStackTrace();
            this.error(23);
        }
        catch (ClassCastException e) {
            e.printStackTrace();
            this.error(23);
        }
    }

    final void synthetic_node(byte sy) {
        if (this.flag_frozenlexer) {
            this.internalError();
        }
        Sym sym = SymFactory.createNode(this.symFile, sy);
        sym.symKind = sy;
        if (this.flag_setnew) {
            sym.symFormat = (char)(sym.symFormat | 2);
        }
        sym.symParent = this.stackTop;
        sym.symStart = this.lexer.getTokenIndex();
        SyntaxData symData = (SyntaxData)this.stackTop.symData;
        if (this.stackTop.symData == null) {
            this.internalError();
        }
        if (symData.stackDepth != this.stackHeight - 1) {
            this.internalError();
        }
        sym.symEnd = sym.symStart;
        Sym parent = this.stackTop;
        if (this.stackTop != null) {
            SyntaxData parentData = (SyntaxData)parent.symData;
            parentData.addKid(sym);
        }
        this.lastPop = sym;
    }

    final void swapChildren(Sym one, Sym two) {
        SyntaxData oneData = (SyntaxData)one.symData;
        SyntaxData twoData = (SyntaxData)two.symData;
        if (oneData == null || twoData == null) {
            this.internalError();
        }
        Sym[] tmp = oneData.kids;
        int tmpCount = oneData.kidCount;
        oneData.kids = twoData.kids;
        oneData.kidCount = twoData.kidCount;
        twoData.kids = tmp;
        twoData.kidCount = tmpCount;
        int i = 0;
        while (i < oneData.kidCount) {
            oneData.kids[i].symParent = one;
            ++i;
        }
        int i2 = 0;
        while (i2 < twoData.kidCount) {
            twoData.kids[i2].symParent = two;
            ++i2;
        }
    }

    void notImplementedYet(String message) {
        String basic = ParserLayer1b.error2message(3);
        basic = ParserLayer1b.format(basic, message);
        this.error(3, basic);
    }

    void internalError() {
        String message = ParserLayer1b.error2message(2);
        this.error(2, message);
        ParserLayer1b.panic(message);
    }

    void error(int code) {
        String message = ParserLayer1b.error2message(code);
        switch (code) {
            case 12: 
            case 16: {
                ClassSym classSym = this.stackTop instanceof ClassSym ? (ClassSym)this.stackTop : this.stackTop.getOwningClassSym();
                if (classSym != null) {
                    int tykind = classSym.getTypeKind();
                    ErrorSym sym = this.error(code, message = ParserLayer1b.format(message, JavaConstants.TY_words[tykind]));
                    if (sym == null) break;
                    sym.errorIntData0 = tykind;
                    break;
                }
                this.error(code, message);
                break;
            }
            case 25: {
                message = ParserLayer1b.format(message, ParserLayer1b.tokenToString(this.curToken));
            }
            default: {
                this.error(code, message);
                break;
            }
        }
    }

    ErrorSym error(int code, String message) {
        if (this.flag_frozenlexer && code != 2) {
            this.internalError();
        }
        int startIndex = this.lexer.getTokenIndex();
        if (this.errorCount++ < 32 && this.lastErrorIndex != startIndex) {
            ErrorSym error = (ErrorSym)SymFactory.createNode(this.symFile, 8);
            int tokenIndex = this.lexer.getTokenIndex();
            error.symParent = this.symFile.parseErrors;
            error.symFile = this.symFile;
            error.symKind = (byte)8;
            error.symStart = tokenIndex;
            error.symEnd = tokenIndex;
            error.errorCode = (short)code;
            error.errorToken = this.curToken;
            Sym errorSymbol = this.stackTop;
            while (errorSymbol != null && (errorSymbol instanceof PlaceholderSym || errorSymbol.symKind == 74)) {
                errorSymbol = errorSymbol.symParent;
            }
            byte symKind = this.stackTop.symKind;
            String prefix = "";
            if (1 <= symKind && symKind < 72) {
                prefix = ParserLayer1b.symbolToString(this.stackTop.symKind);
            }
            if (prefix.length() > 0) {
                message = prefix + ": " + message;
            }
            error.errorMessage = message;
            error.buildSelf();
            this.errorData.addKid(error);
            this.lastErrorIndex = tokenIndex;
            return error;
        }
        return null;
    }

    void errorExpecting(short a) {
        String message = ParserLayer1b.error2message(10);
        ErrorSym sym = this.error(10, message = ParserLayer1b.format(message, ParserLayer1b.tokenToString(a)));
        if (sym != null) {
            sym.errorIntData0 = a;
        }
    }

    void errorExpecting(short a, short b) {
        String message = ParserLayer1b.error2message(11);
        ErrorSym sym = this.error(11, message = ParserLayer1b.format(message, ParserLayer1b.tokenToString(a), ParserLayer1b.tokenToString(b)));
        if (sym != null) {
            if (b < a) {
                short tmp = a;
                a = b;
                b = tmp;
            }
            sym.errorIntData0 = a;
            sym.errorIntData1 = b;
        }
    }

    private static String symbolToString(byte sy) {
        String word = JavaConstants.SRC_words[sy - 1];
        if (word.length() == 0) {
            return word;
        }
        char ch = word.charAt(0);
        if (!Character.isLetter(ch)) {
            return word;
        }
        return Character.toUpperCase(ch) + word.substring(1);
    }

    private static String tokenToString(short token) {
        if (32 <= token && token < 81) {
            return JavaTokens.OP_words[token - 32];
        }
        if (96 <= token && token < 146) {
            return JavaTokens.KW_words[token - 96];
        }
        switch (token) {
            case 4: {
                return "identifier";
            }
            case 0: {
                return "EOF";
            }
            case 6: {
                return "#sql clause";
            }
            case 8: {
                return "integer literal";
            }
            case 10: {
                return "floating-point literal";
            }
            case 12: {
                return "boolean literal";
            }
            case 13: {
                return "character literal";
            }
            case 14: {
                return "string literal";
            }
            case 15: {
                return "null";
            }
            case 24: {
                return "single-line comment";
            }
            case 25: {
                return "multi-line comment";
            }
            case 26: {
                return "javadoc comment";
            }
        }
        return "unknown token";
    }

    ParserLayer1b() {
    }
}

