/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.internal.symbol;

import oracle.javatools.parser.java.v2.JavaConstants;
import oracle.javatools.parser.java.v2.internal.symbol.FileSym;
import oracle.javatools.parser.java.v2.internal.symbol.Sym;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceError;

public final class ErrorSym
extends Sym
implements SourceError {
    public static final ErrorSym[] EMPTY_ARRAY = new ErrorSym[0];
    public short errorCode;
    public short errorToken;
    public int errorIntData0;
    public int errorIntData1;
    public Object[] errorRefData;
    public String errorMessage;
    public Sym errorSymbol;

    private void $init$() {
        this.errorIntData0 = 0;
        this.errorIntData1 = 0;
        this.errorRefData = JavaConstants.EMPTY_OBJECT_ARRAY;
        this.errorSymbol = null;
    }

    public short getErrorCode() {
        return this.errorCode;
    }

    public short getErrorToken() {
        return this.errorToken;
    }

    public int getErrorSeverity() {
        return ErrorSym.error2severity(this.getErrorCode());
    }

    public int getErrorCategory() {
        return ErrorSym.error2category(this.getErrorCode());
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public SourceElement getErrorSymbol() {
        return this.errorSymbol;
    }

    public int getErrorData0() {
        return this.getErrorIntData0();
    }

    public int getErrorData1() {
        return this.getErrorIntData1();
    }

    public int getErrorIntData0() {
        return this.errorIntData0;
    }

    public int getErrorIntData1() {
        return this.errorIntData1;
    }

    public Object getErrorRefData0() {
        return this.getErrorRefData(0);
    }

    public Object getErrorRefData1() {
        return this.getErrorRefData(1);
    }

    public Object getErrorRefData(int n) {
        if (0 <= n && n < this.errorRefData.length) {
            return this.errorRefData[n];
        }
        return null;
    }

    public int getStartOffset() {
        int start = super.getStartOffset();
        if (start >= 0) {
            return start;
        }
        if (this.errorSymbol != null) {
            return this.errorSymbol.getStartOffset();
        }
        return -1;
    }

    public int getEndOffset() {
        int end = super.getEndOffset();
        if (end >= 0) {
            return end;
        }
        if (this.errorSymbol != null) {
            return this.errorSymbol.getEndOffset();
        }
        return this.getStartOffset();
    }

    public int compareTo(Sym o) {
        int startCompare = super.compareTo(o);
        if (startCompare != 0) {
            return startCompare;
        }
        if (o.symKind == 8) {
            ErrorSym other = (ErrorSym)o;
            short error1 = this.errorCode;
            short error2 = other.errorCode;
            return error1 - error2;
        }
        return 0;
    }

    public boolean equals(Object o) {
        if (o instanceof ErrorSym) {
            return this.equals((ErrorSym)o);
        }
        return super.equals(o);
    }

    public boolean equals(ErrorSym otherSym) {
        if (this == otherSym) {
            return true;
        }
        if (this.errorCode != otherSym.errorCode) {
            return false;
        }
        int thisStart = this.getStartOffset();
        if (thisStart < 0) {
            return false;
        }
        int otherStart = otherSym.getStartOffset();
        if (otherStart < 0) {
            return false;
        }
        if (thisStart != otherStart || this.getEndOffset() != otherSym.getEndOffset()) {
            return false;
        }
        String thisMessage = this.getErrorMessage();
        String otherMessage = otherSym.getErrorMessage();
        return thisMessage.equals(otherMessage);
    }

    protected void checkCloneable() {
        ErrorSym.unsupported("May not clone errors.");
    }

    public Sym cloneSelf(FileSym targetFile) {
        ErrorSym sym = (ErrorSym)super.cloneSelf(targetFile);
        sym.symStart = this.symStart;
        sym.symEnd = this.symEnd;
        sym.errorCode = this.errorCode;
        sym.errorToken = this.errorToken;
        sym.errorIntData0 = this.errorIntData0;
        sym.errorIntData1 = this.errorIntData1;
        sym.errorRefData = (Object[])this.errorRefData.clone();
        sym.errorMessage = this.errorMessage;
        if (this.errorSymbol != null) {
            Sym mappedSym = this.errorSymbol.getMapping();
            if (mappedSym == null) {
                ErrorSym.panic("Failed to map the error Sym");
            }
            sym.errorSymbol = mappedSym;
        }
        return sym;
    }

    protected void verboseSelf(StringBuilder buffer) {
        buffer.append(" \"");
        buffer.append(this.errorMessage);
        buffer.append("\" (");
        buffer.append(this.errorCode);
        buffer.append(')');
    }

    public ErrorSym() {
        this.$init$();
    }
}

