/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.internal.symbol;

import java.io.PrintWriter;
import java.util.Collection;
import oracle.javatools.parser.java.v2.internal.compiler.CompilerDriver;
import oracle.javatools.parser.java.v2.internal.compiler.ImportObj;
import oracle.javatools.parser.java.v2.internal.format.FormatDriver;
import oracle.javatools.parser.java.v2.internal.symbol.NameSym;
import oracle.javatools.parser.java.v2.internal.symbol.ObjectSym;
import oracle.javatools.parser.java.v2.internal.symbol.Sym;
import oracle.javatools.parser.java.v2.internal.symbol.TreeSym;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaElement;
import oracle.javatools.parser.java.v2.model.JavaHasType;
import oracle.javatools.parser.java.v2.model.SourceImport;

public final class ImportSym
extends ObjectSym
implements SourceImport {
    protected static final char VALID_ACCESS = '\b';

    public boolean isStaticImport() {
        return (this.symAccess & 8) != 0;
    }

    public boolean isNarrow() {
        String name = this.getName();
        return name.endsWith(".*") ^ true;
    }

    public Collection getImportedElements() {
        return this.getImportObj().getImportedElements();
    }

    public int getImportedElementCount() {
        return this.getImportObj().getImportedElementCount();
    }

    public JavaHasType getImportedElementAt(int index) {
        return this.getImportObj().getImportedElementAt(index);
    }

    public JavaClass getQualifyingType() {
        return this.getImportObj().getQualifyingType();
    }

    public boolean isInvalid() {
        return (this.objectFlags & 0x40) != 0;
    }

    public void setInvalid() {
        this.objectFlags = (char)(this.objectFlags | 0x40);
    }

    public boolean isUsed() {
        return (this.objectFlags & 0x80) != 0;
    }

    public void setUsed() {
        this.objectFlags = (char)(this.objectFlags | 0x80);
    }

    protected boolean isValidChild(Sym target, byte argument) {
        switch (target.symKind) {
            case 20: {
                return true;
            }
        }
        return super.isValidChild(target, argument);
    }

    protected boolean isValidAccess(char access) {
        int allowed = 8;
        return super.isValidAccess((char)(access & 0xFFFFFFF7));
    }

    public boolean checkSafeToInsert() {
        return true;
    }

    public boolean checkSafeToDelete(TreeSym parent) {
        return true;
    }

    public String printCompiledInfo() {
        if (this.isInvalid()) {
            return "<error>";
        }
        if (!this.isUsed()) {
            return "<unused>";
        }
        ImportObj importObj = this.getImportObj();
        int count = importObj.getImportedElementCount();
        if (count == 1) {
            return "imports " + importObj.getImportedElementAt(0).printCompiledInfo();
        }
        return "imports many...";
    }

    protected JavaElement resolveImpl(CompilerDriver compiler) {
        compiler.resolve(this);
        return this;
    }

    public ImportObj getImportObj() {
        if (this.hasObjData()) {
            return (ImportObj)this.symData;
        }
        ImportObj importObj = new ImportObj();
        importObj.objSym = this;
        this.symData = importObj;
        return importObj;
    }

    protected void printSelf(FormatDriver out) {
        out.print(this);
    }

    public void print(PrintWriter out, int ignored) {
        NameSym name = this.getNameSym();
        if (name != null) {
            out.print("import ");
            if (this.isStatic()) {
                out.print("static ");
            }
            ImportSym.print(name, out);
            out.println(";");
        }
    }
}

