/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.internal.symbol;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.parser.java.v2.CallerContext;
import oracle.javatools.parser.java.v2.JavaConstants;
import oracle.javatools.parser.java.v2.internal.InternalConstants;
import oracle.javatools.parser.java.v2.internal.compiler.CallerContextCookie;
import oracle.javatools.parser.java.v2.internal.compiler.CallerContextImpl;
import oracle.javatools.parser.java.v2.internal.compiler.CompilerDriver;
import oracle.javatools.parser.java.v2.internal.format.Emitter;
import oracle.javatools.parser.java.v2.internal.format.FormatDriver;
import oracle.javatools.parser.java.v2.internal.symbol.ClassSym;
import oracle.javatools.parser.java.v2.internal.symbol.FileSym;
import oracle.javatools.parser.java.v2.internal.symbol.MemberSym;
import oracle.javatools.parser.java.v2.internal.symbol.ObjectSym;
import oracle.javatools.parser.java.v2.internal.symbol.SymData;
import oracle.javatools.parser.java.v2.internal.symbol.SymFactory;
import oracle.javatools.parser.java.v2.internal.symbol.SymOperation;
import oracle.javatools.parser.java.v2.internal.symbol.SymText;
import oracle.javatools.parser.java.v2.internal.symbol.SymTransaction;
import oracle.javatools.parser.java.v2.internal.symbol.SymUtilities;
import oracle.javatools.parser.java.v2.internal.symbol.TreeSym;
import oracle.javatools.parser.java.v2.internal.util.UsageHook;
import oracle.javatools.parser.java.v2.model.JavaElement;
import oracle.javatools.parser.java.v2.model.JavaFile;
import oracle.javatools.parser.java.v2.model.NodeBinding;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.scanner.TokenArray;
import oracle.javatools.parser.java.v2.util.SimplifyTypeHelper;
import oracle.javatools.parser.java.v2.util.SourceVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Sym
extends SymUtilities
implements SourceElement,
JavaElement,
NodeBinding,
Comparable {
    protected static final byte ___code_conventions = 0;
    public static final Sym[] EMPTY_ARRAY = new Sym[0];
    private static final boolean[] isTyRef = new boolean[79];
    private static final boolean[] isMemberD = new boolean[79];
    private static final boolean[] isBlockElem = new boolean[79];
    public FileSym symFile;
    public Sym symParent;
    public int symSiblingIndex;
    public byte symKind;
    public byte symFlags;
    public char symAccess;
    public int symStart;
    public int symEnd;
    public transient char symFormat;
    public transient byte symIndent;
    public transient SymData symData;
    public NodeBinding[] symBindings;

    static {
        Sym.isTyRef[27] = true;
        Sym.isMemberD[3] = true;
        Sym.isMemberD[6] = true;
        Sym.isMemberD[7] = true;
        Sym.isMemberD[9] = true;
        Sym.isMemberD[5] = true;
        Sym.isMemberD[19] = true;
        Sym.isBlockElem[3] = true;
        Sym.isBlockElem[18] = true;
        Sym.isBlockElem[23] = true;
        int i = 28;
        while (i < 46) {
            Sym.isBlockElem[i] = true;
            ++i;
        }
    }

    private void $init$() {
        this.symParent = null;
        this.symSiblingIndex = -1;
        this.symKind = 0;
        this.symFlags = 0;
        this.symAccess = '\u0000';
        this.symStart = -1;
        this.symEnd = -1;
        this.symFormat = '\u0000';
        this.symIndent = 0;
        this.symData = null;
        this.symBindings = NodeBinding.EMPTY_ARRAY;
    }

    @Override
    public int getStartOffset() {
        int start = this.getStartIndex();
        if (start == -1) {
            return -1;
        }
        this.ensureSavepoint();
        if (this.symFile.tokens.tokenCount <= start) {
            Sym.panic();
        }
        return this.symFile.tokens.tokenStarts[start];
    }

    @Override
    public int getEndOffset() {
        int end = this.getEndIndex();
        if (end == -1) {
            if (this.getStartIndex() != -1) {
                return this.getStartOffset();
            }
            return -1;
        }
        this.ensureSavepoint();
        if (this.symFile.tokens.tokenCount <= end) {
            Sym.panic();
        }
        return this.symFile.tokens.tokenEnds[end];
    }

    public final int getStartIndex() {
        return this.symStart;
    }

    public final int getEndIndex() {
        return this.symEnd;
    }

    @Override
    public String getText() {
        NodeBinding binding = this.getBinding(4);
        if (binding != null) {
            return binding.toString();
        }
        TextBuffer textBuffer = this.symFile.getTextBuffer();
        if (textBuffer == null) {
            return "";
        }
        this.ensureSavepoint();
        int startOffset = this.getStartOffset();
        if (startOffset == -1) {
            return "";
        }
        int endOffset = this.getEndOffset();
        if (endOffset <= startOffset) {
            return "";
        }
        String text = textBuffer.getString(startOffset, endOffset - startOffset);
        return text;
    }

    protected void setText(String text) {
        Sym.unsupported("Base Sym implementation may not set text");
    }

    protected final void setTextImpl(String text) {
        SymTransaction transaction = this.verifyTransaction();
        SymOperation op = transaction.newOperation((byte)5);
        op.opTarget = this;
        op.opText = this.getText();
        op.buildSelf();
    }

    @Override
    public final int getSymbolKind() {
        return this.symKind;
    }

    @Override
    public int getElementKind() {
        return 0;
    }

    public void simplifyType() {
        SimplifyTypeHelper.simplifyType(this);
    }

    @Override
    public final void addSelf(SourceElement parent) {
        Sym sym = (Sym)parent;
        sym.add(this);
    }

    @Override
    public final void replaceSelf(SourceElement newElement) {
        Sym newSym = (Sym)newElement;
        if (this.symParent == null) {
            Sym.errorNoParent();
        }
        this.symParent.replace(this, newSym);
    }

    @Override
    public final void addSelf(SourceElement siblingElement, boolean before) {
        ListIterator siblings = siblingElement.getSiblings(458752);
        if (!before) {
            siblings.next();
        }
        siblings.add(this);
    }

    @Override
    public final void addSelfBefore(SourceElement sibling) {
        this.addSelf(sibling, true);
    }

    @Override
    public final void addSelfAfter(SourceElement sibling) {
        this.addSelf(sibling, false);
    }

    @Override
    public void removeSelf() {
        if (this.symParent != null) {
            this.symParent.remove(this);
        }
    }

    protected void add(Sym child) {
        Sym.unsupported("Sym may not be parent");
    }

    protected void replace(Sym oldSym, Sym newSym) {
        Sym.unsupported("Sym may not be parent");
    }

    protected void remove(Sym child) {
        Sym.unsupported("Sym may not be parent");
    }

    protected void remove(Sym child, byte filter) {
        Sym.unsupported("Sym may not be parent");
    }

    protected int indexOf(Sym sym) {
        return -1;
    }

    protected int lastIndexOf(Sym sym) {
        return -1;
    }

    @Override
    public final NodeBinding getBinding(int target) {
        if (this.symData != null && this.symData.getBindingType() == target) {
            return this.symData;
        }
        int bindingCount = this.symBindings.length;
        int i = 0;
        while (i < bindingCount) {
            NodeBinding data = this.symBindings[i];
            if (data.getBindingType() == target) {
                return data;
            }
            ++i;
        }
        return null;
    }

    @Override
    public final void setBinding(NodeBinding data) {
        switch (data.getBindingType()) {
            case 1: 
            case 2: {
                this.symData = (SymData)data;
                return;
            }
        }
        int target = data.getBindingType();
        int bindingCount = this.symBindings.length;
        int i = 0;
        while (i < bindingCount) {
            if (this.symBindings[i].getBindingType() == target) {
                this.symBindings[i] = data;
                return;
            }
            ++i;
        }
        NodeBinding[] newArray = new NodeBinding[bindingCount + 1];
        if (bindingCount > 0) {
            System.arraycopy(this.symBindings, 0, newArray, 0, bindingCount);
        }
        newArray[bindingCount] = data;
        this.symBindings = newArray;
    }

    @Override
    public final void clearBinding(int target) {
        if (this.symData != null && this.symData.getBindingType() == target) {
            this.symData = null;
            return;
        }
        int bindingCount = this.symBindings.length;
        int i = 0;
        while (i < bindingCount) {
            if (this.symBindings[i].getBindingType() == target) {
                if (bindingCount == 1) {
                    this.symBindings = NodeBinding.EMPTY_ARRAY;
                    break;
                }
                NodeBinding[] newArray = new NodeBinding[bindingCount - 1];
                if (i != 0) {
                    System.arraycopy(this.symBindings, 0, newArray, 0, i);
                }
                if (i != bindingCount - 1) {
                    System.arraycopy(this.symBindings, i + 1, newArray, i, bindingCount - 1 - i);
                }
                this.symBindings = newArray;
                break;
            }
            ++i;
        }
    }

    public void clearAllBindings(int key) {
        this.clearBinding(key);
    }

    public CallerContext getContext() {
        return this.getContextImpl();
    }

    @Override
    public void setContext(CallerContext context) {
        this.setContextImpl((CallerContextImpl)context);
    }

    public CallerContextImpl getContextImpl() {
        NodeBinding binding = this.getBinding(3);
        if (binding == null) {
            return null;
        }
        CallerContextCookie cookie = (CallerContextCookie)binding;
        return cookie.context;
    }

    public void setContextImpl(CallerContextImpl context) {
        CallerContextImpl found = this.getContextImpl();
        if (found == null && this.symParent != null) {
            Sym.panic("Cannot have both parent and context");
        }
        if (context == null) {
            this.clearBinding(3);
            this.symParent = null;
        } else {
            CallerContextCookie cookie = new CallerContextCookie(context);
            this.setBinding(cookie);
            this.symParent = context.scopeCookie;
        }
    }

    private final void setMapping(Sym other) {
        this.setBinding(other);
    }

    public final Sym getMapping() {
        NodeBinding found = this.getBinding(5);
        if (found != null) {
            return (Sym)found;
        }
        return null;
    }

    @Override
    public int getModifiers() {
        return this.symAccess;
    }

    public final void addModifiers(int modifiers) {
        int targetAccess = this.symAccess | modifiers;
        int publicProtectedPrivate = 7;
        int accessModifiers = modifiers & 7;
        if (accessModifiers != 0) {
            switch (accessModifiers) {
                case 1: 
                case 2: 
                case 4: {
                    int exclusive = 7 & ~accessModifiers;
                    targetAccess &= ~exclusive;
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
        }
        this.setModifiers(targetAccess);
    }

    public final void removeModifiers(int modifiers) {
        this.setModifiers(this.symAccess & ~modifiers);
    }

    public final void setModifiers(int modifiers) {
        char access = (char)modifiers;
        access = (char)(access & 0xFFFF9DFF);
        char saved = (char)(this.symAccess & 0x6200);
        access = (char)(access | saved);
        this.setModifiersImpl(access);
    }

    protected void setModifiersImpl(char access) {
        this.setAccess(access);
    }

    public List getModifierTokens() {
        return InternalConstants.kEmptyList;
    }

    public List getSourceAnnotations() {
        return InternalConstants.kEmptyList;
    }

    public final boolean isPublic() {
        return (this.getModifiers() & 1) != 0;
    }

    public final boolean isProtected() {
        return (this.getModifiers() & 4) != 0;
    }

    public final boolean isPrivate() {
        return (this.getModifiers() & 2) != 0;
    }

    public final boolean isPackagePrivate() {
        return (this.getModifiers() & 7) == 0;
    }

    public final boolean isStatic() {
        return (this.getModifiers() & 8) != 0;
    }

    @Override
    public final boolean isFinal() {
        return (this.getModifiers() & 0x10) != 0;
    }

    public final boolean isAbstract() {
        return (this.getModifiers() & 0x400) != 0;
    }

    @Override
    public final boolean isSynthetic() {
        return (this.symAccess & 0x1000) != 0;
    }

    public final boolean isVarargs() {
        return (this.symAccess & 0x80) != 0;
    }

    public final boolean isTransient() {
        return (this.symAccess & 0x80) != 0;
    }

    public boolean isNative() {
        return (this.symAccess & 0x100) != 0;
    }

    @Override
    public final JavaFile getFile() {
        return this.getOwningSourceFile();
    }

    @Override
    public final SourceFile getOwningFile() {
        return this.getOwningSourceFile();
    }

    @Override
    public final SourceFile getOwningSourceFile() {
        return this.symFile;
    }

    @Override
    public final SourceElement getParent() {
        return this.getParentSym();
    }

    public final Sym getParentSym() {
        Sym parent = this.symParent;
        while (parent != null) {
            if ((parent.symFlags & 2) == 0) {
                return parent;
            }
            parent = parent.symParent;
        }
        return null;
    }

    @Override
    public List getChildren() {
        return InternalConstants.kEmptyList;
    }

    @Override
    public List getChildren(int mask) {
        return InternalConstants.kEmptyList;
    }

    public Collection getSyms(byte filter) {
        return JavaConstants.kEmptyCollection;
    }

    public final Collection getChildrenRecursive(byte filter) {
        ArrayList list = new ArrayList();
        this.getChildrenRecursive(filter, list);
        return list;
    }

    protected void getChildrenRecursive(byte filter, ArrayList list) {
    }

    @Override
    public ListIterator getSiblings() {
        Sym parent = this.getParentSym();
        if (parent == null) {
            return InternalConstants.kEmptyList.listIterator();
        }
        if (parent == this.symFile) {
            parent = this.symFile.getRoot();
        }
        TreeSym treeSym = (TreeSym)parent;
        return treeSym.getSiblingsFor(this);
    }

    @Override
    public ListIterator getSiblings(int mask) {
        Sym parent = this.getParentSym();
        if (parent == null) {
            return InternalConstants.kEmptyList.listIterator();
        }
        TreeSym treeSym = (TreeSym)parent;
        return treeSym.getSiblingsFor(this, mask);
    }

    @Override
    public final SourceElement getSiblingBefore() {
        return this.getSiblingSymBefore();
    }

    @Override
    public final SourceElement getSiblingAfter() {
        return this.getSiblingSymAfter();
    }

    public final Sym getSiblingSymBefore() {
        if (this.symSiblingIndex <= 0) {
            return null;
        }
        Sym parent = this.getParentSym();
        if (parent == null) {
            return null;
        }
        if (parent == this.symFile) {
            parent = this.symFile.getRoot();
        }
        TreeSym treeSym = (TreeSym)parent;
        return treeSym.getSiblingBeforeFor(this);
    }

    public final Sym getSiblingSymAfter() {
        if (this.symSiblingIndex < 0) {
            return null;
        }
        Sym parent = this.getParentSym();
        if (parent == null) {
            return null;
        }
        if (parent == this.symFile) {
            parent = this.symFile.getRoot();
        }
        TreeSym treeSym = (TreeSym)parent;
        return treeSym.getSiblingAfterFor(this);
    }

    @Override
    public final boolean isSourceElement() {
        return true;
    }

    public final SourceElement getSourceSymbol() {
        return this;
    }

    @Override
    public final SourceElement getSourceElement() {
        return this.getSourceSymbol();
    }

    @Override
    public JavaElement getOwner() {
        Sym sym = this.symParent;
        while (sym != null) {
            if (sym instanceof ObjectSym) {
                return sym;
            }
            sym = sym.symParent;
        }
        return null;
    }

    @Override
    public boolean isDeprecated() {
        return false;
    }

    @Override
    public boolean isHidden() {
        return false;
    }

    public boolean hasDeprecatedTag() {
        return false;
    }

    public boolean hasHiddenTag() {
        return false;
    }

    @Override
    public JavaElement getCompiledObject() {
        return null;
    }

    public boolean isProcessed() {
        return false;
    }

    @Override
    public final void resolve() {
        if (this.isProcessed()) {
            return;
        }
        CallerContextImpl callerContext = this.getContextImpl();
        CompilerDriver compiler = callerContext != null ? callerContext.compiler : this.symFile.getCompiler();
        if (compiler == null) {
            return;
        }
        this.resolve(compiler);
    }

    @Override
    public final void compile() {
        CompilerDriver compiler = this.symKind == 11 ? this.symFile.createCompiler() : this.symFile.getCompiler();
        if (compiler == null) {
            return;
        }
        this.compile(compiler);
    }

    public void clearOffsets() {
        this.symStart = -1;
        this.symEnd = -1;
    }

    public void clearCompiledInfo() {
        this.symData = null;
    }

    protected void clearFormatInfo() {
        this.symFormat = '\u0000';
        this.clearBinding(4);
        this.clearBinding(5);
    }

    @Override
    public String printCompiledInfo() {
        return "";
    }

    public final String toString() {
        return this.verbose();
    }

    public int compareTo(Sym other) {
        if (this == other) {
            return 0;
        }
        int start1 = this.symStart;
        int start2 = other.symStart;
        if (start1 != start2) {
            return start1 - start2;
        }
        int end1 = this.symEnd;
        int end2 = other.symEnd;
        if (end1 != end2) {
            return end2 - end1;
        }
        int depth1 = this.getDepth();
        int depth2 = other.getDepth();
        return depth1 - depth2;
    }

    public int compareTo(Object o) {
        return this.compareTo((Sym)o);
    }

    @Override
    public int getBindingType() {
        return 5;
    }

    public void buildSelf() {
        this.symData = null;
    }

    public void sortSelf() {
    }

    public void addToSubtree(Sym sym) {
    }

    protected void distributeChildren(Sym[] kids, int start, int end) {
    }

    protected int indexSelf(Sym[] index, int pos, TokenArray tokens) {
        if (!this.isSynthetic() && (this.symFlags & 2) == 0) {
            while (pos <= this.symEnd) {
                index[pos++] = this;
            }
        }
        return pos;
    }

    protected void removeSelf(TextBuffer textBuffer) {
        int startOffset = this.getStartOffset();
        int endOffset = this.getEndOffset();
        textBuffer.remove(startOffset, endOffset - startOffset);
    }

    @Override
    public final void visitSelf(SourceVisitor visitor) {
        this.traverseSelf(visitor);
    }

    protected final void adjustSelf(Sym other) {
        this.mapSelf(other);
        this.traverseSelf(SymAdjustTraversal.singleton);
    }

    protected void adjustSelfImpl(Sym other) {
        this.symStart = other.symStart;
        this.symEnd = other.symEnd;
    }

    protected final void mapSelf(Sym other) {
        this.traverseDual(other, SymMappingDualTraversal.singleton);
    }

    protected final void mapSelfImpl(Sym other) {
        this.setMapping(other);
        other.setMapping(this);
    }

    public boolean traverseSelf(SymTraversal traverse) {
        try {
            traverse.enter(this);
            boolean bl = traverse.leave(this);
            return bl;
        }
        catch (TraversalCancelledException e) {
            boolean bl = false;
            return bl;
        }
    }

    protected boolean traverseDual(Sym other, SymDualTraversal traverse) {
        try {
            traverse.enter(this, other);
            boolean bl = traverse.leave(this, other);
            return bl;
        }
        catch (TraversalCancelledException e) {
            boolean bl = false;
            return bl;
        }
    }

    public final boolean testSymFlag(byte mask) {
        return (this.symFlags & mask) != 0;
    }

    public final boolean isScope() {
        return this.testSymFlag((byte)1);
    }

    public final boolean isInvisible() {
        return this.testSymFlag((byte)2);
    }

    public final boolean isSkeleton() {
        return this.testSymFlag((byte)4);
    }

    public final boolean is(byte filter) {
        if (1 <= filter && filter < 79) {
            return this.symKind == filter;
        }
        switch (filter) {
            case 79: {
                return isMemberD[this.symKind];
            }
            case 80: {
                return isMemberD[this.symKind] && this.symKind != 5;
            }
            case 81: {
                return isBlockElem[this.symKind];
            }
            case 82: {
                return Sym.srcIsStmt(this.symKind);
            }
            case 83: {
                return Sym.srcIsExpr(this.symKind);
            }
            case 84: {
                return this.isScope();
            }
            case 85: {
                return this.isSkeleton();
            }
            case 86: {
                return this.symKind == 62 || this.symKind == 65;
            }
            case 87: {
                return 62 <= this.symKind && this.symKind < 69;
            }
            case 88: {
                return 69 <= this.symKind && this.symKind < 72;
            }
            case 89: {
                return this.symKind == 57 && this.is((byte)85);
            }
            case 90: {
                return this.symKind == 10 || this.symKind == 7;
            }
            case 91: {
                return this.is((byte)10);
            }
            case 92: {
                return this.is((byte)17);
            }
        }
        return true;
    }

    protected final String verbose() {
        StringBuilder stringBuffer = new StringBuilder();
        stringBuffer.append(SymFactory.describe(this.symKind));
        stringBuffer.append(" (");
        stringBuffer.append(this.symKind);
        stringBuffer.append(") [");
        stringBuffer.append(this.getStartOffset());
        stringBuffer.append('-');
        stringBuffer.append(this.getEndOffset() - 1);
        stringBuffer.append(']');
        stringBuffer.append(" [");
        stringBuffer.append(this.symStart);
        stringBuffer.append('-');
        stringBuffer.append(this.symEnd);
        stringBuffer.append(']');
        this.verboseSelf(stringBuffer);
        return stringBuffer.toString();
    }

    protected void verboseSelf(StringBuilder stringBuffer) {
    }

    public void describeSelf(int depth) {
        int i = 0;
        while (i < depth) {
            System.err.print("..");
            ++i;
        }
        System.err.print("+-");
        System.err.println(this.verbose());
    }

    public final int getDepth() {
        int count = 0;
        Sym sym = this.symParent;
        while (sym != null) {
            ++count;
            sym = sym.symParent;
        }
        return count;
    }

    public Sym getScope() {
        Sym sym = this.symParent;
        if (sym == null) {
            return null;
        }
        if (sym.is((byte)84)) {
            return sym;
        }
        return sym.getScope();
    }

    public final ClassSym getOwningClassSym() {
        Sym sym = this.symParent;
        while (sym != null) {
            if (sym.symKind == 3) {
                return (ClassSym)sym;
            }
            sym = sym.symParent;
        }
        return null;
    }

    public final MemberSym getOwningMemberSym() {
        Sym sym = this.symParent;
        while (sym != null) {
            if (sym.is((byte)79)) {
                return (MemberSym)sym;
            }
            sym = sym.symParent;
        }
        return null;
    }

    protected final boolean isAttached() {
        Sym sym = this;
        while (sym.symParent != null) {
            sym = sym.symParent;
        }
        return sym == this.symFile;
    }

    public Sym getChildAt(int offset) {
        return null;
    }

    protected final boolean hasSyntaxData() {
        return this.symData != null && this.symData.getBindingType() == 1;
    }

    protected boolean hasObjData() {
        return this.symData != null && this.symData.getBindingType() == 2;
    }

    public final JavaElement resolve(CompilerDriver compiler) {
        return this.resolveImpl(compiler);
    }

    public final JavaElement compile(CompilerDriver compiler) {
        UsageHook hook = compiler.getUsageHook();
        if (hook != null && !hook.shouldTraverse(this)) {
            return null;
        }
        return this.compileImpl(compiler);
    }

    protected JavaElement resolveImpl(CompilerDriver compiler) {
        return this.getCompiledObject();
    }

    protected JavaElement compileImpl(CompilerDriver compiler) {
        return this.resolveImpl(compiler);
    }

    protected void setAccess(char access) {
        char oldAccess = this.symAccess;
        if (access == oldAccess) {
            return;
        }
        this.setAccessImpl(access);
        this.setAccessTrigger(oldAccess);
    }

    protected final void setAccessImpl(char access) {
        if (!this.isValidAccess(access)) {
            Sym.unsupported("Illegal access mask");
        }
        SymTransaction transaction = this.verifyTransaction();
        SymOperation op = transaction.newOperation((byte)4);
        op.opTarget = this;
        op.symAccess = this.symAccess;
        this.symAccess = access;
        this.symFormat = (char)(this.symFormat | 8);
        op.buildSelf();
    }

    protected void linkSelfTrigger(TreeSym parent, byte filter) {
        Sym sym = parent;
        while (sym != null) {
            if (sym == this) {
                Sym.errorCycle(this);
            }
            sym = sym.symParent;
        }
    }

    protected void unlinkSelfTrigger(TreeSym parent, byte filter) {
        this.saveText(parent);
        this.symSiblingIndex = -1;
    }

    protected void setAccessTrigger(char oldAccess) {
    }

    public final void saveText() {
        this.saveText((TreeSym)null);
    }

    private void saveText(TreeSym parent) {
        if (!this.isSynthetic() && this.symStart != -1 && this.getBinding(4) == null) {
            String text = this.getText();
            this.saveText(text, parent);
        }
    }

    public final void saveText(ReadTextBuffer textBuffer) {
        int startOffset = this.getStartOffset();
        int endOffset = this.getEndOffset();
        if (startOffset >= 0 && startOffset <= endOffset) {
            String text = textBuffer.getString(startOffset, endOffset - startOffset);
            this.saveText(text, null);
            return;
        }
        try {
            Sym.panic("Invalid offsets");
        }
        catch (IllegalStateException e) {
            e.printStackTrace();
        }
    }

    public final void saveText(SymText text) {
        this.symFormat = (char)(this.symFormat | 4);
        this.setBinding(text);
    }

    public final SymText unsaveText() {
        this.symFormat = (char)(this.symFormat & 0xFFFFFFFB);
        SymText text = (SymText)this.getBinding(4);
        if (text != null) {
            this.clearBinding(4);
        }
        return text;
    }

    private final void saveText(String s, TreeSym parent) {
        Sym parentSym;
        if (parent == null && (parentSym = this.getParentSym()) instanceof TreeSym) {
            parent = (TreeSym)parentSym;
        }
        SymText symText = new SymText(s, parent);
        this.setBinding(symText);
        this.symFormat = (char)(this.symFormat | 4);
    }

    protected boolean isValidChild(Sym target, byte filter) {
        switch (target.symKind) {
            case 71: {
                return true;
            }
            case 69: 
            case 70: {
                return true;
            }
        }
        return false;
    }

    protected boolean isValidAccess(char access) {
        return access == '\u0000' || access == '\u1000';
    }

    public boolean checkSourceSanity() {
        return true;
    }

    public final SymTransaction verifyTransaction() {
        SymTransaction transaction = this.symFile.getTransactionSym();
        if (transaction == null) {
            Sym.unsupported("Must be in a transaction");
        }
        return transaction;
    }

    protected final void ensureSavepoint() {
        if (this.symFile.flag_noAutoSavepoint()) {
            return;
        }
        if (!this.isAttached()) {
            return;
        }
        SymTransaction transaction = this.symFile.getTransactionSym();
        if (transaction == null) {
            return;
        }
        transaction.checkSavepoint();
    }

    protected void checkCloneable() {
    }

    @Override
    public final SourceElement cloneSelf(SourceFile targetFile) {
        this.checkCloneable();
        FileSym fileSym = (FileSym)targetFile;
        Sym sym = this.cloneSelf(fileSym);
        this.clearFormatInfo();
        sym.symFile = this.symFile;
        sym.symStart = this.symStart;
        sym.symEnd = this.symEnd;
        sym.saveText();
        sym.symFile = fileSym;
        sym.symStart = -1;
        sym.symEnd = -1;
        return sym;
    }

    protected Sym cloneSelfImpl(FileSym targetFile) {
        return SymFactory.createNode(targetFile, this.symKind);
    }

    public Sym cloneSelf(FileSym targetFile) {
        Sym sym = this.cloneSelfImpl(targetFile);
        sym.symStart = -1;
        sym.symEnd = -1;
        sym.symFlags = this.symFlags;
        sym.symAccess = this.symAccess;
        sym.symFormat = (char)(sym.symFormat | 2);
        sym.setMapping(this);
        return sym;
    }

    public void qualifySelf() {
    }

    @Override
    public final void reformatSelf(int formatMask) {
        if (this == this.symFile) {
            this.symFile.reformatSubtree(this.symFile.getRoot(), formatMask);
        } else {
            this.symFile.reformatSubtree(this, formatMask);
        }
    }

    public boolean checkSafeToInsert() {
        return false;
    }

    public boolean checkSafeToDelete(TreeSym parent) {
        return false;
    }

    public int getFormatInsertOffset() {
        TreeSym parent = (TreeSym)this.symParent;
        Sym[] treeChildren = parent.treeChildren;
        int count = treeChildren.length;
        if (count < 2) {
            return -1;
        }
        int index = parent.indexOf(this);
        if (index == -1) {
            Sym.errorInvalidParent();
        }
        if (parent.symKind == 73) {
            int next = index + 1;
            while (next < count) {
                Sym nextChild = treeChildren[next];
                if (nextChild.symKind != this.symKind) break;
                if (nextChild.symStart != -1) {
                    return nextChild.getFormatStartOffsetImpl();
                }
                ++next;
            }
            int prev = index - 1;
            while (0 <= prev) {
                Sym prevChild = treeChildren[prev];
                if (prevChild.symKind != this.symKind) break;
                if (prevChild.symStart != -1) {
                    return prevChild.getFormatEndOffsetImpl();
                }
                --prev;
            }
            if (next < count) {
                return treeChildren[next].getFormatStartOffsetImpl();
            }
            if (0 <= prev) {
                return treeChildren[prev].getFormatEndOffsetImpl();
            }
            if (index == count - 1) {
                return parent.getEndOffset();
            }
            return parent.getStartOffset();
        }
        if (index + 1 == treeChildren.length) {
            return treeChildren[index - 1].getFormatEndOffsetImpl();
        }
        return treeChildren[index + 1].getFormatStartOffsetImpl();
    }

    public final int getFormatStartOffset() {
        boolean endsOnLineByItself;
        boolean bl = endsOnLineByItself = this.getEndOffset() != this.getFormatEndOffsetImpl();
        if (endsOnLineByItself) {
            return this.getFormatStartOffsetImpl();
        }
        return this.getStartOffset();
    }

    public final int getFormatEndOffset() {
        return this.getFormatEndOffsetImpl();
    }

    protected final int getFormatStartOffsetImpl() {
        SymText symText;
        int startOffset = this.getStartOffset();
        if (startOffset == -1) {
            return -1;
        }
        Sym parent = this.symParent;
        if (this.symParent == null && (symText = (SymText)this.getBinding(4)) != null) {
            parent = symText.parent;
        }
        if (parent != null && this.getStartIndex() == parent.getStartIndex()) {
            return startOffset;
        }
        TextBuffer textBuffer = this.symFile.getTextBuffer();
        if (textBuffer == null) {
            return startOffset;
        }
        int pos = startOffset;
        while (pos > 0) {
            char ch = textBuffer.getChar(pos - 1);
            switch (ch) {
                case '\n': {
                    return pos;
                }
            }
            if (!Character.isWhitespace(ch)) {
                return startOffset;
            }
            --pos;
        }
        return 0;
    }

    protected final int getFormatEndOffsetImpl() {
        SymText symText;
        int endIndex = this.getEndIndex();
        if (endIndex == -1) {
            return this.getEndOffset();
        }
        Sym parent = this.symParent;
        if (this.symParent == null && (symText = (SymText)this.getBinding(4)) != null) {
            parent = symText.parent;
        }
        if (parent != null && this.getEndIndex() == parent.getEndIndex()) {
            return this.getEndOffset();
        }
        TokenArray tokens = this.symFile.tokens;
        if (tokens.tokenCount <= endIndex + 1) {
            return tokens.tokenEnds[tokens.tokenCount - 1];
        }
        int endOffset = this.getEndOffset();
        TextBuffer textBuffer = this.symFile.getTextBuffer();
        if (textBuffer == null) {
            return endOffset;
        }
        int nextStart = tokens.tokenStarts[endIndex + 1];
        int startOffset = this.getStartOffset();
        boolean onLineByItself = startOffset == 0 || startOffset != this.getFormatStartOffsetImpl() || textBuffer.getChar(startOffset - 1) == '\n';
        int pos = endOffset;
        while (pos < nextStart) {
            char ch = textBuffer.getChar(pos);
            switch (ch) {
                case '\n': {
                    if (onLineByItself) {
                        return pos + 1;
                    }
                    return pos;
                }
            }
            ++pos;
        }
        return nextStart;
    }

    protected static void print(Sym sym, PrintWriter out, int argument) {
        if (sym == null) {
            return;
        }
        sym.print(out, argument);
    }

    protected static void print(Sym sym, PrintWriter out) {
        if (sym == null) {
            return;
        }
        sym.print(out);
    }

    protected void printSelf(FormatDriver out) {
        out.print(this);
    }

    public final void print(FormatDriver out) {
        out.enter(this);
        try {
            try {
                this.printSelf(out);
            }
            catch (NullPointerException e) {
                e.printStackTrace();
            }
            catch (ClassCastException e) {
                e.printStackTrace();
            }
            catch (RuntimeException e) {
                e.printStackTrace();
                throw e;
            }
        }
        finally {
            out.leave(this);
        }
    }

    @Override
    public final void print(PrintWriter out) {
        Emitter emitter = Emitter.createRegularEmitter();
        FormatDriver formatter = new FormatDriver(this.symFile, emitter);
        formatter.init(this);
        try {
            this.print(formatter);
        }
        finally {
            formatter.fini(this);
        }
        out.print(emitter.toString());
    }

    @Override
    public void print(PrintWriter out, int argument) {
        this.print(out);
    }

    protected final void print_modifiers(PrintWriter out) {
        if ((this.symAccess & '\u0001') != 0) {
            out.print(Sym.kw2text((short)128) + ' ');
        }
        if ((this.symAccess & 2) != 0) {
            out.print(Sym.kw2text((short)126) + ' ');
        }
        if ((this.symAccess & 4) != 0) {
            out.print(Sym.kw2text((short)127) + ' ');
        }
        if ((this.symAccess & 8) != 0) {
            out.print(Sym.kw2text((short)131) + ' ');
        }
        if ((this.symAccess & 0x10) != 0) {
            out.print(Sym.kw2text((short)111) + ' ');
        }
        if (this.symKind != 3 && (this.symAccess & 0x20) != 0) {
            out.print(Sym.kw2text((short)135) + ' ');
        }
        if (this.symKind == 9) {
            if ((this.symAccess & 0x40) != 0) {
                out.print(Sym.kw2text((short)142) + ' ');
            }
            if ((this.symAccess & 0x80) != 0) {
                out.print(Sym.kw2text((short)139) + ' ');
            }
        }
        if ((this.symAccess & 0x100) != 0) {
            out.print(Sym.kw2text((short)123) + ' ');
        }
        if ((this.symAccess & 0x400) != 0) {
            out.print(Sym.kw2text((short)96) + ' ');
        }
        if ((this.symAccess & 0x800) != 0) {
            out.print(Sym.kw2text((short)132) + ' ');
        }
    }

    @Override
    public SourceElement[] getContainedElements() {
        List children = this.getChildren();
        int count = children.size();
        return children.toArray(new SourceElement[count]);
    }

    public Sym() {
        this.$init$();
    }

    private static class SymAdjustTraversal
    extends SymTraversal {
        protected static final SymAdjustTraversal singleton = new SymAdjustTraversal();

        protected boolean leave(Sym sym) {
            Sym other = sym.getMapping();
            if (other != null) {
                sym.adjustSelfImpl(other);
            }
            return true;
        }

        private SymAdjustTraversal() {
        }
    }

    private static class SymMappingDualTraversal
    extends SymDualTraversal {
        protected static final SymMappingDualTraversal singleton = new SymMappingDualTraversal();

        protected boolean enter(Sym sym, Sym other) {
            sym.mapSelfImpl(other);
            return true;
        }

        private SymMappingDualTraversal() {
        }
    }

    public static abstract class SymTraversal
    extends SymUtilities {
        protected boolean enter(Sym sym) {
            return true;
        }

        protected boolean leave(Sym sym) {
            return true;
        }
    }

    public static class TraversalCancelledException
    extends RuntimeException {
    }

    public static abstract class SymDualTraversal
    extends SymUtilities {
        protected boolean enter(Sym sym, Sym other) {
            return true;
        }

        protected boolean leave(Sym sym, Sym other) {
            return true;
        }
    }
}

