/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.internal.symbol;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.buffer.TextBufferFactory;
import oracle.javatools.parser.java.v2.JavaConstants;
import oracle.javatools.parser.java.v2.SourceFactory;
import oracle.javatools.parser.java.v2.common.CommonUtilities;
import oracle.javatools.parser.java.v2.common.PrimitiveType;
import oracle.javatools.parser.java.v2.internal.InternalConstants;
import oracle.javatools.parser.java.v2.internal.parser.ParserDriver;
import oracle.javatools.parser.java.v2.internal.parser.SyntaxData;
import oracle.javatools.parser.java.v2.internal.symbol.AnnotateSym;
import oracle.javatools.parser.java.v2.internal.symbol.BlanklineSym;
import oracle.javatools.parser.java.v2.internal.symbol.BlockSym;
import oracle.javatools.parser.java.v2.internal.symbol.ClassBodySym;
import oracle.javatools.parser.java.v2.internal.symbol.ClassSym;
import oracle.javatools.parser.java.v2.internal.symbol.CommentSym;
import oracle.javatools.parser.java.v2.internal.symbol.EnumConstantSym;
import oracle.javatools.parser.java.v2.internal.symbol.ErrorSym;
import oracle.javatools.parser.java.v2.internal.symbol.FieldDeclSym;
import oracle.javatools.parser.java.v2.internal.symbol.FieldSym;
import oracle.javatools.parser.java.v2.internal.symbol.FileSym;
import oracle.javatools.parser.java.v2.internal.symbol.FormalParameterSym;
import oracle.javatools.parser.java.v2.internal.symbol.FormalsSym;
import oracle.javatools.parser.java.v2.internal.symbol.ImportSym;
import oracle.javatools.parser.java.v2.internal.symbol.InitializerSym;
import oracle.javatools.parser.java.v2.internal.symbol.InterfacesSym;
import oracle.javatools.parser.java.v2.internal.symbol.LabelSym;
import oracle.javatools.parser.java.v2.internal.symbol.LocalVardeclSym;
import oracle.javatools.parser.java.v2.internal.symbol.LocalVariableSym;
import oracle.javatools.parser.java.v2.internal.symbol.MethodSym;
import oracle.javatools.parser.java.v2.internal.symbol.NameSym;
import oracle.javatools.parser.java.v2.internal.symbol.PackageSym;
import oracle.javatools.parser.java.v2.internal.symbol.PlaceholderSym;
import oracle.javatools.parser.java.v2.internal.symbol.RootSym;
import oracle.javatools.parser.java.v2.internal.symbol.SqljSym;
import oracle.javatools.parser.java.v2.internal.symbol.SuperclassSym;
import oracle.javatools.parser.java.v2.internal.symbol.SwitchLabelSym;
import oracle.javatools.parser.java.v2.internal.symbol.Sym;
import oracle.javatools.parser.java.v2.internal.symbol.ThrowsClauseSym;
import oracle.javatools.parser.java.v2.internal.symbol.TreeSym;
import oracle.javatools.parser.java.v2.internal.symbol.TypeArgumentSym;
import oracle.javatools.parser.java.v2.internal.symbol.TypeParameterSym;
import oracle.javatools.parser.java.v2.internal.symbol.TypeSym;
import oracle.javatools.parser.java.v2.internal.symbol.doc.DocBlockTagSym;
import oracle.javatools.parser.java.v2.internal.symbol.doc.DocCommentSym;
import oracle.javatools.parser.java.v2.internal.symbol.doc.DocDescriptionSym;
import oracle.javatools.parser.java.v2.internal.symbol.doc.DocInlineTagSym;
import oracle.javatools.parser.java.v2.internal.symbol.doc.DocReferenceSym;
import oracle.javatools.parser.java.v2.internal.symbol.doc.DocSym;
import oracle.javatools.parser.java.v2.internal.symbol.doc.DocTagNameSym;
import oracle.javatools.parser.java.v2.internal.symbol.doc.DocTextFragmentSym;
import oracle.javatools.parser.java.v2.internal.symbol.expr.AnnotateExpr;
import oracle.javatools.parser.java.v2.internal.symbol.expr.ArrayAccessExpr;
import oracle.javatools.parser.java.v2.internal.symbol.expr.ArrayCreatorExpr;
import oracle.javatools.parser.java.v2.internal.symbol.expr.AssignExpr;
import oracle.javatools.parser.java.v2.internal.symbol.expr.ClassCreatorExpr;
import oracle.javatools.parser.java.v2.internal.symbol.expr.DotExpr;
import oracle.javatools.parser.java.v2.internal.symbol.expr.Expr;
import oracle.javatools.parser.java.v2.internal.symbol.expr.InfixExpr;
import oracle.javatools.parser.java.v2.internal.symbol.expr.ListExpr;
import oracle.javatools.parser.java.v2.internal.symbol.expr.LiteralExpr;
import oracle.javatools.parser.java.v2.internal.symbol.expr.MethodCallExpr;
import oracle.javatools.parser.java.v2.internal.symbol.expr.QuestionExpr;
import oracle.javatools.parser.java.v2.internal.symbol.expr.SimpleNameExpr;
import oracle.javatools.parser.java.v2.internal.symbol.expr.TypeExpr;
import oracle.javatools.parser.java.v2.internal.symbol.expr.TypecastExpr;
import oracle.javatools.parser.java.v2.internal.symbol.expr.UnaryExpr;
import oracle.javatools.parser.java.v2.internal.symbol.expr.WrapperExpr;
import oracle.javatools.parser.java.v2.internal.symbol.stmt.AssertStmt;
import oracle.javatools.parser.java.v2.internal.symbol.stmt.BlockStmt;
import oracle.javatools.parser.java.v2.internal.symbol.stmt.BreakStmt;
import oracle.javatools.parser.java.v2.internal.symbol.stmt.CatchStmt;
import oracle.javatools.parser.java.v2.internal.symbol.stmt.ContinueStmt;
import oracle.javatools.parser.java.v2.internal.symbol.stmt.DoStmt;
import oracle.javatools.parser.java.v2.internal.symbol.stmt.ElseStmt;
import oracle.javatools.parser.java.v2.internal.symbol.stmt.EmptyStmt;
import oracle.javatools.parser.java.v2.internal.symbol.stmt.ExpressionStmt;
import oracle.javatools.parser.java.v2.internal.symbol.stmt.FinallyStmt;
import oracle.javatools.parser.java.v2.internal.symbol.stmt.ForStmt;
import oracle.javatools.parser.java.v2.internal.symbol.stmt.IfStmt;
import oracle.javatools.parser.java.v2.internal.symbol.stmt.ReturnStmt;
import oracle.javatools.parser.java.v2.internal.symbol.stmt.SwitchStmt;
import oracle.javatools.parser.java.v2.internal.symbol.stmt.SynchStmt;
import oracle.javatools.parser.java.v2.internal.symbol.stmt.ThrowStmt;
import oracle.javatools.parser.java.v2.internal.symbol.stmt.TryStmt;
import oracle.javatools.parser.java.v2.internal.symbol.stmt.WhileStmt;
import oracle.javatools.parser.java.v2.model.SourceAnnotation;
import oracle.javatools.parser.java.v2.model.SourceBlock;
import oracle.javatools.parser.java.v2.model.SourceBlockElement;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceClassBody;
import oracle.javatools.parser.java.v2.model.SourceClassInitializer;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceEnumConstant;
import oracle.javatools.parser.java.v2.model.SourceFieldDeclaration;
import oracle.javatools.parser.java.v2.model.SourceFieldVariable;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceFormalParameter;
import oracle.javatools.parser.java.v2.model.SourceFormalParameterList;
import oracle.javatools.parser.java.v2.model.SourceImport;
import oracle.javatools.parser.java.v2.model.SourceInterfacesClause;
import oracle.javatools.parser.java.v2.model.SourceLexicalBlankline;
import oracle.javatools.parser.java.v2.model.SourceLexicalComment;
import oracle.javatools.parser.java.v2.model.SourceLocalVariable;
import oracle.javatools.parser.java.v2.model.SourceLocalVariableDeclaration;
import oracle.javatools.parser.java.v2.model.SourceMember;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.javatools.parser.java.v2.model.SourceName;
import oracle.javatools.parser.java.v2.model.SourcePackage;
import oracle.javatools.parser.java.v2.model.SourceSuperclassClause;
import oracle.javatools.parser.java.v2.model.SourceThrowsClause;
import oracle.javatools.parser.java.v2.model.SourceTypeArgument;
import oracle.javatools.parser.java.v2.model.SourceTypeParameter;
import oracle.javatools.parser.java.v2.model.SourceTypeReference;
import oracle.javatools.parser.java.v2.model.doc.SourceDocBlockTag;
import oracle.javatools.parser.java.v2.model.doc.SourceDocComment;
import oracle.javatools.parser.java.v2.model.doc.SourceDocDescription;
import oracle.javatools.parser.java.v2.model.doc.SourceDocInlineTag;
import oracle.javatools.parser.java.v2.model.doc.SourceDocReference;
import oracle.javatools.parser.java.v2.model.doc.SourceDocTagName;
import oracle.javatools.parser.java.v2.model.doc.SourceDocTextFragment;
import oracle.javatools.parser.java.v2.model.expression.SourceAnnotationExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceArrayAccessExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceAssignmentExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceDotExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceInfixExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceListExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceMethodCallExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceNewArrayExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceNewClassExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceQuestionExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceSimpleNameExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceTypeExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceTypecastExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceUnaryExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceWrapperExpression;
import oracle.javatools.parser.java.v2.model.statement.SourceAssertStatement;
import oracle.javatools.parser.java.v2.model.statement.SourceBlockStatement;
import oracle.javatools.parser.java.v2.model.statement.SourceBreakStatement;
import oracle.javatools.parser.java.v2.model.statement.SourceCatchClause;
import oracle.javatools.parser.java.v2.model.statement.SourceContinueStatement;
import oracle.javatools.parser.java.v2.model.statement.SourceDoStatement;
import oracle.javatools.parser.java.v2.model.statement.SourceElseClause;
import oracle.javatools.parser.java.v2.model.statement.SourceEmptyStatement;
import oracle.javatools.parser.java.v2.model.statement.SourceExpressionStatement;
import oracle.javatools.parser.java.v2.model.statement.SourceFinallyClause;
import oracle.javatools.parser.java.v2.model.statement.SourceForStatement;
import oracle.javatools.parser.java.v2.model.statement.SourceIfStatement;
import oracle.javatools.parser.java.v2.model.statement.SourceReturnStatement;
import oracle.javatools.parser.java.v2.model.statement.SourceStatement;
import oracle.javatools.parser.java.v2.model.statement.SourceStatementLabel;
import oracle.javatools.parser.java.v2.model.statement.SourceSwitchLabel;
import oracle.javatools.parser.java.v2.model.statement.SourceSwitchStatement;
import oracle.javatools.parser.java.v2.model.statement.SourceSynchStatement;
import oracle.javatools.parser.java.v2.model.statement.SourceThrowStatement;
import oracle.javatools.parser.java.v2.model.statement.SourceTryStatement;
import oracle.javatools.parser.java.v2.model.statement.SourceWhileStatement;

public final class SymFactory
extends SourceFactory
implements InternalConstants {
    private final FileSym symFile;

    public static FileSym createFile() {
        FileSym fileSym = new FileSym();
        fileSym.symKind = (byte)11;
        return fileSym;
    }

    public SourceElement createSourceElement(int kind) {
        Sym sym = SymFactory.createNode(this.symFile, kind);
        sym.symFormat = (char)(sym.symFormat | 2);
        return sym;
    }

    public SourceExpression createExpression(int code) {
        Expr e = SymFactory.createExpr(this.symFile, (byte)code);
        return e;
    }

    public SourceFile getSourceFile() {
        return this.symFile;
    }

    public SourceName createName(String name) {
        return this.createNameSym(name);
    }

    protected SourceName createSimpleName(String name) {
        return this.createSimpleNameSym(name);
    }

    private NameSym createSimpleNameSym(String name) {
        if (CommonUtilities.isValidSimpleName(name)) {
            return this.createNameSymImpl(name);
        }
        throw new IllegalArgumentException("Not a valid simple name: " + name);
    }

    private NameSym createNameSym(String name) {
        if (CommonUtilities.isValidQualifiedName(name)) {
            return this.createNameSymImpl(name);
        }
        throw new IllegalArgumentException("Not a valid qualified name: " + name);
    }

    private NameSym createNameSymImpl(String name) {
        NameSym nameSym = (NameSym)SymFactory.createNode(this.symFile, 20);
        nameSym.nameString = name;
        nameSym.symFormat = (char)(nameSym.symFormat | 2);
        return nameSym;
    }

    protected SourceTypeReference createTypeImpl(String name, int dimensions) {
        if (CommonUtilities.containsClassThisSuper(name)) {
            throw new IllegalArgumentException("Not a valid type name: " + name);
        }
        NameSym nameSym = this.createNameSymImpl(name);
        TypeSym sym = (TypeSym)SymFactory.createNode(this.symFile, 27);
        PrimitiveType primitive = PrimitiveType.lookupPrimitive(name);
        if (primitive != null) {
            sym.typeToken = JavaConstants.PRIMITIVE_tokens[primitive.primCode];
        }
        sym.treeChildren = new Sym[]{nameSym};
        sym.typeBaseDimension = (short)dimensions;
        SymFactory.finishSym(sym);
        return sym;
    }

    public SourceTypeArgument createTypeArgument(int bound, SourceTypeReference type) {
        TypeArgumentSym sym = (TypeArgumentSym)SymFactory.createNode(this.symFile, 25);
        if (type != null) {
            sym.treeChildren = new Sym[]{(Sym)((Object)type)};
        }
        sym.argBound = (byte)bound;
        SymFactory.finishSym(sym);
        return sym;
    }

    public SourceLexicalComment createComment(String text) {
        CommentSym sym = (CommentSym)SymFactory.createNode(this.symFile, 69);
        if (text.startsWith("/**")) {
            sym.tokenValue = (short)26;
        } else if (text.startsWith("/*")) {
            sym.tokenValue = (short)25;
        } else if (text.startsWith("//")) {
            sym.tokenValue = (short)24;
        } else {
            throw new IllegalArgumentException(text);
        }
        sym.symFlags = (byte)(sym.symFlags | 0x40);
        sym.tokenText = text;
        SymFactory.finishSym(sym);
        return sym;
    }

    public SourceLexicalBlankline createBlankline() {
        BlanklineSym sym = (BlanklineSym)SymFactory.createNode(this.symFile, 70);
        SymFactory.finishSym(sym);
        return sym;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Sym createFromText(String text, byte inputKind) {
        if (text == null) {
            return null;
        }
        TextBuffer textBuffer = TextBufferFactory.createArrayTextBuffer();
        textBuffer.insert(0, text.toCharArray());
        try {
            ParserDriver parser = new ParserDriver();
            parser.setTextBuffer(textBuffer);
            FileSym fileSym = this.symFile;
            synchronized (fileSym) {
                Sym sym = parser.parseIsolated(this.symFile, 0, inputKind);
                if (sym != null) {
                    sym.symFormat = (char)(sym.symFormat | 2);
                }
                Sym sym2 = sym;
                return sym2;
            }
        }
        catch (RuntimeException e) {
            Sym sym = null;
            return sym;
        }
    }

    public final SourceAnnotation createAnnotationFromText(String text) {
        try {
            SourceAnnotation sourceAnnotation = (SourceAnnotation)((Object)this.createFromText(text, (byte)1));
            return sourceAnnotation;
        }
        catch (ClassCastException e) {
            SourceAnnotation sourceAnnotation = null;
            return sourceAnnotation;
        }
    }

    public final SourceBlock createBlockFromText(String text) {
        try {
            SourceBlock sourceBlock = (SourceBlock)((Object)this.createFromText(text, (byte)2));
            return sourceBlock;
        }
        catch (ClassCastException e) {
            SourceBlock sourceBlock = null;
            return sourceBlock;
        }
    }

    public final SourceBlockElement createBlockElementFromText(String text) {
        try {
            SourceBlockElement sourceBlockElement = (SourceBlockElement)((Object)this.createFromText(text, (byte)3));
            return sourceBlockElement;
        }
        catch (ClassCastException e) {
            SourceBlockElement sourceBlockElement = null;
            return sourceBlockElement;
        }
    }

    public final SourceClass createClassFromText(String text) {
        try {
            SourceClass sourceClass = (SourceClass)((Object)this.createFromText(text, (byte)4));
            return sourceClass;
        }
        catch (ClassCastException e) {
            SourceClass sourceClass = null;
            return sourceClass;
        }
    }

    public final SourceDocBlockTag createDocBlockTagFromText(String text) {
        if (text == null) {
            return null;
        }
        if (!text.startsWith("@")) {
            throw new IllegalArgumentException("Doesn't start with '@'.");
        }
        String commentText = "/** " + text + " */";
        SourceDocComment comment = this.createDocCommentFromText(commentText);
        if (comment == null) {
            return null;
        }
        List tags = comment.getBlockTags();
        if (tags.size() == 0) {
            return null;
        }
        try {
            SourceDocBlockTag tag = (SourceDocBlockTag)tags.get(0);
            tag.removeSelf();
            SourceDocBlockTag sourceDocBlockTag = tag;
            return sourceDocBlockTag;
        }
        catch (ClassCastException e) {
            SourceDocBlockTag sourceDocBlockTag = null;
            return sourceDocBlockTag;
        }
    }

    public final SourceDocComment createDocCommentFromText(String text) {
        try {
            SourceDocComment sourceDocComment = (SourceDocComment)((Object)this.createFromText(text, (byte)6));
            return sourceDocComment;
        }
        catch (ClassCastException e) {
            SourceDocComment sourceDocComment = null;
            return sourceDocComment;
        }
    }

    public final SourceDocInlineTag createDocInlineTagFromText(String text) {
        if (text == null) {
            return null;
        }
        if (!text.startsWith("{") || !text.endsWith("}")) {
            throw new IllegalArgumentException("Doesn't start with '@'.");
        }
        String commentText = "/** " + text + " */";
        SourceDocComment comment = this.createDocCommentFromText(commentText);
        if (comment == null) {
            return null;
        }
        SourceDocDescription description = comment.getDescription();
        if (description == null) {
            return null;
        }
        Collection tags = description.getInlineTags();
        if (tags.size() == 0) {
            return null;
        }
        try {
            SourceDocInlineTag tag = (SourceDocInlineTag)tags.iterator().next();
            tag.removeSelf();
            SourceDocInlineTag sourceDocInlineTag = tag;
            return sourceDocInlineTag;
        }
        catch (ClassCastException e) {
            SourceDocInlineTag sourceDocInlineTag = null;
            return sourceDocInlineTag;
        }
    }

    public final SourceExpression createExpressionFromText(String text) {
        try {
            SourceExpression sourceExpression = (SourceExpression)((Object)this.createFromText(text, (byte)5));
            return sourceExpression;
        }
        catch (ClassCastException e) {
            SourceExpression sourceExpression = null;
            return sourceExpression;
        }
    }

    public final SourceMember createMemberFromText(String text) {
        try {
            SourceMember sourceMember = (SourceMember)((Object)this.createFromText(text, (byte)7));
            return sourceMember;
        }
        catch (ClassCastException e) {
            SourceMember sourceMember = null;
            return sourceMember;
        }
    }

    public final SourceStatement createStatementFromText(String text) {
        try {
            SourceStatement sourceStatement = (SourceStatement)((Object)this.createFromText(text, (byte)8));
            return sourceStatement;
        }
        catch (ClassCastException e) {
            SourceStatement sourceStatement = null;
            return sourceStatement;
        }
    }

    public final SourceTypeReference createTypeFromText(String text) {
        try {
            if (text != null && text.indexOf("...") >= 0) {
                SourceTypeReference sourceTypeReference = null;
                return sourceTypeReference;
            }
            SourceTypeReference sourceTypeReference = (SourceTypeReference)((Object)this.createFromText(text, (byte)9));
            return sourceTypeReference;
        }
        catch (ClassCastException e) {
            SourceTypeReference sourceTypeReference = null;
            return sourceTypeReference;
        }
    }

    public final SourceDocReference createDocMemberReferenceFromText(String text) {
        String actualText = "/**\n * @see " + text + "\n" + " */";
        SourceDocComment comment = this.createDocCommentFromText(actualText);
        if (comment != null) {
            try {
                SourceDocBlockTag seeTag;
                SourceDocReference reference;
                List tags = comment.getBlockTags();
                if (tags.size() > 0 && (reference = (seeTag = (SourceDocBlockTag)tags.get(0)).getReference()) != null) {
                    reference.removeSelf();
                    SourceDocReference sourceDocReference = reference;
                    return sourceDocReference;
                }
            }
            catch (ClassCastException e) {
                // empty catch block
            }
        }
        return null;
    }

    public SourceAnnotation createAnnotation(String name, SourceListExpression arguments) {
        AnnotateSym sym = (AnnotateSym)SymFactory.createNode(this.symFile, 1);
        NameSym nameSym = this.createNameSym(name);
        sym.treeChildren = arguments != null ? new Sym[]{nameSym, (Sym)((Object)arguments)} : new Sym[]{nameSym};
        SymFactory.finishSym(sym);
        return sym;
    }

    public SourceTypeParameter createTypeParameter(String name, SourceTypeReference[] bounds) {
        TypeParameterSym sym = (TypeParameterSym)SymFactory.createNode(this.symFile, 26);
        SyntaxData data = new SyntaxData();
        data.addKid(this.createSimpleNameSym(name));
        if (bounds != null) {
            int count = bounds.length;
            int i = 0;
            while (i < count) {
                data.addKid((Sym)((Object)bounds[i]));
                ++i;
            }
        }
        sym.symData = data;
        sym.buildSelf();
        SymFactory.finishSym(sym);
        return sym;
    }

    public SourcePackage createPackageDeclaration(String name) {
        PackageSym sym = (PackageSym)SymFactory.createNode(this.symFile, 21);
        sym.treeChildren = new Sym[]{this.createNameSym(name)};
        SymFactory.finishSym(sym);
        return sym;
    }

    public SourceImport createImportDeclaration(int modifiers, String name) {
        if (!CommonUtilities.isValidImportName(name)) {
            String message = "Not a valid import string: " + name;
            throw new IllegalArgumentException(message);
        }
        ImportSym sym = (ImportSym)SymFactory.createNode(this.symFile, 14);
        sym.symAccess = (char)modifiers;
        NameSym nameSym = this.createNameSymImpl(name);
        sym.treeChildren = new Sym[]{nameSym};
        SymFactory.finishSym(sym);
        return sym;
    }

    public SourceClass createClass(int tyKind, String name, SourceTypeParameter[] tyParameters, SourceSuperclassClause superclassClause, SourceInterfacesClause interfacesClause, SourceClassBody body) {
        ClassSym sym = (ClassSym)SymFactory.createNode(this.symFile, 3);
        SyntaxData data = new SyntaxData();
        data.addKid(this.createSimpleNameSym(name));
        if (tyParameters == null) {
            tyParameters = SourceTypeParameter.EMPTY_ARRAY;
        }
        int tyParameterCount = tyParameters.length;
        int i = 0;
        while (i < tyParameterCount) {
            data.addKid((Sym)((Object)tyParameters[i]));
            ++i;
        }
        if (superclassClause != null) {
            data.addKid((Sym)((Object)superclassClause));
        }
        if (interfacesClause != null) {
            data.addKid((Sym)((Object)interfacesClause));
        }
        if (body == null) {
            body = this.createClassBody();
        }
        data.addKid((Sym)((Object)body));
        sym.symData = data;
        sym.buildSelf();
        SymFactory.finishSym(sym);
        sym.setTypeKind(tyKind);
        return sym;
    }

    public SourceMethod createConstructor(SourceTypeParameter[] typeParameters, SourceFormalParameterList parameters, SourceThrowsClause throwsClause, SourceBlock block) {
        MethodSym sym = (MethodSym)SymFactory.createNode(this.symFile, 6);
        SyntaxData data = new SyntaxData();
        Sym nameSym = (Sym)((Object)this.createName("Constructor"));
        data.addKid(nameSym);
        if (parameters == null) {
            parameters = this.createFormalParameterList();
        }
        data.addKid((Sym)((Object)parameters));
        if (throwsClause != null) {
            data.addKid((Sym)((Object)throwsClause));
        }
        if (block == null) {
            block = this.createBlock();
        }
        data.addKid((Sym)((Object)block));
        sym.symData = data;
        sym.buildSelf();
        SymFactory.finishSym(sym);
        return sym;
    }

    public SourceMethod createMethod(SourceTypeParameter[] tyParameters, SourceTypeReference returnType, String methodName, SourceFormalParameterList parameters, SourceThrowsClause throwsClause, SourceBlock block) {
        MethodSym sym = (MethodSym)SymFactory.createNode(this.symFile, 19);
        SyntaxData data = new SyntaxData();
        if (returnType == null) {
            returnType = this.createType((byte)9);
        }
        data.addKid((Sym)((Object)returnType));
        data.addKid(this.createSimpleNameSym(methodName));
        if (parameters == null) {
            parameters = this.createFormalParameterList();
        }
        data.addKid((Sym)((Object)parameters));
        if (throwsClause != null) {
            data.addKid((Sym)((Object)throwsClause));
        }
        if (block != null) {
            data.addKid((Sym)((Object)block));
        }
        sym.symData = data;
        sym.buildSelf();
        SymFactory.finishSym(sym);
        return sym;
    }

    public SourceEnumConstant createEnumConstant(String name, SourceListExpression arguments, SourceClassBody body) {
        EnumConstantSym sym = (EnumConstantSym)SymFactory.createNode(this.symFile, 7);
        SyntaxData data = new SyntaxData();
        data.addKid(this.createSimpleNameSym(name));
        if (arguments != null) {
            data.addKid((Sym)((Object)arguments));
        }
        if (body != null) {
            data.addKid((Sym)((Object)body));
        }
        sym.symData = data;
        sym.buildSelf();
        SymFactory.finishSym(sym);
        return sym;
    }

    public SourceClassInitializer createClassInitializer(int modifiers, SourceBlock block) {
        InitializerSym sym = (InitializerSym)SymFactory.createNode(this.symFile, 5);
        sym.symAccess = (char)modifiers;
        if (block == null) {
            block = this.createBlock();
        }
        sym.treeChildren = new Sym[]{(Sym)((Object)block)};
        SymFactory.finishSym(sym);
        return sym;
    }

    public SourceFieldVariable createFieldVariable(SourceLocalVariable variable) {
        LocalVariableSym varSym = (LocalVariableSym)variable;
        FieldSym sym = (FieldSym)SymFactory.createNode(this.symFile, 10);
        sym.treeChildren = varSym.treeChildren;
        int count = sym.treeChildren.length;
        int i = 0;
        while (i < count) {
            sym.treeChildren[i].symParent = null;
            ++i;
        }
        varSym.treeChildren = Sym.EMPTY_ARRAY;
        SymFactory.finishSym(sym);
        return sym;
    }

    public SourceFieldDeclaration createFieldDeclaration(SourceFieldVariable variable) {
        FieldSym varSym = (FieldSym)variable;
        FieldDeclSym sym = (FieldDeclSym)SymFactory.createNode(this.symFile, 9);
        sym.treeChildren = new Sym[]{varSym};
        sym.symAccess = varSym.symAccess;
        SymFactory.finishSym(sym);
        return sym;
    }

    public SourceFieldDeclaration createFieldDeclaration(SourceLocalVariableDeclaration locals) {
        LocalVardeclSym vardeclSym = (LocalVardeclSym)locals;
        FieldDeclSym sym = (FieldDeclSym)SymFactory.createNode(this.symFile, 9);
        sym.treeChildren = vardeclSym.treeChildren;
        vardeclSym.treeChildren = Sym.EMPTY_ARRAY;
        SymFactory.finishSym(sym);
        return sym;
    }

    public SourceSuperclassClause createSuperclassClause(SourceTypeReference superclass) {
        if (superclass == null) {
            return null;
        }
        SuperclassSym sym = (SuperclassSym)SymFactory.createNode(this.symFile, 22);
        sym.treeChildren = new Sym[]{(Sym)((Object)superclass)};
        sym.buildSelf();
        SymFactory.finishSym(sym);
        return sym;
    }

    public SourceInterfacesClause createInterfacesClause(SourceTypeReference[] interfaces) {
        if (interfaces == null) {
            interfaces = SourceTypeReference.EMPTY_ARRAY;
        }
        if (interfaces.length == 0) {
            return null;
        }
        InterfacesSym sym = (InterfacesSym)SymFactory.createNode(this.symFile, 15);
        SyntaxData data = new SyntaxData();
        int interfaceCount = interfaces.length;
        int i = 0;
        while (i < interfaceCount) {
            data.addKid((Sym)((Object)interfaces[i]));
            ++i;
        }
        sym.symData = data;
        sym.buildSelf();
        SymFactory.finishSym(sym);
        return sym;
    }

    public SourceClassBody createClassBody(SourceMember[] members) {
        ClassBodySym sym = (ClassBodySym)SymFactory.createNode(this.symFile, 4);
        int count = members.length;
        if (count > 0) {
            sym.treeChildren = new Sym[count];
            int i = 0;
            while (i < count) {
                sym.treeChildren[i] = (Sym)((Object)members[i]);
                ++i;
            }
        }
        SymFactory.finishSym(sym);
        return sym;
    }

    public SourceFormalParameter createFormalParameter(SourceLocalVariable variable) {
        LocalVariableSym varSym = (LocalVariableSym)variable;
        if ((varSym.symFormat & 2) == 0) {
            throw new UnsupportedOperationException("Only accepts newly created variables");
        }
        FormalParameterSym sym = (FormalParameterSym)SymFactory.createNode(this.symFile, 13);
        sym.treeChildren = varSym.treeChildren;
        int count = sym.treeChildren.length;
        int i = 0;
        while (i < count) {
            sym.treeChildren[i].symParent = null;
            ++i;
        }
        varSym.treeChildren = Sym.EMPTY_ARRAY;
        SymFactory.finishSym(sym);
        return sym;
    }

    public SourceFormalParameterList createFormalParameterList(SourceFormalParameter[] parameters) {
        FormalsSym sym = (FormalsSym)SymFactory.createNode(this.symFile, 12);
        int count = parameters.length;
        if (count > 0) {
            sym.treeChildren = new Sym[count];
            int i = 0;
            while (i < count) {
                sym.treeChildren[i] = (Sym)((Object)parameters[i]);
                ++i;
            }
        }
        SymFactory.finishSym(sym);
        return sym;
    }

    public SourceThrowsClause createThrowsClause(SourceTypeReference[] exceptions) {
        if (exceptions.length == 0) {
            return null;
        }
        ThrowsClauseSym sym = (ThrowsClauseSym)SymFactory.createNode(this.symFile, 24);
        int count = exceptions.length;
        sym.treeChildren = new Sym[count];
        int i = 0;
        while (i < count) {
            sym.treeChildren[i] = (Sym)((Object)exceptions[i]);
            ++i;
        }
        SymFactory.finishSym(sym);
        return sym;
    }

    public SourceLocalVariable createLocalVariable(int modifiers, SourceTypeReference type, String name, int xdimensions, SourceExpression e) {
        LocalVariableSym sym = (LocalVariableSym)SymFactory.createNode(this.symFile, 17);
        sym.treeChildren = e != null ? new Sym[]{(Sym)((Object)type), this.createSimpleNameSym(name), (Sym)((Object)e)} : new Sym[]{(Sym)((Object)type), this.createNameSym(name)};
        sym.varXDimension = (short)xdimensions;
        sym.symAccess = (char)(modifiers &= 0x10);
        sym.symFormat = (char)(sym.symFormat | 2);
        SymFactory.finishSym(sym);
        return sym;
    }

    public SourceLocalVariableDeclaration createLocalVariableDeclaration(SourceLocalVariable variable) {
        LocalVariableSym varSym = (LocalVariableSym)variable;
        LocalVardeclSym sym = (LocalVardeclSym)SymFactory.createNode(this.symFile, 18);
        sym.treeChildren = new Sym[]{(Sym)((Object)variable)};
        sym.symAccess = varSym.symAccess;
        SymFactory.finishSym(sym);
        return sym;
    }

    public SourceBlock createBlock(SourceElement[] elements) {
        BlockSym sym = (BlockSym)SymFactory.createNode(this.symFile, 2);
        int elementCount = elements.length;
        if (elementCount > 0) {
            sym.treeChildren = new Sym[elementCount];
            int i = 0;
            while (i < elementCount) {
                sym.treeChildren[i] = (Sym)elements[i];
                ++i;
            }
        }
        SymFactory.finishSym(sym);
        return sym;
    }

    public SourceAssertStatement createAssertStatement(SourceExpression condition, SourceExpression output) {
        AssertStmt sym = (AssertStmt)SymFactory.createNode(this.symFile, 28);
        sym.stmtToken = (short)144;
        sym.treeChildren = output != null ? new Sym[]{(Sym)((Object)condition), (Sym)((Object)output)} : new Sym[]{(Sym)((Object)condition)};
        SymFactory.finishSym(sym);
        return sym;
    }

    public SourceBlockStatement createBlockStatement(SourceBlock block) {
        BlockStmt sym = (BlockStmt)SymFactory.createNode(this.symFile, 29);
        if (block == null) {
            block = this.createBlock(SourceElement.EMPTY_ARRAY);
        }
        sym.treeChildren = new Sym[]{(Sym)((Object)block)};
        SymFactory.finishSym(sym);
        return sym;
    }

    public SourceBreakStatement createBreakStatement(String target) {
        BreakStmt sym = (BreakStmt)SymFactory.createNode(this.symFile, 30);
        sym.stmtToken = (short)98;
        if (target != null) {
            sym.treeChildren = new Sym[]{this.createSimpleNameSym(target)};
        }
        SymFactory.finishSym(sym);
        return sym;
    }

    public SourceCatchClause createCatchClause(SourceFormalParameterList parameters, SourceBlockStatement child) {
        CatchStmt sym = (CatchStmt)SymFactory.createNode(this.symFile, 31);
        sym.stmtToken = (short)101;
        Sym one = (Sym)((Object)this.createClause(child));
        sym.treeChildren = new Sym[]{(Sym)((Object)parameters), one};
        SymFactory.finishSym(sym);
        return sym;
    }

    public SourceContinueStatement createContinueStatement(String target) {
        ContinueStmt sym = (ContinueStmt)SymFactory.createNode(this.symFile, 32);
        sym.stmtToken = (short)105;
        if (target != null) {
            sym.treeChildren = new Sym[]{this.createNameSym(target)};
        }
        SymFactory.finishSym(sym);
        return sym;
    }

    public SourceDoStatement createDoStatement(SourceExpression e, SourceStatement child) {
        DoStmt sym = (DoStmt)SymFactory.createNode(this.symFile, 33);
        sym.stmtToken = (short)107;
        if (e.getSymbolKind() != 61) {
            e = this.createWrapperExpression(e);
        }
        Sym one = (Sym)((Object)this.createClause(child));
        sym.treeChildren = new Sym[]{one, (Sym)((Object)e)};
        SymFactory.finishSym(sym);
        return sym;
    }

    public SourceElseClause createElseClause(SourceStatement child) {
        ElseStmt sym = (ElseStmt)SymFactory.createNode(this.symFile, 34);
        sym.stmtToken = (short)109;
        Sym one = (Sym)((Object)this.createClause(child));
        sym.treeChildren = new Sym[]{one};
        SymFactory.finishSym(sym);
        return sym;
    }

    public SourceEmptyStatement createEmptyStatement() {
        EmptyStmt sym = (EmptyStmt)SymFactory.createNode(this.symFile, 35);
        SymFactory.finishSym(sym);
        return sym;
    }

    public SourceExpressionStatement createExpressionStatement(SourceExpression e) {
        ExpressionStmt sym = (ExpressionStmt)SymFactory.createNode(this.symFile, 36);
        sym.treeChildren = new Sym[]{(Sym)((Object)e)};
        SymFactory.finishSym(sym);
        return sym;
    }

    public SourceFinallyClause createFinallyClause(SourceBlockStatement child) {
        FinallyStmt sym = (FinallyStmt)SymFactory.createNode(this.symFile, 37);
        sym.stmtToken = (short)112;
        Sym one = (Sym)((Object)this.createClause(child));
        sym.treeChildren = new Sym[]{one};
        SymFactory.finishSym(sym);
        return sym;
    }

    public SourceForStatement createForStatement(SourceListExpression inits, SourceExpression condition, SourceListExpression updates, SourceStatement child) {
        ForStmt sym = (ForStmt)SymFactory.createNode(this.symFile, 38);
        sym.stmtToken = (short)114;
        sym.forType = 0;
        if (inits == null) {
            inits = this.createExpressionList();
        }
        if (inits.getOperandCount() > 0) {
            sym.symFlags = (byte)(sym.symFlags | 0x20);
        }
        if (condition != null) {
            sym.symFlags = (byte)(sym.symFlags | 0x40);
        }
        if (updates == null) {
            updates = this.createExpressionList();
        }
        if (updates.getOperandCount() > 0) {
            sym.symFlags = (byte)(sym.symFlags | 0xFFFFFF80);
        }
        SyntaxData data = new SyntaxData();
        data.addKid((Sym)((Object)inits));
        data.addKid((Sym)((Object)condition));
        data.addKid((Sym)((Object)updates));
        data.addKid((Sym)((Object)this.createClause(child)));
        sym.symData = data;
        sym.buildSelf();
        SymFactory.finishSym(sym);
        return sym;
    }

    public SourceForStatement createForVariableStatement(SourceLocalVariableDeclaration variables, SourceExpression condition, SourceListExpression updates, SourceStatement child) {
        ForStmt sym = (ForStmt)SymFactory.createNode(this.symFile, 38);
        sym.stmtToken = (short)114;
        sym.forType = 1;
        if (condition != null) {
            sym.symFlags = (byte)(sym.symFlags | 0x40);
        }
        if (updates == null) {
            updates = this.createExpressionList();
        }
        if (updates.getOperandCount() > 0) {
            sym.symFlags = (byte)(sym.symFlags | 0xFFFFFF80);
        }
        SyntaxData data = new SyntaxData();
        data.addKid((Sym)((Object)variables));
        data.addKid((Sym)((Object)condition));
        data.addKid((Sym)((Object)updates));
        data.addKid((Sym)((Object)this.createClause(child)));
        sym.symData = data;
        sym.buildSelf();
        SymFactory.finishSym(sym);
        return sym;
    }

    public SourceForStatement createForEnhancedStatement(SourceLocalVariableDeclaration d, SourceExpression collection, SourceStatement child) {
        ForStmt sym = (ForStmt)SymFactory.createNode(this.symFile, 38);
        sym.stmtToken = (short)114;
        sym.forType = (byte)2;
        SourceStatement last = this.createClause(child);
        sym.treeChildren = new Sym[]{(Sym)((Object)d), (Sym)((Object)collection), (Sym)((Object)last)};
        SymFactory.finishSym(sym);
        return sym;
    }

    public SourceIfStatement createIfStatement(SourceExpression e, SourceStatement child) {
        IfStmt sym = (IfStmt)SymFactory.createNode(this.symFile, 39);
        sym.stmtToken = (short)116;
        if (e.getSymbolKind() != 61) {
            e = this.createWrapperExpression(e);
        }
        Sym one = (Sym)((Object)this.createClause(child));
        sym.treeChildren = new Sym[]{(Sym)((Object)e), one};
        SymFactory.finishSym(sym);
        return sym;
    }

    public SourceIfStatement createIfStatement(SourceExpression e, SourceStatement child, SourceElseClause clause) {
        IfStmt sym = (IfStmt)SymFactory.createNode(this.symFile, 39);
        sym.stmtToken = (short)116;
        if (e.getSymbolKind() != 61) {
            e = this.createWrapperExpression(e);
        }
        Sym one = (Sym)((Object)this.createClause(child));
        sym.treeChildren = clause == null ? new Sym[]{(Sym)((Object)e), one} : new Sym[]{(Sym)((Object)e), one, (Sym)((Object)clause)};
        SymFactory.finishSym(sym);
        return sym;
    }

    public SourceReturnStatement createReturnStatement(SourceExpression e) {
        ReturnStmt sym = (ReturnStmt)SymFactory.createNode(this.symFile, 40);
        sym.stmtToken = (short)129;
        if (e != null) {
            sym.treeChildren = new Sym[]{(Sym)((Object)e)};
        }
        SymFactory.finishSym(sym);
        return sym;
    }

    public SourceSwitchStatement createSwitchStatement(SourceExpression e, SourceBlockStatement child) {
        SwitchStmt sym = (SwitchStmt)SymFactory.createNode(this.symFile, 41);
        sym.stmtToken = (short)134;
        if (e.getSymbolKind() != 61) {
            e = this.createWrapperExpression(e);
        }
        Sym one = (Sym)((Object)this.createClause(child));
        sym.treeChildren = new Sym[]{(Sym)((Object)e), one};
        SymFactory.finishSym(sym);
        return sym;
    }

    public SourceSynchStatement createSynchronizedStatement(SourceExpression e, SourceBlockStatement child) {
        SynchStmt sym = (SynchStmt)SymFactory.createNode(this.symFile, 42);
        sym.stmtToken = (short)135;
        if (e.getSymbolKind() != 61) {
            e = this.createWrapperExpression(e);
        }
        Sym one = (Sym)((Object)this.createClause(child));
        sym.treeChildren = new Sym[]{(Sym)((Object)e), one};
        SymFactory.finishSym(sym);
        return sym;
    }

    public SourceThrowStatement createThrowStatement(SourceExpression e) {
        ThrowStmt sym = (ThrowStmt)SymFactory.createNode(this.symFile, 43);
        sym.stmtToken = (short)137;
        sym.treeChildren = new Sym[]{(Sym)((Object)e)};
        SymFactory.finishSym(sym);
        return sym;
    }

    public SourceTryStatement createTryStatement(SourceBlockStatement tryClause, SourceCatchClause[] catchClauses, SourceFinallyClause finallyClause) {
        TryStmt sym = (TryStmt)SymFactory.createNode(this.symFile, 44);
        sym.stmtToken = (short)140;
        SyntaxData data = new SyntaxData();
        data.addKid((Sym)((Object)this.createClause(tryClause)));
        int catchCount = catchClauses.length;
        int i = 0;
        while (i < catchCount) {
            data.addKid((Sym)((Object)catchClauses[i]));
            ++i;
        }
        if (finallyClause != null) {
            data.addKid((Sym)((Object)finallyClause));
        }
        sym.symData = data;
        sym.buildSelf();
        SymFactory.finishSym(sym);
        return sym;
    }

    public SourceTryStatement createTryCatchStatement(SourceBlockStatement tryClause, SourceFormalParameterList parameters, SourceBlockStatement catchClause) {
        TryStmt sym = (TryStmt)SymFactory.createNode(this.symFile, 44);
        sym.stmtToken = (short)140;
        Sym one = (Sym)((Object)this.createClause(tryClause));
        Sym two = (Sym)((Object)this.createCatchClause(parameters, catchClause));
        sym.treeChildren = new Sym[]{one, two};
        SymFactory.finishSym(sym);
        return sym;
    }

    public SourceTryStatement createTryCatchFinallyStatement(SourceBlockStatement tryClause, SourceFormalParameterList parameters, SourceBlockStatement catchClause, SourceBlockStatement finallyClause) {
        TryStmt sym = (TryStmt)SymFactory.createNode(this.symFile, 44);
        sym.stmtToken = (short)140;
        Sym one = (Sym)((Object)this.createClause(tryClause));
        Sym two = (Sym)((Object)this.createCatchClause(parameters, catchClause));
        Sym three = (Sym)((Object)this.createFinallyClause(finallyClause));
        sym.treeChildren = new Sym[]{one, two, three};
        SymFactory.finishSym(sym);
        return sym;
    }

    public SourceTryStatement createTryFinallyStatement(SourceBlockStatement tryClause, SourceBlockStatement finallyClause) {
        TryStmt sym = (TryStmt)SymFactory.createNode(this.symFile, 44);
        sym.stmtToken = (short)140;
        Sym one = (Sym)((Object)this.createClause(tryClause));
        Sym two = (Sym)((Object)this.createFinallyClause(finallyClause));
        sym.treeChildren = new Sym[]{one, two};
        SymFactory.finishSym(sym);
        return sym;
    }

    public SourceWhileStatement createWhileStatement(SourceExpression e, SourceStatement child) {
        WhileStmt sym = (WhileStmt)SymFactory.createNode(this.symFile, 45);
        sym.stmtToken = (short)143;
        if (e.getSymbolKind() != 61) {
            e = this.createWrapperExpression(e);
        }
        Sym one = (Sym)((Object)this.createClause(child));
        sym.treeChildren = new Sym[]{(Sym)((Object)e), one};
        SymFactory.finishSym(sym);
        return sym;
    }

    public SourceStatementLabel createStatementLabel(String name) {
        LabelSym sym = (LabelSym)SymFactory.createNode(this.symFile, 16);
        NameSym nameSym = this.createSimpleNameSym(name);
        sym.treeChildren = new Sym[]{nameSym};
        SymFactory.finishSym(sym);
        return sym;
    }

    public SourceSwitchLabel createSwitchCaseLabel(SourceExpression e) {
        SwitchLabelSym sym = (SwitchLabelSym)SymFactory.createNode(this.symFile, 23);
        if (e != null) {
            sym.treeChildren = new Sym[]{(Sym)((Object)e)};
        }
        SymFactory.finishSym(sym);
        return sym;
    }

    public SourceSwitchLabel createSwitchDefaultLabel() {
        SwitchLabelSym sym = (SwitchLabelSym)SymFactory.createNode(this.symFile, 23);
        SymFactory.finishSym(sym);
        return sym;
    }

    private SourceStatement createClause(SourceStatement statement) {
        if (statement != null) {
            return statement;
        }
        return this.createEmptyStatement();
    }

    private SourceBlockStatement createClause(SourceBlockStatement statement) {
        if (statement != null) {
            return statement;
        }
        return this.createBlockStatement(null);
    }

    public SourceAnnotationExpression createAnnotationExpression(SourceAnnotation a) {
        AnnotateExpr sym = (AnnotateExpr)SymFactory.createExpr(this.symFile, (byte)4);
        sym.treeChildren = new Sym[]{(Sym)((Object)a)};
        SymFactory.finishSym(sym);
        return sym;
    }

    public SourceArrayAccessExpression createArrayAccess(SourceExpression lhs, SourceListExpression dereferences) {
        ArrayAccessExpr sym = (ArrayAccessExpr)SymFactory.createExpr(this.symFile, (byte)16);
        sym.treeChildren = new Sym[]{(Sym)((Object)lhs), (Sym)((Object)dereferences)};
        SymFactory.finishSym(sym);
        return sym;
    }

    public SourceListExpression createArrayConstant(SourceExpression[] operands) {
        ListExpr sym = (ListExpr)SymFactory.createExpr(this.symFile, (byte)5);
        int operandCount = operands.length;
        if (operandCount > 0) {
            sym.treeChildren = new Sym[operandCount];
            int i = 0;
            while (i < operandCount) {
                sym.treeChildren[i] = (Sym)((Object)operands[i]);
                ++i;
            }
        }
        SymFactory.finishSym(sym);
        return sym;
    }

    public SourceAssignmentExpression createAssignment(int code, SourceExpression lhs, SourceExpression rhs) {
        AssignExpr sym = (AssignExpr)SymFactory.createExpr(this.symFile, (byte)code);
        sym.treeChildren = new Sym[]{(Sym)((Object)lhs), (Sym)((Object)rhs)};
        SymFactory.finishSym(sym);
        return sym;
    }

    protected SourceNewArrayExpression createNewArrayExpressionImpl(SourceTypeReference type, SourceListExpression list) {
        ArrayCreatorExpr sym = (ArrayCreatorExpr)SymFactory.createExpr(this.symFile, (byte)39);
        sym.treeChildren = new Sym[]{(Sym)((Object)type), (Sym)((Object)list)};
        SymFactory.finishSym(sym);
        return sym;
    }

    public SourceNewClassExpression createNewClassExpression(SourceExpression lhs, SourceTypeReference type, SourceListExpression arguments, SourceClassBody body) {
        ClassCreatorExpr sym = (ClassCreatorExpr)SymFactory.createExpr(this.symFile, (byte)40);
        SyntaxData data = new SyntaxData();
        if (lhs != null) {
            data.addKid((Sym)((Object)lhs));
        }
        data.addKid((Sym)((Object)type));
        if (arguments == null) {
            arguments = this.createArgumentList(SourceExpression.EMPTY_ARRAY);
        }
        data.addKid((Sym)((Object)arguments));
        if (body != null) {
            data.addKid((Sym)((Object)body));
        }
        sym.symData = data;
        sym.buildSelf();
        SymFactory.finishSym(sym);
        return sym;
    }

    public SourceDotExpression createDotReference(SourceExpression lhs, String name) {
        DotExpr sym = (DotExpr)SymFactory.createExpr(this.symFile, (byte)19);
        sym.treeChildren = new Sym[]{(Sym)((Object)lhs), this.createSimpleNameSym(name)};
        SymFactory.finishSym(sym);
        return sym;
    }

    public SourceListExpression createExpressionList(SourceExpression[] arguments) {
        int argumentCount;
        ListExpr sym = (ListExpr)SymFactory.createExpr(this.symFile, (byte)26);
        if (arguments != null && (argumentCount = arguments.length) > 0) {
            sym.treeChildren = new Sym[argumentCount];
            int i = 0;
            while (i < argumentCount) {
                sym.treeChildren[i] = (Sym)((Object)arguments[i]);
                ++i;
            }
        }
        SymFactory.finishSym(sym);
        return sym;
    }

    public SourceInfixExpression createInfixExpression(int code, SourceExpression lhs, SourceExpression rhs) {
        InfixExpr sym = (InfixExpr)SymFactory.createExpr(this.symFile, (byte)code);
        sym.treeChildren = new Sym[]{(Sym)((Object)lhs), (Sym)((Object)rhs)};
        SymFactory.finishSym(sym);
        return sym;
    }

    public SourceInfixExpression createInfixExpression(int code, SourceExpression[] operands) {
        InfixExpr sym = (InfixExpr)SymFactory.createExpr(this.symFile, (byte)code);
        int operandCount = operands.length;
        if (operandCount > 0) {
            sym.treeChildren = new Sym[operandCount];
            int i = 0;
            while (i < operandCount) {
                sym.treeChildren[i] = (Sym)((Object)operands[i]);
                ++i;
            }
        }
        SymFactory.finishSym(sym);
        return sym;
    }

    public SourceMethodCallExpression createMethodCall(SourceExpression lhs, SourceTypeArgument[] typeArguments, String name, SourceListExpression arguments) {
        MethodCallExpr sym = (MethodCallExpr)SymFactory.createExpr(this.symFile, (byte)24);
        if (arguments == null) {
            arguments = this.createArgumentList(SourceExpression.EMPTY_ARRAY);
        }
        sym.treeChildren = lhs != null ? new Sym[]{(Sym)((Object)lhs), this.createSimpleNameSym(name), (Sym)((Object)arguments)} : new Sym[]{this.createSimpleNameSym(name), (Sym)((Object)arguments)};
        SymFactory.finishSym(sym);
        return sym;
    }

    public SourceQuestionExpression createQuestionExpression(SourceExpression one, SourceExpression two, SourceExpression three) {
        QuestionExpr sym = (QuestionExpr)SymFactory.createExpr(this.symFile, (byte)15);
        sym.treeChildren = new Sym[]{(Sym)((Object)one), (Sym)((Object)two), (Sym)((Object)three)};
        SymFactory.finishSym(sym);
        return sym;
    }

    public SourceSimpleNameExpression createSimpleNameExpression(String name) {
        SimpleNameExpr sym = (SimpleNameExpr)SymFactory.createExpr(this.symFile, (byte)53);
        sym.treeChildren = new Sym[]{this.createSimpleNameSym(name)};
        SymFactory.finishSym(sym);
        return sym;
    }

    public SourceTypeExpression createTypeExpression(SourceTypeReference type) {
        TypeExpr sym = (TypeExpr)SymFactory.createExpr(this.symFile, (byte)54);
        sym.treeChildren = new Sym[]{(Sym)((Object)type)};
        SymFactory.finishSym(sym);
        return sym;
    }

    public SourceTypecastExpression createTypecast(SourceTypeReference type, SourceExpression operand) {
        TypecastExpr sym = (TypecastExpr)SymFactory.createExpr(this.symFile, (byte)55);
        TypeExpr typeExpr = (TypeExpr)this.createTypeExpression(type);
        sym.treeChildren = new Sym[]{typeExpr, (Sym)((Object)operand)};
        SymFactory.finishSym(sym);
        return sym;
    }

    public SourceUnaryExpression createUnaryExpression(int code, SourceExpression operand) {
        UnaryExpr sym = (UnaryExpr)SymFactory.createExpr(this.symFile, (byte)code);
        sym.treeChildren = new Sym[]{(Sym)((Object)operand)};
        SymFactory.finishSym(sym);
        return sym;
    }

    public SourceWrapperExpression createWrapperExpression(SourceExpression operand) {
        WrapperExpr sym = (WrapperExpr)SymFactory.createExpr(this.symFile, (byte)38);
        sym.treeChildren = new Sym[]{(Sym)((Object)operand)};
        SymFactory.finishSym(sym);
        return sym;
    }

    public SourceDocComment createDocComment(SourceDocDescription description, SourceDocBlockTag[] tags) {
        DocCommentSym sym = (DocCommentSym)SymFactory.createNode(this.symFile, 63);
        SyntaxData data = new SyntaxData();
        if (description != null) {
            data.addKid((Sym)((Object)description));
        }
        if (tags != null && tags.length > 0) {
            int tagCount = tags.length;
            int i = 0;
            while (i < tagCount) {
                data.addKid((Sym)((Object)tags[i]));
                ++i;
            }
        }
        sym.symData = data;
        sym.buildSelf();
        SymFactory.finishSym(sym);
        return sym;
    }

    public SourceDocTextFragment createDocTextFragment(String text) {
        DocTextFragmentSym sym = (DocTextFragmentSym)SymFactory.createDocElement(null, 68);
        sym.symFile = this.symFile;
        sym.textString = text;
        SymFactory.finishSym(sym);
        return sym;
    }

    public SourceDocDescription createDocDescription(SourceDocTextFragment[] lines) {
        DocDescriptionSym sym = (DocDescriptionSym)SymFactory.createDocElement(null, 64);
        sym.symFile = this.symFile;
        if (lines != null && lines.length > 0) {
            SyntaxData data = new SyntaxData();
            int count = lines.length;
            int i = 0;
            while (i < count) {
                String text;
                DocTextFragmentSym textSym = (DocTextFragmentSym)lines[i];
                if (i != count - 1 && !(text = textSym.textString).endsWith("\n") && !text.endsWith("\r")) {
                    throw new IllegalArgumentException();
                }
                data.addKid((Sym)((Object)lines[i]));
                ++i;
            }
            sym.symData = data;
            sym.buildSelf();
        }
        SymFactory.finishSym(sym);
        return sym;
    }

    public SourceDocTagName createDocTagName(String name) {
        if (!name.startsWith("@")) {
            new RuntimeException("Warning: Found " + name + ". You probably meant @" + name + ".").printStackTrace();
            name = '@' + name;
        }
        DocTagNameSym sym = (DocTagNameSym)SymFactory.createDocElement(null, 67);
        sym.symFile = this.symFile;
        sym.tagCode = DocTagNameSym.lookupTag(name);
        sym.tagName = name;
        SymFactory.finishSym(sym);
        return sym;
    }

    public SourceDocReference createDocParameterReference(String parameterName) {
        DocReferenceSym sym = (DocReferenceSym)SymFactory.createDocElement(null, 66);
        sym.symFile = this.symFile;
        sym.refParameterName = parameterName;
        SymFactory.finishSym(sym);
        return sym;
    }

    public SourceDocReference createDocReference(String classString, String memberName, String[] parameterTypes) {
        DocReferenceSym sym = (DocReferenceSym)SymFactory.createDocElement(null, 66);
        sym.symFile = this.symFile;
        sym.refClassName = classString;
        sym.refMemberName = memberName;
        if (parameterTypes != null) {
            sym.refMethodParameters = Arrays.asList(parameterTypes);
        }
        SymFactory.finishSym(sym);
        return sym;
    }

    public SourceDocBlockTag createDocBlockTag(SourceDocTagName name, SourceDocReference[] references, SourceDocDescription description) {
        DocBlockTagSym sym = (DocBlockTagSym)SymFactory.createDocElement(null, 62);
        sym.symFile = this.symFile;
        DocTagNameSym tagNameSym = (DocTagNameSym)name;
        SyntaxData data = new SyntaxData();
        data.addKid(tagNameSym);
        int referenceCount = references.length;
        int i = 0;
        while (i < referenceCount) {
            data.addKid((Sym)((Object)references[i]));
            ++i;
        }
        if (description != null) {
            data.addKid((Sym)((Object)description));
        }
        sym.symData = data;
        sym.buildSelf();
        sym.tagCode = tagNameSym.tagCode;
        SymFactory.finishSym(sym);
        return sym;
    }

    public SourceDocInlineTag createDocInlineTag(SourceDocTagName name, SourceDocReference[] references, SourceDocDescription description) {
        DocInlineTagSym sym = (DocInlineTagSym)SymFactory.createDocElement(null, 65);
        sym.symFile = this.symFile;
        DocTagNameSym tagNameSym = (DocTagNameSym)name;
        SyntaxData data = new SyntaxData();
        data.addKid(tagNameSym);
        int referenceCount = references.length;
        int i = 0;
        while (i < referenceCount) {
            data.addKid((Sym)((Object)references[i]));
            ++i;
        }
        if (description != null) {
            data.addKid((Sym)((Object)description));
        }
        sym.symData = data;
        sym.buildSelf();
        sym.tagCode = tagNameSym.tagCode;
        SymFactory.finishSym(sym);
        return sym;
    }

    private static void finishSym(Sym sym) {
        sym.symFormat = (char)(sym.symFormat | 2);
    }

    private static void finishSym(TreeSym sym) {
        sym.symFormat = (char)(sym.symFormat | 2);
        sym.hookupChildren();
        sym.setupSkeleton();
    }

    public SymFactory(SourceFile file) {
        this((FileSym)file);
    }

    public SymFactory(FileSym fileSym) {
        this.symFile = fileSym;
    }

    public static Sym createNode(FileSym fileSym, int sy) {
        Sym sym;
        switch (sy) {
            case 69: {
                sym = new CommentSym();
                break;
            }
            case 70: {
                sym = new BlanklineSym();
                break;
            }
            case 71: {
                sym = new SqljSym();
                break;
            }
            case 20: {
                sym = new NameSym();
                break;
            }
            case 27: {
                sym = new TypeSym();
                break;
            }
            case 28: {
                sym = new AssertStmt();
                break;
            }
            case 29: {
                sym = new BlockStmt();
                break;
            }
            case 30: {
                sym = new BreakStmt();
                break;
            }
            case 31: {
                sym = new CatchStmt();
                break;
            }
            case 32: {
                sym = new ContinueStmt();
                break;
            }
            case 33: {
                sym = new DoStmt();
                break;
            }
            case 34: {
                sym = new ElseStmt();
                break;
            }
            case 35: {
                sym = new EmptyStmt();
                break;
            }
            case 36: {
                sym = new ExpressionStmt();
                break;
            }
            case 37: {
                sym = new FinallyStmt();
                break;
            }
            case 38: {
                sym = new ForStmt();
                break;
            }
            case 39: {
                sym = new IfStmt();
                break;
            }
            case 40: {
                sym = new ReturnStmt();
                break;
            }
            case 41: {
                sym = new SwitchStmt();
                break;
            }
            case 42: {
                sym = new SynchStmt();
                break;
            }
            case 43: {
                sym = new ThrowStmt();
                break;
            }
            case 44: {
                sym = new TryStmt();
                break;
            }
            case 45: {
                sym = new WhileStmt();
                break;
            }
            case 2: {
                sym = new BlockSym();
                break;
            }
            case 16: {
                sym = new LabelSym();
                break;
            }
            case 23: {
                sym = new SwitchLabelSym();
                break;
            }
            case 18: {
                sym = new LocalVardeclSym();
                break;
            }
            case 13: {
                sym = new FormalParameterSym();
                break;
            }
            case 17: {
                sym = new LocalVariableSym();
                break;
            }
            case 9: {
                sym = new FieldDeclSym();
                break;
            }
            case 10: {
                sym = new FieldSym();
                break;
            }
            case 6: 
            case 19: {
                sym = new MethodSym();
                break;
            }
            case 5: {
                sym = new InitializerSym();
                break;
            }
            case 7: {
                sym = new EnumConstantSym();
                break;
            }
            case 12: {
                sym = new FormalsSym();
                break;
            }
            case 3: {
                sym = new ClassSym();
                break;
            }
            case 4: {
                sym = new ClassBodySym();
                break;
            }
            case 1: {
                sym = new AnnotateSym();
                break;
            }
            case 63: {
                sym = new DocCommentSym();
                break;
            }
            case 22: {
                sym = new SuperclassSym();
                break;
            }
            case 15: {
                sym = new InterfacesSym();
                break;
            }
            case 24: {
                sym = new ThrowsClauseSym();
                break;
            }
            case 26: {
                sym = new TypeParameterSym();
                break;
            }
            case 25: {
                sym = new TypeArgumentSym();
                break;
            }
            case 8: {
                sym = new ErrorSym();
                break;
            }
            case 14: {
                sym = new ImportSym();
                break;
            }
            case 21: {
                sym = new PackageSym();
                break;
            }
            case 73: {
                sym = new RootSym();
                break;
            }
            case 74: {
                sym = new TreeSym();
                break;
            }
            default: {
                sym = new PlaceholderSym();
                break;
            }
        }
        sym.symKind = (byte)sy;
        sym.symFile = fileSym;
        return sym;
    }

    public static Expr createExpr(FileSym fileSym, byte opt) {
        if (1 <= opt && opt < 58) {
            Expr sym;
            byte type = JavaConstants.opt2srcTable[opt - 1];
            switch (type) {
                case 46: {
                    sym = new AnnotateExpr();
                    break;
                }
                case 47: {
                    sym = new ArrayAccessExpr();
                    break;
                }
                case 48: {
                    sym = new AssignExpr();
                    break;
                }
                case 49: {
                    sym = new DotExpr();
                    break;
                }
                case 50: {
                    sym = new InfixExpr();
                    break;
                }
                case 51: {
                    sym = new ListExpr();
                    break;
                }
                case 52: {
                    sym = new LiteralExpr();
                    break;
                }
                case 53: {
                    sym = new MethodCallExpr();
                    break;
                }
                case 54: {
                    sym = new ArrayCreatorExpr();
                    break;
                }
                case 55: {
                    sym = new ClassCreatorExpr();
                    break;
                }
                case 57: {
                    sym = new SimpleNameExpr();
                    break;
                }
                case 56: {
                    sym = new QuestionExpr();
                    break;
                }
                case 58: {
                    sym = new TypeExpr();
                    break;
                }
                case 59: {
                    sym = new TypecastExpr();
                    break;
                }
                case 60: {
                    sym = new UnaryExpr();
                    break;
                }
                case 61: {
                    sym = new WrapperExpr();
                    break;
                }
                default: {
                    sym = null;
                    break;
                }
            }
            if (sym != null) {
                sym.symKind = type;
                sym.symFile = fileSym;
                sym.exprOptcode = opt;
                return sym;
            }
        }
        throw new RuntimeException("Unknown operator: " + opt);
    }

    public static DocSym createDocElement(DocCommentSym owningSym, int sy) {
        DocSym sym;
        switch (sy) {
            case 62: {
                sym = new DocBlockTagSym();
                break;
            }
            case 64: {
                sym = new DocDescriptionSym();
                break;
            }
            case 65: {
                sym = new DocInlineTagSym();
                break;
            }
            case 66: {
                sym = new DocReferenceSym();
                break;
            }
            case 68: {
                sym = new DocTextFragmentSym();
                break;
            }
            case 67: {
                sym = new DocTagNameSym();
                break;
            }
            default: {
                CommonUtilities.panic("" + sy);
                return null;
            }
        }
        sym.symKind = (byte)sy;
        sym.docOwning = owningSym;
        if (owningSym != null) {
            sym.symFile = owningSym.symFile;
        }
        return sym;
    }

    protected static void setupSynthetic(Sym sym, Sym parent, int index) {
        sym.symParent = parent;
        sym.symAccess = (char)(sym.symAccess | 0x1000);
        sym.symStart = index;
        sym.symEnd = index;
    }

    public static String describe(byte symKind) {
        if (0 < symKind && symKind < 72) {
            return JavaConstants.SRC_words[symKind - 1];
        }
        if (72 <= symKind && symKind < 79) {
            return InternalConstants.SRCX_words[symKind - 72];
        }
        return "SRC_invalid";
    }
}

