/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.internal.symbol;

import javax.swing.undo.UndoableEdit;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.compare.CompareUtils;
import oracle.javatools.parser.java.v2.JavaParser;
import oracle.javatools.parser.java.v2.internal.format.DamageCalculation;
import oracle.javatools.parser.java.v2.internal.format.Emitter;
import oracle.javatools.parser.java.v2.internal.format.FormatDriver;
import oracle.javatools.parser.java.v2.internal.parser.SyntaxData;
import oracle.javatools.parser.java.v2.internal.symbol.FileSym;
import oracle.javatools.parser.java.v2.internal.symbol.SymOperation;
import oracle.javatools.parser.java.v2.internal.symbol.SymTransaction;
import oracle.javatools.parser.java.v2.internal.symbol.TreeSym;
import oracle.javatools.parser.java.v2.internal.util.DocCommentHelper;
import oracle.javatools.parser.java.v2.internal.util.FormatRegion;
import oracle.javatools.parser.java.v2.internal.util.ImportHelper;
import oracle.javatools.parser.java.v2.internal.util.TokenMap;
import oracle.javatools.parser.java.v2.write.SourceSavepoint;

public final class SymSavepoint
extends TreeSym
implements SourceSavepoint {
    protected UndoableEdit undoableEdit;
    protected SymTransaction.TextEdit lastIncludedEdit;

    private void $init$() {
        this.symKind = (byte)77;
    }

    protected SymSavepoint(SymTransaction parent) {
        this.$init$();
        this.symParent = parent;
        this.symFile = parent.symFile;
    }

    public void undoSelf() {
        int count = this.treeChildren.length;
        int i = count - 1;
        while (i >= 0) {
            SymOperation op = (SymOperation)this.treeChildren[i];
            op.undoSelf();
            --i;
        }
        if (this.undoableEdit != null) {
            this.undoableEdit.undo();
        }
        this.symFile.adjustOffsets();
    }

    public void buildSelf() {
        SyntaxData data = (SyntaxData)this.symData;
        super.buildSelf();
        data.kidCount = 0;
    }

    public void preprocessSelf() {
        ImportHelper importHelper = new ImportHelper(this.symFile);
        importHelper.process();
        DocCommentHelper docCommentHelper = new DocCommentHelper(this.symFile);
        docCommentHelper.process();
    }

    public void processSelf() {
        if (this.treeChildren.length == 0) {
            SymSavepoint.panic();
        }
        int count = this.treeChildren.length;
        SymOperation[] ops = new SymOperation[count];
        System.arraycopy(this.treeChildren, 0, ops, 0, count);
        DamageCalculation.preprocess(ops);
        Emitter emitter = Emitter.createSavedTextEmitter();
        FileSym formattedFile = SymSavepoint.getFormattedFile(this.symFile, emitter);
        this.symFile.mapSelf(formattedFile);
        TokenMap tokenMap = new TokenMap(this.symFile, formattedFile);
        TextBuffer textBuffer = this.symFile.getTextBuffer();
        textBuffer.beginEdit();
        try {
            FormatRegion[] regions = DamageCalculation.process(ops, tokenMap);
            int regionCount = regions.length;
            int i = regionCount - 1;
            while (i >= 0) {
                FormatRegion region = regions[i];
                SymSavepoint.performRegionReplace(region, this.symFile, formattedFile);
                --i;
            }
        }
        finally {
            this.undoableEdit = textBuffer.endEdit();
        }
        this.symFile.adjustOffsets();
        this.symFile.clearFormatInfo();
    }

    private static FileSym getFormattedFile(FileSym fileSym, Emitter emitter) {
        FormatDriver formatter = new FormatDriver(fileSym, emitter);
        formatter.init(fileSym);
        try {
            fileSym.print(formatter);
        }
        finally {
            formatter.fini(fileSym);
        }
        TextBuffer formattedBuffer = emitter.getOutputBuffer();
        FileSym formattedFile = (FileSym)JavaParser.parse(formattedBuffer, fileSym.j2se);
        formattedFile.setTextBuffer(formattedBuffer);
        return formattedFile;
    }

    private static void performRegionReplace(FormatRegion region, FileSym fileSym, FileSym formattedFile) {
        int targetLength;
        int targetEndOffset;
        int dirtyEndOffset;
        int targetStartOffset;
        int dirtyStartOffset;
        int dirtyStartIndex = region.fromIndices.getStartOffset();
        int targetStartIndex = region.toIndices.getStartOffset();
        if (dirtyStartIndex == 0 && targetStartIndex == 0) {
            dirtyStartOffset = 0;
            targetStartOffset = 0;
        } else {
            dirtyStartOffset = fileSym.tokens.tokenStarts[dirtyStartIndex];
            targetStartOffset = formattedFile.tokens.tokenStarts[targetStartIndex];
        }
        TextBuffer formattedBuffer = formattedFile.getTextBuffer();
        TextBuffer textBuffer = fileSym.getTextBuffer();
        int dirtyEndIndex = region.fromIndices.getEndOffset();
        int targetEndIndex = region.toIndices.getEndOffset();
        if (dirtyEndIndex >= fileSym.tokens.tokenCount - 2 && targetEndIndex >= formattedFile.tokens.tokenCount - 2) {
            dirtyEndOffset = textBuffer.getLength();
            targetEndOffset = formattedBuffer.getLength();
        } else {
            dirtyEndOffset = fileSym.tokens.tokenEnds[dirtyEndIndex];
            targetEndOffset = formattedFile.tokens.tokenEnds[targetEndIndex];
        }
        int dirtyLength = dirtyEndOffset - dirtyStartOffset;
        if (dirtyLength < 0) {
            SymSavepoint.panic();
        }
        if ((targetLength = targetEndOffset - targetStartOffset) < 0) {
            SymSavepoint.panic();
        }
        char[] targetText = formattedBuffer.getChars(targetStartOffset, targetLength);
        CompareUtils.replaceText(textBuffer, dirtyStartOffset, dirtyLength, targetText);
    }
}

