/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.internal.symbol;

import java.io.PrintWriter;
import oracle.javatools.parser.java.v2.JavaProvider;
import oracle.javatools.parser.java.v2.common.CommonUtilities;
import oracle.javatools.parser.java.v2.internal.compiler.CompilerDriver;
import oracle.javatools.parser.java.v2.internal.format.FormatDriver;
import oracle.javatools.parser.java.v2.internal.symbol.FileSym;
import oracle.javatools.parser.java.v2.internal.symbol.ObjectSym;
import oracle.javatools.parser.java.v2.internal.symbol.Sym;
import oracle.javatools.parser.java.v2.model.JavaElement;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.JavaTypeVariable;
import oracle.javatools.parser.java.v2.model.SourceTypeArgument;

public class TypeArgumentSym
extends ObjectSym
implements SourceTypeArgument {
    public byte argBound;
    public JavaType argResolved;

    public int getBound() {
        return this.argBound;
    }

    public JavaElement getCompiledObject() {
        return this.getResolvedType();
    }

    public JavaType getResolvedType() {
        if (this.argResolved == null) {
            this.resolve();
        }
        return this.argResolved;
    }

    public JavaType getResolvedType(JavaTypeVariable typeParameter, JavaProvider provider) {
        if ((this.objectFlags & 0x80) != 0) {
            return this.argResolved;
        }
        JavaType newArgResolved = null;
        if (this.argBound == 3) {
            JavaType parameterType = typeParameter.getResolvedType();
            newArgResolved = CommonUtilities.createWildcardType((byte)1, parameterType, provider);
        } else if (this.argBound == 2) {
            JavaType upperBound = typeParameter.getResolvedType();
            JavaType lowerBound = this.getResolvedType();
            if (upperBound != null && lowerBound != null) {
                newArgResolved = upperBound.isAssignableFrom(lowerBound) ? CommonUtilities.createWildcardType((byte)1, upperBound, provider) : CommonUtilities.createWildcardType((byte)2, lowerBound, provider);
            }
        }
        if (newArgResolved == null) {
            newArgResolved = this.getResolvedType();
        }
        this.argResolved = newArgResolved;
        this.objectFlags = (char)(this.objectFlags | 0x80);
        return this.argResolved;
    }

    public void clearCompiledInfo() {
        super.clearCompiledInfo();
        this.argResolved = null;
    }

    public String printCompiledInfo() {
        JavaType resolvedType = this.getResolvedType();
        if (resolvedType != null) {
            return "refers to " + resolvedType.getDescriptor();
        }
        return "refers to <unknown>";
    }

    protected boolean isValidChild(Sym target, byte argument) {
        switch (target.symKind) {
            case 27: {
                return true;
            }
        }
        return super.isValidChild(target, argument);
    }

    protected JavaElement resolveImpl(CompilerDriver compiler) {
        if (this.argResolved == null && !this.isProcessed()) {
            this.argResolved = compiler.resolve(this);
        }
        return this.argResolved;
    }

    public Sym cloneSelf(FileSym targetFile) {
        TypeArgumentSym sym = (TypeArgumentSym)super.cloneSelf(targetFile);
        sym.argBound = this.argBound;
        return sym;
    }

    protected void printSelf(FormatDriver out) {
        out.print(this);
    }

    public void print(PrintWriter out, int ignored) {
        switch (this.argBound) {
            default: {
                out.print('?');
                break;
            }
            case 1: {
                out.print("? extends ");
                TypeArgumentSym.print(this.getTypeSym(), out);
                break;
            }
            case 2: {
                out.print("? super ");
                TypeArgumentSym.print(this.getTypeSym(), out);
                break;
            }
            case 0: {
                TypeArgumentSym.print(this.getTypeSym(), out);
                break;
            }
        }
    }
}

