/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.internal.symbol.doc;

import oracle.javatools.parser.java.v2.internal.symbol.Sym;
import oracle.javatools.parser.java.v2.internal.symbol.doc.DocReferenceSym;
import oracle.javatools.parser.java.v2.internal.symbol.doc.DocSym;
import oracle.javatools.parser.java.v2.internal.symbol.doc.DocTagNameSym;
import oracle.javatools.parser.java.v2.model.doc.SourceDocReference;
import oracle.javatools.parser.java.v2.model.doc.SourceDocTag;

public abstract class DocTagSym
extends DocSym
implements SourceDocTag {
    static final DocTagSym[] EMPTY_ARRAY = new DocTagSym[0];
    public short tagCode;

    public String getName() {
        DocTagNameSym tagNameSym = this.getTagNameSym();
        if (tagNameSym != null) {
            return tagNameSym.getText();
        }
        return "";
    }

    public DocTagNameSym getTagNameSym() {
        return (DocTagNameSym)this.getChild((byte)67);
    }

    public String getArgumentText() {
        int count = this.treeChildren.length;
        if (count == 0) {
            return "";
        }
        int pos = 0;
        if (this.treeChildren[pos].symKind == 67) {
            ++pos;
        }
        StringBuilder buffer = new StringBuilder();
        int i = pos;
        while (i < count) {
            DocSym child = (DocSym)this.treeChildren[i];
            child.appendDocText(buffer);
            ++i;
        }
        return buffer.toString();
    }

    public boolean isStandard() {
        return this.tagCode != 201;
    }

    public boolean isException() {
        return this.tagCode == 205 || this.tagCode == 213;
    }

    public boolean isParameter() {
        return this.tagCode == 207;
    }

    public boolean isReference() {
        switch (this.tagCode) {
            case 206: {
                return true;
            }
            case 216: {
                return true;
            }
            case 209: {
                return this.getChild((byte)66) != null;
            }
            case 218: {
                return this.getChildren().size() > 1;
            }
        }
        return false;
    }

    public boolean isReference(String referenceName) {
        SourceDocReference reference = this.getReference();
        if (reference == null) {
            return false;
        }
        return referenceName.equals(reference.getNormalizedText());
    }

    public SourceDocReference getReference() {
        if (!(this.isException() || this.isParameter() || this.isReference())) {
            return null;
        }
        return this.getReferenceSym();
    }

    private DocReferenceSym getReferenceSym() {
        return (DocReferenceSym)this.getChild((byte)66);
    }

    public String getReferenceText() {
        if (!(this.isException() || this.isParameter() || this.isReference())) {
            return null;
        }
        DocReferenceSym reference = this.getReferenceSym();
        if (reference == null) {
            return "";
        }
        return reference.getNormalizedText();
    }

    public boolean isSerial() {
        return this.tagCode == 217 || this.tagCode == 210;
    }

    public boolean isSerialField() {
        return this.tagCode == 211;
    }

    public SourceDocReference getFieldNameReference() {
        if (!this.isSerialField()) {
            return null;
        }
        return this.getReferenceSym();
    }

    public SourceDocReference getFieldTypeReference() {
        if (!this.isSerialField()) {
            return null;
        }
        return (DocReferenceSym)this.getLastChild((byte)66);
    }

    protected boolean isValidChild(Sym target, byte argument) {
        switch (target.symKind) {
            case 64: 
            case 66: 
            case 67: {
                return true;
            }
        }
        return super.isValidChild(target, argument);
    }
}

