/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.internal.symbol.expr;

import java.util.Iterator;
import oracle.javatools.parser.java.v2.JavaConstants;
import oracle.javatools.parser.java.v2.internal.compiler.CompilerDriver;
import oracle.javatools.parser.java.v2.internal.format.FormatDriver;
import oracle.javatools.parser.java.v2.internal.symbol.Sym;
import oracle.javatools.parser.java.v2.internal.symbol.expr.Expr;
import oracle.javatools.parser.java.v2.model.JavaElement;
import oracle.javatools.parser.java.v2.model.expression.SourceListExpression;

public final class ListExpr
extends Expr
implements SourceListExpression {
    public Object getConstantValue() {
        if (this.exprOptcode != 5) {
            return null;
        }
        int count = this.getOperandCount();
        if (count == 0) {
            return JavaConstants.EMPTY_OBJECT_ARRAY;
        }
        Object[] things = new Object[count];
        if (count < 16) {
            int i = 0;
            while (i < count) {
                things[i] = this.getNthOperandSym(i).getConstantValue();
                ++i;
            }
        } else {
            Iterator iterator = this.getOperands().iterator();
            int i = 0;
            while (iterator.hasNext()) {
                Expr e = (Expr)iterator.next();
                things[i] = e.getConstantValue();
                ++i;
            }
        }
        return things;
    }

    public String printCompiledInfo() {
        if (this.exprOptcode == 26) {
            return "";
        }
        return super.printCompiledInfo();
    }

    protected JavaElement resolveImplImpl(CompilerDriver compiler) {
        return compiler.resolve(this);
    }

    protected void unlinkChildTrigger(Sym child, byte filter) {
        Sym parentSym;
        super.unlinkChildTrigger(child, filter);
        if (this.treeChildren.length == 0 && (parentSym = this.getParentSym()) != null && parentSym.symKind == 1) {
            this.symFlags = (byte)(this.symFlags | 4);
        }
    }

    protected void printSelf(FormatDriver out) {
        out.print(this);
    }
}

