/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.scanner;

import oracle.javatools.parser.AbstractLexer;
import oracle.javatools.parser.LexerToken;
import oracle.javatools.parser.java.v2.JavadocTokens;
import oracle.javatools.parser.java.v2.scanner.FastLexer;
import oracle.javatools.parser.util.KeywordTable;

public class JavadocLexer
extends FastLexer
implements JavadocTokens {
    private int lastToken;
    private int startOffset;
    private int endOffset;
    private boolean useLastToken;
    private int lexerState;
    private boolean flag_allowTag;
    private static final int STATE_COMMENT_START = 1;
    private static final int STATE_NEWLINE = 2;
    private static final int STATE_LINE_START = 3;
    private static final int STATE_BODY = 4;
    private static final int STATE_COMMENT_END = 12;
    private static final int STATE_EOF = 13;
    private static KeywordTable keywordTable;
    private static short[] operatorTable;

    private void $init$() {
        this.flag_allowTag = false;
    }

    public JavadocLexer() {
        this.$init$();
        this.setTextBuffer(null);
        this.setPosition(0);
    }

    private void reset() {
        this.lexerState = 1;
        this.lastToken = -1;
        this.startOffset = -1;
        this.endOffset = -1;
        this.useLastToken = false;
        this.flag_allowTag = true;
    }

    public int getToken() {
        return this.lastToken;
    }

    public int getStartOffset() {
        return this.startOffset;
    }

    public int getEndOffset() {
        return this.endOffset;
    }

    public void backup() {
        this.useLastToken = true;
    }

    public void setPosition(int offset) {
        this.reset();
        super.setPosition(offset);
    }

    public int lex() {
        return this.lex(null);
    }

    public int lex(LexerToken lexedToken) {
        block12: {
            if (this.useLastToken) {
                this.useLastToken = false;
                return this.fillLexerToken(lexedToken);
            }
            this.startOffset = this.currentPos;
            try {
                boolean tokenFound;
                do {
                    this.lastToken = 0;
                    switch (this.lexerState) {
                        case 1: {
                            tokenFound = this.handleCommentStart();
                            break;
                        }
                        case 2: {
                            tokenFound = this.handleNewline();
                            break;
                        }
                        case 3: {
                            tokenFound = this.handleLineStart();
                            break;
                        }
                        case 4: {
                            tokenFound = this.handleBody();
                            break;
                        }
                        case 12: {
                            tokenFound = this.handleCommentEnd();
                            break;
                        }
                        case 13: {
                            tokenFound = true;
                            break;
                        }
                        default: {
                            throw new IllegalStateException("Unknown state: " + this.lexerState);
                        }
                    }
                } while (!tokenFound);
            }
            catch (IndexOutOfBoundsException e) {
                this.lexerState = 13;
                this.currentPos = this.textBuffer.getLength();
                if (this.lastToken != 0) break block12;
                this.startOffset = this.currentPos;
            }
        }
        this.endOffset = this.currentPos;
        this.useLastToken = false;
        return this.fillLexerToken(lexedToken);
    }

    private boolean handleCommentStart() {
        this.lexerState = 4;
        this.lastToken = 194;
        if (this.textBuffer.getChar(this.currentPos) == '/') {
            ++this.currentPos;
            if (this.textBuffer.getChar(this.currentPos) == '*') {
                ++this.currentPos;
            }
        }
        this.skipAsterisks();
        return true;
    }

    private boolean handleNewline() {
        this.lexerState = 3;
        switch (this.textBuffer.getChar(this.currentPos)) {
            case '\n': {
                this.lastToken = 193;
                ++this.currentPos;
                this.flag_allowTag = true;
                return true;
            }
            case '\r': {
                this.lastToken = 193;
                ++this.currentPos;
                if (this.textBuffer.getChar(this.currentPos) == '\n') {
                    ++this.currentPos;
                }
                this.flag_allowTag = true;
                return true;
            }
        }
        return false;
    }

    private boolean handleLineStart() {
        this.lexerState = 4;
        int savedPos = this.currentPos;
        this.skipSpaces();
        if (this.textBuffer.getChar(this.currentPos) == '*') {
            this.lastToken = 194;
            ++this.currentPos;
            if (this.textBuffer.getChar(this.currentPos) == '/') {
                --this.currentPos;
                this.lexerState = 12;
                return false;
            }
            this.skipAsterisks();
            this.flag_allowTag = true;
            return true;
        }
        this.currentPos = savedPos;
        return false;
    }

    private boolean handleBody() {
        char ch = this.textBuffer.getChar(this.currentPos);
        if (ch == ' ' || ch == '\t') {
            this.lastToken = 5;
            do {
                ++this.currentPos;
            } while ((ch = this.textBuffer.getChar(this.currentPos)) == ' ' || ch == '\t');
            this.startOffset = this.currentPos;
        }
        int lastPos = -1;
        boolean tokenFound = false;
        this.lastToken = 192;
        block7: while (true) {
            if (lastPos == this.currentPos) {
                throw new IllegalStateException("Infinite loop");
            }
            lastPos = this.currentPos;
            ch = this.textBuffer.getChar(this.currentPos);
            switch (ch) {
                case '\t': 
                case ' ': {
                    break block7;
                }
                case '\n': 
                case '\r': {
                    this.lexerState = 2;
                    break block7;
                }
                case '@': {
                    if (this.flag_allowTag && this.isTagStart(this.textBuffer.getChar(this.currentPos + 1))) {
                        if (tokenFound) break block7;
                        this.lastToken = this.skipTagName();
                        tokenFound = true;
                        break block7;
                    }
                }
                case '*': {
                    if (this.textBuffer.getChar(this.currentPos + 1) == '/') {
                        this.lexerState = 12;
                        break block7;
                    }
                }
                default: {
                    int tk;
                    if (ch < '\u0100' && (tk = operatorTable[ch]) > 0) {
                        if (tokenFound) break block7;
                        this.lastToken = tk;
                        ++this.currentPos;
                        tokenFound = true;
                        break block7;
                    }
                    ++this.currentPos;
                    tokenFound = true;
                    continue block7;
                }
            }
            break;
        }
        if (tokenFound) {
            this.flag_allowTag = this.lastToken == 49;
        }
        return tokenFound;
    }

    private boolean handleCommentEnd() {
        this.lexerState = 13;
        this.currentPos += 2;
        return true;
    }

    private int skipTagName() {
        int hash = KeywordTable.computePartialHash('@', 0);
        int tagEnd = this.currentPos + 1;
        char c = this.textBuffer.getChar(tagEnd);
        if (!this.isTagStart(c)) {
            return -1;
        }
        do {
            hash = KeywordTable.computePartialHash(c, hash);
        } while (this.isTagPart(c = this.textBuffer.getChar(++tagEnd)));
        int tagType = keywordTable.lookupKeyword(this.textBuffer, this.currentPos, tagEnd, hash);
        if (tagType == -1) {
            tagType = 201;
        }
        this.currentPos = tagEnd;
        return tagType;
    }

    private boolean isTagStart(char c) {
        return Character.isLetter(c);
    }

    private boolean isTagPart(char c) {
        return Character.isJavaIdentifierPart(c) || c == '.' || c == ':' || c == '-';
    }

    private void skipAsterisks() {
        while (this.textBuffer.getChar(this.currentPos) == '*' && this.textBuffer.getChar(this.currentPos + 1) != '/') {
            ++this.currentPos;
        }
    }

    private void skipSpaces() {
        block3: while (true) {
            char c = this.textBuffer.getChar(this.currentPos);
            switch (c) {
                case '\t': 
                case ' ': {
                    ++this.currentPos;
                    continue block3;
                }
            }
            break;
        }
    }

    private int fillLexerToken(LexerToken lexedToken) {
        if (lexedToken != null) {
            AbstractLexer.DefaultLexerToken outToken = (AbstractLexer.DefaultLexerToken)lexedToken;
            outToken.setToken(this.lastToken);
            outToken.setStartOffset(this.startOffset);
            outToken.setEndOffset(this.endOffset);
        }
        return this.lastToken;
    }

    static {
        operatorTable = new short[256];
        int tagCount = 20;
        if (JavadocTokens.TAG_words.length != 20) {
            System.out.println("Warning: Keyword count mismatch");
        }
        keywordTable = new KeywordTable(20);
        keywordTable.setCaseSensitivity(true);
        int tag = 202;
        while (tag < 222) {
            keywordTable.addKeyword(JavadocTokens.TAG_words[tag - 202], tag);
            tag = (short)(tag + 1);
        }
        JavadocLexer.operatorTable[123] = 49;
        JavadocLexer.operatorTable[125] = 70;
        JavadocLexer.operatorTable[40] = 55;
        JavadocLexer.operatorTable[41] = 72;
        JavadocLexer.operatorTable[35] = 47;
        JavadocLexer.operatorTable[44] = 39;
        JavadocLexer.operatorTable[46] = 43;
    }
}

