/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.util;

import oracle.javatools.parser.java.v2.model.JavaAnnotation;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaField;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Annotations {
    public static <S> AnnotationValueGetter<S> getter(JavaType type, String elementName) {
        if (type == null) {
            throw new IllegalArgumentException("Null type");
        }
        if (!type.isAnnotation()) {
            throw new IllegalArgumentException("Not an annotation type");
        }
        if (elementName == null || elementName.length() == 0) {
            throw new IllegalArgumentException("Invalid element name");
        }
        JavaMethod m = type.getMethod(elementName, JavaType.EMPTY_ARRAY);
        if (m == null) {
            throw new IllegalArgumentException("No such element: " + elementName);
        }
        return new AnnotationValueGetter(type, elementName, null);
    }

    public static AnnotationValueGetter<Byte> byteGetter(JavaType type, String elementName) {
        return Annotations.getter(type, elementName);
    }

    public static AnnotationValueGetter<Character> charGetter(JavaType type, String elementName) {
        return Annotations.getter(type, elementName);
    }

    public static AnnotationValueGetter<Short> shortGetter(JavaType type, String elementName) {
        return Annotations.getter(type, elementName);
    }

    public static AnnotationValueGetter<Integer> integerGetter(JavaType type, String elementName) {
        return Annotations.getter(type, elementName);
    }

    public static AnnotationValueGetter<Long> longGetter(JavaType type, String elementName) {
        return Annotations.getter(type, elementName);
    }

    public static AnnotationValueGetter<Float> floatGetter(JavaType type, String elementName) {
        return Annotations.getter(type, elementName);
    }

    public static AnnotationValueGetter<Double> doubleGetter(JavaType type, String elementName) {
        return Annotations.getter(type, elementName);
    }

    public static AnnotationValueGetter<String> stringGetter(JavaType type, String elementName) {
        return Annotations.getter(type, elementName);
    }

    public static AnnotationValueGetter<JavaType> classGetter(JavaType type, String elementName) {
        return Annotations.getter(type, elementName);
    }

    public static AnnotationValueGetter<Object[]> arrayGetter(JavaType type, String elementName) {
        return Annotations.getter(type, elementName);
    }

    public static AnnotationValueGetter<JavaField> enumGetter(JavaType type, String elementName) {
        return Annotations.getter(type, elementName);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AnnotationValueGetter<T> {
        private final JavaType annotationType;
        private final String annotationElement;

        private AnnotationValueGetter(JavaType type, String element) {
            this.annotationType = type;
            this.annotationElement = element;
        }

        public T get(JavaClass target) {
            JavaAnnotation annotation = target.getAnnotation(this.annotationType);
            return (T)annotation.getComponents().get(this.annotationElement);
        }

        AnnotationValueGetter(JavaType javaType, String string, 1 var3_3) {
            this(javaType, string);
        }

        public final class 1 {
        }
    }
}

