/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.util;

import oracle.javatools.parser.java.v2.JavaConstants;
import oracle.javatools.parser.java.v2.common.CommonUtilities;
import oracle.javatools.parser.java.v2.internal.symbol.AnnotateSym;
import oracle.javatools.parser.java.v2.internal.symbol.FileSym;
import oracle.javatools.parser.java.v2.internal.symbol.Sym;
import oracle.javatools.parser.java.v2.internal.symbol.TypeSym;
import oracle.javatools.parser.java.v2.internal.symbol.doc.DocReferenceSym;
import oracle.javatools.parser.java.v2.internal.symbol.expr.DotExpr;
import oracle.javatools.parser.java.v2.internal.util.ImportHelper;
import oracle.javatools.parser.java.v2.model.SourceElement;

public class SimplifyTypeHelper
implements JavaConstants {
    private final ImportHelper helper;

    public static void simplifyType(SourceElement element) {
        switch (element.getSymbolKind()) {
            case 27: {
                TypeSym typeSym = (TypeSym)element;
                ImportHelper helper = new ImportHelper(typeSym.symFile);
                helper.performAutoImport(typeSym);
                break;
            }
            case 49: {
                DotExpr dotExpr = (DotExpr)element;
                ImportHelper helper = new ImportHelper(dotExpr.symFile);
                helper.performAutoImport(dotExpr);
                break;
            }
            case 66: {
                DocReferenceSym docReferenceSym = (DocReferenceSym)element;
                ImportHelper helper = new ImportHelper(docReferenceSym.symFile);
                helper.performAutoImport(docReferenceSym);
                break;
            }
            case 1: {
                AnnotateSym annotateSym = (AnnotateSym)element;
                ImportHelper helper = new ImportHelper(annotateSym.symFile);
                helper.performAutoImport(annotateSym);
                break;
            }
        }
    }

    public static void simplifyAllTypes(SourceElement subtree) {
        Sym sym = (Sym)subtree;
        ImportHelper helper = new ImportHelper(sym.symFile);
        helper.process(sym);
    }

    public static SimplifyTypeHelper simplifyTypeName(SourceElement scope, String name) {
        if (scope == null || name == null || !CommonUtilities.isValidQualifiedName(name)) {
            throw new IllegalArgumentException();
        }
        Sym sym = (Sym)scope;
        FileSym fileSym = sym.symFile;
        try {
            SimplifyTypeHelper simplifyTypeHelper = new SimplifyTypeHelper(fileSym, sym, name);
            return simplifyTypeHelper;
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            SimplifyTypeHelper simplifyTypeHelper = null;
            return simplifyTypeHelper;
        }
    }

    public String getImportName() {
        return this.helper.addImportName;
    }

    public String getSimplifiedName() {
        return this.helper.simplifiedName;
    }

    private SimplifyTypeHelper(FileSym fileSym, Sym scope, String name) {
        this.helper = new ImportHelper(fileSym);
        this.helper.performAutoImport(scope, name);
    }
}

