/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.util.filter;

import java.util.HashSet;
import oracle.javatools.parser.java.v2.common.CommonUtilities;
import oracle.javatools.parser.java.v2.model.JavaElement;
import oracle.javatools.parser.java.v2.model.JavaHasType;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.util.filter.JavaFilter;

public class AssignableFilter
implements JavaFilter {
    public static final int REQUIRE_none = 0;
    public static final int REQUIRE_INSTANCE = 1;
    public static final int REQUIRE_TYPE = 2;
    public static final int REQUIRE_EXACT_TYPE = 3;
    private final JavaType target;
    private final int require;
    private final HashSet hits;
    private final HashSet misses;

    public final boolean accepts(JavaElement element) {
        JavaHasType ht;
        JavaType subject;
        if (!(element instanceof JavaHasType)) {
            return false;
        }
        if (this.require > 0) {
            boolean reqType;
            boolean isType = element instanceof JavaType;
            switch (this.require) {
                case 1: {
                    reqType = false;
                    break;
                }
                case 2: 
                case 3: {
                    reqType = true;
                    break;
                }
                default: {
                    CommonUtilities.panic("Invalid require: " + this.require);
                    reqType = false;
                }
            }
            if (isType != reqType) {
                return false;
            }
        }
        if ((subject = (ht = (JavaHasType)element).getResolvedType()) == null) {
            return false;
        }
        if (this.hits.contains(subject)) {
            return true;
        }
        if (this.misses.contains(subject)) {
            return false;
        }
        boolean accepted = this.acceptsImpl(subject);
        if (accepted) {
            this.hits.add(subject);
        } else {
            this.misses.add(subject);
        }
        return accepted;
    }

    private boolean acceptsImpl(JavaType subject) {
        if (this.require == 3) {
            return this.target.equals(subject);
        }
        return this.target.isAssignableFrom(subject);
    }

    private void $init$() {
        this.hits = new HashSet(10);
        this.misses = new HashSet();
    }

    public AssignableFilter(JavaType target) {
        this(target, 0);
    }

    public AssignableFilter(JavaType target, int require) {
        this.$init$();
        this.target = target;
        this.require = require;
        switch (require) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public JavaType getTarget() {
        return this.target;
    }
}

