/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.plsql;

import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.parser.Lexer;
import oracle.javatools.parser.plsql.data.PlsqlRoot;
import oracle.javatools.parser.plsql.syntax.PlsqlDriver;
import oracle.javatools.parser.plsql.syntax.PlsqlLexer;
import oracle.javatools.parser.plsql.syntax.SqlDriver;
import oracle.javatools.parser.plsql.syntax.SqlLexer;

public class PlsqlParser {
    public static final int INPUT_PLS_SRC = 0;
    protected static final int INPUT_SQL_QCPI = 16;
    public static final int INPUT_SQL_BEX = 17;
    public static final int INPUT_default = 0;

    public static Lexer createPlsqlLexer() {
        return new PlsqlLexer();
    }

    public static Lexer createSqlLexer() {
        return new SqlLexer();
    }

    public static PlsqlRoot parsePlsql(ReadTextBuffer textBuffer) {
        ParsingOptions options = new ParsingOptions();
        options.inputType = 0;
        return PlsqlParser.parse(textBuffer, options);
    }

    public static PlsqlRoot parseSql(ReadTextBuffer textBuffer) {
        ParsingOptions options = new ParsingOptions();
        options.inputType = 16;
        return PlsqlParser.parseSql(textBuffer, null);
    }

    public static PlsqlRoot parse(ReadTextBuffer textBuffer, ParsingOptions options) {
        if (options == null) {
            options = new ParsingOptions();
        }
        try {
            if (options.inputType == 0) {
                PlsqlDriver plsql = new PlsqlDriver();
                plsql.setTextBuffer(textBuffer);
                PlsqlRoot plsqlRoot = plsql.ph1drv();
                return plsqlRoot;
            }
            if (options.inputType == 16) {
                SqlDriver sql = new SqlDriver();
                sql.setTextBuffer(textBuffer);
                PlsqlRoot plsqlRoot = sql.qcpidrv();
                return plsqlRoot;
            }
            if (options.inputType == 17) {
                SqlDriver sql = new SqlDriver();
                sql.setTextBuffer(textBuffer);
                PlsqlRoot plsqlRoot = sql.qcpidrv(1);
                return plsqlRoot;
            }
            PlsqlRoot plsqlRoot = null;
            return plsqlRoot;
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            PlsqlRoot plsqlRoot = null;
            return plsqlRoot;
        }
    }

    private static PlsqlRoot parseSql(ReadTextBuffer textBuffer, ParsingOptions options) {
        if (options == null) {
            options = new ParsingOptions();
        }
        try {
            SqlDriver sql = new SqlDriver();
            sql.setTextBuffer(textBuffer);
            PlsqlRoot plsqlRoot = sql.qcpidrv();
            return plsqlRoot;
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            PlsqlRoot plsqlRoot = null;
            return plsqlRoot;
        }
    }

    public static class ParsingOptions {
        public int inputType;
        public int startOffset;

        private void $init$() {
            this.inputType = 0;
            this.startOffset = 0;
        }

        public ParsingOptions() {
            this.$init$();
        }
    }
}

