/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.plsql.old.symbol;

import java.util.ArrayList;
import oracle.javatools.parser.plsql.old.symbol.FunctionSymbol;
import oracle.javatools.parser.plsql.old.symbol.PlsqlSymbol;
import oracle.javatools.parser.plsql.old.symbol.Statement;
import oracle.javatools.parser.plsql.old.symbol.VariableSymbol;

public class CodeBlockSymbol
extends PlsqlSymbol {
    private ArrayList variables;
    private ArrayList types;
    private ArrayList statements;
    private ArrayList functions;
    private VariableSymbol[] variableArray;
    private VariableSymbol[] typeArray;
    private Statement[] statementArray;
    private FunctionSymbol[] functionArray;

    public VariableSymbol[] getVariables() {
        return this.variableArray;
    }

    public VariableSymbol[] getTypes() {
        return this.typeArray;
    }

    public Statement[] getStatements() {
        return this.statementArray;
    }

    public FunctionSymbol[] getFunctions() {
        return this.functionArray;
    }

    private void $init$() {
        this.variables = CodeBlockSymbol.allocArrayList();
        this.types = CodeBlockSymbol.allocArrayList();
        this.statements = CodeBlockSymbol.allocArrayList();
        this.functions = CodeBlockSymbol.allocArrayList();
        this.variableArray = null;
        this.typeArray = null;
        this.statementArray = null;
        this.functionArray = null;
    }

    CodeBlockSymbol(int code) {
        super(code);
        this.$init$();
    }

    void addVariable(VariableSymbol v) {
        this.variables.add(v);
    }

    void addType(VariableSymbol v) {
        this.types.add(v);
    }

    void addStatement(Statement s) {
        this.statements.add(s);
    }

    void addFunction(FunctionSymbol i) {
        this.functions.add(i);
    }

    void doneParsing() {
        super.doneParsing();
        this.generateVariableArray();
        this.generateTypeArray();
        this.generateStatementArray();
        this.generateFunctionArray();
    }

    private void generateVariableArray() {
        this.variableArray = VariableSymbol.EMPTY_ARRAY;
        this.variableArray = this.variables.toArray(this.variableArray);
        CodeBlockSymbol.freeArrayList(this.variables);
        this.variables = null;
    }

    private void generateTypeArray() {
        this.typeArray = VariableSymbol.EMPTY_ARRAY;
        this.typeArray = this.types.toArray(this.typeArray);
        CodeBlockSymbol.freeArrayList(this.types);
        this.types = null;
    }

    private void generateStatementArray() {
        this.statementArray = Statement.EMPTY_ARRAY;
        this.statementArray = this.statements.toArray(this.statementArray);
        CodeBlockSymbol.freeArrayList(this.statements);
        this.statements = null;
    }

    private void generateFunctionArray() {
        this.functionArray = FunctionSymbol.EMPTY_ARRAY;
        this.functionArray = this.functions.toArray(this.functionArray);
        CodeBlockSymbol.freeArrayList(this.functions);
        this.functions = null;
    }
}

