/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.plsql.syntax;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import oracle.javatools.parser.plsql.PlsqlTokens;
import oracle.javatools.parser.plsql.SqlKeywords;
import oracle.javatools.parser.plsql.syntax.BaseSqlLexer;
import oracle.javatools.parser.util.KeywordTable;

public class SqlPlsqlLexer
extends BaseSqlLexer {
    public static final int KW_base = 1024;
    private static KeywordTable keywordTable;

    public SqlPlsqlLexer() {
        super(keywordTable);
    }

    static {
        int sqlKeywordCount = SqlKeywords.KW_words.length;
        int sqlDupwordCount = SqlKeywords.DW_words.length;
        int plSqlKeywordCount = PlsqlTokens.KW_words.length;
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>(sqlKeywordCount + sqlDupwordCount + plSqlKeywordCount);
        int i = 0;
        while (i < SqlKeywords.KW_words.length) {
            String word = SqlKeywords.KW_words[i];
            hashMap.put(word, new Integer(i));
            ++i;
        }
        int i2 = 0;
        while (i2 < SqlKeywords.DW_words.length) {
            String word = SqlKeywords.DW_words[i2];
            hashMap.put(word, new Integer(i2 + sqlKeywordCount));
            ++i2;
        }
        int i3 = 0;
        while (i3 < PlsqlTokens.KW_words.length) {
            String word = PlsqlTokens.KW_words[i3];
            hashMap.put(word, new Integer(i3 + sqlKeywordCount + sqlDupwordCount));
            ++i3;
        }
        Set entries = hashMap.entrySet();
        int numKeywords = entries.size();
        keywordTable = new KeywordTable(numKeywords);
        keywordTable.setCaseSensitivity(false);
        for (Map.Entry entry : entries) {
            String word = (String)entry.getKey();
            int token = (Integer)entry.getValue();
            keywordTable.addKeyword(word, token + 1024);
        }
    }
}

