/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.util;

import java.util.ArrayList;
import java.util.List;
import oracle.javatools.parser.util.AsyncTask;

public class AsyncScheduler {
    private List taskList;
    private int threadCount;
    private List threadList;
    private String threadPrefix;
    private int threadId;
    private int idleTimeout;
    private int idleCount;
    private int maxThreads;
    private static final int DEFAULT_MAX_TOTAL_THREADS = 1;
    private static final boolean DEBUG_VERBOSE = false;

    public AsyncScheduler(String runnerPrefix, int idleTimeout) {
        this(runnerPrefix, idleTimeout, 1);
    }

    public AsyncScheduler(String runnerPrefix, int idleTimeout, int maxThreads) {
        this.$init$();
        this.threadPrefix = runnerPrefix;
        this.idleTimeout = idleTimeout;
        this.maxThreads = maxThreads;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleTask(AsyncTask task) {
        List list = this.taskList;
        synchronized (list) {
            this.taskList.add(task);
            int numTasks = this.taskList.size();
            int i = this.threadCount - 1;
            while (i >= 0) {
                Thread t = (Thread)this.threadList.get(i);
                if (!t.isAlive()) {
                    this.threadList.remove(t);
                    --this.threadCount;
                }
                --i;
            }
            if (this.idleCount > 0) {
                this.taskList.notify();
            } else if (this.threadCount < this.maxThreads) {
                TRunner r = new TRunner(null);
                Thread t = new Thread(r);
                String name = this.threadPrefix + this.threadId++;
                t.setName(name);
                t.setPriority(1);
                this.threadList.add(t);
                ++this.threadCount;
                t.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelTask(AsyncTask task) {
        List list = this.threadList;
        synchronized (list) {
            this.threadList.remove(task);
        }
        task.requestCancel();
    }

    private void $init$() {
        this.taskList = new ArrayList();
        this.threadCount = 0;
        this.threadList = new ArrayList();
        this.threadId = 1;
        this.idleCount = 0;
    }

    static List ra$taskList(AsyncScheduler asyncScheduler) {
        return asyncScheduler.taskList;
    }

    static int ra$idleCount(AsyncScheduler asyncScheduler) {
        return asyncScheduler.idleCount;
    }

    static void wa$idleCount(AsyncScheduler asyncScheduler, int n) {
        asyncScheduler.idleCount = n;
    }

    static int ra$idleTimeout(AsyncScheduler asyncScheduler) {
        return asyncScheduler.idleTimeout;
    }

    static int ra$threadCount(AsyncScheduler asyncScheduler) {
        return asyncScheduler.threadCount;
    }

    static void wa$threadCount(AsyncScheduler asyncScheduler, int n) {
        asyncScheduler.threadCount = n;
    }

    static List ra$threadList(AsyncScheduler asyncScheduler) {
        return asyncScheduler.threadList;
    }

    private class TRunner
    implements Runnable {
        private void printVerbose(String message) {
            String name = Thread.currentThread().getName();
            System.out.print("TRunner(" + name + ") ");
            System.out.println(message);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (true) {
                AsyncTask task = null;
                List list = AsyncScheduler.ra$taskList(AsyncScheduler.this);
                synchronized (list) {
                    if (AsyncScheduler.ra$taskList(AsyncScheduler.this).size() == 0) {
                        try {
                            AsyncScheduler asyncScheduler = AsyncScheduler.this;
                            AsyncScheduler.wa$idleCount(asyncScheduler, AsyncScheduler.ra$idleCount(asyncScheduler) + 1);
                            AsyncScheduler.ra$taskList(AsyncScheduler.this).wait(AsyncScheduler.ra$idleTimeout(AsyncScheduler.this));
                            AsyncScheduler asyncScheduler2 = AsyncScheduler.this;
                            AsyncScheduler.wa$idleCount(asyncScheduler2, AsyncScheduler.ra$idleCount(asyncScheduler2) - 1);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        if (AsyncScheduler.ra$taskList(AsyncScheduler.this).size() == 0) {
                            AsyncScheduler asyncScheduler = AsyncScheduler.this;
                            AsyncScheduler.wa$threadCount(asyncScheduler, AsyncScheduler.ra$threadCount(asyncScheduler) - 1);
                            AsyncScheduler.ra$threadList(AsyncScheduler.this).remove(Thread.currentThread());
                            return;
                        }
                    }
                    task = (AsyncTask)AsyncScheduler.ra$taskList(AsyncScheduler.this).remove(0);
                }
                task.run();
            }
        }

        private TRunner() {
        }

        TRunner(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

