/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.util;

import oracle.javatools.buffer.ReadTextBuffer;

public final class KeywordTable {
    private int tableSize = 16;
    private int tableSizeMask;
    private boolean isCaseSensitive;
    private Keyword[] hashTable;

    public KeywordTable(int numKeywords) {
        while (this.tableSize < numKeywords) {
            this.tableSize <<= 1;
        }
        this.tableSizeMask = this.tableSize - 1;
        this.isCaseSensitive = true;
        this.hashTable = new Keyword[this.tableSize];
    }

    public void setCaseSensitivity(boolean isCaseSensitive) {
        this.isCaseSensitive = isCaseSensitive;
    }

    public void addKeyword(String keyword, int token) {
        Keyword key = new Keyword(keyword, token, this.isCaseSensitive, null);
        int hash = Keyword.mav$getHash(key);
        int bucket = hash & this.tableSizeMask;
        Keyword nextKey = this.hashTable[bucket];
        this.hashTable[bucket] = key;
        Keyword.mav$setNext(key, nextKey);
    }

    public int lookupKeyword(ReadTextBuffer buffer, int startOffset, int endOffset, int precomputedHash) {
        int bucket = precomputedHash & this.tableSizeMask;
        if (this.isCaseSensitive) {
            Keyword key = this.hashTable[bucket];
            while (key != null) {
                if (Keyword.mav$getHash(key) == precomputedHash && Keyword.mav$matches(key, buffer, startOffset, endOffset)) {
                    return Keyword.mav$getToken(key);
                }
                key = Keyword.mav$getNext(key);
            }
        } else {
            Keyword key = this.hashTable[bucket];
            while (key != null) {
                if (Keyword.mav$getHash(key) == precomputedHash && Keyword.mav$matchesInsensitive(key, buffer, startOffset, endOffset)) {
                    return Keyword.mav$getToken(key);
                }
                key = Keyword.mav$getNext(key);
            }
        }
        return -1;
    }

    public static int computeHash(char[] keyword) {
        int hash = 0;
        int length = keyword.length;
        int i = 0;
        while (i < length) {
            hash += keyword[i];
            ++i;
        }
        return hash;
    }

    public static int computeInsensitiveHash(char[] keyword) {
        int hash = 0;
        int length = keyword.length;
        int i = 0;
        while (i < length) {
            hash += Character.toLowerCase(keyword[i]);
            ++i;
        }
        return hash;
    }

    public static int computePartialHash(char nextChar, int lastHash) {
        return lastHash + nextChar;
    }

    public static int computeInsensitivePartialHash(char nextChar, int lastHash) {
        return lastHash + Character.toLowerCase(nextChar);
    }

    private static final class Keyword {
        private char[] keyword;
        private int token;
        private int hash;
        private Keyword next;

        private Keyword(String keywordStr, int token, boolean isCaseSensitive) {
            this.keyword = keywordStr.toCharArray();
            this.token = token;
            this.hash = isCaseSensitive ? KeywordTable.computeHash(this.keyword) : KeywordTable.computeInsensitiveHash(this.keyword);
            this.next = null;
        }

        private int getHash() {
            return this.hash;
        }

        private int getToken() {
            return this.token;
        }

        private char[] getKeyword() {
            return this.keyword;
        }

        private Keyword getNext() {
            return this.next;
        }

        private void setNext(Keyword next) {
            this.next = next;
        }

        private boolean matches(ReadTextBuffer textBuffer, int startOffset, int endOffset) {
            int keywordLength = this.keyword.length;
            if (keywordLength == endOffset - startOffset) {
                int i = 0;
                while (i < keywordLength) {
                    if (this.keyword[i++] == textBuffer.getChar(startOffset++)) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        private boolean matchesInsensitive(ReadTextBuffer textBuffer, int startOffset, int endOffset) {
            int keywordLength = this.keyword.length;
            if (keywordLength == endOffset - startOffset) {
                int i = 0;
                while (i < keywordLength) {
                    char t;
                    char k;
                    if ((k = this.keyword[i++]) == (t = textBuffer.getChar(startOffset++)) || Character.toLowerCase(k) == Character.toLowerCase(t)) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        static int mav$getHash(Keyword keyword) {
            return keyword.getHash();
        }

        static boolean mav$matches(Keyword keyword, ReadTextBuffer readTextBuffer, int n, int n2) {
            return keyword.matches(readTextBuffer, n, n2);
        }

        static int mav$getToken(Keyword keyword) {
            return keyword.getToken();
        }

        static Keyword mav$getNext(Keyword keyword) {
            return keyword.getNext();
        }

        static boolean mav$matchesInsensitive(Keyword keyword, ReadTextBuffer readTextBuffer, int n, int n2) {
            return keyword.matchesInsensitive(readTextBuffer, n, n2);
        }

        Keyword(String string, int n, boolean bl, 1 var4_4) {
            this(string, n, bl);
        }

        static void mav$setNext(Keyword keyword, Keyword keyword2) {
            keyword.setNext(keyword2);
        }

        public final class 1 {
        }
    }
}

