/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.patch;

import java.util.EventObject;
import oracle.javatools.patch.PatchEngine;

public class PatchEvent
extends EventObject {
    public static final int PATCH_APPLY_STARTED = 1;
    public static final int PATCH_FILE_CREATED = 2;
    public static final int PATCH_FILE_CREATE_FAILED = 3;
    public static final int PATCH_FILE_DELETED = 4;
    public static final int PATCH_FILE_DELETE_FAILED = 5;
    public static final int PATCH_FILE_BACKED_UP = 6;
    public static final int PATCH_FILE_BACKUP_FAILED = 7;
    public static final int PATCH_BUFFER_CHANGING = 8;
    public static final int PATCH_FILE_SAVED = 9;
    public static final int PATCH_FILE_SAVE_FAILED = 10;
    public static final int PATCH_APPLY_FINISHED = 11;
    public static final int PATCH_PROGRESS_UPDATED = 12;
    private final int _id;
    private final String _firstFilePath;
    private final String _secondFilePath;
    private float _progress;

    PatchEvent(PatchEngine source, int id) {
        this(source, id, null);
    }

    PatchEvent(PatchEngine source, int id, String firstFilePath) {
        this(source, id, firstFilePath, null);
    }

    PatchEvent(PatchEngine source, int id, String firstFilePath, String secondFilePath) {
        this(source, id, firstFilePath, secondFilePath, 0.0f);
    }

    PatchEvent(PatchEngine source, int id, float progress) {
        this(source, id, null, null, progress);
    }

    private PatchEvent(PatchEngine source, int id, String firstFilePath, String secondFilePath, float progress) {
        super(source);
        this._id = id;
        this._firstFilePath = firstFilePath;
        this._secondFilePath = secondFilePath;
        this._progress = progress;
    }

    public int getID() {
        return this._id;
    }

    public String getFirstFilePath() {
        return this._firstFilePath;
    }

    public String getSecondFilePath() {
        return this._secondFilePath;
    }

    public float getProgress() {
        return this._progress;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString());
        stringBuffer.append("[ID=");
        switch (this._id) {
            case 1: {
                stringBuffer.append("PATCH_APPLY_STARTED");
                break;
            }
            case 2: {
                stringBuffer.append("PATCH_FILE_CREATED");
                break;
            }
            case 3: {
                stringBuffer.append("PATCH_FILE_CREATE_FAILED");
                break;
            }
            case 4: {
                stringBuffer.append("PATCH_FILE_DELETED");
                break;
            }
            case 5: {
                stringBuffer.append("PATCH_FILE_DELETE_FAILED");
                break;
            }
            case 6: {
                stringBuffer.append("PATCH_FILE_BACKED_UP");
                break;
            }
            case 7: {
                stringBuffer.append("PATCH_FILE_BACKUP_FAILED");
                break;
            }
            case 8: {
                stringBuffer.append("PATCH_BUFFER_CHANGING");
                break;
            }
            case 9: {
                stringBuffer.append("PATCH_FILE_SAVED");
                break;
            }
            case 10: {
                stringBuffer.append("PATCH_FILE_SAVE_FAILED");
                break;
            }
            case 11: {
                stringBuffer.append("PATCH_APPLY_FINISHED");
                break;
            }
            case 12: {
                stringBuffer.append("PATCH_PROGRESS_UPDATED");
                break;
            }
        }
        stringBuffer.append(",First File Path=");
        stringBuffer.append(this._firstFilePath);
        stringBuffer.append(",Second File Path=");
        stringBuffer.append(this._secondFilePath);
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

