/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.patch;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.javatools.patch.PatchEntry;
import oracle.javatools.patch.PatchHunk;
import oracle.javatools.patch.PatchHunkLine;
import oracle.javatools.patch.PatchModel;

public class PatchFormat {
    private static final String DIFF_DATE_FORMAT = "EEE MMM dd HH:mm:ss yyyy";
    private static final Locale DIFF_DATE_LOCALE = Locale.US;
    private static final String RFC_822_DATE_FORMAT = "dd MMM yyyy HH:mm:ss Z";
    private static final Locale RFC_822_DATE_LOCALE = Locale.US;
    private static final String ISO_8601_DATE_FORMAT = "yyyy-MM-dd HH:mm:ss Z";
    private static final Locale ISO_8601_DATE_LOCALE = Locale.US;
    private static final String NO_NL_AT_EOF_MARKER = "\\ No newline at end of file";
    private static final String DEV_NULL = "/dev/null";
    private String _charsetName;

    public void setEncoding(String charsetName) {
        this._charsetName = charsetName;
    }

    public String getEncoding() {
        return this._charsetName;
    }

    public String format(PatchModel model) {
        OutputStreamWriter osw;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            osw = this._charsetName != null ? new OutputStreamWriter((OutputStream)baos, this._charsetName) : new OutputStreamWriter(baos);
        }
        catch (UnsupportedEncodingException uee) {
            uee.printStackTrace();
            String string = "";
            return string;
        }
        BufferedWriter bw = new BufferedWriter(osw);
        try {
            PatchEntry[] entries = model.getEntries();
            int i = 0;
            while (i < entries.length) {
                bw.write("--- " + this.formatEntryHeaderLine(entries[i].getFromFile(), entries[i].getFromFileModificationTime(), entries[i].getFromFileRevision()));
                bw.newLine();
                bw.write("+++ " + this.formatEntryHeaderLine(entries[i].getToFile(), entries[i].getToFileModificationTime(), entries[i].getToFileRevision()));
                bw.newLine();
                PatchHunk[] hunks = entries[i].getHunks();
                int j = 0;
                while (j < hunks.length) {
                    bw.write(this.formatHunkRangeLine(hunks[j]));
                    bw.newLine();
                    PatchHunkLine[] hunkLines = hunks[j].getLines();
                    int k = 0;
                    while (k < hunkLines.length) {
                        int indicator = hunkLines[k].getIndicator();
                        if (indicator == 2) {
                            bw.write(43);
                        }
                        if (indicator == 3) {
                            bw.write(45);
                        }
                        if (indicator == 1) {
                            bw.write(32);
                        }
                        bw.write(hunkLines[k].getLineData());
                        bw.newLine();
                        if (hunkLines[k].isNoNewlineAtEOF()) {
                            bw.write(NO_NL_AT_EOF_MARKER);
                            bw.newLine();
                        }
                        ++k;
                    }
                    ++j;
                }
                bw.flush();
                ++i;
            }
            String string = this._charsetName != null ? new String(baos.toByteArray(), this._charsetName) : new String(baos.toByteArray());
            return string;
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            String string = "";
            return string;
        }
    }

    public PatchModel parse(String source) throws ParseException {
        InputStreamReader isr;
        PatchModel model = new PatchModel();
        try {
            isr = this._charsetName != null ? new InputStreamReader((InputStream)new ByteArrayInputStream(source.getBytes(this._charsetName)), this._charsetName) : new InputStreamReader(new ByteArrayInputStream(source.getBytes()));
        }
        catch (UnsupportedEncodingException uee) {
            uee.printStackTrace();
            PatchModel patchModel = model;
            return patchModel;
        }
        BufferedReader br = new BufferedReader(isr);
        PatchEntry entry = null;
        PatchHunk hunk = null;
        PatchHunkLine hunkLine = null;
        Pattern pattern1 = Pattern.compile("(---|\\+\\+\\+) ([^\\t]+)\\t([[^\\t]$]+)(\\t[^\\t]+)?.*");
        Pattern pattern2 = Pattern.compile("@@ -([^ ]+) \\+([^ ]+) @@");
        while (true) {
            String line = null;
            try {
                line = br.readLine();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
            if (line == null) break;
            Matcher matcher = pattern1.matcher(line);
            if (matcher.matches()) {
                String revision;
                String fileName = matcher.group(2);
                fileName = fileName.equals("nul") || fileName.equals(DEV_NULL) ? null : fileName;
                Date modificationTime = this.parseModificationTime(matcher.group(3));
                String string = revision = matcher.group(4) != null ? matcher.group(4).trim() : null;
                if (matcher.group(1).startsWith("-")) {
                    entry = new PatchEntry();
                    model.addEntry(entry);
                    hunk = null;
                    entry.setFromFile(fileName);
                    entry.setFromFileModificationTime(modificationTime);
                    entry.setFromFileRevision(revision);
                    continue;
                }
                if (entry == null) continue;
                entry.setToFile(fileName);
                entry.setToFileModificationTime(modificationTime);
                entry.setToFileRevision(revision);
                continue;
            }
            if (entry == null) continue;
            matcher = pattern2.matcher(line);
            if (matcher.matches()) {
                hunk = new PatchHunk();
                entry.addHunk(hunk);
                try {
                    String s = matcher.group(1);
                    int i = s.indexOf(44);
                    hunk.setFromFileLineNumber(this.parseRangeLineNumber(s, i));
                    hunk.setFromFileLineCount(this.parseRangeLineCount(s, i));
                    s = matcher.group(2);
                    i = s.indexOf(44);
                    hunk.setToFileLineNumber(this.parseRangeLineNumber(s, i));
                    hunk.setToFileLineCount(this.parseRangeLineCount(s, i));
                }
                catch (NumberFormatException nfe) {
                    throw new PatchParseException("contains bad line number or count: \"" + line + "\"");
                }
            }
            if (line.length() == 0 || hunk == null) continue;
            char initialChar = line.charAt(0);
            if (line.startsWith(NO_NL_AT_EOF_MARKER) && hunkLine != null) {
                hunkLine.setNoNewlineAtEOF(true);
                continue;
            }
            hunkLine = null;
            if (initialChar == ' ') {
                hunkLine = new PatchHunkLine(1);
            }
            if (initialChar == '+') {
                hunkLine = new PatchHunkLine(2);
            }
            if (initialChar == '-') {
                hunkLine = new PatchHunkLine(3);
            }
            if (hunkLine == null) continue;
            hunkLine.setLineData(line.substring(1));
            hunk.addLine(hunkLine);
        }
        if (model.getEntries().length <= 0) {
            throw new PatchParseException("does not contain any entry information");
        }
        PatchEntry[] entries = model.getEntries();
        int i = 0;
        while (i < entries.length) {
            if (entries[i].getFromFile() == null && entries[i].getToFile() == null) {
                throw new PatchParseException("contains a null to/from file entry");
            }
            ++i;
        }
        return model;
    }

    private String formatEntryHeaderLine(String fileName, Date modTime, String revision) {
        StringBuffer headerLineBuffer = new StringBuffer();
        if (fileName != null) {
            headerLineBuffer.append(fileName);
        } else {
            headerLineBuffer.append(DEV_NULL);
        }
        if (modTime != null) {
            headerLineBuffer.append('\t');
            headerLineBuffer.append(new SimpleDateFormat(DIFF_DATE_FORMAT, DIFF_DATE_LOCALE).format(modTime));
        }
        if (revision != null) {
            headerLineBuffer.append('\t');
            headerLineBuffer.append(revision);
        }
        return headerLineBuffer.toString();
    }

    private String formatHunkRangeLine(PatchHunk hunk) {
        StringBuffer rangeLineBuffer = new StringBuffer();
        rangeLineBuffer.append("@@ -");
        rangeLineBuffer.append(hunk.getFromFileLineNumber());
        if (hunk.getFromFileLineCount() != 1) {
            rangeLineBuffer.append(',');
            rangeLineBuffer.append(hunk.getFromFileLineCount());
        }
        rangeLineBuffer.append(" +");
        rangeLineBuffer.append(hunk.getToFileLineNumber());
        if (hunk.getToFileLineCount() != 1) {
            rangeLineBuffer.append(',');
            rangeLineBuffer.append(hunk.getToFileLineCount());
        }
        rangeLineBuffer.append(" @@");
        return rangeLineBuffer.toString();
    }

    private Date parseModificationTime(String modTime) {
        try {
            Date date = new SimpleDateFormat(DIFF_DATE_FORMAT, DIFF_DATE_LOCALE).parse(modTime);
            return date;
        }
        catch (ParseException parseException) {
            try {
                Date date = new SimpleDateFormat(RFC_822_DATE_FORMAT, RFC_822_DATE_LOCALE).parse(modTime);
                return date;
            }
            catch (ParseException parseException2) {
                try {
                    Date date = new SimpleDateFormat(ISO_8601_DATE_FORMAT, ISO_8601_DATE_LOCALE).parse(modTime.replaceAll("\\.\\d+", ""));
                    return date;
                }
                catch (ParseException pe) {
                    return new Date(System.currentTimeMillis());
                }
            }
        }
    }

    private int parseRangeLineNumber(String range, int i) {
        return Math.max(0, Integer.parseInt(i < 0 ? range : range.substring(0, i)));
    }

    private int parseRangeLineCount(String range, int i) {
        int lineCount = -1;
        if (i > 0) {
            lineCount = Integer.parseInt(range.substring(i + 1));
        }
        return lineCount < 0 ? 1 : lineCount;
    }

    private class PatchParseException
    extends ParseException {
        PatchParseException(String message) {
            super("Unparseable patch: " + message, 0);
        }
    }
}

