/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.util;

import java.util.HashMap;
import java.util.Locale;
import java.util.ResourceBundle;

public class BundleLoader {
    private static final Locale DEFAULT_LOCALE = BundleLoader.findLocale();

    public static final ResourceBundle getBundle(String baseName) {
        return ResourceBundle.getBundle(baseName, DEFAULT_LOCALE, BundleLoader.class.getClassLoader());
    }

    public static final ResourceBundle getBundle(String baseName, ClassLoader loader) {
        return ResourceBundle.getBundle(baseName, DEFAULT_LOCALE, loader);
    }

    private static final Locale findLocale() {
        int newpos;
        Locale locale = Locale.getDefault();
        String inclusionList = System.getProperty("oracle.translated.locales");
        if (inclusionList == null) {
            return locale;
        }
        HashMap<String, String> inclusions = new HashMap<String, String>();
        int pos = 0;
        do {
            String inclusion = (newpos = inclusionList.indexOf(44, pos)) == -1 ? inclusionList.substring(pos) : inclusionList.substring(pos, newpos);
            inclusions.put(inclusion.trim(), "");
            pos = newpos + 1;
        } while (newpos != -1);
        if (inclusions.containsKey(locale.toString())) {
            return locale;
        }
        if (inclusions.containsKey((locale = new Locale(locale.getLanguage(), locale.getCountry())).toString())) {
            return locale;
        }
        if (inclusions.containsKey((locale = new Locale(locale.getLanguage())).toString())) {
            return locale;
        }
        return new Locale("");
    }
}

