/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.util;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.javatools.util.CommandException;
import oracle.javatools.util.CommandModel;
import oracle.javatools.util.Log;
import oracle.javatools.util.TypeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandParser {
    private Map<String, String> options;
    private Set<String> parameters;
    private Map<String, Class<?>> types;
    private boolean listParameterDefined;
    private String[] requirements;
    private List<String[]> conditionalRequirements;
    private Map<String, String[]> supersedingSets;
    private TypeMap<Object, Converter<?>> converters;
    private static final Log LOG = new Log("command");

    private void $init$() {
        this.options = new HashMap<String, String>();
        this.parameters = new LinkedHashSet<String>();
        this.types = new HashMap();
        this.listParameterDefined = false;
        this.requirements = new String[0];
        this.conditionalRequirements = new ArrayList<String[]>();
        this.supersedingSets = new HashMap<String, String[]>();
        this.converters = new TypeMap();
    }

    public CommandParser() {
        this.$init$();
        this.defineConverter(new ByteConverter(null));
        this.defineConverter(new ShortConverter(null));
        this.defineConverter(new CharacterConverter(null));
        this.defineConverter(new IntegerConverter(null));
        this.defineConverter(new LongConverter(null));
        this.defineConverter(new FloatConverter(null));
        this.defineConverter(new DoubleConverter(null));
        this.defineConverter(new StringConverter(null));
        this.defineConverter(new FileConverter(null));
        this.defineConverter(new URLConverter(null));
        this.defineConverter(new EnumConverter(null));
    }

    public void defineConverter(Converter<?> converter) {
        this.converters.put(converter.getType(), converter);
    }

    public void defineOption(String name) {
        if (this.isDefined(name)) {
            throw new IllegalArgumentException(name + " already defined");
        }
        this.types.put(name, null);
        this.options.put(name, name);
    }

    public void defineOption(String name, Class<?> type) {
        if (this.isDefined(name)) {
            throw new IllegalArgumentException(name + " already defined");
        }
        if (!this.isConvertable(type)) {
            throw new IllegalArgumentException("no converter defined for " + type);
        }
        this.types.put(name, type);
        this.options.put(name, name);
    }

    public void defineParameter(String name, Class<?> type) {
        if (this.isDefined(name)) {
            throw new IllegalArgumentException(name + " already defined");
        }
        if (!this.isConvertable(type)) {
            throw new IllegalArgumentException("no converter defined for " + type);
        }
        if (type.isArray()) {
            if (this.listParameterDefined) {
                throw new IllegalArgumentException("list parameter already defined");
            }
            this.listParameterDefined = true;
        }
        this.types.put(name, type);
        this.parameters.add(name);
    }

    private boolean isConvertable(Class<?> type) {
        if (type.isArray()) {
            type = type.getComponentType();
        }
        return this.converters.containsKey(type);
    }

    public void defineSuperseding(String ... options) {
        String[] stringArray = options;
        int n = 0;
        while (n < stringArray.length) {
            String option = stringArray[n];
            if (!this.isDefined(option)) {
                throw new IllegalArgumentException("option " + option + " not defined");
            }
            if (this.supersedingSets.containsKey(option)) {
                throw new IllegalArgumentException("option " + option + " already in a superseding set");
            }
            this.supersedingSets.put(option, options);
            ++n;
        }
    }

    public void defineRequirement(String ... names) {
        if (names.length == 0) {
            throw new IllegalArgumentException("names.length == 0");
        }
        int i = 0;
        while (i < names.length) {
            String name = names[i];
            if (!this.isDefined(name)) {
                throw new IllegalArgumentException("name " + name + " not parameter or option");
            }
            ++i;
        }
        this.requirements = names;
    }

    public void defineRequirementPresent(String precedent, String antecedent) {
        if (!this.isDefined(precedent)) {
            throw new IllegalArgumentException(precedent + " not defined");
        }
        if (!this.isDefined(antecedent)) {
            throw new IllegalArgumentException(antecedent + " not defined");
        }
        this.conditionalRequirements.add(new String[]{precedent, antecedent});
    }

    public void defineRequirementAbsent(String precedent, String antecedent) {
        if (!this.isDefined(precedent)) {
            throw new IllegalArgumentException(precedent + " not defined");
        }
        if (!this.isDefined(antecedent)) {
            throw new IllegalArgumentException(antecedent + " not defined");
        }
        this.conditionalRequirements.add(new String[]{precedent, '!' + antecedent});
    }

    public void defineSynonym(String name, String synonym) {
        if (!this.isDefined(name)) {
            throw new IllegalArgumentException("option " + name + " not defined");
        }
        if (this.parameters.contains(name)) {
            throw new IllegalArgumentException(name + " is a parameter");
        }
        if (this.isDefined(synonym)) {
            throw new IllegalArgumentException(synonym + " already defined");
        }
        this.options.put(synonym, name);
        this.types.put(synonym, this.types.get(name));
    }

    public Converter getConverter(Class<?> type) {
        return this.converters.get(type);
    }

    public Class getType(String name) {
        if (!this.isDefined(name)) {
            throw new IllegalArgumentException("name " + name + " not defined");
        }
        return this.types.get(name);
    }

    public boolean isDefined(String name) {
        return this.types.containsKey(name);
    }

    public CommandModel parse(String[] arguments) throws CommandException {
        CommandModel parse = new CommandModel(this);
        ArrayList<String> parameterList = new ArrayList<String>();
        Iterator<String> iterator = Arrays.asList(arguments).iterator();
        while (iterator.hasNext()) {
            String parameterOrOption = iterator.next();
            if (parameterOrOption.charAt(0) == '-') {
                Class<?> componentType;
                String option = parameterOrOption.substring(1);
                if (!this.options.containsKey(option)) {
                    this.invalidOption(option);
                }
                option = this.options.get(option);
                Class<?> type = this.types.get(option);
                if (this.supersedingSets.containsKey(option)) {
                    String[] options;
                    String[] stringArray = options = this.supersedingSets.get(option);
                    int n = 0;
                    while (n < stringArray.length) {
                        String superseded = stringArray[n];
                        parse.setValue(superseded, null);
                        ++n;
                    }
                }
                if (type == null) {
                    parse.setValue(option, null);
                    continue;
                }
                Class<?> clazz = componentType = type.isArray() ? type.getComponentType() : type;
                if (!iterator.hasNext()) {
                    this.missingOptionValue(option, componentType);
                }
                Object value = this.convertOptionValue(option, componentType, iterator.next());
                if (type.isArray()) {
                    parse.addValue(option, value);
                    continue;
                }
                parse.setValue(option, value);
                continue;
            }
            parameterList.add(parameterOrOption);
        }
        HashMap<String, String> parameterDescriptions = new HashMap<String, String>();
        Iterator<String> parameterIterator = this.parameters.iterator();
        int i = 0;
        while (i < parameterList.size()) {
            String parameter = (String)parameterList.get(i++);
            if (!parameterIterator.hasNext()) {
                this.unexpectedParameter(parameter);
            }
            String name = parameterIterator.next();
            Class<?> type = this.types.get(name);
            String description = parameter;
            if (type.isArray()) {
                type = type.getComponentType();
                int length = parameterList.size() - this.parameters.size() + 1;
                if (length <= 0) {
                    length = 1;
                }
                if (length > 1) {
                    description = description + "...";
                }
                while (true) {
                    Object value = this.convertParameterValue(name, type, parameter);
                    parse.addValue(name, value);
                    if (--length != 0) {
                        parameter = (String)parameterList.get(i++);
                        continue;
                    }
                    break;
                }
            } else {
                Object value = this.convertParameterValue(name, type, parameter);
                parse.setValue(name, value);
            }
            parameterDescriptions.put(name, description);
        }
        int size = this.requirements.length;
        boolean satisfied = size == 0;
        int i2 = 0;
        while (i2 < size) {
            satisfied = parse.isPresent(this.requirements[i2]);
            if (satisfied) break;
            ++i2;
        }
        if (!satisfied) {
            this.requirementsUnsatisfied(this.parameters, this.requirements);
        }
        size = this.conditionalRequirements.size();
        int i3 = 0;
        while (i3 < size) {
            String[] requirement = this.conditionalRequirements.get(i3);
            String precedent = requirement[0];
            if (parse.isPresent(precedent)) {
                String antecedent = requirement[1];
                if (antecedent.charAt(0) == '!') {
                    String name = antecedent.substring(1);
                    if (parse.isPresent(name)) {
                        this.conditionalRequirementUnsatisfied(precedent, (String)parameterDescriptions.get(precedent), antecedent, (String)parameterDescriptions.get(name));
                    }
                } else if (!parse.isPresent(antecedent)) {
                    this.conditionalRequirementUnsatisfied(precedent, (String)parameterDescriptions.get(precedent), antecedent, (String)parameterDescriptions.get(antecedent));
                }
            }
            ++i3;
        }
        return parse;
    }

    private Object convertOptionValue(String name, Class<?> type, String argument) throws CommandException {
        Converter<?> converter = this.converters.get(type);
        try {
            Object obj = converter.convert(argument, type);
            return obj;
        }
        catch (Throwable e) {
            Object object = this.optionValueConversionFailed(name, converter.getTypeDescription(), argument, e);
            return object;
        }
    }

    private Object convertParameterValue(String name, Class<?> type, String argument) throws CommandException {
        Converter<?> converter = this.converters.get(type);
        try {
            Object obj = converter.convert(argument, type);
            return obj;
        }
        catch (Throwable e) {
            Object object = this.parameterValueConversionFailed(name, converter.getTypeDescription(), argument, e);
            return object;
        }
    }

    protected void invalidOption(String name) throws CommandException {
        throw new CommandException("invalid-option", name);
    }

    protected void missingOptionValue(String name, Class type) throws CommandException {
        throw new CommandException("missing-option-value", name, type);
    }

    protected Object optionValueConversionFailed(String name, String typeDescription, String argument, Throwable e) throws CommandException {
        throw new CommandException(e, "option-value-conversion-failed", name, typeDescription, argument, e.getMessage());
    }

    protected void unexpectedParameter(String name) throws CommandException {
        throw new CommandException("unexpected-parameter", name);
    }

    protected Object parameterValueConversionFailed(String name, String typeDescription, String argument, Throwable e) throws CommandException {
        throw new CommandException(e, "parameter-value-conversion-failed", name, typeDescription, argument, e.getMessage());
    }

    protected void requirementsUnsatisfied(Set parameters, String[] requirements) throws CommandException {
        String parametersKey = "noparameters";
        StringBuffer parametersList = new StringBuffer();
        String optionsKey = "nooptions";
        StringBuffer optionsList = new StringBuffer();
        int i = 0;
        while (i < requirements.length) {
            String name = requirements[i];
            if (parameters.contains(name)) {
                parametersKey = "parameter";
                if (parametersList.length() > 0) {
                    parametersKey = "parameters";
                    parametersList.append(", ");
                }
                parametersList.append(name);
            } else {
                optionsKey = "option";
                if (optionsList.length() > 0) {
                    optionsKey = "options";
                    optionsList.append(", ");
                }
                optionsList.append(name);
            }
            ++i;
        }
        throw new CommandException(parametersKey + '-' + optionsKey + "-requirements-unsatisfied", parametersList, optionsList);
    }

    protected void conditionalRequirementUnsatisfied(String precedent, String precedentValue, String antecedent, String antecedentValue) throws CommandException {
        boolean negated;
        boolean bl = negated = antecedent.charAt(0) == '!';
        if (negated) {
            antecedent = antecedent.substring(1);
        }
        StringBuffer key = new StringBuffer();
        if (precedentValue != null) {
            key.append("parameter");
        } else {
            key.append("option");
            precedentValue = precedent;
        }
        key.append('-');
        if (antecedentValue != null) {
            key.append("parameter");
        } else {
            key.append("option");
            antecedentValue = antecedent;
        }
        if (negated) {
            key.append("-not-absent");
        } else {
            key.append("-not-present");
        }
        throw new CommandException(key.toString(), precedentValue, antecedentValue);
    }

    static Log ra$LOG() {
        return LOG;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public interface Converter<T> {
        public Class<T> getType();

        public String getTypeDescription();

        public T convert(String var1, Class<?> var2) throws Exception;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class StringConverter
    implements Converter<String> {
        @Override
        public Class<String> getType() {
            return String.class;
        }

        @Override
        public String getTypeDescription() {
            return "string";
        }

        @Override
        public String convert(String value, Class<?> type) {
            return value;
        }

        private StringConverter() {
        }

        StringConverter(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ByteConverter
    implements Converter<Byte> {
        @Override
        public Class<Byte> getType() {
            return Byte.class;
        }

        @Override
        public String getTypeDescription() {
            return "byte";
        }

        @Override
        public Byte convert(String string, Class<?> type) {
            return Byte.valueOf(string);
        }

        private ByteConverter() {
        }

        ByteConverter(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ShortConverter
    implements Converter<Short> {
        @Override
        public Class<Short> getType() {
            return Short.class;
        }

        @Override
        public String getTypeDescription() {
            return "short integer";
        }

        @Override
        public Short convert(String string, Class<?> type) {
            return Short.valueOf(string);
        }

        private ShortConverter() {
        }

        ShortConverter(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CharacterConverter
    implements Converter<Character> {
        @Override
        public Class<Character> getType() {
            return Character.class;
        }

        @Override
        public String getTypeDescription() {
            return "character";
        }

        @Override
        public Character convert(String string, Class<?> type) {
            if (string.length() != 1) {
                throw new IllegalArgumentException(string + " not a single character");
            }
            return new Character(string.charAt(0));
        }

        private CharacterConverter() {
        }

        CharacterConverter(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class IntegerConverter
    implements Converter<Integer> {
        @Override
        public Class<Integer> getType() {
            return Integer.class;
        }

        @Override
        public String getTypeDescription() {
            return "integer";
        }

        @Override
        public Integer convert(String string, Class<?> type) {
            return Integer.valueOf(string);
        }

        private IntegerConverter() {
        }

        IntegerConverter(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class LongConverter
    implements Converter<Long> {
        @Override
        public Class<Long> getType() {
            return Long.class;
        }

        @Override
        public String getTypeDescription() {
            return "long integer";
        }

        @Override
        public Long convert(String string, Class<?> type) {
            return Long.valueOf(string);
        }

        private LongConverter() {
        }

        LongConverter(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FloatConverter
    implements Converter<Float> {
        @Override
        public Class<Float> getType() {
            return Float.class;
        }

        @Override
        public String getTypeDescription() {
            return "float";
        }

        @Override
        public Float convert(String string, Class<?> type) {
            return Float.valueOf(string);
        }

        private FloatConverter() {
        }

        FloatConverter(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DoubleConverter
    implements Converter<Double> {
        @Override
        public Class<Double> getType() {
            return Double.class;
        }

        @Override
        public String getTypeDescription() {
            return "double";
        }

        @Override
        public Double convert(String string, Class<?> type) {
            return Double.valueOf(string);
        }

        private DoubleConverter() {
        }

        DoubleConverter(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FileConverter
    implements Converter<File> {
        @Override
        public Class<File> getType() {
            return File.class;
        }

        @Override
        public String getTypeDescription() {
            return "file";
        }

        @Override
        public File convert(String string, Class<?> type) {
            return new File(string);
        }

        private FileConverter() {
        }

        FileConverter(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EnumConverter
    implements Converter<Enum> {
        @Override
        public Class<Enum> getType() {
            return Enum.class;
        }

        @Override
        public String getTypeDescription() {
            return "keyword";
        }

        @Override
        public Enum convert(String string, Class<?> type) {
            String description;
            Enum[] constants;
            Enum[] enumArray = constants = (Enum[])type.getEnumConstants();
            int n = 0;
            while (n < enumArray.length) {
                Enum constant = enumArray[n];
                String name = constant.name();
                if (string.equalsIgnoreCase(name)) {
                    return constant;
                }
                ++n;
            }
            if (constants.length == 1) {
                description = constants[0].name().toLowerCase();
            } else {
                StringBuilder buffer = new StringBuilder("one of ");
                String separator = "";
                Enum[] enumArray2 = constants;
                int n2 = 0;
                while (n2 < enumArray2.length) {
                    Enum constant1 = enumArray2[n2];
                    buffer.append(separator);
                    buffer.append('\"');
                    buffer.append(constant1.name().toLowerCase());
                    buffer.append('\"');
                    separator = ", ";
                    ++n2;
                }
                description = buffer.toString();
            }
            throw new IllegalArgumentException("expected " + description);
        }

        private EnumConverter() {
        }

        EnumConverter(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class URLConverter
    implements Converter<URL> {
        private File contextFile;
        private URL contextURL;

        @Override
        public Class<URL> getType() {
            return URL.class;
        }

        @Override
        public String getTypeDescription() {
            return "URL";
        }

        @Override
        public URL convert(String string, Class<?> type) throws MalformedURLException {
            URL url;
            string = string.trim();
            int size = string.length();
            int start = 0;
            if (string.startsWith("url:")) {
                start = 4;
            }
            boolean hasProtocol = false;
            int i = start;
            while (i < size) {
                char c = string.charAt(i);
                if (c == '/') break;
                if (c == ':') {
                    hasProtocol = this.isValid(string.substring(start, i));
                    break;
                }
                ++i;
            }
            if (hasProtocol) {
                url = new URL(this.contextURL(), string);
                CommandParser.ra$LOG().trace("converted {0} to {1}, protocol", string, (Object)url);
            } else {
                File file = new File(string);
                if (this.isRelative(file)) {
                    file = new File(this.contextFile(), string);
                }
                url = file.toURI().toURL();
                CommandParser.ra$LOG().trace("converted {0} to {1}, no protocol", string, (Object)url);
            }
            return url;
        }

        private boolean isRelative(File file) {
            if (file.isAbsolute()) {
                return false;
            }
            return file.getPath().charAt(0) != '\\';
        }

        private File contextFile() {
            if (this.contextFile != null) {
                return this.contextFile;
            }
            String directory = System.getProperty("ide.startingcwd");
            if (directory == null) {
                directory = System.getProperty("user.dir");
            }
            if (directory.startsWith("\"") && directory.endsWith("\"")) {
                directory = directory.substring(1, directory.length() - 1);
            }
            this.contextFile = new File(directory);
            return this.contextFile;
        }

        private URL contextURL() throws MalformedURLException {
            if (this.contextURL != null) {
                return this.contextURL;
            }
            this.contextURL = this.contextFile().toURI().toURL();
            return this.contextURL;
        }

        private boolean isValid(String protocol) {
            int size = protocol.length();
            if (size < 2) {
                return false;
            }
            char c = protocol.charAt(0);
            if (!Character.isLetter(c)) {
                return false;
            }
            int i = 1;
            while (i < size) {
                c = protocol.charAt(i);
                if (!Character.isLetterOrDigit(c) && c != '.' && c != '+' && c != '-') {
                    return false;
                }
                ++i;
            }
            return true;
        }

        private URLConverter() {
        }

        URLConverter(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

